/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.jetty;

import io.hops.hudi.javax.servlet.http.HttpServletRequest;
import io.hops.hudi.javax.servlet.http.HttpServletResponse;
import io.hops.hudi.org.apache.jetty.http.MimeTypes;
import io.hops.hudi.org.apache.jetty.util.resource.Resource;
import io.javalin.core.compression.CompressionStrategy;
import io.javalin.core.compression.CompressionType;
import io.javalin.core.compression.LeveledBrotliStream;
import io.javalin.core.compression.LeveledGzipStream;
import io.javalin.core.util.JavalinLogger;
import io.javalin.core.util.OptionalDependency;
import io.javalin.core.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/javalin/jetty/JettyPrecompressingResourceHandler;", "", "()V", "compressedFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "getCompressedFiles", "()Ljava/util/concurrent/ConcurrentHashMap;", "excludedMimeTypes", "", "getExcludedMimeTypes", "()Ljava/util/List;", "resourceMaxSize", "", "excludedMimeType", "", "mimeType", "getCompressedByteArray", "resource", "Lio/hops/hudi/org/apache/jetty/util/resource/Resource;", "type", "Lio/javalin/core/compression/CompressionType;", "getStaticResourceByteArray", "target", "handle", "req", "Lio/hops/hudi/javax/servlet/http/HttpServletRequest;", "res", "Lio/hops/hudi/javax/servlet/http/HttpServletResponse;", "javalin"})
public final class JettyPrecompressingResourceHandler {
    @NotNull
    public static final JettyPrecompressingResourceHandler INSTANCE = new JettyPrecompressingResourceHandler();
    @NotNull
    private static final ConcurrentHashMap<String, byte[]> compressedFiles = new ConcurrentHashMap();
    @JvmField
    public static int resourceMaxSize = 0x200000;
    @NotNull
    private static final List<String> excludedMimeTypes = new CompressionStrategy(null, null, 3, null).getExcludedMimeTypesFromCompression();

    private JettyPrecompressingResourceHandler() {
    }

    @NotNull
    public final ConcurrentHashMap<String, byte[]> getCompressedFiles() {
        return compressedFiles;
    }

    @NotNull
    public final List<String> getExcludedMimeTypes() {
        return excludedMimeTypes;
    }

    public final boolean handle(@NotNull Resource resource, @NotNull HttpServletRequest req, @NotNull HttpServletResponse res) {
        Intrinsics.checkNotNullParameter(resource, "resource");
        Intrinsics.checkNotNullParameter(req, "req");
        Intrinsics.checkNotNullParameter(res, "res");
        if (resource.exists() && !resource.isDirectory()) {
            byte[] byArray;
            Object object = req.getAttribute("jetty-target");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String target = (String)object;
            String string = req.getHeader("Accept-Encoding");
            CompressionType acceptCompressType = CompressionType.Companion.getByAcceptEncoding(string == null ? "" : string);
            String contentType = MimeTypes.getDefaultMimeByExtension(target);
            if (contentType == null || this.excludedMimeType(contentType)) {
                acceptCompressType = CompressionType.NONE;
            }
            if ((byArray = this.getStaticResourceByteArray(resource, target, acceptCompressType)) == null) {
                return false;
            }
            byte[] resultByteArray = byArray;
            res.setContentLength(resultByteArray.length);
            res.setHeader("Content-Type", contentType);
            if (acceptCompressType != CompressionType.NONE) {
                res.setHeader("Content-Encoding", acceptCompressType.getTypeName());
            }
            String weakETag = resource.getWeakETag();
            Object object2 = req.getHeader("If-None-Match");
            if (object2 != null) {
                String string2 = object2;
                boolean bl = false;
                boolean bl2 = false;
                String etag = string2;
                boolean bl3 = false;
                if (Intrinsics.areEqual(etag, weakETag)) {
                    res.setStatus(304);
                    return true;
                }
            }
            res.setHeader("ETag", weakETag);
            object2 = resultByteArray;
            boolean bl = false;
            InputStream inputStream = new ByteArrayInputStream((byte[])object2);
            object2 = res.getOutputStream();
            Intrinsics.checkNotNullExpressionValue(object2, "res.outputStream");
            ByteStreamsKt.copyTo$default(inputStream, (OutputStream)object2, 0, 2, null);
            res.getOutputStream().close();
            return true;
        }
        return false;
    }

    private final byte[] getStaticResourceByteArray(Resource resource, String target, CompressionType type) {
        if (resource.length() > (long)resourceMaxSize) {
            JavalinLogger.warn$default("Static file '" + target + "' is larger than configured max size for pre-compression (" + resourceMaxSize + " bytes).\nYou can configure the max size with `JettyPrecompressingResourceHandler.resourceMaxSize = newMaxSize`.", null, 2, null);
            return null;
        }
        return compressedFiles.computeIfAbsent(Intrinsics.stringPlus(target, type.getExtension()), arg_0 -> JettyPrecompressingResourceHandler.getStaticResourceByteArray$lambda-1(resource, type, arg_0));
    }

    private final byte[] getCompressedByteArray(Resource resource, CompressionType type) {
        InputStream fileInput = resource.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = type == CompressionType.GZIP ? (OutputStream)new LeveledGzipStream((OutputStream)byteArrayOutputStream, 9) : (type == CompressionType.BR && Util.INSTANCE.dependencyIsPresent(OptionalDependency.JVMBROTLI) ? (OutputStream)((Object)new LeveledBrotliStream(byteArrayOutputStream, 11)) : (OutputStream)byteArrayOutputStream);
        Intrinsics.checkNotNullExpressionValue(fileInput, "fileInput");
        ByteStreamsKt.copyTo$default(fileInput, outputStream, 0, 2, null);
        fileInput.close();
        outputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "byteArrayOutputStream.toByteArray()");
        return byArray;
    }

    private final boolean excludedMimeType(String mimeType) {
        boolean bl;
        block5: {
            if (Intrinsics.areEqual(mimeType, "")) {
                bl = false;
            } else {
                Iterable $this$any$iv = excludedMimeTypes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String excluded = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains((CharSequence)mimeType, excluded, true)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    private static final byte[] getStaticResourceByteArray$lambda-1(Resource $resource, CompressionType $type, String it) {
        Intrinsics.checkNotNullParameter($resource, "$resource");
        Intrinsics.checkNotNullParameter((Object)$type, "$type");
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.getCompressedByteArray($resource, $type);
    }
}

