/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import io.hops.hudi.com.google.protobuf.ByteString;
import io.hops.hudi.com.google.protobuf.Message;
import io.hops.hudi.com.google.protobuf.RpcCallback;
import io.hops.hudi.com.google.protobuf.RpcController;
import io.hops.hudi.com.google.protobuf.Service;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.protobuf.generated.RowProcessorProtos;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RowProcessor;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public abstract class BaseRowProcessorEndpoint<S extends Message, T extends Message>
extends RowProcessorProtos.RowProcessorService
implements RegionCoprocessor {
    private RegionCoprocessorEnvironment env;

    @Override
    public void process(RpcController controller, RowProcessorProtos.ProcessRequest request, RpcCallback<RowProcessorProtos.ProcessResponse> done) {
        RowProcessorProtos.ProcessResponse resultProto = null;
        try {
            RowProcessor<S, T> processor = this.constructRowProcessorFromRequest(request);
            Region region = this.env.getRegion();
            long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
            long nonce = request.hasNonce() ? request.getNonce() : 0L;
            region.processRowsWithLocks(processor, nonceGroup, nonce);
            T result = processor.getResult();
            RowProcessorProtos.ProcessResponse.Builder b = RowProcessorProtos.ProcessResponse.newBuilder();
            b.setRowProcessorResult(result.toByteString());
            resultProto = b.build();
        }
        catch (Exception e) {
            CoprocessorRpcUtils.setControllerException(controller, new IOException(e));
        }
        done.run(resultProto);
    }

    @Override
    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    RowProcessor<S, T> constructRowProcessorFromRequest(RowProcessorProtos.ProcessRequest request) throws IOException {
        String className = request.getRowProcessorClassName();
        try {
            Class<?> cls = Class.forName(className);
            RowProcessor ci = (RowProcessor)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (request.hasRowProcessorInitializerMessageName()) {
                Message s;
                Method m;
                Class<Message> imn = Class.forName(request.getRowProcessorInitializerMessageName()).asSubclass(Message.class);
                try {
                    m = imn.getMethod("parseFrom", ByteString.class);
                }
                catch (SecurityException e) {
                    throw new IOException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new IOException(e);
                }
                try {
                    s = (Message)m.invoke(null, request.getRowProcessorInitializerMessage());
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IOException(e);
                }
                ci.initialize(s);
            }
            return ci;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

