/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.VersionInfoUtil;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionServerTracker
extends ZKListener {
    private static final Logger LOG = LoggerFactory.getLogger(RegionServerTracker.class);
    private final Set<ServerName> regionServers = new HashSet<ServerName>();
    private final ServerManager serverManager;
    private final MasterServices server;
    private final ExecutorService executor;

    public RegionServerTracker(ZKWatcher watcher, MasterServices server, ServerManager serverManager) {
        super(watcher);
        this.server = server;
        this.serverManager = serverManager;
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("RegionServerTracker-%d").build());
    }

    private Pair<ServerName, HBaseProtos.RegionServerInfo> getServerInfo(String name) throws KeeperException, IOException {
        byte[] data;
        ServerName serverName = ServerName.parseServerName(name);
        String nodePath = ZNodePaths.joinZNode(this.watcher.getZNodePaths().rsZNode, name);
        try {
            data = ZKUtil.getData((ZKWatcher)this.watcher, (String)nodePath);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        if (data == null) {
            LOG.warn("Server node {} does not exist, already dead?", (Object)name);
            return Pair.newPair(serverName, null);
        }
        if (data.length == 0 || !ProtobufUtil.isPBMagicPrefix(data)) {
            LOG.warn("Invalid data for region server node {} on zookeeper, data length = {}", (Object)name, (Object)data.length);
            return Pair.newPair(serverName, null);
        }
        HBaseProtos.RegionServerInfo.Builder builder = HBaseProtos.RegionServerInfo.newBuilder();
        int magicLen = ProtobufUtil.lengthOfPBMagic();
        ProtobufUtil.mergeFrom(builder, data, magicLen, data.length - magicLen);
        return Pair.newPair(serverName, builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Set<ServerName> deadServersFromPE, Set<ServerName> liveServersFromWALDir, Set<ServerName> splittingServersFromWALDir) throws KeeperException, IOException {
        LOG.info("Starting RegionServerTracker; {} have existing ServerCrashProcedures, {} possibly 'live' servers, and {} 'splitting'.", new Object[]{deadServersFromPE.size(), liveServersFromWALDir.size(), splittingServersFromWALDir.size()});
        splittingServersFromWALDir.stream().filter(s -> !deadServersFromPE.contains(s)).forEach(s -> LOG.error("{} has no matching ServerCrashProcedure", s));
        liveServersFromWALDir.forEach(sn -> this.server.getAssignmentManager().getRegionStates().getOrCreateServer((ServerName)sn));
        this.watcher.registerListener((ZKListener)this);
        RegionServerTracker regionServerTracker = this;
        synchronized (regionServerTracker) {
            List servers = ZKUtil.listChildrenAndWatchForNewChildren((ZKWatcher)this.watcher, (String)this.watcher.getZNodePaths().rsZNode);
            if (null != servers) {
                for (String n : servers) {
                    Pair<ServerName, HBaseProtos.RegionServerInfo> pair = this.getServerInfo(n);
                    ServerName serverName = pair.getFirst();
                    HBaseProtos.RegionServerInfo info = pair.getSecond();
                    this.regionServers.add(serverName);
                    ServerMetrics serverMetrics = info != null ? ServerMetricsBuilder.of(serverName, VersionInfoUtil.getVersionNumber(info.getVersionInfo()), info.getVersionInfo().getVersion()) : ServerMetricsBuilder.of(serverName);
                    this.serverManager.checkAndRecordNewServer(serverName, serverMetrics);
                }
            }
            this.serverManager.findDeadServersAndProcess(deadServersFromPE, liveServersFromWALDir);
        }
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    private synchronized void refresh() {
        List names;
        try {
            names = ZKUtil.listChildrenAndWatchForNewChildren((ZKWatcher)this.watcher, (String)this.watcher.getZNodePaths().rsZNode);
        }
        catch (KeeperException e) {
            this.server.abort("Unexpected zk exception getting RS nodes", e);
            return;
        }
        Set<ServerName> servers = CollectionUtils.isEmpty(names) ? Collections.emptySet() : names.stream().map(ServerName::parseServerName).collect(Collectors.toSet());
        Iterator<ServerName> iter = this.regionServers.iterator();
        while (iter.hasNext()) {
            ServerName sn = iter.next();
            if (servers.contains(sn)) continue;
            LOG.info("RegionServer ephemeral node deleted, processing expiration [{}]", (Object)sn);
            this.serverManager.expireServer(sn);
            iter.remove();
        }
        boolean newServerAdded = false;
        for (ServerName sn : servers) {
            if (!this.regionServers.add(sn)) continue;
            newServerAdded = true;
            LOG.info("RegionServer ephemeral node created, adding [" + sn + "]");
        }
        if (newServerAdded && this.server.isInitialized()) {
            this.server.checkIfShouldMoveSystemRegionAsync();
        }
    }

    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.getZNodePaths().rsZNode) && !this.server.isAborted() && !this.server.isStopped()) {
            this.executor.execute(this::refresh);
        }
    }
}

