/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.compactions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.MobCompactPartitionPolicy;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.mob.MobConstants;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.compactions.MobCompactionRequest;
import org.apache.hadoop.hbase.mob.compactions.MobCompactor;
import org.apache.hadoop.hbase.mob.compactions.PartitionedMobCompactionRequest;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class PartitionedMobCompactor
extends MobCompactor {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionedMobCompactor.class);
    protected long mergeableSize;
    protected int delFileMaxCount;
    protected int compactionBatchSize;
    protected int compactionKVMax;
    private final Path tempPath;
    private final Path bulkloadPath;
    private final CacheConfig compactionCacheConfig;
    private final byte[] refCellTags;
    private Encryption.Context cryptoContext = Encryption.Context.NONE;

    public PartitionedMobCompactor(Configuration conf, FileSystem fs, TableName tableName, ColumnFamilyDescriptor column, ExecutorService pool) throws IOException {
        super(conf, fs, tableName, column, pool);
        this.mergeableSize = conf.getLong("hbase.mob.compaction.mergeable.threshold", 0x50000000L);
        this.delFileMaxCount = conf.getInt("hbase.mob.delfile.max.count", 3);
        this.compactionBatchSize = conf.getInt("hbase.mob.compaction.batch.size", 100);
        this.tempPath = new Path(MobUtils.getMobHome(conf), ".tmp");
        this.bulkloadPath = new Path(this.tempPath, new Path(".bulkload", new Path(tableName.getNamespaceAsString(), tableName.getQualifierAsString())));
        this.compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        Configuration copyOfConf = new Configuration(conf);
        copyOfConf.setFloat("hfile.block.cache.size", 0.0f);
        this.compactionCacheConfig = new CacheConfig(copyOfConf);
        ArrayList<Tag> tags = new ArrayList<Tag>(2);
        tags.add(MobConstants.MOB_REF_TAG);
        ArrayBackedTag tableNameTag = new ArrayBackedTag(6, tableName.getName());
        tags.add(tableNameTag);
        this.refCellTags = TagUtil.fromList(tags);
        this.cryptoContext = EncryptionUtil.createEncryptionContext(copyOfConf, column);
    }

    @Override
    public List<Path> compact(List<FileStatus> files, boolean allFiles) throws IOException {
        if (files == null || files.isEmpty()) {
            LOG.info("No candidate mob files");
            return null;
        }
        LOG.info("is allFiles: " + allFiles);
        PartitionedMobCompactionRequest request = this.select(files, allFiles);
        return this.performCompaction(request);
    }

    protected PartitionedMobCompactionRequest select(List<FileStatus> candidates, boolean allFiles) throws IOException {
        HFileLink link;
        FileStatus linkedFile;
        HashMap<PartitionedMobCompactionRequest.CompactionPartitionId, PartitionedMobCompactionRequest.CompactionPartition> filesToCompact = new HashMap<PartitionedMobCompactionRequest.CompactionPartitionId, PartitionedMobCompactionRequest.CompactionPartition>();
        PartitionedMobCompactionRequest.CompactionPartitionId id = new PartitionedMobCompactionRequest.CompactionPartitionId();
        TreeMap<PartitionedMobCompactionRequest.CompactionDelPartitionId, PartitionedMobCompactionRequest.CompactionDelPartition> delFilesToCompact = new TreeMap<PartitionedMobCompactionRequest.CompactionDelPartitionId, PartitionedMobCompactionRequest.CompactionDelPartition>();
        PartitionedMobCompactionRequest.CompactionDelPartitionId delId = new PartitionedMobCompactionRequest.CompactionDelPartitionId();
        ArrayList<PartitionedMobCompactionRequest.CompactionDelPartition> allDelPartitions = new ArrayList<PartitionedMobCompactionRequest.CompactionDelPartition>();
        int selectedFileCount = 0;
        int irrelevantFileCount = 0;
        int totalDelFiles = 0;
        MobCompactPartitionPolicy policy = this.column.getMobCompactPartitionPolicy();
        Calendar calendar = Calendar.getInstance();
        Date currentDate = new Date();
        Date firstDayOfCurrentMonth = null;
        Date firstDayOfCurrentWeek = null;
        if (policy == MobCompactPartitionPolicy.MONTHLY) {
            firstDayOfCurrentMonth = MobUtils.getFirstDayOfMonth(calendar, currentDate);
            firstDayOfCurrentWeek = MobUtils.getFirstDayOfWeek(calendar, currentDate);
        } else if (policy == MobCompactPartitionPolicy.WEEKLY) {
            firstDayOfCurrentWeek = MobUtils.getFirstDayOfWeek(calendar, currentDate);
        }
        boolean withDelFiles = false;
        for (FileStatus fileStatus : candidates) {
            if (!fileStatus.isFile()) continue;
            linkedFile = fileStatus;
            if (HFileLink.isHFileLink(fileStatus.getPath()) && (linkedFile = this.getLinkedFileStatus(link = HFileLink.buildFromHFileLinkPattern(this.conf, fileStatus.getPath()))) == null || !StoreFileInfo.isDelFile(linkedFile.getPath())) continue;
            withDelFiles = true;
            break;
        }
        for (FileStatus fileStatus : candidates) {
            if (!fileStatus.isFile()) {
                ++irrelevantFileCount;
                continue;
            }
            linkedFile = fileStatus;
            if (HFileLink.isHFileLink(fileStatus.getPath()) && (linkedFile = this.getLinkedFileStatus(link = HFileLink.buildFromHFileLinkPattern(this.conf, fileStatus.getPath()))) == null) {
                ++irrelevantFileCount;
                continue;
            }
            if (withDelFiles && StoreFileInfo.isDelFile(linkedFile.getPath())) {
                try (HFile.Reader reader = HFile.createReader(this.fs, linkedFile.getPath(), this.conf);){
                    delId.setStartKey(reader.getFirstRowKey().get());
                    delId.setEndKey(reader.getLastRowKey().get());
                }
                PartitionedMobCompactionRequest.CompactionDelPartition delPartition = (PartitionedMobCompactionRequest.CompactionDelPartition)delFilesToCompact.get(delId);
                if (delPartition == null) {
                    PartitionedMobCompactionRequest.CompactionDelPartitionId newDelId = new PartitionedMobCompactionRequest.CompactionDelPartitionId(delId.getStartKey(), delId.getEndKey());
                    delPartition = new PartitionedMobCompactionRequest.CompactionDelPartition(newDelId);
                    delFilesToCompact.put(newDelId, delPartition);
                }
                delPartition.addDelFile(fileStatus);
                ++totalDelFiles;
                continue;
            }
            String fileName = linkedFile.getPath().getName();
            String date = MobFileName.getDateFromName(fileName);
            boolean skipCompaction = MobUtils.fillPartitionId(id, firstDayOfCurrentMonth, firstDayOfCurrentWeek, date, policy, calendar, this.mergeableSize);
            if (!allFiles && (skipCompaction || linkedFile.getLen() >= id.getThreshold())) continue;
            id.setStartKey(MobFileName.getStartKeyFromName(fileName));
            PartitionedMobCompactionRequest.CompactionPartition compactionPartition = (PartitionedMobCompactionRequest.CompactionPartition)filesToCompact.get(id);
            if (compactionPartition == null) {
                PartitionedMobCompactionRequest.CompactionPartitionId newId = new PartitionedMobCompactionRequest.CompactionPartitionId(id.getStartKey(), id.getDate());
                compactionPartition = new PartitionedMobCompactionRequest.CompactionPartition(newId);
                compactionPartition.addFile(fileStatus);
                filesToCompact.put(newId, compactionPartition);
                newId.updateLatestDate(date);
            } else {
                compactionPartition.addFile(fileStatus);
                compactionPartition.getPartitionId().updateLatestDate(date);
            }
            if (withDelFiles) {
                try (HFile.Reader reader = HFile.createReader(this.fs, linkedFile.getPath(), this.conf);){
                    compactionPartition.setStartKey(reader.getFirstRowKey().get());
                    compactionPartition.setEndKey(reader.getLastRowKey().get());
                }
            }
            ++selectedFileCount;
        }
        for (Map.Entry entry : delFilesToCompact.entrySet()) {
            if (allDelPartitions.size() > 0) {
                PartitionedMobCompactionRequest.CompactionDelPartition prev = allDelPartitions.get(allDelPartitions.size() - 1);
                if (Bytes.compareTo(prev.getId().getEndKey(), ((PartitionedMobCompactionRequest.CompactionDelPartitionId)entry.getKey()).getStartKey()) >= 0) {
                    prev.getId().setEndKey(((PartitionedMobCompactionRequest.CompactionDelPartition)entry.getValue()).getId().getEndKey());
                    prev.addDelFileList(((PartitionedMobCompactionRequest.CompactionDelPartition)entry.getValue()).listDelFiles());
                    continue;
                }
                allDelPartitions.add((PartitionedMobCompactionRequest.CompactionDelPartition)entry.getValue());
                continue;
            }
            allDelPartitions.add((PartitionedMobCompactionRequest.CompactionDelPartition)entry.getValue());
        }
        PartitionedMobCompactionRequest request = new PartitionedMobCompactionRequest(filesToCompact.values(), allDelPartitions);
        if (candidates.size() == totalDelFiles + selectedFileCount + irrelevantFileCount) {
            request.setCompactionType(MobCompactionRequest.CompactionType.ALL_FILES);
        }
        LOG.info("The compaction type is {}, the request has {} del files, {} selected files, and {} irrelevant files table '{}' and column '{}'", new Object[]{request.getCompactionType(), totalDelFiles, selectedFileCount, irrelevantFileCount, this.tableName, this.column.getNameAsString()});
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Path> performCompaction(PartitionedMobCompactionRequest request) throws IOException {
        for (PartitionedMobCompactionRequest.CompactionDelPartition delPartition : request.getDelPartitions()) {
            if (delPartition.getDelFileCount() <= 1) continue;
            List<Path> newDelPaths = this.compactDelFiles(request, delPartition.listDelFiles());
            delPartition.cleanDelFiles();
            delPartition.addDelFileList(newDelPaths);
        }
        List<Path> paths = null;
        int totalDelFileCount = 0;
        try {
            for (PartitionedMobCompactionRequest.CompactionDelPartition delPartition : request.getDelPartitions()) {
                for (Path newDelPath : delPartition.listDelFiles()) {
                    HStoreFile sf = new HStoreFile(this.fs, newDelPath, this.conf, this.compactionCacheConfig, BloomType.NONE, true);
                    sf.initReader();
                    delPartition.addStoreFile(sf);
                    ++totalDelFileCount;
                }
            }
            LOG.info("After merging, there are {} del files. table='{}' column='{}'", new Object[]{totalDelFileCount, this.tableName, this.column.getNameAsString()});
            paths = this.compactMobFiles(request);
            LOG.info("After compaction, there are {} mob files. table='{}' column='{}'", new Object[]{paths.size(), this.tableName, this.column.getNameAsString()});
        }
        finally {
            for (PartitionedMobCompactionRequest.CompactionDelPartition delPartition : request.getDelPartitions()) {
                this.closeStoreFileReaders(delPartition.getStoreFiles());
            }
        }
        if (request.type == MobCompactionRequest.CompactionType.ALL_FILES && !request.getDelPartitions().isEmpty()) {
            LOG.info("After a mob compaction with all files selected, archiving the del files for table='{}' and column='{}'", (Object)this.tableName, (Object)this.column.getNameAsString());
            for (PartitionedMobCompactionRequest.CompactionDelPartition delPartition : request.getDelPartitions()) {
                LOG.info(Objects.toString(delPartition.listDelFiles()));
                if (MobUtils.removeMobFiles(this.conf, this.fs, this.tableName, this.mobTableDir, this.column.getName(), delPartition.getStoreFiles())) continue;
                LOG.error("Failed to archive the del files {} for partition {} table='{}' and column='{}'", new Object[]{delPartition.getStoreFiles(), delPartition.getId(), this.tableName, this.column.getNameAsString()});
            }
        }
        return paths;
    }

    List<HStoreFile> getListOfDelFilesForPartition(PartitionedMobCompactionRequest.CompactionPartition partition, List<PartitionedMobCompactionRequest.CompactionDelPartition> delPartitions) {
        ArrayList<HStoreFile> result = new ArrayList<HStoreFile>();
        DelPartitionComparator comparator = new DelPartitionComparator(false);
        PartitionedMobCompactionRequest.CompactionDelPartitionId id = new PartitionedMobCompactionRequest.CompactionDelPartitionId(null, partition.getStartKey());
        PartitionedMobCompactionRequest.CompactionDelPartition target = new PartitionedMobCompactionRequest.CompactionDelPartition(id);
        int start2 = Collections.binarySearch(delPartitions, target, comparator);
        if (start2 < 0) {
            if ((start2 = (start2 + 1) * -1) == delPartitions.size()) {
                return result;
            }
            if (Bytes.compareTo(partition.getEndKey(), delPartitions.get(start2).getId().getStartKey()) < 0) {
                return result;
            }
        }
        comparator.setCompareStartKey(true);
        id.setStartKey(partition.getEndKey());
        int end = Collections.binarySearch(delPartitions, target, comparator);
        if (end < 0) {
            if ((end = (end + 1) * -1) == 0) {
                return result;
            }
            if (Bytes.compareTo(partition.getStartKey(), delPartitions.get(--end).getId().getEndKey()) > 0) {
                return result;
            }
        }
        for (int i = start2; i <= end; ++i) {
            result.addAll(delPartitions.get(i).getStoreFiles());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Path> compactMobFiles(final PartitionedMobCompactionRequest request) throws IOException {
        Collection<PartitionedMobCompactionRequest.CompactionPartition> partitions = request.compactionPartitions;
        if (partitions == null || partitions.isEmpty()) {
            LOG.info("No partitions of mob files in table='{}' and column='{}'", (Object)this.tableName, (Object)this.column.getNameAsString());
            return Collections.emptyList();
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        final Connection c = ConnectionFactory.createConnection(this.conf);
        final Table table = c.getTable(this.tableName);
        try {
            HashMap<PartitionedMobCompactionRequest.CompactionPartitionId, Future<List<Path>>> results = new HashMap<PartitionedMobCompactionRequest.CompactionPartitionId, Future<List<Path>>>();
            for (final PartitionedMobCompactionRequest.CompactionPartition partition : partitions) {
                final List<HStoreFile> delFiles = this.getListOfDelFilesForPartition(partition, request.getDelPartitions());
                results.put(partition.getPartitionId(), this.pool.submit(new Callable<List<Path>>(){

                    @Override
                    public List<Path> call() throws Exception {
                        LOG.info("Compacting mob files for partition {} for table='{}' and column='{}'", new Object[]{partition.getPartitionId(), PartitionedMobCompactor.this.tableName, PartitionedMobCompactor.this.column.getNameAsString()});
                        return PartitionedMobCompactor.this.compactMobFilePartition(request, partition, delFiles, c, table);
                    }
                }));
            }
            ArrayList failedPartitions = new ArrayList();
            for (Map.Entry result : results.entrySet()) {
                try {
                    paths.addAll((Collection)((Future)result.getValue()).get());
                }
                catch (Exception e) {
                    LOG.error("Failed to compact the partition {} for table='{}' and column='{}'", new Object[]{result.getKey(), this.tableName, this.column.getNameAsString(), e});
                    failedPartitions.add(result.getKey());
                }
            }
            if (!failedPartitions.isEmpty()) {
                throw new IOException("Failed to compact the partitions " + failedPartitions + " for table='" + this.tableName + "' column='" + this.column.getNameAsString() + "'");
            }
        }
        finally {
            try {
                table.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close the Table", (Throwable)e);
            }
        }
        return paths;
    }

    private List<Path> compactMobFilePartition(PartitionedMobCompactionRequest request, PartitionedMobCompactionRequest.CompactionPartition partition, List<HStoreFile> delFiles, Connection connection, Table table) throws IOException {
        if (MobUtils.isMobFileExpired(this.column, EnvironmentEdgeManager.currentTime(), partition.getPartitionId().getDate())) {
            return Collections.emptyList();
        }
        ArrayList<Path> newFiles = new ArrayList<Path>();
        List<FileStatus> files = partition.listFiles();
        int offset = 0;
        Path bulkloadPathOfPartition = new Path(this.bulkloadPath, partition.getPartitionId().toString());
        Path bulkloadColumnPath = new Path(bulkloadPathOfPartition, this.column.getNameAsString());
        while (offset < files.size()) {
            int batch = this.compactionBatchSize;
            if (files.size() - offset < this.compactionBatchSize) {
                batch = files.size() - offset;
            }
            if (batch == 1 && delFiles.isEmpty()) {
                newFiles.add(files.get(offset).getPath());
                ++offset;
                continue;
            }
            this.fs.delete(bulkloadPathOfPartition, true);
            ArrayList<HStoreFile> filesToCompact = new ArrayList<HStoreFile>();
            for (int i = offset; i < batch + offset; ++i) {
                HStoreFile sf = new HStoreFile(this.fs, files.get(i).getPath(), this.conf, this.compactionCacheConfig, BloomType.NONE, true);
                filesToCompact.add(sf);
            }
            filesToCompact.addAll(delFiles);
            this.compactMobFilesInBatch(request, partition, connection, table, filesToCompact, batch, bulkloadPathOfPartition, bulkloadColumnPath, newFiles);
            offset += batch;
        }
        LOG.info("Compaction is finished. The number of mob files is changed from {} to {} for partition={} for table='{}' and column='{}'", new Object[]{files.size(), newFiles.size(), partition.getPartitionId(), this.tableName, this.column.getNameAsString()});
        return newFiles;
    }

    private void closeStoreFileReaders(List<HStoreFile> storeFiles) {
        for (HStoreFile storeFile : storeFiles) {
            try {
                storeFile.closeStoreFile(true);
            }
            catch (IOException e) {
                LOG.warn("Failed to close the reader on store file " + storeFile.getPath(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compactMobFilesInBatch(PartitionedMobCompactionRequest request, PartitionedMobCompactionRequest.CompactionPartition partition, Connection connection, Table table, List<HStoreFile> filesToCompact, int batch, Path bulkloadPathOfPartition, Path bulkloadColumnPath, List<Path> newFiles) throws IOException {
        StoreScanner scanner = this.createScanner(filesToCompact, ScanType.COMPACT_DROP_DELETES);
        List<HStoreFile> mobFilesToCompact = filesToCompact.subList(0, batch);
        Pair<Long, Long> fileInfo = this.getFileInfo(mobFilesToCompact);
        StoreFileWriter writer = null;
        StoreFileWriter refFileWriter = null;
        Path filePath = null;
        long mobCells = 0L;
        boolean cleanupTmpMobFile = false;
        boolean cleanupBulkloadDirOfPartition = false;
        boolean cleanupCommittedMobFile = false;
        boolean closeReaders = true;
        try {
            block15: {
                try {
                    boolean hasMore;
                    writer = MobUtils.createWriter(this.conf, this.fs, this.column, partition.getPartitionId().getLatestDate(), this.tempPath, Long.MAX_VALUE, this.column.getCompactionCompressionType(), partition.getPartitionId().getStartKey(), this.compactionCacheConfig, this.cryptoContext, true);
                    cleanupTmpMobFile = true;
                    filePath = writer.getPath();
                    byte[] fileName = Bytes.toBytes(filePath.getName());
                    refFileWriter = MobUtils.createRefFileWriter(this.conf, this.fs, this.column, bulkloadColumnPath, fileInfo.getSecond(), this.compactionCacheConfig, this.cryptoContext, true);
                    cleanupBulkloadDirOfPartition = true;
                    ArrayList<Cell> cells = new ArrayList<Cell>();
                    ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(this.compactionKVMax).build();
                    do {
                        hasMore = scanner.next(cells, scannerContext);
                        for (Cell cell : cells) {
                            writer.append(cell);
                            Cell reference = MobUtils.createMobRefCell(cell, fileName, this.refCellTags);
                            refFileWriter.append(reference);
                            ++mobCells;
                        }
                        cells.clear();
                    } while (hasMore);
                    scanner.close();
                    if (!cleanupTmpMobFile) break block15;
                }
                catch (Throwable throwable) {
                    scanner.close();
                    if (cleanupTmpMobFile) {
                        this.closeMobFileWriter(writer, fileInfo.getFirst(), mobCells);
                    }
                    if (!cleanupBulkloadDirOfPartition) throw throwable;
                    this.closeRefFileWriter(refFileWriter, fileInfo.getFirst(), request.selectionTime);
                    throw throwable;
                }
                this.closeMobFileWriter(writer, fileInfo.getFirst(), mobCells);
            }
            if (cleanupBulkloadDirOfPartition) {
                this.closeRefFileWriter(refFileWriter, fileInfo.getFirst(), request.selectionTime);
            }
            if (mobCells > 0L) {
                MobUtils.commitFile(this.conf, this.fs, filePath, this.mobFamilyDir, this.compactionCacheConfig);
                cleanupTmpMobFile = false;
                cleanupCommittedMobFile = true;
                LOG.info("start MOB ref bulkload for partition {} table='{}' column='{}'", new Object[]{partition.getPartitionId(), this.tableName, this.column.getNameAsString()});
                this.bulkloadRefFile(connection, table, bulkloadPathOfPartition, filePath.getName());
                cleanupCommittedMobFile = false;
                LOG.info("end MOB ref bulkload for partition {} table='{}' column='{}'", new Object[]{partition.getPartitionId(), this.tableName, this.column.getNameAsString()});
                newFiles.add(new Path(this.mobFamilyDir, filePath.getName()));
            }
            this.closeStoreFileReaders(mobFilesToCompact);
            closeReaders = false;
            MobUtils.removeMobFiles(this.conf, this.fs, this.tableName, this.mobTableDir, this.column.getName(), mobFilesToCompact);
            if (closeReaders) {
                this.closeStoreFileReaders(mobFilesToCompact);
            }
            if (cleanupTmpMobFile) {
                this.deletePath(filePath);
            }
            if (cleanupBulkloadDirOfPartition) {
                this.deletePath(bulkloadPathOfPartition);
            }
            if (!cleanupCommittedMobFile) return;
        }
        catch (Throwable throwable) {
            if (closeReaders) {
                this.closeStoreFileReaders(mobFilesToCompact);
            }
            if (cleanupTmpMobFile) {
                this.deletePath(filePath);
            }
            if (cleanupBulkloadDirOfPartition) {
                this.deletePath(bulkloadPathOfPartition);
            }
            if (!cleanupCommittedMobFile) throw throwable;
            LOG.error("failed MOB ref bulkload for partition {} table='{}' column='{}'", new Object[]{partition.getPartitionId(), this.tableName, this.column.getNameAsString()});
            MobUtils.removeMobFiles(this.conf, this.fs, this.tableName, this.mobTableDir, this.column.getName(), Collections.singletonList(new HStoreFile(this.fs, new Path(this.mobFamilyDir, filePath.getName()), this.conf, this.compactionCacheConfig, BloomType.NONE, true)));
            throw throwable;
        }
        LOG.error("failed MOB ref bulkload for partition {} table='{}' column='{}'", new Object[]{partition.getPartitionId(), this.tableName, this.column.getNameAsString()});
        MobUtils.removeMobFiles(this.conf, this.fs, this.tableName, this.mobTableDir, this.column.getName(), Collections.singletonList(new HStoreFile(this.fs, new Path(this.mobFamilyDir, filePath.getName()), this.conf, this.compactionCacheConfig, BloomType.NONE, true)));
    }

    protected List<Path> compactDelFiles(PartitionedMobCompactionRequest request, List<Path> delFilePaths) throws IOException {
        if (delFilePaths.size() <= this.delFileMaxCount) {
            return delFilePaths;
        }
        int offset = 0;
        ArrayList<Path> paths = new ArrayList<Path>();
        while (offset < delFilePaths.size()) {
            int batch = this.compactionBatchSize;
            if (delFilePaths.size() - offset < this.compactionBatchSize) {
                batch = delFilePaths.size() - offset;
            }
            ArrayList<HStoreFile> batchedDelFiles = new ArrayList<HStoreFile>();
            if (batch == 1) {
                paths.add(delFilePaths.get(offset));
                ++offset;
                continue;
            }
            for (int i = offset; i < batch + offset; ++i) {
                batchedDelFiles.add(new HStoreFile(this.fs, delFilePaths.get(i), this.conf, this.compactionCacheConfig, BloomType.NONE, true));
            }
            paths.add(this.compactDelFilesInBatch(request, batchedDelFiles));
            offset += batch;
        }
        return this.compactDelFiles(request, paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path compactDelFilesInBatch(PartitionedMobCompactionRequest request, List<HStoreFile> delFiles) throws IOException {
        Path filePath;
        block8: {
            StoreScanner scanner = this.createScanner(delFiles, ScanType.COMPACT_RETAIN_DELETES);
            StoreFileWriter writer = null;
            filePath = null;
            try {
                boolean hasMore;
                writer = MobUtils.createDelFileWriter(this.conf, this.fs, this.column, MobUtils.formatDate(new Date(request.selectionTime)), this.tempPath, Long.MAX_VALUE, this.column.getCompactionCompressionType(), HConstants.EMPTY_START_ROW, this.compactionCacheConfig, this.cryptoContext);
                filePath = writer.getPath();
                ArrayList<Cell> cells = new ArrayList<Cell>();
                ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(this.compactionKVMax).build();
                do {
                    hasMore = scanner.next(cells, scannerContext);
                    for (Cell cell : cells) {
                        writer.append(cell);
                    }
                    cells.clear();
                } while (hasMore);
                scanner.close();
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                scanner.close();
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Failed to close the writer of the file " + filePath, (Throwable)e);
                }
                throw throwable;
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close the writer of the file " + filePath, (Throwable)e);
            }
        }
        Path path = MobUtils.commitFile(this.conf, this.fs, filePath, this.mobFamilyDir, this.compactionCacheConfig);
        MobUtils.removeMobFiles(this.conf, this.fs, this.tableName, this.mobTableDir, this.column.getName(), delFiles);
        return path;
    }

    private StoreScanner createScanner(List<HStoreFile> filesToCompact, ScanType scanType) throws IOException {
        List<StoreFileScanner> scanners = StoreFileScanner.getScannersForStoreFiles(filesToCompact, false, true, false, false, Long.MAX_VALUE);
        long ttl = HStore.determineTTLFromFamily(this.column);
        ScanInfo scanInfo = new ScanInfo(this.conf, this.column, ttl, 0L, CellComparator.getInstance());
        return new StoreScanner(scanInfo, scanType, scanners);
    }

    private void bulkloadRefFile(Connection connection, Table table, Path bulkloadDirectory, String fileName) throws IOException {
        try {
            LoadIncrementalHFiles bulkload = new LoadIncrementalHFiles(this.conf);
            bulkload.disableReplication();
            bulkload.doBulkLoad(bulkloadDirectory, connection.getAdmin(), table, connection.getRegionLocator(table.getName()));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void closeMobFileWriter(StoreFileWriter writer, long maxSeqId, long mobCellsCount) throws IOException {
        if (writer != null) {
            writer.appendMetadata(maxSeqId, false, mobCellsCount);
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close the writer of the file " + writer.getPath(), (Throwable)e);
            }
        }
    }

    private void closeRefFileWriter(StoreFileWriter writer, long maxSeqId, long bulkloadTime) throws IOException {
        if (writer != null) {
            writer.appendMetadata(maxSeqId, false);
            writer.appendFileInfo(HStoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes(bulkloadTime));
            writer.appendFileInfo(HStoreFile.SKIP_RESET_SEQ_ID, Bytes.toBytes(true));
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close the writer of the ref file " + writer.getPath(), (Throwable)e);
            }
        }
    }

    private Pair<Long, Long> getFileInfo(List<HStoreFile> storeFiles) throws IOException {
        long maxSeqId = 0L;
        long maxKeyCount = 0L;
        for (HStoreFile sf : storeFiles) {
            maxSeqId = Math.max(maxSeqId, sf.getMaxSequenceId());
            sf.initReader();
            byte[] count = sf.getReader().loadFileInfo().get(HStoreFile.MOB_CELLS_COUNT);
            if (count == null) continue;
            maxKeyCount += Bytes.toLong(count);
        }
        return new Pair<Long, Long>(maxSeqId, maxKeyCount);
    }

    private void deletePath(Path path) {
        LOG.debug("Cleanup, delete path '{}'", (Object)path);
        try {
            if (path != null) {
                this.fs.delete(path, true);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to delete the file " + path, (Throwable)e);
        }
    }

    private FileStatus getLinkedFileStatus(HFileLink link) throws IOException {
        Path[] locations;
        for (Path location : locations = link.getLocations()) {
            if (location == null) continue;
            try {
                FileStatus file = this.fs.getFileStatus(location);
                if (file == null) continue;
                return file;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        LOG.warn("The file " + link + " links to can not be found");
        return null;
    }

    static class DelPartitionComparator
    implements Comparator<PartitionedMobCompactionRequest.CompactionDelPartition> {
        private boolean compareStartKey;

        DelPartitionComparator(boolean compareStartKey) {
            this.compareStartKey = compareStartKey;
        }

        public boolean getCompareStartKey() {
            return this.compareStartKey;
        }

        public void setCompareStartKey(boolean compareStartKey) {
            this.compareStartKey = compareStartKey;
        }

        @Override
        public int compare(PartitionedMobCompactionRequest.CompactionDelPartition o1, PartitionedMobCompactionRequest.CompactionDelPartition o2) {
            if (this.compareStartKey) {
                return Bytes.compareTo(o1.getId().getStartKey(), o2.getId().getStartKey());
            }
            return Bytes.compareTo(o1.getId().getEndKey(), o2.getId().getEndKey());
        }
    }
}

