/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.primitives.Bytes;
import java.util.Arrays;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Private
public class DelimitedKeyPrefixRegionSplitPolicy
extends IncreasingToUpperBoundRegionSplitPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(DelimitedKeyPrefixRegionSplitPolicy.class);
    public static final String DELIMITER_KEY = "DelimitedKeyPrefixRegionSplitPolicy.delimiter";
    private byte[] delimiter = null;

    @Override
    public String toString() {
        return "DelimitedKeyPrefixRegionSplitPolicy{delimiter=" + org.apache.hadoop.hbase.util.Bytes.toStringBinary(this.delimiter) + ", " + super.toString() + '}';
    }

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        String delimiterString = region.getTableDescriptor().getValue(DELIMITER_KEY);
        if (delimiterString == null || delimiterString.length() == 0) {
            LOG.error("DelimitedKeyPrefixRegionSplitPolicy.delimiter not specified for table " + region.getTableDescriptor().getTableName() + ". Using default RegionSplitPolicy");
            return;
        }
        this.delimiter = org.apache.hadoop.hbase.util.Bytes.toBytes(delimiterString);
    }

    @Override
    protected byte[] getSplitPoint() {
        byte[] splitPoint = super.getSplitPoint();
        if (splitPoint != null && this.delimiter != null) {
            int index = Bytes.indexOf(splitPoint, this.delimiter);
            if (index < 0) {
                LOG.warn("Delimiter " + org.apache.hadoop.hbase.util.Bytes.toString(this.delimiter) + "  not found for split key " + org.apache.hadoop.hbase.util.Bytes.toString(splitPoint));
                return splitPoint;
            }
            return Arrays.copyOf(splitPoint, Math.min(index, splitPoint.length));
        }
        return splitPoint;
    }
}

