/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CryptoAESUnwrapHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final CryptoAES cryptoAES;

    public CryptoAESUnwrapHandler(CryptoAES cryptoAES) {
        this.cryptoAES = cryptoAES;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        byte[] bytes = new byte[msg.readableBytes()];
        msg.readBytes(bytes);
        ctx.fireChannelRead(Unpooled.wrappedBuffer(this.cryptoAES.unwrap(bytes, 0, bytes.length)));
    }
}

