/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class TerminatedWrapper<T>
implements DataType<T> {
    protected final DataType<T> wrapped;
    protected final byte[] term;

    public TerminatedWrapper(DataType<T> wrapped, byte[] term) {
        if (null == term || term.length == 0) {
            throw new IllegalArgumentException("terminator must be non-null and non-empty.");
        }
        this.wrapped = wrapped;
        wrapped.getOrder().apply(term);
        this.term = term;
    }

    public TerminatedWrapper(DataType<T> wrapped, String term) {
        this(wrapped, Bytes.toBytes(term));
    }

    @Override
    public boolean isOrderPreserving() {
        return this.wrapped.isOrderPreserving();
    }

    @Override
    public Order getOrder() {
        return this.wrapped.getOrder();
    }

    @Override
    public boolean isNullable() {
        return this.wrapped.isNullable();
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    @Override
    public int encodedLength(T val) {
        return this.wrapped.encodedLength(val) + this.term.length;
    }

    @Override
    public Class<T> encodedClass() {
        return this.wrapped.encodedClass();
    }

    protected int terminatorPosition(PositionedByteRange src) {
        byte[] a = src.getBytes();
        int offset = src.getOffset();
        block0: for (int i = src.getPosition(); i < src.getLength(); ++i) {
            int j;
            if (a[offset + i] != this.term[0]) continue;
            for (j = 1; j < this.term.length && offset + j < src.getLength(); ++j) {
                if (a[offset + i + j] != this.term[j]) continue block0;
            }
            if (j != this.term.length) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int skip(PositionedByteRange src) {
        if (this.wrapped.isSkippable()) {
            int ret = this.wrapped.skip(src);
            src.setPosition(src.getPosition() + this.term.length);
            return ret + this.term.length;
        }
        int start2 = src.getPosition();
        int skipped = this.terminatorPosition(src);
        if (-1 == skipped) {
            throw new IllegalArgumentException("Terminator sequence not found.");
        }
        src.setPosition(skipped += this.term.length);
        return skipped - start2;
    }

    @Override
    public T decode(PositionedByteRange src) {
        if (this.wrapped.isSkippable()) {
            T ret = this.wrapped.decode(src);
            src.setPosition(src.getPosition() + this.term.length);
            return ret;
        }
        int term = this.terminatorPosition(src);
        if (-1 == term) {
            throw new IllegalArgumentException("Terminator sequence not found.");
        }
        byte[] b = new byte[term - src.getPosition()];
        src.get(b);
        T ret = this.wrapped.decode(new SimplePositionedMutableByteRange(b));
        src.get(this.term);
        return ret;
    }

    @Override
    public int encode(PositionedByteRange dst, T val) {
        int start2 = dst.getPosition();
        int written = this.wrapped.encode(dst, val);
        PositionedByteRange b = dst.shallowCopy();
        b.setLength(dst.getPosition());
        b.setPosition(start2);
        if (-1 != this.terminatorPosition(b)) {
            dst.setPosition(start2);
            throw new IllegalArgumentException("Encoded value contains terminator sequence.");
        }
        dst.put(this.term);
        return written + this.term.length;
    }
}

