/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.AbstractRecoveredEditsOutputSink;
import org.apache.hadoop.hbase.wal.EntryBuffers;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RecoveredEditsOutputSink
extends AbstractRecoveredEditsOutputSink {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveredEditsOutputSink.class);
    private ConcurrentMap<String, AbstractRecoveredEditsOutputSink.RecoveredEditsWriter> writers = new ConcurrentHashMap<String, AbstractRecoveredEditsOutputSink.RecoveredEditsWriter>();

    public RecoveredEditsOutputSink(WALSplitter walSplitter, WALSplitter.PipelineController controller, EntryBuffers entryBuffers, int numWriters) {
        super(walSplitter, controller, entryBuffers, numWriters);
    }

    @Override
    public void append(EntryBuffers.RegionEntryBuffer buffer) throws IOException {
        List<WAL.Entry> entries = buffer.entries;
        if (entries.isEmpty()) {
            LOG.warn("got an empty buffer, skipping");
            return;
        }
        AbstractRecoveredEditsOutputSink.RecoveredEditsWriter writer = this.getRecoveredEditsWriter(buffer.tableName, buffer.encodedRegionName, entries.get(0).getKey().getSequenceId());
        if (writer != null) {
            writer.writeRegionEntries(entries);
        }
    }

    private AbstractRecoveredEditsOutputSink.RecoveredEditsWriter getRecoveredEditsWriter(TableName tableName, byte[] region, long seqId) throws IOException {
        AbstractRecoveredEditsOutputSink.RecoveredEditsWriter ret = (AbstractRecoveredEditsOutputSink.RecoveredEditsWriter)this.writers.get(Bytes.toString(region));
        if (ret != null) {
            return ret;
        }
        ret = this.createRecoveredEditsWriter(tableName, region, seqId);
        if (ret == null) {
            return null;
        }
        LOG.trace("Created {}", (Object)ret.path);
        this.writers.put(Bytes.toString(region), ret);
        return ret;
    }

    @Override
    public List<Path> close() throws IOException {
        boolean isSuccessful = true;
        try {
            isSuccessful = this.finishWriterThreads(false);
        }
        finally {
            isSuccessful &= this.closeWriters();
        }
        return isSuccessful ? this.splits : null;
    }

    private boolean closeWriters() throws IOException {
        ArrayList thrown = Lists.newArrayList();
        for (AbstractRecoveredEditsOutputSink.RecoveredEditsWriter writer : this.writers.values()) {
            this.closeCompletionService.submit(() -> {
                Path dst = this.closeRecoveredEditsWriter(writer, thrown);
                LOG.trace("Closed {}", (Object)dst);
                this.splits.add(dst);
                return null;
            });
        }
        boolean progressFailed = false;
        try {
            int n = this.writers.size();
            for (int i = 0; i < n; ++i) {
                Future future = this.closeCompletionService.take();
                future.get();
                if (progressFailed || this.reporter == null || this.reporter.progress()) continue;
                progressFailed = true;
            }
        }
        catch (InterruptedException e) {
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(e);
            throw iie;
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        finally {
            this.closeThreadPool.shutdownNow();
        }
        if (!thrown.isEmpty()) {
            throw MultipleIOException.createIOException(thrown);
        }
        return !progressFailed;
    }

    @Override
    public Map<String, Long> getOutputCounts() {
        TreeMap<String, Long> ret = new TreeMap<String, Long>();
        for (Map.Entry entry : this.writers.entrySet()) {
            ret.put((String)entry.getKey(), ((AbstractRecoveredEditsOutputSink.RecoveredEditsWriter)entry.getValue()).editsWritten);
        }
        return ret;
    }

    @Override
    public int getNumberOfRecoveredRegions() {
        return this.writers.size();
    }

    @Override
    public int getNumOpenWriters() {
        return this.writers.size();
    }
}

