/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.MoreObjects;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystemHelper;
import org.apache.hadoop.metrics2.lib.MetricsInfoImpl;
import org.apache.hadoop.metrics2.lib.MutableCounter;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.lib.MutableSizeHistogram;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.metrics2.lib.MutableTimeHistogram;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DynamicMetricsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicMetricsRegistry.class);
    private final ConcurrentMap<String, MutableMetric> metricsMap = Maps.newConcurrentMap();
    private final ConcurrentMap<String, MetricsTag> tagsMap = Maps.newConcurrentMap();
    private final MetricsInfo metricsInfo;
    private final DefaultMetricsSystemHelper helper = new DefaultMetricsSystemHelper();
    private static final String[] histogramSuffixes = new String[]{"_num_ops", "_min", "_max", "_median", "_75th_percentile", "_90th_percentile", "_95th_percentile", "_99th_percentile"};

    public DynamicMetricsRegistry(String name) {
        this(Interns.info(name, name));
    }

    public DynamicMetricsRegistry(MetricsInfo info) {
        this.metricsInfo = info;
    }

    public MetricsInfo info() {
        return this.metricsInfo;
    }

    public MutableMetric get(String name) {
        return (MutableMetric)this.metricsMap.get(name);
    }

    public MetricsTag getTag(String name) {
        return (MetricsTag)this.tagsMap.get(name);
    }

    public MutableFastCounter newCounter(String name, String desc, long iVal) {
        return this.newCounter((MetricsInfo)new MetricsInfoImpl(name, desc), iVal);
    }

    public MutableFastCounter newCounter(MetricsInfo info, long iVal) {
        MutableFastCounter ret = new MutableFastCounter(info, iVal);
        return this.addNewMetricIfAbsent(info.name(), ret, MutableFastCounter.class);
    }

    public MutableGaugeLong newGauge(String name, String desc, long iVal) {
        return this.newGauge((MetricsInfo)new MetricsInfoImpl(name, desc), iVal);
    }

    public MutableGaugeLong newGauge(MetricsInfo info, long iVal) {
        MutableGaugeLong ret = new MutableGaugeLong(info, iVal);
        return this.addNewMetricIfAbsent(info.name(), ret, MutableGaugeLong.class);
    }

    public MutableStat newStat(String name, String desc, String sampleName, String valueName, boolean extended) {
        MutableStat ret = new MutableStat(name, desc, sampleName, valueName, extended);
        return this.addNewMetricIfAbsent(name, ret, MutableStat.class);
    }

    public MutableStat newStat(String name, String desc, String sampleName, String valueName) {
        return this.newStat(name, desc, sampleName, valueName, false);
    }

    public MutableRate newRate(String name) {
        return this.newRate(name, name, false);
    }

    public MutableRate newRate(String name, String description) {
        return this.newRate(name, description, false);
    }

    public MutableRate newRate(String name, String desc, boolean extended) {
        return this.newRate(name, desc, extended, true);
    }

    @InterfaceAudience.Private
    public MutableRate newRate(String name, String desc, boolean extended, boolean returnExisting) {
        MutableMetric rate;
        if (returnExisting && (rate = (MutableMetric)this.metricsMap.get(name)) != null) {
            if (rate instanceof MutableRate) {
                return (MutableRate)rate;
            }
            throw new MetricsException("Unexpected metrics type " + rate.getClass() + " for " + name);
        }
        MutableRate ret = new MutableRate(name, desc, extended);
        return this.addNewMetricIfAbsent(name, ret, MutableRate.class);
    }

    public MutableHistogram newHistogram(String name) {
        return this.newHistogram(name, "");
    }

    public MutableHistogram newHistogram(String name, String desc) {
        MutableHistogram histo = new MutableHistogram(name, desc);
        return this.addNewMetricIfAbsent(name, histo, MutableHistogram.class);
    }

    public MutableTimeHistogram newTimeHistogram(String name) {
        return this.newTimeHistogram(name, "");
    }

    public MutableTimeHistogram newTimeHistogram(String name, String desc) {
        MutableTimeHistogram histo = new MutableTimeHistogram(name, desc);
        return this.addNewMetricIfAbsent(name, histo, MutableTimeHistogram.class);
    }

    public MutableSizeHistogram newSizeHistogram(String name) {
        return this.newSizeHistogram(name, "");
    }

    public MutableSizeHistogram newSizeHistogram(String name, String desc) {
        MutableSizeHistogram histo = new MutableSizeHistogram(name, desc);
        return this.addNewMetricIfAbsent(name, histo, MutableSizeHistogram.class);
    }

    synchronized void add(String name, MutableMetric metric) {
        this.addNewMetricIfAbsent(name, metric, MutableMetric.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(String name, long value) {
        MutableMetric m = (MutableMetric)this.metricsMap.get(name);
        if (m != null) {
            if (!(m instanceof MutableStat)) throw new MetricsException("Unsupported add(value) for metric " + name);
            ((MutableStat)m).add(value);
            return;
        } else {
            this.metricsMap.put(name, (MutableMetric)this.newRate(name));
            this.add(name, value);
        }
    }

    public DynamicMetricsRegistry setContext(String name) {
        return this.tag((MetricsInfo)MsInfo.Context, name, true);
    }

    public DynamicMetricsRegistry tag(String name, String description, String value) {
        return this.tag(name, description, value, false);
    }

    public DynamicMetricsRegistry tag(String name, String description, String value, boolean override) {
        return this.tag((MetricsInfo)new MetricsInfoImpl(name, description), value, override);
    }

    public DynamicMetricsRegistry tag(MetricsInfo info, String value, boolean override) {
        MetricsTag tag = Interns.tag(info, value);
        if (!override) {
            MetricsTag existing = this.tagsMap.putIfAbsent(info.name(), tag);
            if (existing != null) {
                throw new MetricsException("Tag " + info.name() + " already exists!");
            }
            return this;
        }
        this.tagsMap.put(info.name(), tag);
        return this;
    }

    public DynamicMetricsRegistry tag(MetricsInfo info, String value) {
        return this.tag(info, value, false);
    }

    Collection<MetricsTag> tags() {
        return this.tagsMap.values();
    }

    Collection<MutableMetric> metrics() {
        return this.metricsMap.values();
    }

    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        for (MetricsTag tag : this.tags()) {
            builder.add(tag);
        }
        for (MutableMetric metric : this.metrics()) {
            metric.snapshot(builder, all);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("info", this.metricsInfo).add("tags", this.tags()).add("metrics", this.metrics()).toString();
    }

    public void removeMetric(String name) {
        this.helper.removeObjectName(name);
        this.metricsMap.remove(name);
    }

    public void removeHistogramMetrics(String baseName) {
        for (String suffix : histogramSuffixes) {
            this.removeMetric(baseName + suffix);
        }
    }

    public MutableGaugeLong getGauge(String gaugeName, long potentialStartingValue) {
        MutableGaugeLong newGauge;
        MutableMetric metric = (MutableMetric)this.metricsMap.get(gaugeName);
        if (metric == null && (metric = this.metricsMap.putIfAbsent(gaugeName, (MutableMetric)(newGauge = new MutableGaugeLong((MetricsInfo)new MetricsInfoImpl(gaugeName, ""), potentialStartingValue)))) == null) {
            return newGauge;
        }
        if (!(metric instanceof MutableGaugeLong)) {
            throw new MetricsException("Metric already exists in registry for metric name: " + gaugeName + " and not of type MetricMutableGaugeLong");
        }
        return (MutableGaugeLong)metric;
    }

    public MutableGaugeInt getGaugeInt(String gaugeName, int potentialStartingValue) {
        MutableGaugeInt newGauge;
        MutableMetric metric = (MutableMetric)this.metricsMap.get(gaugeName);
        if (metric == null && (metric = this.metricsMap.putIfAbsent(gaugeName, (MutableMetric)(newGauge = new MutableGaugeInt((MetricsInfo)new MetricsInfoImpl(gaugeName, ""), potentialStartingValue)))) == null) {
            return newGauge;
        }
        if (!(metric instanceof MutableGaugeInt)) {
            throw new MetricsException("Metric already exists in registry for metric name: " + gaugeName + " and not of type MetricMutableGaugeInr");
        }
        return (MutableGaugeInt)metric;
    }

    public MutableFastCounter getCounter(String counterName, long potentialStartingValue) {
        MutableFastCounter newCounter;
        MutableMetric counter = (MutableMetric)this.metricsMap.get(counterName);
        if (counter == null && (counter = this.metricsMap.putIfAbsent(counterName, (MutableMetric)(newCounter = new MutableFastCounter((MetricsInfo)new MetricsInfoImpl(counterName, ""), potentialStartingValue)))) == null) {
            return newCounter;
        }
        if (!(counter instanceof MutableCounter)) {
            throw new MetricsException("Metric already exists in registry for metric name: " + counterName + " and not of type MutableCounter");
        }
        return (MutableFastCounter)counter;
    }

    public MutableHistogram getHistogram(String histoName) {
        MutableHistogram newCounter;
        MutableMetric histo = (MutableMetric)this.metricsMap.get(histoName);
        if (histo == null && (histo = this.metricsMap.putIfAbsent(histoName, newCounter = new MutableHistogram((MetricsInfo)new MetricsInfoImpl(histoName, "")))) == null) {
            return newCounter;
        }
        if (!(histo instanceof MutableHistogram)) {
            throw new MetricsException("Metric already exists in registry for metric name: " + histoName + " and not of type MutableHistogram");
        }
        return (MutableHistogram)histo;
    }

    private <T extends MutableMetric> T addNewMetricIfAbsent(String name, T ret, Class<T> metricClass) {
        MutableMetric metric = this.metricsMap.putIfAbsent(name, ret);
        if (metric == null) {
            return ret;
        }
        return (T)((MutableMetric)this.returnExistingWithCast(metric, metricClass, name));
    }

    private <T> T returnExistingWithCast(MutableMetric metric, Class<T> metricClass, String name) {
        if (!metricClass.isAssignableFrom(metric.getClass())) {
            throw new MetricsException("Metric already exists in registry for metric name: " + name + " and not of type " + metricClass + " but instead of type " + metric.getClass());
        }
        return (T)metric;
    }

    public void clearMetrics() {
        for (String name : this.metricsMap.keySet()) {
            this.helper.removeObjectName(name);
        }
        this.metricsMap.clear();
    }
}

