/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\b\u0011\u0001]A\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\tW\u0001\u0011\t\u0011)A\u0005O!AA\u0006\u0001BC\u0002\u0013\u0005Q\u0006\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003/\u0011!y\u0004A!b\u0001\n\u0003\u0001\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b)\u0003A\u0011A&\t\u000fE\u0003!\u0019!C\u0005%\"1\u0011\f\u0001Q\u0001\nMCQA\u0017\u0001\u0005BmCQA\u0019\u0001\u0005B\rDQ!\u001c\u0001\u0005\n9Dq!!\b\u0001\t\u0013\ty\u0002C\u0004\u0002:\u0001!I!a\u000f\u0003%\u0019KG.Z*zgR,WNU3mCRLwN\u001c\u0006\u0003#I\tA\u0001[;eS*\u00111\u0003F\u0001\u0007CB\f7\r[3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\r#!\tI\u0002%D\u0001\u001b\u0015\tYB$A\u0004t_V\u00148-Z:\u000b\u0005uq\u0012aA:rY*\u0011qDE\u0001\u0006gB\f'o[\u0005\u0003Ci\u0011ABQ1tKJ+G.\u0019;j_:\u0004\"!G\u0012\n\u0005\u0011R\"!\u0003+bE2,7kY1o\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010^\u000b\u0002OA\u0011\u0001&K\u0007\u00029%\u0011!\u0006\b\u0002\u000b'Fc5i\u001c8uKb$\u0018aC:rY\u000e{g\u000e^3yi\u0002\n\u0011b\u001c9u!\u0006\u0014\u0018-\\:\u0016\u00039\u0002Ba\f\u001d<w9\u0011\u0001G\u000e\t\u0003cQj\u0011A\r\u0006\u0003gY\ta\u0001\u0010:p_Rt$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"\u0014A\u0002)sK\u0012,g-\u0003\u0002:u\t\u0019Q*\u00199\u000b\u0005]\"\u0004CA\u0018=\u0013\ti$H\u0001\u0004TiJLgnZ\u0001\u000b_B$\b+\u0019:b[N\u0004\u0013AC7fi\u0006\u001cE.[3oiV\t\u0011\t\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006)A/\u00192mK*\u0011a\tE\u0001\u0007G>lWn\u001c8\n\u0005!\u001b%!\u0006%p_\u0012LW\rV1cY\u0016lU\r^1DY&,g\u000e^\u0001\f[\u0016$\u0018m\u00117jK:$\b%\u0001\u0004=S:LGO\u0010\u000b\u0005\u0019:{\u0005\u000b\u0005\u0002N\u00015\t\u0001\u0003C\u0003&\u000f\u0001\u0007q\u0005C\u0003-\u000f\u0001\u0007a\u0006C\u0003@\u000f\u0001\u0007\u0011)A\u0002m_\u001e,\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-R\tQa\u001d7gi)L!\u0001W+\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\rM\u001c\u0007.Z7b+\u0005a\u0006CA/a\u001b\u0005q&BA0\u001d\u0003\u0015!\u0018\u0010]3t\u0013\t\tgL\u0001\u0006TiJ,8\r\u001e+za\u0016\f\u0011BY;jY\u0012\u001c6-\u00198\u0015\u0003\u0011\u00042!\u001a5k\u001b\u00051'BA4\u001f\u0003\r\u0011H\rZ\u0005\u0003S\u001a\u00141A\u0015#E!\tA3.\u0003\u0002m9\t\u0019!k\\<\u0002\u001dQ|'*\u0019<b\u0007>t7/^7feV\u0011q\u000e \u000b\u0004a\u00065\u0001cA9yu6\t!O\u0003\u0002ti\u0006Aa-\u001e8di&|gN\u0003\u0002vm\u0006!Q\u000f^5m\u0015\u00059\u0018\u0001\u00026bm\u0006L!!\u001f:\u0003\u0011\r{gn];nKJ\u0004\"a\u001f?\r\u0001\u0011)Q\u0010\u0004b\u0001}\n\tA+E\u0002\u0000\u0003\u000f\u0001B!!\u0001\u0002\u00045\tA'C\u0002\u0002\u0006Q\u0012qAT8uQ&tw\r\u0005\u0003\u0002\u0002\u0005%\u0011bAA\u0006i\t\u0019\u0011I\\=\t\u000f\u0005=A\u00021\u0001\u0002\u0012\u0005A1m\u001c8tk6,'\u000fE\u0004\u0002\u0002\u0005M!0a\u0006\n\u0007\u0005UAGA\u0005Gk:\u001cG/[8ocA!\u0011\u0011AA\r\u0013\r\tY\u0002\u000e\u0002\u0005+:LG/\u0001\nu_*\u000bg/\u0019'p]\u001e4UO\\2uS>tW\u0003BA\u0011\u0003W!B!a\t\u0002.A)\u0011/!\n\u0002*%\u0019\u0011q\u0005:\u0003\u001dQ{Gj\u001c8h\rVt7\r^5p]B\u001910a\u000b\u0005\u000bul!\u0019\u0001@\t\u000f\u0005=R\u00021\u0001\u00022\u0005)\u0011\r\u001d9msBA\u0011\u0011AA\n\u0003S\t\u0019\u0004\u0005\u0003\u0002\u0002\u0005U\u0012bAA\u001ci\t!Aj\u001c8h\u0003=!xNS1wCB\u0013X\rZ5dCR,W\u0003BA\u001f\u0003\u000f\"B!a\u0010\u0002JA)\u0011/!\u0011\u0002F%\u0019\u00111\t:\u0003\u0013A\u0013X\rZ5dCR,\u0007cA>\u0002H\u0011)QP\u0004b\u0001}\"9\u00111\n\bA\u0002\u00055\u0013a\u0001;tiBA\u0011\u0011AA\n\u0003\u000b\ny\u0005\u0005\u0003\u0002\u0002\u0005E\u0013bAA*i\t9!i\\8mK\u0006t\u0007")
public class FileSystemRelation
extends BaseRelation
implements TableScan {
    private final SQLContext sqlContext;
    private final Map<String, String> optParams;
    private final HoodieTableMetaClient metaClient;
    private final Logger log;

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Map<String, String> optParams() {
        return this.optParams;
    }

    public HoodieTableMetaClient metaClient() {
        return this.metaClient;
    }

    private Logger log() {
        return this.log;
    }

    public StructType schema() {
        return new StructType((StructField[])((Object[])new StructField[]{new StructField("File_ID", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Partition_Path", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Base_Instant_Time", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Base_File_Path", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Base_File_Size", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Log_File_Count", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Log_File_Size", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Log_File_Scheduled", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Log_File_Unscheduled", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}));
    }

    public RDD<Row> buildScan() {
        ArrayBuffer data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String subPath = (String)this.optParams().getOrElse((Object)DataSourceReadOptions$.MODULE$.FILESYSTEM_RELATION_ARG_SUBPATH().key(), (Function0 & Serializable & scala.Serializable)() -> "");
        String path = String.format("%s/%s/*", this.metaClient().getBasePath(), subPath);
        List<StoragePathInfo> fileStatusList = FSUtils.getGlobStatusExcludingMetaFolder(this.metaClient().getStorage(), new StoragePath(path));
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(this.metaClient(), this.metaClient().getActiveTimeline().getWriteTimeline(), fileStatusList);
        Stream<HoodieFileGroup> fileGroups = fsView.getAllFileGroups();
        fileGroups.forEach(this.toJavaConsumer((Function1 & Serializable & scala.Serializable)fg -> {
            FileSystemRelation.$anonfun$buildScan$2(this, data, fg);
            return BoxedUnit.UNIT;
        }));
        return this.sqlContext().createDataFrame((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)data).asJava(), this.schema()).rdd();
    }

    private <T> Consumer<T> toJavaConsumer(Function1<T, BoxedUnit> consumer) {
        return new Consumer<T>(null, consumer){
            private final Function1 consumer$1;

            public Consumer<T> andThen(Consumer<? super T> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(T t) {
                this.consumer$1.apply(t);
            }
            {
                this.consumer$1 = consumer$1;
            }
        };
    }

    private <T> ToLongFunction<T> toJavaLongFunction(Function1<T, Object> apply2) {
        return new ToLongFunction<T>(null, apply2){
            private final Function1 apply$1;

            public long applyAsLong(T t) {
                return BoxesRunTime.unboxToLong((Object)this.apply$1.apply(t));
            }
            {
                this.apply$1 = apply$1;
            }
        };
    }

    private <T> Predicate<T> toJavaPredicate(Function1<T, Object> tst) {
        return new Predicate<T>(null, tst){
            private final Function1 tst$1;

            public Predicate<T> and(Predicate<? super T> x$1) {
                return Predicate.super.and(x$1);
            }

            public Predicate<T> negate() {
                return Predicate.super.negate();
            }

            public Predicate<T> or(Predicate<? super T> x$1) {
                return Predicate.super.or(x$1);
            }

            public boolean test(T t) {
                return BoxesRunTime.unboxToBoolean((Object)this.tst$1.apply(t));
            }
            {
                this.tst$1 = tst$1;
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$buildScan$5(FileSlice fs$1, HoodieLogFile lf) {
        String string = lf.getDeltaCommitTime();
        String string2 = fs$1.getBaseInstantTime();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$buildScan$7(FileSlice fs$1, HoodieLogFile lf) {
        String string = lf.getDeltaCommitTime();
        String string2 = fs$1.getBaseInstantTime();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$buildScan$3(FileSystemRelation $this, HoodieFileGroup fg$1, ArrayBuffer data$1, FileSlice fs) {
        long logFileSize = fs.getLogFiles().mapToLong($this.toJavaLongFunction((Function1 & Serializable & scala.Serializable)lf -> BoxesRunTime.boxToLong((long)lf.getFileSize()))).sum();
        long logFileCompactionSize = fs.getLogFiles().filter($this.toJavaPredicate((Function1 & Serializable & scala.Serializable)lf -> BoxesRunTime.boxToBoolean((boolean)FileSystemRelation.$anonfun$buildScan$5(fs, lf)))).mapToLong($this.toJavaLongFunction((Function1 & Serializable & scala.Serializable)lf -> BoxesRunTime.boxToLong((long)lf.getFileSize()))).sum();
        long logFileNonCompactionSize = fs.getLogFiles().filter($this.toJavaPredicate((Function1 & Serializable & scala.Serializable)lf -> BoxesRunTime.boxToBoolean((boolean)FileSystemRelation.$anonfun$buildScan$7(fs, lf)))).mapToLong($this.toJavaLongFunction((Function1 & Serializable & scala.Serializable)lf -> BoxesRunTime.boxToLong((long)lf.getFileSize()))).sum();
        Row r = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fg$1.getFileGroupId().getFileId(), fg$1.getPartitionPath(), fs.getBaseInstantTime(), fs.getBaseFile().isPresent() ? ((BaseFile)fs.getBaseFile().get()).getPath() : "", fs.getBaseFile().isPresent() ? (Number)BoxesRunTime.boxToLong((long)((BaseFile)fs.getBaseFile().get()).getFileSize()) : (Number)BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToLong((long)fs.getLogFiles().count()), BoxesRunTime.boxToLong((long)logFileSize), BoxesRunTime.boxToLong((long)logFileCompactionSize), BoxesRunTime.boxToLong((long)logFileNonCompactionSize)}));
        data$1.$plus$eq((Object)r);
    }

    public static final /* synthetic */ void $anonfun$buildScan$2(FileSystemRelation $this, ArrayBuffer data$1, HoodieFileGroup fg) {
        fg.getAllFileSlices().forEach($this.toJavaConsumer((Function1 & Serializable & scala.Serializable)fs -> {
            FileSystemRelation.$anonfun$buildScan$3($this, fg, data$1, fs);
            return BoxedUnit.UNIT;
        }));
    }

    public FileSystemRelation(SQLContext sqlContext, Map<String, String> optParams, HoodieTableMetaClient metaClient) {
        this.sqlContext = sqlContext;
        this.optParams = optParams;
        this.metaClient = metaClient;
        this.log = LoggerFactory.getLogger(FileSystemRelation.class);
    }
}

