/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;

public class AvroSchemaComparatorForSchemaEvolution {
    private AvroSchemaComparatorForSchemaEvolution() {
    }

    public static boolean schemaEquals(Schema s1, Schema s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.getType() != s2.getType()) {
            return false;
        }
        switch (s1.getType()) {
            case RECORD: {
                return AvroSchemaComparatorForSchemaEvolution.recordSchemaEquals(s1, s2);
            }
            case ENUM: {
                return AvroSchemaComparatorForSchemaEvolution.enumSchemaEquals(s1, s2);
            }
            case ARRAY: {
                return AvroSchemaComparatorForSchemaEvolution.arraySchemaEquals(s1, s2);
            }
            case MAP: {
                return AvroSchemaComparatorForSchemaEvolution.mapSchemaEquals(s1, s2);
            }
            case FIXED: {
                return AvroSchemaComparatorForSchemaEvolution.fixedSchemaEquals(s1, s2);
            }
            case UNION: {
                return AvroSchemaComparatorForSchemaEvolution.unionSchemaEquals(s1, s2);
            }
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                return AvroSchemaComparatorForSchemaEvolution.primitiveSchemaEquals(s1, s2);
            }
        }
        throw new IllegalArgumentException("Unknown schema type: " + s1.getType());
    }

    private static boolean recordSchemaEquals(Schema s1, Schema s2) {
        if (s1.isError() != s2.isError()) {
            return false;
        }
        List fields1 = s1.getFields();
        List fields2 = s2.getFields();
        if (fields1.size() != fields2.size()) {
            return false;
        }
        Map fieldMap1 = fields1.stream().collect(Collectors.toMap(Schema.Field::name, Function.identity()));
        for (Schema.Field f2 : fields2) {
            Schema.Field f1 = (Schema.Field)fieldMap1.get(f2.name());
            if (f1 == null) {
                return false;
            }
            if (AvroSchemaComparatorForSchemaEvolution.fieldEquals(f1, f2)) continue;
            return false;
        }
        return AvroSchemaComparatorForSchemaEvolution.logicalTypeSchemaEquals(s1, s2);
    }

    private static boolean fieldEquals(Schema.Field f1, Schema.Field f2) {
        if (!f1.name().equals(f2.name())) {
            return false;
        }
        if (f1.order() != f2.order()) {
            return false;
        }
        if (f1.hasDefaultValue() != f2.hasDefaultValue()) {
            return false;
        }
        if (!AvroSchemaComparatorForSchemaEvolution.schemaEquals(f1.schema(), f2.schema())) {
            return false;
        }
        return !f1.hasDefaultValue() || f1.defaultVal().equals(f2.defaultVal());
    }

    private static boolean enumSchemaEquals(Schema s1, Schema s2) {
        if (!s1.getName().equals(s2.getName())) {
            return false;
        }
        List symbols1 = s1.getEnumSymbols();
        List symbols2 = s2.getEnumSymbols();
        if (symbols1.size() != symbols2.size()) {
            return false;
        }
        return symbols1.equals(symbols2);
    }

    private static boolean unionSchemaEquals(Schema s1, Schema s2) {
        List types1 = s1.getTypes();
        List types2 = s2.getTypes();
        if (types1.size() != types2.size()) {
            return false;
        }
        Set set1 = types1.stream().map(SchemaWrapper::new).collect(Collectors.toSet());
        Set set2 = types2.stream().map(SchemaWrapper::new).collect(Collectors.toSet());
        return set1.equals(set2);
    }

    private static boolean arraySchemaEquals(Schema s1, Schema s2) {
        return AvroSchemaComparatorForSchemaEvolution.schemaEquals(s1.getElementType(), s2.getElementType());
    }

    private static boolean mapSchemaEquals(Schema s1, Schema s2) {
        return AvroSchemaComparatorForSchemaEvolution.schemaEquals(s1.getValueType(), s2.getValueType());
    }

    private static boolean fixedSchemaEquals(Schema s1, Schema s2) {
        return s1.getName().equals(s2.getName()) && s1.getFixedSize() == s2.getFixedSize() && AvroSchemaComparatorForSchemaEvolution.logicalTypeSchemaEquals(s1, s2);
    }

    private static boolean primitiveSchemaEquals(Schema s1, Schema s2) {
        return AvroSchemaComparatorForSchemaEvolution.logicalTypeSchemaEquals(s1, s2);
    }

    private static boolean logicalTypeSchemaEquals(Schema s1, Schema s2) {
        LogicalType lt1 = s1.getLogicalType();
        LogicalType lt2 = s2.getLogicalType();
        if (lt1 == null && lt2 == null) {
            return true;
        }
        if (lt1 == null || lt2 == null) {
            return false;
        }
        if (!lt1.getName().equals(lt2.getName())) {
            return false;
        }
        if (lt1 instanceof LogicalTypes.Decimal) {
            LogicalTypes.Decimal d1 = (LogicalTypes.Decimal)lt1;
            LogicalTypes.Decimal d2 = (LogicalTypes.Decimal)lt2;
            return d1.getPrecision() == d2.getPrecision() && d1.getScale() == d2.getScale();
        }
        return true;
    }

    static class SchemaWrapper {
        private final Schema schema;

        public SchemaWrapper(Schema schema) {
            this.schema = schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaWrapper that = (SchemaWrapper)o;
            return AvroSchemaComparatorForSchemaEvolution.schemaEquals(this.schema, that.schema);
        }

        public int hashCode() {
            return this.schema.getType().hashCode();
        }
    }
}

