/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class HoodieSliceInfo
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 6188032345461705953L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieSliceInfo\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"dataFilePath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"deltaFilePaths\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"fileId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]},{\"name\":\"partitionPath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"bootstrapFilePath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieSliceInfo> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieSliceInfo> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private String dataFilePath;
    private List<String> deltaFilePaths;
    private String fileId;
    private String partitionPath;
    private String bootstrapFilePath;
    private Integer version;
    private static final DatumWriter<HoodieSliceInfo> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieSliceInfo> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieSliceInfo> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieSliceInfo> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieSliceInfo> createDecoder(SchemaStore resolver2) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver2);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static HoodieSliceInfo fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieSliceInfo)((Object)DECODER.decode(b));
    }

    public HoodieSliceInfo() {
    }

    public HoodieSliceInfo(String dataFilePath, List<String> deltaFilePaths, String fileId, String partitionPath, String bootstrapFilePath, Integer version) {
        this.dataFilePath = dataFilePath;
        this.deltaFilePaths = deltaFilePaths;
        this.fileId = fileId;
        this.partitionPath = partitionPath;
        this.bootstrapFilePath = bootstrapFilePath;
        this.version = version;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.dataFilePath;
            }
            case 1: {
                return this.deltaFilePaths;
            }
            case 2: {
                return this.fileId;
            }
            case 3: {
                return this.partitionPath;
            }
            case 4: {
                return this.bootstrapFilePath;
            }
            case 5: {
                return this.version;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.dataFilePath = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.deltaFilePaths = (List)value$;
                break;
            }
            case 2: {
                this.fileId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.partitionPath = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.bootstrapFilePath = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.version = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getDataFilePath() {
        return this.dataFilePath;
    }

    public void setDataFilePath(String value) {
        this.dataFilePath = value;
    }

    public List<String> getDeltaFilePaths() {
        return this.deltaFilePaths;
    }

    public void setDeltaFilePaths(List<String> value) {
        this.deltaFilePaths = value;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String value) {
        this.fileId = value;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(String value) {
        this.partitionPath = value;
    }

    public String getBootstrapFilePath() {
        return this.bootstrapFilePath;
    }

    public void setBootstrapFilePath(String value) {
        this.bootstrapFilePath = value;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer value) {
        this.version = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieSliceInfo other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        if (this.dataFilePath == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.dataFilePath);
        }
        if (this.deltaFilePaths == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.deltaFilePaths.size();
            out.writeArrayStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (String e0 : this.deltaFilePaths) {
                ++actualSize0;
                out.startItem();
                out.writeString(e0);
            }
            out.writeArrayEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
        if (this.fileId == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.fileId);
        }
        if (this.partitionPath == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.partitionPath);
        }
        if (this.bootstrapFilePath == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.bootstrapFilePath);
        }
        if (this.version == null) {
            out.writeIndex(1);
            out.writeNull();
        } else {
            out.writeIndex(0);
            out.writeInt(this.version.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 1) {
                in.readNull();
                this.dataFilePath = null;
            } else {
                this.dataFilePath = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.deltaFilePaths = null;
            } else {
                GenericData.Array ga0;
                long size0 = in.readArrayStart();
                GenericData.Array a0 = this.deltaFilePaths;
                if (a0 == null) {
                    this.deltaFilePaths = a0 = new GenericData.Array((int)size0, (Schema)SCHEMA$.getField("deltaFilePaths").schema().getTypes().get(1));
                } else {
                    a0.clear();
                }
                GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                while (0L < size0) {
                    while (size0 != 0L) {
                        String e0 = ga0 != null ? (String)ga0.peek() : null;
                        e0 = in.readString();
                        a0.add(e0);
                        --size0;
                    }
                    size0 = in.arrayNext();
                }
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fileId = null;
            } else {
                this.fileId = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.partitionPath = null;
            } else {
                this.partitionPath = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.bootstrapFilePath = null;
            } else {
                this.bootstrapFilePath = in.readString();
            }
            if (in.readIndex() != 0) {
                in.readNull();
                this.version = null;
            } else {
                this.version = in.readInt();
            }
        } else {
            block10: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.dataFilePath = null;
                            continue block10;
                        }
                        this.dataFilePath = in.readString();
                        continue block10;
                    }
                    case 1: {
                        GenericData.Array ga0;
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.deltaFilePaths = null;
                            continue block10;
                        }
                        long size0 = in.readArrayStart();
                        GenericData.Array a0 = this.deltaFilePaths;
                        if (a0 == null) {
                            this.deltaFilePaths = a0 = new GenericData.Array((int)size0, (Schema)SCHEMA$.getField("deltaFilePaths").schema().getTypes().get(1));
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                String e0 = ga0 != null ? (String)ga0.peek() : null;
                                e0 = in.readString();
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block10;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fileId = null;
                            continue block10;
                        }
                        this.fileId = in.readString();
                        continue block10;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.partitionPath = null;
                            continue block10;
                        }
                        this.partitionPath = in.readString();
                        continue block10;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.bootstrapFilePath = null;
                            continue block10;
                        }
                        this.bootstrapFilePath = in.readString();
                        continue block10;
                    }
                    case 5: {
                        if (in.readIndex() != 0) {
                            in.readNull();
                            this.version = null;
                            continue block10;
                        }
                        this.version = in.readInt();
                        continue block10;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieSliceInfo>
    implements RecordBuilder<HoodieSliceInfo> {
        private String dataFilePath;
        private List<String> deltaFilePaths;
        private String fileId;
        private String partitionPath;
        private String bootstrapFilePath;
        private Integer version;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.dataFilePath)) {
                this.dataFilePath = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.dataFilePath);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], other.deltaFilePaths)) {
                this.deltaFilePaths = (List)this.data().deepCopy(this.fields()[1].schema(), other.deltaFilePaths);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.fileId)) {
                this.fileId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.fileId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.partitionPath)) {
                this.partitionPath = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.partitionPath);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.bootstrapFilePath)) {
                this.bootstrapFilePath = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.bootstrapFilePath);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.version)) {
                this.version = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.version);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(HoodieSliceInfo other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.dataFilePath)) {
                this.dataFilePath = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.dataFilePath);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.deltaFilePaths)) {
                this.deltaFilePaths = (List)this.data().deepCopy(this.fields()[1].schema(), (Object)other.deltaFilePaths);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.fileId)) {
                this.fileId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.fileId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.partitionPath)) {
                this.partitionPath = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.partitionPath);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.bootstrapFilePath)) {
                this.bootstrapFilePath = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.bootstrapFilePath);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.version)) {
                this.version = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.version);
                this.fieldSetFlags()[5] = true;
            }
        }

        public String getDataFilePath() {
            return this.dataFilePath;
        }

        public Builder setDataFilePath(String value) {
            this.validate(this.fields()[0], value);
            this.dataFilePath = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasDataFilePath() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearDataFilePath() {
            this.dataFilePath = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public List<String> getDeltaFilePaths() {
            return this.deltaFilePaths;
        }

        public Builder setDeltaFilePaths(List<String> value) {
            this.validate(this.fields()[1], value);
            this.deltaFilePaths = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasDeltaFilePaths() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearDeltaFilePaths() {
            this.deltaFilePaths = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getFileId() {
            return this.fileId;
        }

        public Builder setFileId(String value) {
            this.validate(this.fields()[2], value);
            this.fileId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasFileId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearFileId() {
            this.fileId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getPartitionPath() {
            return this.partitionPath;
        }

        public Builder setPartitionPath(String value) {
            this.validate(this.fields()[3], value);
            this.partitionPath = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasPartitionPath() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearPartitionPath() {
            this.partitionPath = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getBootstrapFilePath() {
            return this.bootstrapFilePath;
        }

        public Builder setBootstrapFilePath(String value) {
            this.validate(this.fields()[4], value);
            this.bootstrapFilePath = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasBootstrapFilePath() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearBootstrapFilePath() {
            this.bootstrapFilePath = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getVersion() {
            return this.version;
        }

        public Builder setVersion(Integer value) {
            this.validate(this.fields()[5], value);
            this.version = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasVersion() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearVersion() {
            this.version = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public HoodieSliceInfo build() {
            try {
                HoodieSliceInfo record = new HoodieSliceInfo();
                record.dataFilePath = this.fieldSetFlags()[0] ? this.dataFilePath : (String)this.defaultValue(this.fields()[0]);
                record.deltaFilePaths = this.fieldSetFlags()[1] ? this.deltaFilePaths : (List)this.defaultValue(this.fields()[1]);
                record.fileId = this.fieldSetFlags()[2] ? this.fileId : (String)this.defaultValue(this.fields()[2]);
                record.partitionPath = this.fieldSetFlags()[3] ? this.partitionPath : (String)this.defaultValue(this.fields()[3]);
                record.bootstrapFilePath = this.fieldSetFlags()[4] ? this.bootstrapFilePath : (String)this.defaultValue(this.fields()[4]);
                record.version = this.fieldSetFlags()[5] ? this.version : (Integer)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

