/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.timeline;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.ActiveAction;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;

public class ActiveActionWithDetails
extends ActiveAction {
    private final Option<byte[]> requestedDetails;
    private final Option<byte[]> inflightDetails;
    private final Option<byte[]> completedDetails;

    protected ActiveActionWithDetails(@Nullable HoodieInstant requested, Option<byte[]> requestedDetails, @Nullable HoodieInstant inflight, Option<byte[]> inflightDetails, HoodieInstant completed, Option<byte[]> completedDetails) {
        super(requested, inflight, Collections.singletonList(completed));
        this.requestedDetails = requestedDetails;
        this.inflightDetails = inflightDetails;
        this.completedDetails = completedDetails;
    }

    public static ActiveActionWithDetails fromInstantAndDetails(List<Pair<HoodieInstant, Option<byte[]>>> instantAndDetails) {
        ValidationUtils.checkArgument(instantAndDetails.size() <= 3);
        HoodieInstant requested = null;
        HoodieInstant inflight = null;
        HoodieInstant completed = null;
        Option<byte[]> requestedDetails = Option.empty();
        Option<byte[]> inflightDetails = Option.empty();
        Option<byte[]> completedDetails = Option.empty();
        for (Pair<HoodieInstant, Option<byte[]>> instantAndDetail : instantAndDetails) {
            HoodieInstant instant = instantAndDetail.getKey();
            Option<byte[]> details = instantAndDetail.getRight();
            if (instant.isRequested()) {
                requested = instant;
                requestedDetails = details;
                continue;
            }
            if (instant.isInflight()) {
                inflight = instant;
                inflightDetails = details;
                continue;
            }
            completed = instant;
            completedDetails = details;
        }
        return new ActiveActionWithDetails(requested, requestedDetails, inflight, inflightDetails, Objects.requireNonNull(completed), completedDetails);
    }

    @Override
    public Option<byte[]> getCommitMetadata(HoodieTableMetaClient metaClient) {
        return this.completedDetails;
    }

    @Override
    public Option<byte[]> getRequestedCommitMetadata(HoodieTableMetaClient metaClient) {
        return this.requestedDetails;
    }

    @Override
    public Option<byte[]> getInflightCommitMetadata(HoodieTableMetaClient metaClient) {
        return this.inflightDetails;
    }

    @Override
    public Option<byte[]> getCleanPlan(HoodieTableMetaClient metaClient) {
        return this.requestedDetails;
    }

    @Override
    public Option<byte[]> getCompactionPlan(HoodieTableMetaClient metaClient) {
        return this.requestedDetails;
    }

    @Override
    public Option<byte[]> getLogCompactionPlan(HoodieTableMetaClient metaClient) {
        return this.requestedDetails;
    }
}

