/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.validator;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SparkPreCommitValidator<T, I, K, O extends HoodieData<WriteStatus>> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkPreCommitValidator.class);
    private final HoodieSparkTable<T> table;
    private final HoodieEngineContext engineContext;
    private final HoodieWriteConfig writeConfig;
    private final HoodieMetrics metrics;

    protected SparkPreCommitValidator(HoodieSparkTable<T> table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        this.table = table;
        this.engineContext = engineContext;
        this.writeConfig = writeConfig;
        this.metrics = new HoodieMetrics(writeConfig, table.getStorage());
    }

    protected Set<String> getPartitionsModified(HoodieWriteMetadata<O> writeResult) {
        Set<String> partitionsModified = writeResult.getWriteStats().isPresent() ? writeResult.getWriteStats().get().stream().map(HoodieWriteStat::getPartitionPath).collect(Collectors.toSet()) : new HashSet<String>(((HoodieData)writeResult.getWriteStatuses()).map(WriteStatus::getPartitionPath).collectAsList());
        return partitionsModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(String instantTime, HoodieWriteMetadata<O> writeResult, Dataset<Row> before, Dataset<Row> after) throws HoodieValidationException {
        HoodieTimer timer = HoodieTimer.start();
        try {
            this.validateRecordsBeforeAndAfter(before, after, this.getPartitionsModified(writeResult));
        }
        finally {
            long duration = timer.endTimer();
            LOG.info(this.getClass() + " validator took " + duration + " ms, metrics on? " + this.getWriteConfig().isMetricsOn());
            this.publishRunStats(instantTime, duration);
        }
    }

    private void publishRunStats(String instantTime, long duration) {
        if (this.getWriteConfig().isMetricsOn()) {
            HoodieTableMetaClient metaClient = this.getHoodieTable().getMetaClient();
            Option<HoodieInstant> currentInstant = metaClient.getActiveTimeline().findInstantsAfterOrEquals(instantTime, 1).firstInstant();
            this.metrics.reportMetrics(currentInstant.get().getAction(), this.getClass().getSimpleName(), duration);
        }
    }

    protected abstract void validateRecordsBeforeAndAfter(Dataset<Row> var1, Dataset<Row> var2, Set<String> var3);

    public HoodieTable getHoodieTable() {
        return this.table;
    }

    public HoodieEngineContext getEngineContext() {
        return this.engineContext;
    }

    public HoodieWriteConfig getWriteConfig() {
        return this.writeConfig;
    }

    protected Dataset<Row> executeSqlQuery(SQLContext sqlContext, String sqlQuery, String tableName, String logLabel) {
        String queryWithTempTableName = sqlQuery.replaceAll("<TABLE_NAME>", tableName);
        LOG.info("Running query ({}): {}", (Object)logLabel, (Object)queryWithTempTableName);
        return sqlContext.sql(queryWithTempTableName);
    }
}

