/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.commit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.commit.BaseDatasetBulkInsertCommitActionExecutor;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieInternalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;

public class DatasetBulkInsertCommitActionExecutor
extends BaseDatasetBulkInsertCommitActionExecutor {
    public DatasetBulkInsertCommitActionExecutor(HoodieWriteConfig config, SparkRDDWriteClient writeClient, String instantTime) {
        super(config, writeClient, instantTime);
    }

    @Override
    protected void preExecute() {
    }

    @Override
    protected Option<HoodieData<WriteStatus>> doExecute(Dataset<Row> records, boolean arePartitionRecordsSorted) {
        Map<String, String> opts = this.writeConfig.getProps().entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
        Map<String, String> optsOverrides = Collections.singletonMap("hoodie.bulkinsert.are.partitioner.records.sorted", String.valueOf(arePartitionRecordsSorted));
        HashMap<String, String> customOpts = new HashMap<String, String>(1);
        if (!HoodieSparkUtils.isSpark3()) {
            throw new HoodieException("Bulk insert using row writer is not supported with current Spark version. To use row writer please switch to spark 3");
        }
        String targetFormat = "org.apache.hudi.spark3.internal";
        customOpts.put(HoodieInternalConfig.BULKINSERT_INPUT_DATA_SCHEMA_DDL.key(), records.schema().json());
        records.write().format(targetFormat).option("hoodie.instant.time", this.instantTime).options(opts).options(customOpts).options(optsOverrides).mode(SaveMode.Append).save();
        return Option.empty();
    }

    @Override
    protected void afterExecute(HoodieWriteMetadata<JavaRDD<WriteStatus>> result) {
    }

    @Override
    public WriteOperationType getWriteOperationType() {
        return WriteOperationType.BULK_INSERT;
    }
}

