/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.checkpoint;

import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.checkpoint.Checkpoint;

public class StreamerCheckpointV1
extends Checkpoint {
    public static final String STREAMER_CHECKPOINT_KEY_V1 = "deltastreamer.checkpoint.key";
    public static final String STREAMER_CHECKPOINT_RESET_KEY_V1 = "deltastreamer.checkpoint.reset_key";

    public StreamerCheckpointV1(String key) {
        this.checkpointKey = key;
        this.checkpointResetKey = null;
        this.checkpointIgnoreKey = null;
    }

    public StreamerCheckpointV1(Checkpoint checkpoint) {
        this.checkpointKey = checkpoint.getCheckpointKey();
        this.checkpointResetKey = checkpoint.getCheckpointResetKey();
        this.checkpointIgnoreKey = checkpoint.getCheckpointIgnoreKey();
    }

    public StreamerCheckpointV1(HoodieCommitMetadata commitMetadata) {
        this.checkpointKey = commitMetadata.getMetadata(STREAMER_CHECKPOINT_KEY_V1);
        this.checkpointResetKey = commitMetadata.getMetadata(STREAMER_CHECKPOINT_RESET_KEY_V1);
        this.checkpointIgnoreKey = commitMetadata.getMetadata("deltastreamer.checkpoint.ignore_key");
    }

    @Override
    public Map<String, String> getCheckpointCommitMetadata(String overrideResetKey, String overrideIgnoreKey) {
        HashMap<String, String> checkpointCommitMetadata = new HashMap<String, String>();
        if (this.checkpointKey != null) {
            checkpointCommitMetadata.put(STREAMER_CHECKPOINT_KEY_V1, this.getCheckpointKey());
        }
        if (overrideResetKey != null) {
            checkpointCommitMetadata.put(STREAMER_CHECKPOINT_RESET_KEY_V1, overrideResetKey);
        }
        if (overrideIgnoreKey != null) {
            checkpointCommitMetadata.put("deltastreamer.checkpoint.ignore_key", overrideIgnoreKey);
        }
        return checkpointCommitMetadata;
    }
}

