/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.checkpoint;

import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.checkpoint.Checkpoint;

public class StreamerCheckpointV2
extends Checkpoint {
    public static final String STREAMER_CHECKPOINT_KEY_V2 = "streamer.checkpoint.key.v2";
    public static final String STREAMER_CHECKPOINT_RESET_KEY_V2 = "streamer.checkpoint.reset.key.v2";

    public StreamerCheckpointV2(String key) {
        this.checkpointKey = key;
    }

    public StreamerCheckpointV2(Checkpoint checkpoint) {
        this.checkpointKey = checkpoint.getCheckpointKey();
        this.checkpointResetKey = checkpoint.getCheckpointResetKey();
        this.checkpointIgnoreKey = checkpoint.getCheckpointIgnoreKey();
    }

    public StreamerCheckpointV2(HoodieCommitMetadata commitMetadata) {
        this.checkpointKey = commitMetadata.getMetadata(STREAMER_CHECKPOINT_KEY_V2);
        this.checkpointResetKey = commitMetadata.getMetadata(STREAMER_CHECKPOINT_RESET_KEY_V2);
        this.checkpointIgnoreKey = commitMetadata.getMetadata("deltastreamer.checkpoint.ignore_key");
    }

    public void addV1Props() {
        this.extraProps.put("deltastreamer.checkpoint.key", this.checkpointKey);
        this.extraProps.put("deltastreamer.checkpoint.reset_key", this.checkpointResetKey);
    }

    @Override
    public Map<String, String> getCheckpointCommitMetadata(String overrideResetKey, String overrideIgnoreKey) {
        HashMap<String, String> checkpointCommitMetadata = new HashMap<String, String>();
        if (this.checkpointKey != null) {
            checkpointCommitMetadata.put(STREAMER_CHECKPOINT_KEY_V2, this.getCheckpointKey());
        }
        if (overrideResetKey != null) {
            checkpointCommitMetadata.put(STREAMER_CHECKPOINT_RESET_KEY_V2, overrideResetKey);
        }
        if (overrideIgnoreKey != null) {
            checkpointCommitMetadata.put("deltastreamer.checkpoint.ignore_key", overrideIgnoreKey);
        }
        checkpointCommitMetadata.putAll(this.extraProps);
        return checkpointCommitMetadata;
    }
}

