/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.LocalAvroSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;

public class FileGroupReaderSchemaHandler<T> {
    protected final Schema tableSchema;
    protected final Schema requestedSchema;
    protected final Schema requiredSchema;
    protected final InternalSchema internalSchema;
    protected final Option<InternalSchema> internalSchemaOpt;
    protected final HoodieTableConfig hoodieTableConfig;
    protected final HoodieReaderContext<T> readerContext;
    protected final TypedProperties properties;
    protected final Option<HoodieRecordMerger> recordMerger;
    protected final boolean hasBootstrapBaseFile;
    protected boolean needsBootstrapMerge;
    protected final boolean needsMORMerge;
    private final LocalAvroSchemaCache localAvroSchemaCache;
    private final Option<Pair<String, String>> customDeleteMarkerKeyValue;
    private final boolean hasBuiltInDelete;

    public FileGroupReaderSchemaHandler(HoodieReaderContext<T> readerContext, Schema tableSchema, Schema requestedSchema, Option<InternalSchema> internalSchemaOpt, HoodieTableConfig hoodieTableConfig, TypedProperties properties) {
        this.properties = properties;
        this.readerContext = readerContext;
        this.hasBootstrapBaseFile = readerContext.getHasBootstrapBaseFile();
        this.needsMORMerge = readerContext.getHasLogFiles();
        this.recordMerger = readerContext.getRecordMerger();
        this.tableSchema = tableSchema;
        this.requestedSchema = AvroSchemaCache.intern(requestedSchema);
        this.hoodieTableConfig = hoodieTableConfig;
        Pair<Option<Pair<String, String>>, Boolean> deleteConfigs = FileGroupReaderSchemaHandler.getDeleteConfigs(properties, tableSchema);
        this.customDeleteMarkerKeyValue = deleteConfigs.getLeft();
        this.hasBuiltInDelete = deleteConfigs.getRight();
        this.requiredSchema = AvroSchemaCache.intern(this.prepareRequiredSchema());
        this.internalSchema = this.pruneInternalSchema(this.requiredSchema, internalSchemaOpt);
        this.internalSchemaOpt = this.getInternalSchemaOpt(internalSchemaOpt);
        readerContext.setNeedsBootstrapMerge(this.needsBootstrapMerge);
        this.localAvroSchemaCache = LocalAvroSchemaCache.getInstance();
    }

    public Schema getTableSchema() {
        return this.tableSchema;
    }

    public Schema getRequestedSchema() {
        return this.requestedSchema;
    }

    public Schema getRequiredSchema() {
        return this.requiredSchema;
    }

    public InternalSchema getInternalSchema() {
        return this.internalSchema;
    }

    public Option<InternalSchema> getInternalSchemaOpt() {
        return this.internalSchemaOpt;
    }

    public Option<UnaryOperator<T>> getOutputConverter() {
        if (!this.requestedSchema.equals((Object)this.requiredSchema)) {
            return Option.of(this.readerContext.projectRecord(this.requiredSchema, this.requestedSchema));
        }
        return Option.empty();
    }

    public Option<Pair<String, String>> getCustomDeleteMarkerKeyValue() {
        return this.customDeleteMarkerKeyValue;
    }

    public boolean hasBuiltInDelete() {
        return this.hasBuiltInDelete;
    }

    private InternalSchema pruneInternalSchema(Schema requiredSchema, Option<InternalSchema> internalSchemaOption) {
        if (!internalSchemaOption.isPresent()) {
            return InternalSchema.getEmptyInternalSchema();
        }
        InternalSchema notPruned = internalSchemaOption.get();
        if (notPruned == null || notPruned.isEmptySchema()) {
            return InternalSchema.getEmptyInternalSchema();
        }
        return this.doPruneInternalSchema(requiredSchema, notPruned);
    }

    protected Option<InternalSchema> getInternalSchemaOpt(Option<InternalSchema> internalSchemaOpt) {
        return internalSchemaOpt;
    }

    protected InternalSchema doPruneInternalSchema(Schema requiredSchema, InternalSchema internalSchema) {
        return AvroInternalSchemaConverter.pruneAvroSchemaToInternalSchema(requiredSchema, internalSchema);
    }

    @VisibleForTesting
    Schema generateRequiredSchema() {
        if (!this.needsMORMerge) {
            return this.requestedSchema;
        }
        if (this.hoodieTableConfig.getRecordMergeMode() == RecordMergeMode.CUSTOM && !this.recordMerger.get().isProjectionCompatible()) {
            return this.tableSchema;
        }
        ArrayList<Schema.Field> addedFields = new ArrayList<Schema.Field>();
        for (String field : FileGroupReaderSchemaHandler.getMandatoryFieldsForMerging(this.hoodieTableConfig, this.properties, this.tableSchema, this.recordMerger, this.hasBuiltInDelete, this.customDeleteMarkerKeyValue)) {
            if (AvroSchemaUtils.findNestedField(this.requestedSchema, field).isPresent()) continue;
            Option<Schema.Field> foundFieldOpt = AvroSchemaUtils.findNestedField(this.tableSchema, field);
            if (!foundFieldOpt.isPresent()) {
                throw new IllegalArgumentException("Field: " + field + " does not exist in the table schema");
            }
            Schema.Field foundField = foundFieldOpt.get();
            addedFields.add(foundField);
        }
        if (addedFields.isEmpty()) {
            return this.requestedSchema;
        }
        return AvroSchemaUtils.appendFieldsToSchemaDedupNested(this.requestedSchema, addedFields);
    }

    private static String[] getMandatoryFieldsForMerging(HoodieTableConfig cfg, TypedProperties props, Schema tableSchema, Option<HoodieRecordMerger> recordMerger, boolean hasBuiltInDelete, Option<Pair<String, String>> customDeleteMarkerKeyAndValue) {
        String preCombine;
        Triple<RecordMergeMode, String, String> mergingConfigs = HoodieTableConfig.inferCorrectMergingBehavior(cfg.getRecordMergeMode(), cfg.getPayloadClass(), cfg.getRecordMergeStrategyId(), cfg.getPreCombineField(), cfg.getTableVersion());
        if (mergingConfigs.getLeft() == RecordMergeMode.CUSTOM) {
            return recordMerger.get().getMandatoryFieldsForMerging(tableSchema, cfg, props);
        }
        HashSet<Object> requiredFields = new HashSet<Object>();
        if (cfg.populateMetaFields()) {
            requiredFields.add(HoodieRecord.RECORD_KEY_METADATA_FIELD);
        } else {
            Option<String[]> fields = cfg.getRecordKeyFields();
            if (fields.isPresent()) {
                requiredFields.addAll(Arrays.asList((Object[])fields.get()));
            }
        }
        if (mergingConfigs.getLeft() == RecordMergeMode.EVENT_TIME_ORDERING && !StringUtils.isNullOrEmpty(preCombine = cfg.getPreCombineField())) {
            requiredFields.add(preCombine);
        }
        if (hasBuiltInDelete) {
            requiredFields.add("_hoodie_is_deleted");
        }
        if (customDeleteMarkerKeyAndValue.isPresent()) {
            requiredFields.add(customDeleteMarkerKeyAndValue.get().getLeft());
        }
        return requiredFields.toArray(new String[0]);
    }

    protected Schema prepareRequiredSchema() {
        Schema preReorderRequiredSchema = this.generateRequiredSchema();
        Pair<List<Schema.Field>, List<Schema.Field>> requiredFields = FileGroupReaderSchemaHandler.getDataAndMetaCols(preReorderRequiredSchema);
        this.needsBootstrapMerge = this.hasBootstrapBaseFile && !requiredFields.getLeft().isEmpty() && !requiredFields.getRight().isEmpty();
        return this.needsBootstrapMerge ? this.createSchemaFromFields(Stream.concat(requiredFields.getLeft().stream(), requiredFields.getRight().stream()).collect(Collectors.toList())) : preReorderRequiredSchema;
    }

    public Pair<List<Schema.Field>, List<Schema.Field>> getBootstrapRequiredFields() {
        return FileGroupReaderSchemaHandler.getDataAndMetaCols(this.requiredSchema);
    }

    public Pair<List<Schema.Field>, List<Schema.Field>> getBootstrapDataFields() {
        return FileGroupReaderSchemaHandler.getDataAndMetaCols(this.tableSchema);
    }

    @VisibleForTesting
    static Pair<List<Schema.Field>, List<Schema.Field>> getDataAndMetaCols(Schema schema) {
        Map<Boolean, List<Schema.Field>> fieldsByMeta = schema.getFields().stream().filter(f -> !Objects.equals(f.name(), "_tmp_metadata_row_index")).collect(Collectors.partitioningBy(f -> HoodieRecord.HOODIE_META_COLUMNS_WITH_OPERATION.contains(f.name())));
        return Pair.of(fieldsByMeta.getOrDefault(true, Collections.emptyList()), fieldsByMeta.getOrDefault(false, Collections.emptyList()));
    }

    public Schema createSchemaFromFields(List<Schema.Field> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            Schema.Field curr = fields.get(i);
            fields.set(i, new Schema.Field(curr.name(), curr.schema(), curr.doc(), curr.defaultVal()));
        }
        return AvroSchemaUtils.createNewSchemaFromFieldsWithReference(this.tableSchema, fields);
    }

    private static Pair<Option<Pair<String, String>>, Boolean> getDeleteConfigs(TypedProperties props, Schema tableSchema) {
        Option<Object> customDeleteMarkerKeyAndValue;
        boolean deleteMarkerExists;
        String deleteKey = props.getProperty("hoodie.payload.delete.field");
        String deleteMarker = props.getProperty("hoodie.payload.delete.marker");
        boolean deleteKeyExists = !StringUtils.isNullOrEmpty(deleteKey);
        boolean bl = deleteMarkerExists = !StringUtils.isNullOrEmpty(deleteMarker);
        if (deleteKeyExists && deleteMarkerExists) {
            customDeleteMarkerKeyAndValue = Option.of(Pair.of(deleteKey, deleteMarker));
        } else if (!deleteKeyExists && !deleteMarkerExists) {
            customDeleteMarkerKeyAndValue = Option.empty();
        } else {
            throw new IllegalArgumentException("Either custom delete key or marker is not specified");
        }
        return Pair.of(customDeleteMarkerKeyAndValue, FileGroupReaderSchemaHandler.hasBuiltInDeleteField(tableSchema));
    }

    private static boolean hasBuiltInDeleteField(Schema schema) {
        return schema.getField("_hoodie_is_deleted") != null;
    }
}

