/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;

public interface HoodieArchivedTimeline
extends HoodieTimeline {
    public static final String COMPLETION_TIME_ARCHIVED_META_FIELD = "completionTime";

    public void loadInstantDetailsInMemory(String var1, String var2);

    public void loadCompletedInstantDetailsInMemory();

    public void loadCompactionDetailsInMemory(String var1);

    public void loadCompactionDetailsInMemory(String var1, String var2);

    public void clearInstantDetailsFromMemory(String var1);

    public void clearInstantDetailsFromMemory(String var1, String var2);

    public HoodieArchivedTimeline reload();

    public HoodieArchivedTimeline reload(String var1);

    public static class StartTsFilter
    extends TimeRangeFilter {
        public StartTsFilter(String startTs) {
            super(startTs, null);
        }

        @Override
        public boolean isInRange(String instantTime) {
            return InstantComparison.compareTimestamps(instantTime, InstantComparison.GREATER_THAN_OR_EQUALS, this.startTs);
        }
    }

    public static class ClosedClosedTimeRangeFilter
    extends TimeRangeFilter {
        private final String startTs;
        private final String endTs;

        public ClosedClosedTimeRangeFilter(String startTs, String endTs) {
            super(startTs, endTs);
            this.startTs = startTs;
            this.endTs = endTs;
        }

        @Override
        public boolean isInRange(String instantTime) {
            return InstantComparison.isInClosedRange(instantTime, this.startTs, this.endTs);
        }

        public boolean isInRange(HoodieInstant instant) {
            return InstantComparison.isInClosedRange(instant.requestedTime(), this.startTs, this.endTs);
        }
    }

    public static class ClosedOpenTimeRangeFilter
    extends TimeRangeFilter {
        public ClosedOpenTimeRangeFilter(String startTs, String endTs) {
            super(startTs, endTs);
        }

        @Override
        public boolean isInRange(String instantTime) {
            return InstantComparison.isInClosedOpenRange(instantTime, this.startTs, this.endTs);
        }
    }

    public static class TimeRangeFilter {
        protected final String startTs;
        protected final String endTs;

        public TimeRangeFilter(String startTs, String endTs) {
            this.startTs = startTs;
            this.endTs = endTs;
        }

        public boolean isInRange(String instantTime) {
            return InstantComparison.isInRange(instantTime, this.startTs, this.endTs);
        }
    }

    public static enum LoadMode {
        TIME,
        ACTION,
        METADATA,
        PLAN,
        FULL;

    }
}

