/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import java.util.stream.Stream;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.ArchivedTimelineLoader;
import org.apache.hudi.common.table.timeline.CompletionTimeQueryView;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantReader;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineFactory;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.v1.ActiveTimelineV1;
import org.apache.hudi.common.table.timeline.versioning.v1.ArchivedTimelineLoaderV1;
import org.apache.hudi.common.table.timeline.versioning.v1.ArchivedTimelineV1;
import org.apache.hudi.common.table.timeline.versioning.v1.BaseTimelineV1;
import org.apache.hudi.common.table.timeline.versioning.v1.CompletionTimeQueryViewV1;

public class TimelineV1Factory
extends TimelineFactory {
    private final TimelineLayout layout;

    public TimelineV1Factory(TimelineLayout layout) {
        this.layout = layout;
    }

    @Override
    public HoodieTimeline createDefaultTimeline(Stream<HoodieInstant> instants, HoodieInstantReader instantReader) {
        return new BaseTimelineV1(instants, instantReader);
    }

    @Override
    public HoodieActiveTimeline createActiveTimeline() {
        return new ActiveTimelineV1();
    }

    @Override
    public HoodieArchivedTimeline createArchivedTimeline(HoodieTableMetaClient metaClient) {
        return new ArchivedTimelineV1(metaClient);
    }

    @Override
    public HoodieArchivedTimeline createArchivedTimeline(HoodieTableMetaClient metaClient, String startTs) {
        return new ArchivedTimelineV1(metaClient, startTs);
    }

    @Override
    public ArchivedTimelineLoader createArchivedTimelineLoader() {
        return new ArchivedTimelineLoaderV1();
    }

    @Override
    public HoodieActiveTimeline createActiveTimeline(HoodieTableMetaClient metaClient) {
        return new ActiveTimelineV1(metaClient);
    }

    @Override
    public HoodieActiveTimeline createActiveTimeline(HoodieTableMetaClient metaClient, boolean applyLayoutFilter) {
        return new ActiveTimelineV1(metaClient, applyLayoutFilter);
    }

    @Override
    public CompletionTimeQueryView createCompletionTimeQueryView(HoodieTableMetaClient metaClient) {
        return new CompletionTimeQueryViewV1(metaClient);
    }

    @Override
    public CompletionTimeQueryView createCompletionTimeQueryView(HoodieTableMetaClient metaClient, String eagerInstant) {
        return new CompletionTimeQueryViewV1(metaClient, eagerInstant);
    }
}

