/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.util.ObjectSizeCalculator;
import org.apache.hudi.common.util.SizeEstimator;

class HoodieFileGroupSizeEstimator
implements SizeEstimator<List<HoodieFileGroup>>,
Serializable {
    HoodieFileGroupSizeEstimator() {
    }

    @Override
    public long sizeEstimate(List<HoodieFileGroup> hoodieFileGroups) {
        if (hoodieFileGroups.isEmpty()) {
            return 0L;
        }
        long sizeOfFileGroupIds = ObjectSizeCalculator.getObjectSize(hoodieFileGroups.get(0).getFileGroupId()) * (long)hoodieFileGroups.size();
        long sizeOfFileSlices = ObjectSizeCalculator.getObjectSize(hoodieFileGroups.stream().flatMap(HoodieFileGroup::getAllFileSlices).collect(Collectors.toList()));
        return sizeOfFileSlices + sizeOfFileGroupIds;
    }
}

