/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.queue.HoodieConsumer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.execution.HoodieLazyInsertIterable;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyOnWriteInsertHandler<T>
implements HoodieConsumer<HoodieLazyInsertIterable.HoodieInsertValueGenResult<HoodieRecord>, List<WriteStatus>> {
    private static final Logger LOG = LoggerFactory.getLogger(CopyOnWriteInsertHandler.class);
    private final HoodieWriteConfig config;
    private final String instantTime;
    private final boolean areRecordsSorted;
    private final HoodieTable hoodieTable;
    private final String idPrefix;
    private final TaskContextSupplier taskContextSupplier;
    private final WriteHandleFactory writeHandleFactory;
    private int numSkippedRecords = 0;
    private final List<WriteStatus> statuses = new ArrayList<WriteStatus>();
    private final Map<String, HoodieWriteHandle> handles = new HashMap<String, HoodieWriteHandle>();

    public CopyOnWriteInsertHandler(HoodieWriteConfig config, String instantTime, boolean areRecordsSorted, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, WriteHandleFactory writeHandleFactory) {
        this.config = config;
        this.instantTime = instantTime;
        this.areRecordsSorted = areRecordsSorted;
        this.hoodieTable = hoodieTable;
        this.idPrefix = idPrefix;
        this.taskContextSupplier = taskContextSupplier;
        this.writeHandleFactory = writeHandleFactory;
    }

    @Override
    public void consume(HoodieLazyInsertIterable.HoodieInsertValueGenResult<HoodieRecord> genResult) {
        HoodieRecord record = genResult.getResult();
        String partitionPath = record.getPartitionPath();
        try {
            if (record.shouldIgnore(genResult.schema, this.config.getProps())) {
                ++this.numSkippedRecords;
                return;
            }
        }
        catch (IOException e) {
            LOG.warn("Writing record should be ignore " + record, (Throwable)e);
        }
        HoodieWriteHandle handle2 = this.handles.get(partitionPath);
        if (handle2 == null) {
            if (this.areRecordsSorted) {
                this.closeOpenHandles();
            }
            handle2 = this.writeHandleFactory.create(this.config, this.instantTime, this.hoodieTable, record.getPartitionPath(), this.idPrefix, this.taskContextSupplier);
            this.handles.put(partitionPath, handle2);
        }
        if (!handle2.canWrite(genResult.getResult())) {
            this.statuses.addAll(handle2.close());
            handle2 = this.writeHandleFactory.create(this.config, this.instantTime, this.hoodieTable, record.getPartitionPath(), this.idPrefix, this.taskContextSupplier);
            this.handles.put(partitionPath, handle2);
        }
        handle2.write(record, genResult.schema, this.config.getProps());
    }

    @Override
    public List<WriteStatus> finish() {
        this.closeOpenHandles();
        ValidationUtils.checkState(this.statuses.size() + this.numSkippedRecords > 0);
        return this.statuses;
    }

    private void closeOpenHandles() {
        for (HoodieWriteHandle handle2 : this.handles.values()) {
            this.statuses.addAll(handle2.close());
        }
        this.handles.clear();
    }
}

