/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.expression;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.util.CollectionUtils;

public interface HoodieExpressionIndex<S, T>
extends Serializable {
    public static final String HOODIE_EXPRESSION_INDEX_RELATIVE_FILE_PATH = "_hoodie_expression_index_relative_file_path";
    public static final String HOODIE_EXPRESSION_INDEX_PARTITION = "_hoodie_expression_index_partition";
    public static final String HOODIE_EXPRESSION_INDEX_FILE_SIZE = "_hoodie_expression_index_file_size";
    public static final String HOODIE_EXPRESSION_INDEX_PARTITION_STAT_PREFIX = "__partition_stat__";
    public static final String EXPRESSION_OPTION = "expr";
    public static final String TRIM_STRING_OPTION = "trimString";
    public static final String REGEX_GROUP_INDEX_OPTION = "idx";
    public static final String REPLACEMENT_OPTION = "replacement";
    public static final String PATTERN_OPTION = "pattern";
    public static final String LENGTH_OPTION = "len";
    public static final String POSITION_OPTION = "pos";
    public static final String DAYS_OPTION = "days";
    public static final String FORMAT_OPTION = "format";
    public static final String IDENTITY_TRANSFORM = "identity";
    public static final String BLOOM_FILTER_TYPE = "filtertype";
    public static final String BLOOM_FILTER_NUM_ENTRIES = "numentries";
    public static final String FALSE_POSITIVE_RATE = "fpp";
    public static final String DYNAMIC_BLOOM_MAX_ENTRIES = "maxentries";
    public static final Map<String, String> BLOOM_FILTER_CONFIG_MAPPING = CollectionUtils.createImmutableMap(new HashMap<String, String>(){
        {
            this.put(HoodieExpressionIndex.BLOOM_FILTER_TYPE, HoodieStorageConfig.BLOOM_FILTER_TYPE.key());
            this.put(HoodieExpressionIndex.BLOOM_FILTER_NUM_ENTRIES, HoodieStorageConfig.BLOOM_FILTER_NUM_ENTRIES_VALUE.key());
            this.put(HoodieExpressionIndex.FALSE_POSITIVE_RATE, HoodieStorageConfig.BLOOM_FILTER_FPP_VALUE.key());
            this.put(HoodieExpressionIndex.DYNAMIC_BLOOM_MAX_ENTRIES, HoodieStorageConfig.BLOOM_FILTER_DYNAMIC_MAX_ENTRIES.key());
        }
    });

    public String getIndexName();

    public String getIndexFunction();

    public List<String> getOrderedSourceFields();

    public T apply(List<S> var1);
}

