/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.visitor;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.internal.schema.visitor.InternalSchemaVisitor;

public class NameToPositionVisitor
extends InternalSchemaVisitor<Map<String, Integer>> {
    private final Deque<String> fieldNames = new LinkedList<String>();
    private final Map<String, Integer> nameToId = new HashMap<String, Integer>();
    private final AtomicInteger position = new AtomicInteger(0);

    @Override
    public void beforeField(Types.Field field) {
        this.nameToId.put(InternalSchemaUtils.createFullName(field.name(), this.fieldNames), this.position.getAndIncrement());
        this.fieldNames.push(field.name());
    }

    @Override
    public void afterField(Types.Field field) {
        this.fieldNames.pop();
    }

    @Override
    public void beforeArrayElement(Types.Field elementField) {
        this.nameToId.put(InternalSchemaUtils.createFullName("element", this.fieldNames), this.position.getAndIncrement());
        this.fieldNames.push(elementField.name());
    }

    @Override
    public void afterArrayElement(Types.Field elementField) {
        this.fieldNames.pop();
    }

    @Override
    public void beforeMapKey(Types.Field keyField) {
        this.nameToId.put(InternalSchemaUtils.createFullName("key", this.fieldNames), this.position.getAndIncrement());
        this.fieldNames.push(keyField.name());
    }

    @Override
    public void afterMapKey(Types.Field keyField) {
        this.fieldNames.pop();
    }

    @Override
    public void beforeMapValue(Types.Field valueField) {
        this.nameToId.put(InternalSchemaUtils.createFullName("value", this.fieldNames), this.position.getAndIncrement());
        this.fieldNames.push(valueField.name());
    }

    @Override
    public void afterMapValue(Types.Field valueField) {
        this.fieldNames.pop();
    }

    @Override
    public Map<String, Integer> schema(InternalSchema schema, Map<String, Integer> recordResult) {
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> record(Types.RecordType record, List<Map<String, Integer>> fieldResults) {
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> field(Types.Field field, Map<String, Integer> fieldResult) {
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> array(Types.ArrayType array, Map<String, Integer> elementResult) {
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> map(Types.MapType map, Map<String, Integer> keyResult, Map<String, Integer> valueResult) {
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> primitive(Type.PrimitiveType primitive) {
        return this.nameToId;
    }
}

