/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileInfo;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.apache.hudi.io.hfile.protobuf.generated.HFileProtos;
import org.apache.hudi.io.util.IOUtils;

public class HFileFileInfoBlock
extends HFileBlock {
    public static final byte[] PB_MAGIC = new byte[]{80, 66, 85, 70};

    public HFileFileInfoBlock(HFileContext context, byte[] byteBuff, int startOffsetInBuff) {
        super(context, HFileBlockType.FILE_INFO, byteBuff, startOffsetInBuff);
    }

    public HFileInfo readFileInfo() throws IOException {
        int pbMagicLength = PB_MAGIC.length;
        if (IOUtils.compareTo(PB_MAGIC, 0, pbMagicLength, this.byteBuff, this.startOffsetInBuff + 33, pbMagicLength) != 0) {
            throw new IOException("Unexpected Protobuf magic at the beginning of the HFileFileInfoBlock: " + StringUtils.fromUTF8Bytes(this.byteBuff, this.startOffsetInBuff + 33, pbMagicLength));
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.byteBuff, this.startOffsetInBuff + 33 + pbMagicLength, this.uncompressedSizeWithoutHeader);
        HashMap<UTF8StringKey, byte[]> fileInfoMap = new HashMap<UTF8StringKey, byte[]>();
        HFileProtos.InfoProto infoProto = HFileProtos.InfoProto.parseDelimitedFrom(inputStream);
        for (HFileProtos.BytesBytesPair pair : infoProto.getMapEntryList()) {
            fileInfoMap.put(new UTF8StringKey(pair.getFirst().toByteArray()), pair.getSecond().toByteArray());
        }
        return new HFileInfo(fileInfoMap);
    }
}

