/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.io.hfile.BlockIndexEntry;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.util.IOUtils;

public class HFileLeafIndexBlock
extends HFileBlock {
    protected HFileLeafIndexBlock(HFileContext context, byte[] byteBuff, int startOffsetInBuff) {
        super(context, HFileBlockType.LEAF_INDEX, byteBuff, startOffsetInBuff);
    }

    protected HFileLeafIndexBlock(HFileContext context, HFileBlockType blockType, byte[] byteBuff, int startOffsetInBuff) {
        super(context, blockType, byteBuff, startOffsetInBuff);
    }

    public List<BlockIndexEntry> readBlockIndex() {
        int buffOffset = this.startOffsetInBuff + 33;
        int numEntries = IOUtils.readInt(this.byteBuff, buffOffset);
        buffOffset += 4;
        ArrayList<Integer> relativeOffsets = new ArrayList<Integer>();
        for (int i = 0; i <= numEntries; ++i) {
            relativeOffsets.add(IOUtils.readInt(this.byteBuff, buffOffset));
            buffOffset += 4;
        }
        ArrayList<BlockIndexEntry> indexEntries = new ArrayList<BlockIndexEntry>();
        int secondIndexAfterOffset = buffOffset;
        for (int i = 0; i < numEntries; ++i) {
            ValidationUtils.checkState(buffOffset - secondIndexAfterOffset == (Integer)relativeOffsets.get(i));
            long offset = IOUtils.readLong(this.byteBuff, buffOffset);
            int size = IOUtils.readInt(this.byteBuff, buffOffset + 8);
            int keyStartOffset = buffOffset + 12;
            int nextEntryStartOffset = secondIndexAfterOffset + (Integer)relativeOffsets.get(i + 1);
            int keyLength = nextEntryStartOffset - keyStartOffset;
            byte[] keyBytes = IOUtils.copy(this.byteBuff, buffOffset + 12, keyLength);
            Key key = new Key(keyBytes);
            indexEntries.add(new BlockIndexEntry(key, Option.empty(), offset, size));
            buffOffset += 12 + keyLength;
        }
        return indexEntries;
    }
}

