/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hudi.io.compress.CompressionCodec;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileUtils;
import org.apache.hudi.io.hfile.protobuf.generated.HFileProtos;

public class HFileTrailer {
    public static final int TRAILER_SIZE = 4096;
    private static final int NOT_PB_SIZE = 12;
    private long fileInfoOffset;
    private long loadOnOpenDataOffset;
    private int dataIndexCount;
    private long uncompressedDataIndexSize;
    private int metaIndexCount;
    private long totalUncompressedBytes;
    private long keyValueEntryCount;
    private CompressionCodec compressionCodec = CompressionCodec.NONE;
    private int numDataIndexLevels;
    private long firstDataBlockOffset;
    private long lastDataBlockOffset;
    private String comparatorClassName = "";
    private byte[] encryptionKey;
    private final int majorVersion;
    private final int minorVersion;

    public HFileTrailer(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public static int getTrailerSize() {
        return 4096;
    }

    public long getLoadOnOpenDataOffset() {
        return this.loadOnOpenDataOffset;
    }

    public int getNumDataIndexLevels() {
        return this.numDataIndexLevels;
    }

    public int getDataIndexCount() {
        return this.dataIndexCount;
    }

    public int getMetaIndexCount() {
        return this.metaIndexCount;
    }

    public long getNumKeyValueEntries() {
        return this.keyValueEntryCount;
    }

    public CompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public void deserialize(DataInputStream stream) throws IOException {
        HFileBlockType.TRAILER.readAndCheckMagic(stream);
        int start2 = stream.available();
        HFileProtos.TrailerProto trailerProto = HFileProtos.TrailerProto.PARSER.parseDelimitedFrom(stream);
        int size = start2 - stream.available();
        stream.skip(HFileTrailer.getTrailerSize() - 12 - size);
        if (trailerProto.hasFileInfoOffset()) {
            this.fileInfoOffset = trailerProto.getFileInfoOffset();
        }
        if (trailerProto.hasLoadOnOpenDataOffset()) {
            this.loadOnOpenDataOffset = trailerProto.getLoadOnOpenDataOffset();
        }
        if (trailerProto.hasUncompressedDataIndexSize()) {
            this.uncompressedDataIndexSize = trailerProto.getUncompressedDataIndexSize();
        }
        if (trailerProto.hasTotalUncompressedBytes()) {
            this.totalUncompressedBytes = trailerProto.getTotalUncompressedBytes();
        }
        if (trailerProto.hasDataIndexCount()) {
            this.dataIndexCount = trailerProto.getDataIndexCount();
        }
        if (trailerProto.hasMetaIndexCount()) {
            this.metaIndexCount = trailerProto.getMetaIndexCount();
        }
        if (trailerProto.hasEntryCount()) {
            this.keyValueEntryCount = trailerProto.getEntryCount();
        }
        if (trailerProto.hasNumDataIndexLevels()) {
            this.numDataIndexLevels = trailerProto.getNumDataIndexLevels();
        }
        if (trailerProto.hasFirstDataBlockOffset()) {
            this.firstDataBlockOffset = trailerProto.getFirstDataBlockOffset();
        }
        if (trailerProto.hasLastDataBlockOffset()) {
            this.lastDataBlockOffset = trailerProto.getLastDataBlockOffset();
        }
        if (trailerProto.hasComparatorClassName()) {
            this.comparatorClassName = trailerProto.getComparatorClassName();
        }
        this.compressionCodec = trailerProto.hasCompressionCodec() ? HFileUtils.decodeCompressionCodec(trailerProto.getCompressionCodec()) : CompressionCodec.NONE;
        if (trailerProto.hasEncryptionKey()) {
            this.encryptionKey = trailerProto.getEncryptionKey().toByteArray();
        }
    }

    public String toString() {
        return "HFileTrailer{fileInfoOffset=" + this.fileInfoOffset + ", loadOnOpenDataOffset=" + this.loadOnOpenDataOffset + ", dataIndexCount=" + this.dataIndexCount + ", uncompressedDataIndexSize=" + this.uncompressedDataIndexSize + ", metaIndexCount=" + this.metaIndexCount + ", totalUncompressedBytes=" + this.totalUncompressedBytes + ", entryCount=" + this.keyValueEntryCount + ", compressionCodec=" + (Object)((Object)this.compressionCodec) + ", numDataIndexLevels=" + this.numDataIndexLevels + ", firstDataBlockOffset=" + this.firstDataBlockOffset + ", lastDataBlockOffset=" + this.lastDataBlockOffset + ", comparatorClassName='" + this.comparatorClassName + '\'' + ", encryptionKey=" + Arrays.toString(this.encryptionKey) + ", majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + '}';
    }
}

