/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.factory;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.AutoRecordGenWrapperKeyGenerator;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.GlobalDeleteKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieSparkKeyGeneratorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSparkKeyGeneratorFactory.class);
    private static final Map<String, String> COMMON_TO_SPARK_KEYGENERATOR = new HashMap<String, String>();

    public static KeyGenerator createKeyGenerator(TypedProperties props) {
        String keyGeneratorClass = HoodieSparkKeyGeneratorFactory.getKeyGeneratorClassName(props);
        return HoodieSparkKeyGeneratorFactory.createKeyGenerator(keyGeneratorClass, props);
    }

    public static KeyGenerator createKeyGenerator(String keyGeneratorClass, TypedProperties props) {
        boolean autoRecordKeyGen;
        boolean bl = autoRecordKeyGen = KeyGenUtils.isAutoGeneratedRecordKeysEnabled(props) && !props.getBoolean("_hoodie.spark.sql.merge.into.prepped", false);
        if (autoRecordKeyGen) {
            props.remove(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key());
        }
        KeyGenerator keyGenerator = (KeyGenerator)ReflectionUtils.loadClass(keyGeneratorClass, props);
        if (autoRecordKeyGen) {
            return new AutoRecordGenWrapperKeyGenerator(props, (BuiltinKeyGenerator)keyGenerator);
        }
        return keyGenerator;
    }

    public static Option<BaseKeyGenerator> createBaseKeyGenerator(HoodieWriteConfig writeConfig) {
        if (!writeConfig.populateMetaFields()) {
            try {
                TypedProperties typedProperties = TypedProperties.copy(writeConfig.getProps());
                return Option.of((BaseKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator(typedProperties));
            }
            catch (ClassCastException cce) {
                throw new HoodieException("Only BaseKeyGenerators are supported when meta columns are disabled ", cce);
            }
        }
        return Option.empty();
    }

    public static String getKeyGeneratorClassNameFromType(KeyGeneratorType type) {
        switch (type) {
            case SIMPLE: {
                return SimpleKeyGenerator.class.getName();
            }
            case COMPLEX: {
                return ComplexKeyGenerator.class.getName();
            }
            case TIMESTAMP: {
                return TimestampBasedKeyGenerator.class.getName();
            }
            case CUSTOM: {
                return CustomKeyGenerator.class.getName();
            }
            case NON_PARTITION: {
                return NonpartitionedKeyGenerator.class.getName();
            }
            case GLOBAL_DELETE: {
                return GlobalDeleteKeyGenerator.class.getName();
            }
        }
        throw new HoodieKeyGeneratorException("Unsupported keyGenerator Type " + (Object)((Object)type));
    }

    public static Option<BuiltinKeyGenerator> getKeyGenerator(Properties properties) {
        TypedProperties typedProperties = new TypedProperties();
        typedProperties.putAll((Map<?, ?>)properties);
        if (Option.ofNullable(properties.get(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key())).map(v -> v.equals(NonpartitionedKeyGenerator.class.getName())).orElse(false).booleanValue()) {
            return Option.empty();
        }
        try {
            return Option.of((BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator(typedProperties));
        }
        catch (ClassCastException cce) {
            throw new HoodieIOException("Only those key generators implementing BuiltInKeyGenerator interface is supported with virtual keys");
        }
    }

    public static KeyGeneratorType inferKeyGeneratorTypeFromWriteConfig(TypedProperties props) {
        String partitionFields = props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), null);
        String recordsKeyFields = props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), null);
        return KeyGenUtils.inferKeyGeneratorType(Option.ofNullable(recordsKeyFields), partitionFields);
    }

    public static String getKeyGeneratorClassName(TypedProperties props) {
        String keyGeneratorClass = props.getString(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), null);
        if (StringUtils.isNullOrEmpty(keyGeneratorClass)) {
            KeyGeneratorType keyGeneratorTypeEnum;
            String keyGeneratorType = props.getString(HoodieWriteConfig.KEYGENERATOR_TYPE.key(), null);
            if (StringUtils.isNullOrEmpty(keyGeneratorType)) {
                keyGeneratorTypeEnum = HoodieSparkKeyGeneratorFactory.inferKeyGeneratorTypeFromWriteConfig(props);
                LOG.info("The value of {} is empty; inferred to be {}", (Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key(), (Object)keyGeneratorTypeEnum);
            } else {
                try {
                    keyGeneratorTypeEnum = KeyGeneratorType.valueOf(keyGeneratorType.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    throw new HoodieKeyGeneratorException("Unsupported keyGenerator Type " + keyGeneratorType);
                }
            }
            keyGeneratorClass = HoodieSparkKeyGeneratorFactory.getKeyGeneratorClassNameFromType(keyGeneratorTypeEnum);
        }
        return keyGeneratorClass;
    }

    public static String convertToSparkKeyGenerator(String keyGeneratorClassName) {
        return COMMON_TO_SPARK_KEYGENERATOR.getOrDefault(keyGeneratorClassName, keyGeneratorClassName);
    }

    static {
        COMMON_TO_SPARK_KEYGENERATOR.put("org.apache.hudi.keygen.ComplexAvroKeyGenerator", "org.apache.hudi.keygen.ComplexKeyGenerator");
        COMMON_TO_SPARK_KEYGENERATOR.put("org.apache.hudi.keygen.CustomAvroKeyGenerator", "org.apache.hudi.keygen.CustomKeyGenerator");
        COMMON_TO_SPARK_KEYGENERATOR.put("org.apache.hudi.keygen.GlobalAvroDeleteKeyGenerator", "org.apache.hudi.keygen.GlobalDeleteKeyGenerator");
        COMMON_TO_SPARK_KEYGENERATOR.put("org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator", "org.apache.hudi.keygen.NonpartitionedKeyGenerator");
        COMMON_TO_SPARK_KEYGENERATOR.put("org.apache.hudi.keygen.SimpleAvroKeyGenerator", "org.apache.hudi.keygen.SimpleKeyGenerator");
        COMMON_TO_SPARK_KEYGENERATOR.put("org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator", "org.apache.hudi.keygen.TimestampBasedKeyGenerator");
    }
}

