/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

public class BaseFileRecordParsingUtils {
    public static Iterator<HoodieRecord> generateRLIMetadataHoodieRecordsForBaseFile(String basePath, HoodieWriteStat writeStat, Integer writesFileIdEncoding, String instantTime, HoodieStorage storage) {
        String partition = writeStat.getPartitionPath();
        String latestFileName = FSUtils.getFileNameFromPath(writeStat.getPath());
        String fileId = FSUtils.getFileId(latestFileName);
        HashSet<RecordStatus> recordStatuses = new HashSet<RecordStatus>();
        recordStatuses.add(RecordStatus.INSERT);
        recordStatuses.add(RecordStatus.DELETE);
        Map<RecordStatus, List<String>> recordStatusListMap = BaseFileRecordParsingUtils.getRecordKeyStatuses(basePath, writeStat.getPartitionPath(), latestFileName, writeStat.getPrevBaseFile(), storage, recordStatuses);
        ArrayList hoodieRecords = new ArrayList();
        if (recordStatusListMap.containsKey((Object)RecordStatus.INSERT)) {
            hoodieRecords.addAll(recordStatusListMap.get((Object)RecordStatus.INSERT).stream().map(recordKey -> HoodieMetadataPayload.createRecordIndexUpdate(recordKey, partition, fileId, instantTime, writesFileIdEncoding)).collect(Collectors.toList()));
        }
        if (recordStatusListMap.containsKey((Object)RecordStatus.DELETE)) {
            hoodieRecords.addAll(recordStatusListMap.get((Object)RecordStatus.DELETE).stream().map(recordKey -> HoodieMetadataPayload.createRecordIndexDelete(recordKey)).collect(Collectors.toList()));
        }
        return hoodieRecords.iterator();
    }

    @VisibleForTesting
    public static List<String> getRecordKeysDeletedOrUpdated(String basePath, HoodieWriteStat writeStat, HoodieStorage storage) {
        String latestFileName = FSUtils.getFileNameFromPath(writeStat.getPath());
        HashSet<RecordStatus> recordStatuses = new HashSet<RecordStatus>();
        recordStatuses.add(RecordStatus.UPDATE);
        recordStatuses.add(RecordStatus.DELETE);
        return BaseFileRecordParsingUtils.getRecordKeyStatuses(basePath, writeStat.getPartitionPath(), latestFileName, writeStat.getPrevBaseFile(), storage, recordStatuses).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @VisibleForTesting
    public static Map<RecordStatus, List<String>> getRecordKeyStatuses(String basePath, String partition, String latestFileName, String prevFileName, HoodieStorage storage, Set<RecordStatus> recordStatusesOfInterest) {
        Set<String> recordKeysFromLatestBaseFile = BaseFileRecordParsingUtils.getRecordKeysFromBaseFile(storage, basePath, partition, latestFileName);
        if (prevFileName == null) {
            if (recordStatusesOfInterest.contains((Object)RecordStatus.INSERT)) {
                return Collections.singletonMap(RecordStatus.INSERT, new ArrayList<String>(recordKeysFromLatestBaseFile));
            }
            return Collections.emptyMap();
        }
        Set<String> recordKeysFromPreviousBaseFile = BaseFileRecordParsingUtils.getRecordKeysFromBaseFile(storage, basePath, partition, prevFileName);
        HashMap<RecordStatus, List<String>> toReturn = new HashMap<RecordStatus, List<String>>(recordStatusesOfInterest.size());
        if (recordStatusesOfInterest.contains((Object)RecordStatus.DELETE)) {
            toReturn.put(RecordStatus.DELETE, recordKeysFromPreviousBaseFile.stream().filter(recordKey -> !recordKeysFromLatestBaseFile.contains(recordKey)).collect(Collectors.toList()));
        }
        ArrayList updates = new ArrayList();
        ArrayList inserts = new ArrayList();
        recordKeysFromLatestBaseFile.stream().forEach(recordKey -> {
            if (recordKeysFromPreviousBaseFile.contains(recordKey)) {
                updates.add(recordKey);
            } else {
                inserts.add(recordKey);
            }
        });
        if (recordStatusesOfInterest.contains((Object)RecordStatus.UPDATE)) {
            toReturn.put(RecordStatus.UPDATE, updates);
        }
        if (recordStatusesOfInterest.contains((Object)RecordStatus.INSERT)) {
            toReturn.put(RecordStatus.INSERT, inserts);
        }
        return toReturn;
    }

    private static Set<String> getRecordKeysFromBaseFile(HoodieStorage storage, String basePath, String partition, String fileName) {
        StoragePath dataFilePath = new StoragePath(basePath, StringUtils.isNullOrEmpty(partition) ? fileName : partition + "/" + fileName);
        FileFormatUtils fileFormatUtils = HoodieIOFactory.getIOFactory(storage).getFileFormatUtils(HoodieFileFormat.PARQUET);
        return fileFormatUtils.readRowKeys(storage, dataFilePath);
    }

    public static enum RecordStatus {
        INSERT,
        UPDATE,
        DELETE;

    }
}

