/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.parquet.io;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;

public class OutputStreamBackedOutputFile
implements OutputFile {
    private static final long DEFAULT_BLOCK_SIZE = 0x100000L;
    private final FSDataOutputStream outputStream;

    public OutputStreamBackedOutputFile(FSDataOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public PositionOutputStream create(long blockSizeHint) {
        return new PositionOutputStreamAdapter(this.outputStream);
    }

    public PositionOutputStream createOrOverwrite(long blockSizeHint) {
        return this.create(blockSizeHint);
    }

    public boolean supportsBlockSize() {
        return false;
    }

    public long defaultBlockSize() {
        return 0x100000L;
    }

    private static class PositionOutputStreamAdapter
    extends PositionOutputStream {
        private final FSDataOutputStream delegate;

        PositionOutputStreamAdapter(FSDataOutputStream delegate) {
            this.delegate = delegate;
        }

        public long getPos() throws IOException {
            return this.delegate.getPos();
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        public void write(@Nonnull byte[] buffer, int off, int len) throws IOException {
            this.delegate.write(buffer, off, len);
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void close() {
        }
    }
}

