/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hive.SchemaDifference;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.parquet.schema.MessageType;

public interface HoodieMetaSyncOperations {
    public static final String HOODIE_LAST_COMMIT_TIME_SYNC = "last_commit_time_sync";
    public static final String HOODIE_LAST_COMMIT_COMPLETION_TIME_SYNC = "last_commit_completion_time_sync";

    default public void createTable(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
    }

    default public void createOrReplaceTable(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
    }

    default public boolean tableExists(String tableName) {
        return false;
    }

    default public void dropTable(String tableName) {
    }

    default public void addPartitionsToTable(String tableName, List<String> partitionsToAdd) {
    }

    default public void updatePartitionsToTable(String tableName, List<String> changedPartitions) {
    }

    default public void dropPartitions(String tableName, List<String> partitionsToDrop) {
    }

    default public List<Partition> getAllPartitions(String tableName) {
        return Collections.emptyList();
    }

    default public List<Partition> getPartitionsFromList(String tableName, List<String> partitionList) {
        return Collections.emptyList();
    }

    default public boolean databaseExists(String databaseName) {
        return false;
    }

    default public void createDatabase(String databaseName) {
    }

    default public Map<String, String> getMetastoreSchema(String tableName) {
        return Collections.emptyMap();
    }

    default public MessageType getStorageSchema() {
        return null;
    }

    default public MessageType getStorageSchema(boolean includeMetadataField) {
        return null;
    }

    default public void updateTableSchema(String tableName, MessageType newSchema, SchemaDifference schemaDiff) {
    }

    default public List<FieldSchema> getMetastoreFieldSchemas(String tableName) {
        return Collections.emptyList();
    }

    default public List<FieldSchema> getStorageFieldSchemas() {
        return Collections.emptyList();
    }

    default public String getTableLocation(String tableName) {
        return "";
    }

    default public boolean updateTableComments(String tableName, List<FieldSchema> fromMetastore, List<FieldSchema> fromStorage) {
        return false;
    }

    default public Option<String> getLastCommitTimeSynced(String tableName) {
        return Option.empty();
    }

    default public Option<String> getLastCommitCompletionTimeSynced(String tableName) {
        return Option.empty();
    }

    default public void updateLastCommitTimeSynced(String tableName) {
    }

    default public boolean updateTableProperties(String tableName, Map<String, String> tableProperties) {
        return false;
    }

    default public boolean updateSerdeProperties(String tableName, Map<String, String> serdeProperties, boolean useRealtimeFormat) {
        return false;
    }

    default public Option<String> getLastReplicatedTime(String tableName) {
        return Option.empty();
    }

    default public void updateLastReplicatedTimeStamp(String tableName, String timeStamp) {
    }

    default public void deleteLastReplicatedTimeStamp(String tableName) {
    }

    default public String generatePushDownFilter(List<String> writtenPartitions, List<FieldSchema> partitionFields) {
        throw new UnsupportedOperationException();
    }
}

