/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.action.compact.strategy.BoundedIOCompactionStrategy;

public class DayBasedCompactionStrategy
extends BoundedIOCompactionStrategy {
    protected static final String DATE_PARTITION_FORMAT = "yyyy/MM/dd";
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_PARTITION_FORMAT, Locale.ENGLISH));
    protected static Comparator<String> comparator = (leftPartition, rightPartition) -> {
        try {
            leftPartition = DayBasedCompactionStrategy.getPartitionPathWithoutPartitionKeys(leftPartition);
            rightPartition = DayBasedCompactionStrategy.getPartitionPathWithoutPartitionKeys(rightPartition);
            Date left = DATE_FORMAT.get().parse((String)leftPartition);
            Date right = DATE_FORMAT.get().parse((String)rightPartition);
            return left.after(right) ? -1 : (right.after(left) ? 1 : 0);
        }
        catch (ParseException e) {
            throw new HoodieException("Invalid Partition Date Format", e);
        }
    };

    public Comparator<String> getComparator() {
        return comparator;
    }

    @Override
    public Pair<List<String>, List<String>> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> allPartitionPaths) {
        List res = allPartitionPaths.stream().sorted(comparator).collect(Collectors.toList()).subList(0, Math.min(allPartitionPaths.size(), writeConfig.getTargetPartitionsPerDayBasedCompaction()));
        return Pair.of(res, Collections.emptyList());
    }

    protected static String getPartitionPathWithoutPartitionKeys(String partitionPath) {
        if (partitionPath.contains("=")) {
            return partitionPath.replaceFirst(".*?=", "").replaceAll("/.*?=", "/");
        }
        return partitionPath;
    }
}

