/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieUpgradeDowngradeException;
import org.apache.hudi.metadata.HoodieMetadataWriteUtils;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.EightToSevenDowngradeHandler;
import org.apache.hudi.table.upgrade.FiveToFourDowngradeHandler;
import org.apache.hudi.table.upgrade.FiveToSixUpgradeHandler;
import org.apache.hudi.table.upgrade.FourToFiveUpgradeHandler;
import org.apache.hudi.table.upgrade.FourToThreeDowngradeHandler;
import org.apache.hudi.table.upgrade.OneToTwoUpgradeHandler;
import org.apache.hudi.table.upgrade.OneToZeroDowngradeHandler;
import org.apache.hudi.table.upgrade.SevenToEightUpgradeHandler;
import org.apache.hudi.table.upgrade.SevenToSixDowngradeHandler;
import org.apache.hudi.table.upgrade.SixToFiveDowngradeHandler;
import org.apache.hudi.table.upgrade.SixToSevenUpgradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.ThreeToFourUpgradeHandler;
import org.apache.hudi.table.upgrade.ThreeToTwoDowngradeHandler;
import org.apache.hudi.table.upgrade.TwoToOneDowngradeHandler;
import org.apache.hudi.table.upgrade.TwoToThreeUpgradeHandler;
import org.apache.hudi.table.upgrade.ZeroToOneUpgradeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeDowngrade {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeDowngrade.class);
    public static final String HOODIE_UPDATED_PROPERTY_FILE = "hoodie.properties.updated";
    private final SupportsUpgradeDowngrade upgradeDowngradeHelper;
    private HoodieTableMetaClient metaClient;
    protected HoodieWriteConfig config;
    protected HoodieEngineContext context;

    public UpgradeDowngrade(HoodieTableMetaClient metaClient, HoodieWriteConfig config, HoodieEngineContext context, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        this.metaClient = metaClient;
        this.config = config;
        this.context = context;
        this.upgradeDowngradeHelper = upgradeDowngradeHelper;
    }

    public static boolean needsUpgradeOrDowngrade(HoodieTableMetaClient metaClient, HoodieWriteConfig config, HoodieTableVersion toWriteVersion) {
        HoodieTableVersion fromTableVersion = metaClient.getTableConfig().getTableVersion();
        return UpgradeDowngrade.needsUpgrade(metaClient, config, toWriteVersion) || toWriteVersion.versionCode() < fromTableVersion.versionCode();
    }

    public static boolean needsUpgrade(HoodieTableMetaClient metaClient, HoodieWriteConfig config, HoodieTableVersion toWriteVersion) {
        HoodieTableVersion fromTableVersion = metaClient.getTableConfig().getTableVersion();
        if (fromTableVersion.versionCode() < HoodieTableVersion.SIX.versionCode() && toWriteVersion.versionCode() >= HoodieTableVersion.EIGHT.versionCode()) {
            throw new HoodieUpgradeDowngradeException(String.format("Please upgrade table from version %s to %s before upgrading to version %s.", new Object[]{fromTableVersion, HoodieTableVersion.SIX.versionCode(), toWriteVersion}));
        }
        return toWriteVersion.versionCode() > fromTableVersion.versionCode();
    }

    public boolean needsUpgradeOrDowngrade(HoodieTableVersion toWriteVersion) {
        return UpgradeDowngrade.needsUpgradeOrDowngrade(this.metaClient, this.config, toWriteVersion);
    }

    public boolean needsUpgrade(HoodieTableVersion toWriteVersion) {
        return UpgradeDowngrade.needsUpgrade(this.metaClient, this.config, toWriteVersion);
    }

    public void run(HoodieTableVersion toVersion, String instantTime) {
        if (toVersion.versionCode() >= HoodieTableVersion.FOUR.versionCode()) {
            String metadataTablePath = HoodieTableMetadata.getMetadataTableBasePath(this.metaClient.getBasePath().toString());
            try {
                if (this.metaClient.getStorage().exists(new StoragePath(metadataTablePath))) {
                    HoodieTableMetaClient mdtMetaClient = HoodieTableMetaClient.builder().setConf(this.metaClient.getStorageConf().newInstance()).setBasePath(metadataTablePath).build();
                    HoodieWriteConfig mdtWriteConfig = HoodieMetadataWriteUtils.createMetadataWriteConfig(this.config, HoodieFailedWritesCleaningPolicy.EAGER);
                    new UpgradeDowngrade(mdtMetaClient, mdtWriteConfig, this.context, this.upgradeDowngradeHelper).run(toVersion, instantTime);
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to upgrade or downgrade the metadata table to version " + (Object)((Object)toVersion) + ", ignoring the error and continue.", (Throwable)e);
            }
        }
        HoodieTableVersion fromVersion = this.metaClient.getTableConfig().getTableVersion();
        if (!this.needsUpgradeOrDowngrade(toVersion)) {
            return;
        }
        LOG.info("Attempting to move table from version " + (Object)((Object)fromVersion) + " to " + (Object)((Object)toVersion));
        Hashtable<ConfigProperty, String> tablePropsToAdd = new Hashtable<ConfigProperty, String>();
        ArrayList tablePropsToRemove = new ArrayList();
        boolean isDowngrade = false;
        if (fromVersion.versionCode() < toVersion.versionCode()) {
            while (fromVersion.versionCode() < toVersion.versionCode()) {
                HoodieTableVersion nextVersion = HoodieTableVersion.fromVersionCode(fromVersion.versionCode() + 1);
                tablePropsToAdd.putAll(this.upgrade(fromVersion, nextVersion, instantTime));
                fromVersion = nextVersion;
            }
        } else {
            isDowngrade = true;
            while (fromVersion.versionCode() > toVersion.versionCode()) {
                HoodieTableVersion prevVersion = HoodieTableVersion.fromVersionCode(fromVersion.versionCode() - 1);
                Pair<Map<ConfigProperty, String>, List<ConfigProperty>> pair = this.downgrade(fromVersion, prevVersion, instantTime);
                tablePropsToAdd.putAll(pair.getLeft());
                tablePropsToRemove.addAll(pair.getRight());
                fromVersion = prevVersion;
            }
        }
        if (this.metaClient.getTableConfig().isMetadataTableAvailable()) {
            this.metaClient = HoodieTableMetaClient.reload(this.metaClient);
        }
        for (Map.Entry entry : tablePropsToAdd.entrySet()) {
            this.metaClient.getTableConfig().setValue((ConfigProperty)entry.getKey(), (String)entry.getValue());
            ((ConfigProperty)entry.getKey()).getAlternatives().forEach(alternateKey -> this.metaClient.getTableConfig().setValue((String)alternateKey, (String)entry.getValue()));
        }
        for (ConfigProperty configProperty : tablePropsToRemove) {
            this.metaClient.getTableConfig().clearValue(configProperty);
        }
        if (this.config.autoUpgrade()) {
            this.metaClient.getTableConfig().setTableVersion(toVersion);
        }
        HoodieTableConfig.update(this.metaClient.getStorage(), this.metaClient.getMetaPath(), this.metaClient.getTableConfig().getProps());
        if (this.metaClient.getTableConfig().isMetadataTableAvailable() && toVersion.equals((Object)HoodieTableVersion.SIX) && isDowngrade) {
            TypedProperties typedProperties = this.config.getProps();
            typedProperties.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "6");
            typedProperties.setProperty(HoodieWriteConfig.AUTO_UPGRADE_VERSION.key(), "false");
            HoodieWriteConfig hoodieWriteConfig = HoodieWriteConfig.newBuilder().withPath(this.config.getBasePath()).withProperties(typedProperties).build();
            HoodieTable table = this.upgradeDowngradeHelper.getTable(hoodieWriteConfig, this.context);
            String newInstant = table.getMetaClient().createNewInstantTime(false);
            Option<HoodieTableMetadataWriter> mdtWriterOpt = table.getMetadataWriter(newInstant);
            mdtWriterOpt.ifPresent(mdtWriter -> {
                HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
                commitMetadata.setOperationType(WriteOperationType.UPSERT);
                mdtWriter.update(commitMetadata, newInstant);
                try {
                    mdtWriter.close();
                }
                catch (Exception e) {
                    throw new HoodieException("Failed to close MDT writer for table " + table.getConfig().getBasePath());
                }
            });
        }
    }

    protected Map<ConfigProperty, String> upgrade(HoodieTableVersion fromVersion, HoodieTableVersion toVersion, String instantTime) {
        if (fromVersion == HoodieTableVersion.ZERO && toVersion == HoodieTableVersion.ONE) {
            return new ZeroToOneUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.ONE && toVersion == HoodieTableVersion.TWO) {
            return new OneToTwoUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.TWO && toVersion == HoodieTableVersion.THREE) {
            return new TwoToThreeUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.THREE && toVersion == HoodieTableVersion.FOUR) {
            return new ThreeToFourUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FOUR && toVersion == HoodieTableVersion.FIVE) {
            return new FourToFiveUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FIVE && toVersion == HoodieTableVersion.SIX) {
            return new FiveToSixUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.SIX && toVersion == HoodieTableVersion.SEVEN) {
            return new SixToSevenUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.SEVEN && toVersion == HoodieTableVersion.EIGHT) {
            return new SevenToEightUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        throw new HoodieUpgradeDowngradeException(fromVersion.versionCode(), toVersion.versionCode(), true);
    }

    protected Pair<Map<ConfigProperty, String>, List<ConfigProperty>> downgrade(HoodieTableVersion fromVersion, HoodieTableVersion toVersion, String instantTime) {
        if (fromVersion == HoodieTableVersion.ONE && toVersion == HoodieTableVersion.ZERO) {
            return new OneToZeroDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.TWO && toVersion == HoodieTableVersion.ONE) {
            return new TwoToOneDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.THREE && toVersion == HoodieTableVersion.TWO) {
            return new ThreeToTwoDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FOUR && toVersion == HoodieTableVersion.THREE) {
            return new FourToThreeDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FIVE && toVersion == HoodieTableVersion.FOUR) {
            return new FiveToFourDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.SIX && toVersion == HoodieTableVersion.FIVE) {
            return new SixToFiveDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.SEVEN && toVersion == HoodieTableVersion.SIX) {
            return new SevenToSixDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.EIGHT && toVersion == HoodieTableVersion.SEVEN) {
            return new EightToSevenDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        throw new HoodieUpgradeDowngradeException(fromVersion.versionCode(), toVersion.versionCode(), false);
    }
}

