/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class ResolveInsertionBase$
implements SparkAdapterSupport {
    public static ResolveInsertionBase$ MODULE$;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new ResolveInsertionBase$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        ResolveInsertionBase$ resolveInsertionBase$ = this;
        synchronized (resolveInsertionBase$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public Function2<String, String, Object> resolver() {
        return SQLConf$.MODULE$.get().resolver();
    }

    public LogicalPlan createProjectForByNameQuery(String tblName, InsertIntoStatement i) {
        this.sparkAdapter().getSchemaUtils().checkColumnNameDuplication((Seq<String>)i.userSpecifiedCols(), new StringBuilder(27).append("in the table definition of ").append(tblName).toString(), SQLConf$.MODULE$.get().caseSensitiveAnalysis());
        if (i.userSpecifiedCols().size() != i.query().output().size()) {
            if (i.userSpecifiedCols().size() > i.query().output().size()) {
                throw this.cannotWriteNotEnoughColumnsToTableError(tblName, (Seq<String>)i.userSpecifiedCols(), (Seq<Attribute>)i.query().output());
            }
            throw this.cannotWriteNotEnoughColumnsToTableError(tblName, (Seq<String>)i.userSpecifiedCols(), (Seq<Attribute>)i.query().output());
        }
        Seq projectByName = (Seq)((TraversableLike)i.userSpecifiedCols().zip((GenIterable)i.query().output(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String userSpecifiedCol = (String)tuple2._1();
                Attribute queryOutputCol = (Attribute)tuple2._2();
                NamedExpression resolvedCol = (NamedExpression)i.table().resolve((Seq)new .colon.colon((Object)userSpecifiedCol, (List)Nil$.MODULE$), MODULE$.resolver()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw MODULE$.unresolvedAttributeError("UNRESOLVED_COLUMN", userSpecifiedCol, (Seq<String>)((Seq)i.table().output().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())));
                });
                Tuple2 tuple22 = new Tuple2((Object)queryOutputCol.dataType(), (Object)((Expression)resolvedCol).dataType());
                if (tuple22 != null) {
                    DataType input = (DataType)tuple22._1();
                    DataType expected = (DataType)tuple22._2();
                    if (input instanceof StructType) {
                        StructType structType = (StructType)input;
                        if (expected instanceof StructType) {
                            StructType structType2 = (StructType)expected;
                            Cast x$1 = new Cast((Expression)queryOutputCol, (DataType)MODULE$.renameFieldsInStruct(structType, structType2), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                            String x$2 = resolvedCol.name();
                            ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
                            Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                            Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
                            Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
                            return new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6);
                        }
                    }
                }
                Attribute x$7 = queryOutputCol;
                String x$8 = resolvedCol.name();
                ExprId x$9 = Alias$.MODULE$.apply$default$3((Expression)x$7, x$8);
                Seq x$10 = Alias$.MODULE$.apply$default$4((Expression)x$7, x$8);
                Option x$11 = Alias$.MODULE$.apply$default$5((Expression)x$7, x$8);
                Seq x$12 = Alias$.MODULE$.apply$default$6((Expression)x$7, x$8);
                return new Alias((Expression)x$7, x$8, x$9, x$10, x$11, x$12);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return new Project(projectByName, i.query());
    }

    private StructType renameFieldsInStruct(StructType input, StructType expected) {
        if (input.length() == expected.length()) {
            Seq newFields = (Seq)((TraversableLike)input.zip((GenIterable)expected, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField f1 = (StructField)tuple2._1();
                    StructField f2 = (StructField)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)f1.dataType(), (Object)f2.dataType());
                    if (tuple22 != null) {
                        DataType s1 = (DataType)tuple22._1();
                        DataType s2 = (DataType)tuple22._2();
                        if (s1 instanceof StructType) {
                            StructType structType = (StructType)s1;
                            if (s2 instanceof StructType) {
                                StructType structType2 = (StructType)s2;
                                return f1.copy(f2.name(), (DataType)MODULE$.renameFieldsInStruct(structType, structType2), f1.copy$default$3(), f1.copy$default$4());
                            }
                        }
                    }
                    return f1.copy(f2.name(), f1.copy$default$2(), f1.copy$default$3(), f1.copy$default$4());
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            return StructType$.MODULE$.apply(newFields);
        }
        return input;
    }

    public Throwable cannotWriteNotEnoughColumnsToTableError(String tableName, Seq<String> expected, Seq<Attribute> queryOutput) {
        return new AnalysisException(new StringBuilder(83).append("table: ").append(tableName).append("INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS, expect: ").append(expected.mkString(",")).append(" queryOutput: ").append(((TraversableOnce)queryOutput.map((Function1 & Serializable & scala.Serializable)attr -> attr.name(), Seq$.MODULE$.canBuildFrom())).mkString(",")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unresolvedAttributeError(String errorClass, String colName, Seq<String> candidates) {
        return new AnalysisException(new StringBuilder(36).append(errorClass).append(" expect col is : ").append(colName).append(" table output is : ").append(candidates.mkString(",")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    private ResolveInsertionBase$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$(this);
    }
}

