/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.hudi.command.CreateIndexCommand;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class CreateIndexCommand$
implements Serializable {
    public static CreateIndexCommand$ MODULE$;

    static {
        new CreateIndexCommand$();
    }

    public boolean matchesRecordKeys(Set<String> columnNames, HoodieTableConfig tableConfig) {
        Set recordKeyFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableConfig.getRecordKeyFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))))).toSet();
        if (columnNames.equals((Object)recordKeyFields)) {
            return true;
        }
        Set recordKeyColumns = (Set)columnNames.intersect((GenSet)recordKeyFields);
        Set nonRecordKeyColumns = (Set)columnNames.$minus$minus((GenTraversableOnce)recordKeyColumns);
        if (recordKeyColumns.isEmpty()) {
            return false;
        }
        if (nonRecordKeyColumns.nonEmpty()) {
            throw new HoodieIndexException("Index can be created either on all record key columns or a non record key column");
        }
        throw new HoodieIndexException(String.format("Index can be only be created on all record key columns. Configured record key fields %s. Input columns: %s", recordKeyFields, columnNames));
    }

    public CreateIndexCommand apply(CatalogTable table, String indexName, String indexType, boolean ignoreIfExists, Seq<Tuple2<Seq<String>, Map<String, String>>> columns, Map<String, String> options) {
        return new CreateIndexCommand(table, indexName, indexType, ignoreIfExists, columns, options);
    }

    public Option<Tuple6<CatalogTable, String, String, Object, Seq<Tuple2<Seq<String>, Map<String, String>>>, Map<String, String>>> unapply(CreateIndexCommand x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.table(), (Object)x$0.indexName(), (Object)x$0.indexType(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.ignoreIfExists()), x$0.columns(), x$0.options()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CreateIndexCommand$() {
        MODULE$ = this;
    }
}

