/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Base64;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.config.HoodieHBaseIndexConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$MatchCast$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Assignment;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable;
import org.apache.spark.sql.hudi.command.MergeIntoFieldResolutionException;
import org.apache.spark.sql.hudi.command.MergeIntoFieldTypeMismatchException;
import org.apache.spark.sql.hudi.command.MergeIntoHoodieTableCommand;
import org.apache.spark.sql.hudi.command.payload.ExpressionPayload$Serializer$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class MergeIntoHoodieTableCommand$
implements scala.Serializable {
    public static MergeIntoHoodieTableCommand$ MODULE$;
    private final String userGuideString;

    static {
        new MergeIntoHoodieTableCommand$();
    }

    public String userGuideString() {
        return this.userGuideString;
    }

    public Expression stripCasting(Expression expr) {
        Expression expression = expr;
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            Expression expression2 = equalTo.left();
            Expression expression3 = equalTo.right();
            Option<Tuple4<Expression, DataType, Option<String>, Object>> option = HoodieCatalystExpressionUtils$MatchCast$.MODULE$.unapply(expression2);
            if (!option.isEmpty()) {
                Expression leftExpr = (Expression)((Tuple4)option.get())._1();
                DataType leftTargetType = (DataType)((Tuple4)option.get())._2();
                Option<Tuple4<Expression, DataType, Option<String>, Object>> option2 = HoodieCatalystExpressionUtils$MatchCast$.MODULE$.unapply(expression3);
                if (!option2.isEmpty()) {
                    Expression rightExpr = (Expression)((Tuple4)option2.get())._1();
                    DataType rightTargetType = (DataType)((Tuple4)option2.get())._2();
                    if (leftTargetType.sameType(rightTargetType)) {
                        return new EqualTo(leftExpr, rightExpr);
                    }
                }
            }
        }
        return expr;
    }

    public StructType toStructType(Seq<Attribute> attrs) {
        return StructType$.MODULE$.apply((Seq)attrs.map((Function1 & Serializable & scala.Serializable)a -> new StructField(a.qualifiedName().replace('.', '_'), a.dataType(), a.nullable(), a.metadata()), Seq$.MODULE$.canBuildFrom()));
    }

    public String encodeAsBase64String(Object any) {
        return Base64.getEncoder().encodeToString(ExpressionPayload$Serializer$.MODULE$.toBytes(any));
    }

    public void validateTargetTableAttrExistsInAssignments(Function2<String, String, Object> resolver2, LogicalPlan targetTable, Seq<String> fields, String fieldType, Seq<Assignment> assignments) {
        fields.foreach((Function1 & Serializable & scala.Serializable)field -> {
            MergeIntoHoodieTableCommand$.$anonfun$validateTargetTableAttrExistsInAssignments$1(targetTable, resolver2, fieldType, assignments, field);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Tuple2<Attribute, Expression>> resolveFieldAssociationsBetweenSourceAndTarget(Function2<String, String, Object> resolver2, LogicalPlan targetTable, LogicalPlan sourceTable, Seq<String> fields, String fieldType, Seq<Assignment> assignments) {
        return (Seq)fields.map((Function1 & Serializable & scala.Serializable)field -> {
            Attribute targetAttribute = (Attribute)targetTable.output().find((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)MergeIntoHoodieTableCommand$.$anonfun$resolveFieldAssociationsBetweenSourceAndTarget$2(resolver2, field, attr))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new MergeIntoFieldResolutionException(new StringBuilder(37).append("Failed to resolve ").append(fieldType).append(" `").append((String)field).append("` in target table").toString());
            });
            Expression sourceExpr = (Expression)sourceTable.output().find((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)MergeIntoHoodieTableCommand$.$anonfun$resolveFieldAssociationsBetweenSourceAndTarget$4(resolver2, field, attr))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Expression)assignments.collectFirst((PartialFunction)new scala.Serializable((Function2)resolver2, (String)field, sourceTable){
                public static final long serialVersionUID = 0L;
                private final Function2 resolver$4;
                private final String field$2;
                private final LogicalPlan sourceTable$1;

                public final <A1 extends Assignment, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        AttributeReference attributeReference;
                        Expression attr = A1.key();
                        Expression expr = A1.value();
                        if (attr instanceof AttributeReference && BoxesRunTime.unboxToBoolean((Object)this.resolver$4.apply((Object)(attributeReference = (AttributeReference)attr).name(), (Object)this.field$2)) && MergeIntoHoodieTableCommand$.MODULE$.resolvesToSourceAttribute(this.sourceTable$1, expr)) {
                            return (B1)expr;
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Assignment x1) {
                    Assignment assignment = x1;
                    if (assignment != null) {
                        AttributeReference attributeReference;
                        Expression attr = assignment.key();
                        Expression expr = assignment.value();
                        if (attr instanceof AttributeReference && BoxesRunTime.unboxToBoolean((Object)this.resolver$4.apply((Object)(attributeReference = (AttributeReference)attr).name(), (Object)this.field$2)) && MergeIntoHoodieTableCommand$.MODULE$.resolvesToSourceAttribute(this.sourceTable$1, expr)) {
                            return true;
                        }
                    }
                    return false;
                }
                {
                    this.resolver$4 = resolver$4;
                    this.field$2 = field$2;
                    this.sourceTable$1 = sourceTable$1;
                }
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new MergeIntoFieldResolutionException(new StringBuilder(50).append("Failed to resolve ").append(fieldType).append(" `").append((String)field).append("` w/in the source-table output").toString());
            }));
            return new Tuple2((Object)targetAttribute, (Object)sourceExpr);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public boolean resolvesToSourceAttribute(LogicalPlan sourceTable, Expression expr) {
        Expression attr;
        AttributeSet sourceTableOutputSet = sourceTable.outputSet();
        Expression expression = expr;
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            return sourceTableOutputSet.contains((NamedExpression)attributeReference);
        }
        Option<Tuple4<Expression, DataType, Option<String>, Object>> option = HoodieCatalystExpressionUtils$MatchCast$.MODULE$.unapply(expression);
        if (!option.isEmpty() && (attr = (Expression)((Tuple4)option.get())._1()) instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)attr;
            return sourceTableOutputSet.contains((NamedExpression)attributeReference);
        }
        return false;
    }

    public void validateDataTypes(Attribute attr, Expression expr, String columnType) {
        DataType dataType = attr.dataType();
        DataType dataType2 = expr.dataType();
        if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
            throw new MergeIntoFieldTypeMismatchException(new StringBuilder(118).append(columnType).append(" data type mismatch between source table and target table. ").append("Target table uses ").append(attr.dataType()).append(" for column '").append(attr.name()).append("', ").append("source table uses ").append(expr.dataType()).append(" for '").append(expr.sql()).append("'").toString());
        }
    }

    public boolean useGlobalIndex(Map<String, String> parameters) {
        return parameters.get((Object)HoodieIndexConfig.INDEX_TYPE.key()).exists((Function1 & Serializable & scala.Serializable)indexType -> BoxesRunTime.boxToBoolean((boolean)MergeIntoHoodieTableCommand$.MODULE$.isGlobalIndexEnabled(indexType, (Map<String, String>)parameters)));
    }

    public boolean isGlobalIndexEnabled(String indexType, Map<String, String> parameters) {
        return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndex.IndexType.GLOBAL_SIMPLE), HoodieIndexConfig.SIMPLE_INDEX_UPDATE_PARTITION_PATH_ENABLE), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndex.IndexType.GLOBAL_BLOOM), HoodieIndexConfig.BLOOM_INDEX_UPDATE_PARTITION_PATH_ENABLE), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndex.IndexType.RECORD_INDEX), HoodieIndexConfig.RECORD_INDEX_UPDATE_PARTITION_PATH_ENABLE), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndex.IndexType.HBASE), HoodieHBaseIndexConfig.UPDATE_PARTITION_PATH_ENABLE), (List)Nil$.MODULE$))))).collectFirst((PartialFunction)new scala.Serializable(indexType, parameters){
            public static final long serialVersionUID = 0L;
            private final String indexType$1;
            private final Map parameters$2;

            public final <A1 extends Tuple2<HoodieIndex.IndexType, ConfigProperty<? extends Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    HoodieIndex.IndexType hoodieIndex = (HoodieIndex.IndexType)((Object)A1._1());
                    ConfigProperty config = (ConfigProperty)A1._2();
                    String string = this.indexType$1;
                    String string2 = hoodieIndex.name();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return (B1)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString((String)this.parameters$2.getOrElse((Object)config.key(), (Function0 & Serializable & scala.Serializable)() -> config.defaultValue().toString()))).toBoolean());
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<HoodieIndex.IndexType, ConfigProperty<? extends Object>> x1) {
                Tuple2<HoodieIndex.IndexType, ConfigProperty<? extends Object>> tuple2 = x1;
                if (tuple2 != null) {
                    HoodieIndex.IndexType hoodieIndex = (HoodieIndex.IndexType)((Object)tuple2._1());
                    String string = this.indexType$1;
                    String string2 = hoodieIndex.name();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.indexType$1 = indexType$1;
                this.parameters$2 = parameters$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(org.apache.hudi.common.config.ConfigProperty )}, serializedLambda);
            }
        }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public boolean useCustomMergeMode(Map<String, String> parameters) {
        Option mergeModeOpt = parameters.get((Object)DataSourceWriteOptions$.MODULE$.RECORD_MERGE_MODE().key());
        if (mergeModeOpt.isEmpty()) {
            throw new HoodieException("Merge mode cannot be null here");
        }
        return ((String)mergeModeOpt.get()).equals(RecordMergeMode.CUSTOM.name());
    }

    public MergeIntoHoodieTableCommand apply(MergeIntoTable mergeInto) {
        return new MergeIntoHoodieTableCommand(mergeInto);
    }

    public Option<MergeIntoTable> unapply(MergeIntoHoodieTableCommand x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.mergeInto());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$validateTargetTableAttrExistsInAssignments$2(Function2 resolver$3, String field$1, Attribute attr) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$3.apply((Object)attr.name(), (Object)field$1));
    }

    public static final /* synthetic */ boolean $anonfun$validateTargetTableAttrExistsInAssignments$4(Function2 resolver$3, String field$1, Assignment x0$1) {
        AttributeReference attributeReference;
        Expression attr;
        Assignment assignment = x0$1;
        return assignment != null && (attr = assignment.key()) instanceof AttributeReference && BoxesRunTime.unboxToBoolean((Object)resolver$3.apply((Object)(attributeReference = (AttributeReference)attr).name(), (Object)field$1));
    }

    public static final /* synthetic */ void $anonfun$validateTargetTableAttrExistsInAssignments$1(LogicalPlan targetTable$1, Function2 resolver$3, String fieldType$1, Seq assignments$3, String field) {
        targetTable$1.output().find((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)MergeIntoHoodieTableCommand$.$anonfun$validateTargetTableAttrExistsInAssignments$2(resolver$3, field, attr))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new MergeIntoFieldResolutionException(new StringBuilder(37).append("Failed to resolve ").append(fieldType$1).append(" `").append(field).append("` in target table").toString());
        });
        if (!assignments$3.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MergeIntoHoodieTableCommand$.$anonfun$validateTargetTableAttrExistsInAssignments$4(resolver$3, field, x0$1)))) {
            throw new MergeIntoFieldResolutionException(new StringBuilder(49).append("No matching assignment found for target table ").append(fieldType$1).append(" `").append(field).append("`").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$resolveFieldAssociationsBetweenSourceAndTarget$2(Function2 resolver$4, String field$2, Attribute attr) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$4.apply((Object)attr.name(), (Object)field$2));
    }

    public static final /* synthetic */ boolean $anonfun$resolveFieldAssociationsBetweenSourceAndTarget$4(Function2 resolver$4, String field$2, Attribute attr) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$4.apply((Object)attr.name(), (Object)field$2));
    }

    private MergeIntoHoodieTableCommand$() {
        MODULE$ = this;
        this.userGuideString = new StringBuilder(145).append("To use the MERGE INTO statement on this MOR table, please specify `UPDATE SET *` as the update statement to update all columns, and set `").append(DataSourceWriteOptions$.MODULE$.ENABLE_MERGE_INTO_PARTIAL_UPDATES().key()).append("=false`.").toString();
    }
}

