/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.AutoRecordGenWrapperKeyGenerator;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u000f\u001f\u0001-B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006y\u0001!\t!\u0010\u0005\t\u0003\u0002A)\u0019!C\u0005\u0005\"Aq\n\u0001EC\u0002\u0013%\u0001\u000b\u0003\u0005U\u0001!\u0015\r\u0011\"\u0003V\u0011!1\u0006\u0001#b\u0001\n\u00139\u0006\"\u0002/\u0001\t\u0003j\u0006\"\u0002/\u0001\t\u0003\u001a\b\"\u0002/\u0001\t\u0003R\bbBA\r\u0001\u0011\u0005\u00131\u0004\u0005\b\u00033\u0001A\u0011IA\u0010\u0011\u001d\tI\u0002\u0001C!\u0003GAq!!\u000b\u0001\t\u0003\nY\u0003C\u0004\u0002>\u0001!\t%a\u000b\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!q\u00111\n\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002N\u0005msaBA1=!\u0005\u00111\r\u0004\u0007;yA\t!!\u001a\t\rq\u0012B\u0011AA:\u0011%\t)H\u0005b\u0001\n\u0003\t9\b\u0003\u0005\u0002zI\u0001\u000b\u0011BA)\u0011%\tYH\u0005b\u0001\n\u0003\t9\b\u0003\u0005\u0002~I\u0001\u000b\u0011BA)\u0011%\tyH\u0005b\u0001\n\u0013\t\t\t\u0003\u0005\u0002\u0018J\u0001\u000b\u0011BAB\u0011%\tIJ\u0005b\u0001\n\u0013\t\t\t\u0003\u0005\u0002\u001cJ\u0001\u000b\u0011BAB\u0011%\tiJEA\u0001\n\u0013\tyJA\bTc2\\U-_$f]\u0016\u0014\u0018\r^8s\u0015\ty\u0002%A\u0004d_6l\u0017M\u001c3\u000b\u0005\u0005\u0012\u0013\u0001\u00025vI&T!a\t\u0013\u0002\u0007M\fHN\u0003\u0002&M\u0005)1\u000f]1sW*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0017\u0011\u00055\nT\"\u0001\u0018\u000b\u0005=\u0002\u0014AB6fs\u001e,gN\u0003\u0002\"M%\u0011!G\f\u0002\u0014\u0005VLG\u000e^5o\u0017\u0016Lx)\u001a8fe\u0006$xN]\u0001\u0006aJ|\u0007o\u001d\t\u0003kij\u0011A\u000e\u0006\u0003oa\naaY8oM&<'BA\u001d1\u0003\u0019\u0019w.\\7p]&\u00111H\u000e\u0002\u0010)f\u0004X\r\u001a)s_B,'\u000f^5fg\u00061A(\u001b8jiz\"\"A\u0010!\u0011\u0005}\u0002Q\"\u0001\u0010\t\u000bM\u0012\u0001\u0019\u0001\u001b\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006,\u0012a\u0011\t\u0004\t\u001eKU\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\r=\u0003H/[8o!\tQU*D\u0001L\u0015\ta%%A\u0003usB,7/\u0003\u0002O\u0017\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002!\u0005,Ho\u001c*fG>\u0014HmS3z\u000f\u0016tW#A)\u0011\u0005\u0011\u0013\u0016BA*F\u0005\u001d\u0011un\u001c7fC:\fQbY8na2,\u0007pS3z\u000f\u0016tW#\u0001\u0017\u0002\u001d=\u0014\u0018nZ5oC2\\U-_$f]V\t\u0001\fE\u0002E\u000ff\u0003\"!\f.\n\u0005ms#AG*qCJ\\7*Z=HK:,'/\u0019;pe&sG/\u001a:gC\u000e,\u0017\u0001D4fiJ+7m\u001c:e\u0017\u0016LHC\u00010j!\tyfM\u0004\u0002aIB\u0011\u0011-R\u0007\u0002E*\u00111MK\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015,\u0015A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!Z#\t\u000b)<\u0001\u0019A6\u0002\rI,7m\u001c:e!\ta\u0017/D\u0001n\u0015\tqw.A\u0004hK:,'/[2\u000b\u0005A4\u0013\u0001B1we>L!A]7\u0003\u001b\u001d+g.\u001a:jGJ+7m\u001c:e)\tqF\u000fC\u0003v\u0011\u0001\u0007a/A\u0002s_^\u0004\"a\u001e=\u000e\u0003\tJ!!\u001f\u0012\u0003\u0007I{w\u000fF\u0003|\u0003\u000b\t)\u0002E\u0002}\u0003\u0003i\u0011! \u0006\u0003\u0019zT!a \u0013\u0002\rUt7/\u00194f\u0013\r\t\u0019! \u0002\u000b+R3\u0005h\u0015;sS:<\u0007bBA\u0004\u0013\u0001\u0007\u0011\u0011B\u0001\fS:$XM\u001d8bYJ{w\u000f\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\tyAI\u0001\tG\u0006$\u0018\r\\=ti&!\u00111CA\u0007\u0005-Ie\u000e^3s]\u0006d'k\\<\t\r\u0005]\u0011\u00021\u0001J\u0003\u0019\u00198\r[3nC\u0006\u0001r-\u001a;QCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b\u000b\u0004=\u0006u\u0001\"\u00026\u000b\u0001\u0004YGc\u00010\u0002\"!)Qo\u0003a\u0001mR)10!\n\u0002(!9\u0011q\u0001\u0007A\u0002\u0005%\u0001BBA\f\u0019\u0001\u0007\u0011*\u0001\fhKR\u0014VmY8sI.+\u0017PR5fY\u0012t\u0015-\\3t)\t\ti\u0003E\u0003\u00020\u0005eb,\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0012\u0001\u00026bm\u0006LA!a\u000f\u00022\t!A*[:u\u0003Y9W\r\u001e)beRLG/[8o!\u0006$\bNR5fY\u0012\u001c\u0018!H2p]Z,'\u000f\u001e)beRLG/[8o!\u0006$\b\u000eV8Tc2$\u0016\u0010]3\u0015\u000by\u000b\u0019%a\u0012\t\r\u0005\u0015s\u00021\u0001_\u00035\u0001\u0018M\u001d;ji&|g\u000eU1uQ\"1\u0011\u0011J\bA\u0002E\u000bqA]8x)f\u0004X-\u0001\u000ftkB,'\u000fJ4fiB\u000b'\u000f^5uS>t\u0007+\u0019;i\r&,G\u000eZ:\u0015\u0005\u0005=\u0003CBA\u0018\u0003s\t\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\u0011\t9&!\u000e\u0002\t1\fgnZ\u0005\u0004O\u0006U\u0013\u0002BA\u001f\u0003;J1!a\u0018/\u0005A\u0011\u0015m]3LKf<UM\\3sCR|'/A\bTc2\\U-_$f]\u0016\u0014\u0018\r^8s!\ty$cE\u0003\u0013\u0003O\ni\u0007E\u0002E\u0003SJ1!a\u001bF\u0005\u0019\te.\u001f*fMB\u0019A)a\u001c\n\u0007\u0005ETI\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002d\u0005\u0001\u0002+\u0011*U\u0013RKuJT0T\u0007\"+U*Q\u000b\u0003\u0003#\n\u0011\u0003U!S)&#\u0016j\u0014(`'\u000eCU)T!!\u0003iy%+S$J\u001d\u0006culS#Z\u000f\u0016sul\u0011'B'N{f*Q'F\u0003my%+S$J\u001d\u0006culS#Z\u000f\u0016sul\u0011'B'N{f*Q'FA\u0005\u0019B/[7fgR\fW\u000e\u001d+j[\u00164uN]7biV\u0011\u00111\u0011\t\u0005\u0003\u000b\u000b\u0019*\u0004\u0002\u0002\b*!\u0011\u0011RAF\u0003\u00191wN]7bi*!\u0011QRAH\u0003\u0011!\u0018.\\3\u000b\u0007\u0005E\u0005&\u0001\u0003k_\u0012\f\u0017\u0002BAK\u0003\u000f\u0013\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0003Q!\u0018.\\3ti\u0006l\u0007\u000fV5nK\u001a{'/\\1uA\u0005\u00112/\u001d7US6,7\u000f^1na\u001a{'/\\1u\u0003M\u0019\u0018\u000f\u001c+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;!\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0005\u0006\u0003BA*\u0003GKA!!*\u0002V\t1qJ\u00196fGR\u0004")
public class SqlKeyGenerator
extends BuiltinKeyGenerator {
    private Option<StructType> partitionSchema;
    private boolean autoRecordKeyGen;
    private BuiltinKeyGenerator complexKeyGen;
    private Option<SparkKeyGeneratorInterface> originalKeyGen;
    private final TypedProperties props;
    private volatile byte bitmap$0;

    public static String ORIGINAL_KEYGEN_CLASS_NAME() {
        return SqlKeyGenerator$.MODULE$.ORIGINAL_KEYGEN_CLASS_NAME();
    }

    public static String PARTITION_SCHEMA() {
        return SqlKeyGenerator$.MODULE$.PARTITION_SCHEMA();
    }

    private /* synthetic */ List super$getPartitionPathFields() {
        return super.getPartitionPathFields();
    }

    private Option<StructType> partitionSchema$lzycompute() {
        SqlKeyGenerator sqlKeyGenerator = this;
        synchronized (sqlKeyGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String partitionSchema = this.props.getString(SqlKeyGenerator$.MODULE$.PARTITION_SCHEMA(), "");
                this.partitionSchema = partitionSchema != null && new StringOps(Predef$.MODULE$.augmentString(partitionSchema)).nonEmpty() ? new Some((Object)StructType$.MODULE$.fromDDL(partitionSchema)) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.partitionSchema;
    }

    private Option<StructType> partitionSchema() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.partitionSchema$lzycompute();
        }
        return this.partitionSchema;
    }

    private boolean autoRecordKeyGen$lzycompute() {
        SqlKeyGenerator sqlKeyGenerator = this;
        synchronized (sqlKeyGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.autoRecordKeyGen = KeyGenUtils.isAutoGeneratedRecordKeysEnabled(this.props);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.autoRecordKeyGen;
    }

    private boolean autoRecordKeyGen() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.autoRecordKeyGen$lzycompute();
        }
        return this.autoRecordKeyGen;
    }

    private BuiltinKeyGenerator complexKeyGen$lzycompute() {
        SqlKeyGenerator sqlKeyGenerator = this;
        synchronized (sqlKeyGenerator) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.complexKeyGen = this.autoRecordKeyGen() ? new AutoRecordGenWrapperKeyGenerator(this.props, new ComplexKeyGenerator(this.props)) : new ComplexKeyGenerator(this.props);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.complexKeyGen;
    }

    private BuiltinKeyGenerator complexKeyGen() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.complexKeyGen$lzycompute();
        }
        return this.complexKeyGen;
    }

    private Option<SparkKeyGeneratorInterface> originalKeyGen$lzycompute() {
        SqlKeyGenerator sqlKeyGenerator = this;
        synchronized (sqlKeyGenerator) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.originalKeyGen = Option$.MODULE$.apply((Object)this.props.getString(SqlKeyGenerator$.MODULE$.ORIGINAL_KEYGEN_CLASS_NAME(), null)).map((Function1 & Serializable & scala.Serializable)originalKeyGenClassName -> {
                    ValidationUtils.checkArgument(new StringOps(Predef$.MODULE$.augmentString(originalKeyGenClassName)).nonEmpty());
                    String convertedKeyGenClassName = HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator(originalKeyGenClassName);
                    TypedProperties keyGenProps = TypedProperties.fromMap($this.props);
                    keyGenProps.remove(SqlKeyGenerator$.MODULE$.ORIGINAL_KEYGEN_CLASS_NAME());
                    keyGenProps.put(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), convertedKeyGenClassName);
                    SparkKeyGeneratorInterface keyGenerator = (SparkKeyGeneratorInterface)((Object)KeyGenUtils.createKeyGeneratorByClassName(keyGenProps));
                    if (this.autoRecordKeyGen()) {
                        return new AutoRecordGenWrapperKeyGenerator(keyGenProps, (BuiltinKeyGenerator)keyGenerator);
                    }
                    return keyGenerator;
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.originalKeyGen;
    }

    private Option<SparkKeyGeneratorInterface> originalKeyGen() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.originalKeyGen$lzycompute();
        }
        return this.originalKeyGen;
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return (String)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKey(record).getRecordKey()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getRecordKey(record));
    }

    @Override
    public String getRecordKey(Row row) {
        return (String)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getRecordKey(row)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getRecordKey(row));
    }

    @Override
    public UTF8String getRecordKey(InternalRow internalRow, StructType schema) {
        return (UTF8String)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getRecordKey(internalRow, schema)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getRecordKey(internalRow, schema));
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        String partitionPath = (String)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getKey(record).getPartitionPath()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getPartitionPath(record));
        return this.convertPartitionPathToSqlType(partitionPath, false);
    }

    @Override
    public String getPartitionPath(Row row) {
        String partitionPath = (String)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getPartitionPath(row)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getPartitionPath(row));
        return this.convertPartitionPathToSqlType(partitionPath, true);
    }

    @Override
    public UTF8String getPartitionPath(InternalRow internalRow, StructType schema) {
        UTF8String partitionPath = (UTF8String)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getPartitionPath(internalRow, schema)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getPartitionPath(internalRow, schema));
        return UTF8String.fromString((String)this.convertPartitionPathToSqlType(partitionPath.toString(), true));
    }

    @Override
    public List<String> getRecordKeyFieldNames() {
        return (List)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getRecordKeyFieldNames()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getRecordKeyFieldNames());
    }

    @Override
    public List<String> getPartitionPathFields() {
        return (List)this.originalKeyGen().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkKeyGeneratorInterface sparkKeyGeneratorInterface = x0$1;
            if (sparkKeyGeneratorInterface instanceof BaseKeyGenerator) {
                BaseKeyGenerator baseKeyGenerator = (BaseKeyGenerator)((Object)sparkKeyGeneratorInterface);
                return baseKeyGenerator.getPartitionPathFields();
            }
            return (List)Option$.MODULE$.apply((Object)this.super$getPartitionPathFields()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptyList());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.complexKeyGen().getPartitionPathFields());
    }

    private String convertPartitionPathToSqlType(String partitionPath, boolean rowType) {
        if (this.partitionSchema().isDefined()) {
            String[] partitionFragments = partitionPath.split("/");
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionFragments)).size() != ((SeqLike)this.partitionSchema().get()).size()) {
                return partitionPath;
            }
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionFragments)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])((StructType)this.partitionSchema().get()).fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String _partitionValue;
                    StructField partitionField;
                    String hiveStylePrefix;
                    String partitionValue = (String)tuple2._1();
                    boolean isHiveStyle = partitionValue.startsWith(hiveStylePrefix = new StringBuilder(1).append((partitionField = (StructField)tuple2._2()).name()).append("=").toString());
                    String string = _partitionValue = isHiveStyle ? partitionValue.substring(hiveStylePrefix.length()) : partitionValue;
                    String string2 = "__HIVE_DEFAULT_PARTITION__";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return partitionValue;
                    }
                    DataType dataType = partitionField.dataType();
                    if (TimestampType$.MODULE$.equals(dataType)) {
                        long timeMs = rowType ? SqlKeyGenerator$.MODULE$.org$apache$spark$sql$hudi$command$SqlKeyGenerator$$sqlTimestampFormat().parseMillis(_partitionValue) : (this.isConsistentLogicalTimestampEnabled() ? Timestamp.valueOf(_partitionValue).getTime() : TimeUnit.MILLISECONDS.convert(new StringOps(Predef$.MODULE$.augmentString(_partitionValue)).toLong(), TimeUnit.MICROSECONDS));
                        String timestampFormat = PartitionPathEncodeUtils.escapePathName(SqlKeyGenerator$.MODULE$.org$apache$spark$sql$hudi$command$SqlKeyGenerator$$timestampTimeFormat().print(timeMs));
                        if (isHiveStyle) {
                            return new StringBuilder(0).append(hiveStylePrefix).append(timestampFormat).toString();
                        }
                        return timestampFormat;
                    }
                    return partitionValue;
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("/");
        }
        return partitionPath;
    }

    public SqlKeyGenerator(TypedProperties props) {
        this.props = props;
        super(props);
    }
}

