/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.function.Supplier;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.ExportInstantsProcedure$;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\tUa\u0001\u0002\r\u001a\u0001!BQA\u000e\u0001\u0005\u0002]B\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001\u001e\t\u0013y\u0002\u0001\u0019!a\u0001\n\u0003y\u0004\"\u0003%\u0001\u0001\u0004\u0005\t\u0015)\u0003<\u0011\u001dI\u0005A1A\u0005\u0002)Caa\u0015\u0001!\u0002\u0013Y\u0005b\u0002+\u0001\u0005\u0004%I!\u0016\u0005\u00073\u0002\u0001\u000b\u0011\u0002,\t\u000fi\u0003!\u0019!C\u00057\"1!\r\u0001Q\u0001\nqCQa\u0019\u0001\u0005\u0002UCQ\u0001\u001a\u0001\u0005\u0002mCQ!\u001a\u0001\u0005B\u0019DQ\u0001 \u0001\u0005\nuDq!!\"\u0001\t\u0013\t9\tC\u0004\u0002B\u0002!I!a1\t\u000f\u0005=\b\u0001\"\u0011\u0002r\u001e9\u00111_\r\t\u0002\u0005UhA\u0002\r\u001a\u0011\u0003\t9\u0010\u0003\u00047'\u0011\u0005\u0011q \u0005\t\u0005\u0003\u0019\"\u0019!C\u0001\u0015\"9!1A\n!\u0002\u0013Y\u0005b\u0002B\u0003'\u0011\u0005!q\u0001\u0002\u0018\u000bb\u0004xN\u001d;J]N$\u0018M\u001c;t!J|7-\u001a3ve\u0016T!AG\u000e\u0002\u0015A\u0014xnY3ekJ,7O\u0003\u0002\u001d;\u000591m\\7nC:$'B\u0001\u0010 \u0003\u0011AW\u000fZ5\u000b\u0005\u0001\n\u0013aA:rY*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001IS\u0006\r\t\u0003U-j\u0011!G\u0005\u0003Ye\u0011QBQ1tKB\u0013xnY3ekJ,\u0007C\u0001\u0016/\u0013\ty\u0013D\u0001\tQe>\u001cW\rZ;sK\n+\u0018\u000e\u001c3feB\u0011\u0011\u0007N\u0007\u0002e)\u00111'I\u0001\tS:$XM\u001d8bY&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001\b\u0005\u0002+\u0001\u0005!2o\u001c:u\u0005f4\u0015.\u001a7e!\u0006\u0014\u0018-\\3uKJ,\u0012a\u000f\t\u0003UqJ!!P\r\u0003%A\u0013xnY3ekJ,\u0007+\u0019:b[\u0016$XM]\u0001\u0019g>\u0014HOQ=GS\u0016dG\rU1sC6,G/\u001a:`I\u0015\fHC\u0001!G!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0011)f.\u001b;\t\u000f\u001d\u001b\u0011\u0011!a\u0001w\u0005\u0019\u0001\u0010J\u0019\u0002+M|'\u000f\u001e\"z\r&,G\u000e\u001a)be\u0006lW\r^3sA\u0005qA-\u001a4bk2$\u0018i\u0019;j_:\u001cX#A&\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015\u0001\u00027b]\u001eT\u0011\u0001U\u0001\u0005U\u00064\u0018-\u0003\u0002S\u001b\n11\u000b\u001e:j]\u001e\fq\u0002Z3gCVdG/Q2uS>t7\u000fI\u0001\u000b!\u0006\u0013\u0016)T#U\u000bJ\u001bV#\u0001,\u0011\u0007\u0005;6(\u0003\u0002Y\u0005\n)\u0011I\u001d:bs\u0006Y\u0001+\u0011*B\u001b\u0016#VIU*!\u0003-yU\u000b\u0016)V)~#\u0016\fU#\u0016\u0003q\u0003\"!\u00181\u000e\u0003yS!aX\u0010\u0002\u000bQL\b/Z:\n\u0005\u0005t&AC*ueV\u001cG\u000fV=qK\u0006aq*\u0016+Q+R{F+\u0017)FA\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0002\u0015=,H\u000f];u)f\u0004X-\u0001\u0003dC2dGCA4x!\rA\u0007o\u001d\b\u0003S:t!A[7\u000e\u0003-T!\u0001\\\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0015BA8C\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001d:\u0003\u0007M+\u0017O\u0003\u0002p\u0005B\u0011A/^\u0007\u0002?%\u0011ao\b\u0002\u0004%><\b\"\u0002=\u000e\u0001\u0004I\u0018\u0001B1sON\u0004\"A\u000b>\n\u0005mL\"!\u0004)s_\u000e,G-\u001e:f\u0003J<7/\u0001\u000bd_BL\u0018I]2iSZ,G-\u00138ti\u0006tGo\u001d\u000b\f}\u0006\r\u0011QCA\u001b\u0003\u007f\t\u0019\u0005\u0005\u0002B\u007f&\u0019\u0011\u0011\u0001\"\u0003\u0007%sG\u000fC\u0004\u0002\u00069\u0001\r!a\u0002\u0002\u0011\t\f7/\u001a)bi\"\u0004B!!\u0003\u0002\u00129!\u00111BA\u0007!\tQ')C\u0002\u0002\u0010\t\u000ba\u0001\u0015:fI\u00164\u0017b\u0001*\u0002\u0014)\u0019\u0011q\u0002\"\t\u000f\u0005]a\u00021\u0001\u0002\u001a\u0005A1\u000f^1ukN,7\u000f\u0005\u0004\u0002\u001c\u0005\u0005\u0012QE\u0007\u0003\u0003;Q1!a\bP\u0003\u0011)H/\u001b7\n\t\u0005\r\u0012Q\u0004\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\u0005\u0019\u001c(bAA\u0018G\u00051\u0001.\u00193p_BLA!a\r\u0002*\tQa)\u001b7f'R\fG/^:\t\u000f\u0005]b\u00021\u0001\u0002:\u0005I\u0011m\u0019;j_:\u001cV\r\u001e\t\u0007\u00037\tY$a\u0002\n\t\u0005u\u0012Q\u0004\u0002\u0004'\u0016$\bBBA!\u001d\u0001\u0007a0A\u0003mS6LG\u000fC\u0004\u0002F9\u0001\r!a\u0002\u0002\u00171|7-\u00197G_2$WM\u001d\u0015\u0006\u001d\u0005%\u0013Q\u000b\t\u0006\u0003\u0006-\u0013qJ\u0005\u0004\u0003\u001b\u0012%A\u0002;ie><8\u000fE\u0002i\u0003#J1!a\u0015s\u0005%)\u0005pY3qi&|g.M\u0004\u001f\u0003\u000f\t9&a!2\u0013\r\nI&!\u0019\u0002z\u0005\rT\u0003BA.\u0003;*\"!a\u0002\u0005\u000f\u0005}sE1\u0001\u0002j\t\tA+\u0003\u0003\u0002d\u0005\u0015\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002h\t\u000ba\u0001\u001e5s_^\u001c\u0018\u0003BA6\u0003c\u00022!QA7\u0013\r\tyG\u0011\u0002\b\u001d>$\b.\u001b8h!\u0011\t\u0019(!\u001e\u000f\u0005\u0005s\u0017bAA<e\nIA\u000b\u001b:po\u0006\u0014G.Z\u0019\nG\u0005m\u0014QPA@\u0003Or1!QA?\u0013\r\t9GQ\u0019\u0006E\u0005\u0013\u0015\u0011\u0011\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005=\u0013aF2paftuN\\!sG\"Lg/\u001a3J]N$\u0018M\u001c;t)%q\u0018\u0011RAP\u0003c\u000b\u0019\fC\u0004\u0002\f>\u0001\r!!$\u0002\u00155,G/Y\"mS\u0016tG\u000f\u0005\u0003\u0002\u0010\u0006mUBAAI\u0015\u0011\t\u0019*!&\u0002\u000bQ\f'\r\\3\u000b\t\u0005]\u0015\u0011T\u0001\u0007G>lWn\u001c8\u000b\u0005y\u0019\u0013\u0002BAO\u0003#\u0013Q\u0003S8pI&,G+\u00192mK6+G/Y\"mS\u0016tG\u000fC\u0004\u0002\">\u0001\r!a)\u0002\u0011%t7\u000f^1oiN\u0004b!a\u0007\u0002\"\u0005\u0015\u0006\u0003BAT\u0003[k!!!+\u000b\t\u0005-\u0016\u0011S\u0001\ti&lW\r\\5oK&!\u0011qVAU\u00055Aun\u001c3jK&s7\u000f^1oi\"1\u0011\u0011I\bA\u0002yDq!!\u0012\u0010\u0001\u0004\t9\u0001K\u0003\u0010\u0003\u0013\n9,M\u0004\u001f\u0003\u000f\tI,a02\u0013\r\nI&!\u0019\u0002<\u0006\r\u0014'C\u0012\u0002|\u0005u\u0014QXA4c\u0015\u0011\u0013IQAAc\r1\u0013qJ\u0001\foJLG/\u001a+p\r&dW\rF\u0004A\u0003\u000b\f\u0019.a6\t\u000f\u0005\u001d\u0007\u00031\u0001\u0002J\u000691\u000f^8sC\u001e,\u0007\u0003BAf\u0003\u001fl!!!4\u000b\t\u0005\u001d\u0017\u0011T\u0005\u0005\u0003#\fiMA\u0007I_>$\u0017.Z*u_J\fw-\u001a\u0005\b\u0003+\u0004\u0002\u0019AA\u0004\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005e\u0007\u00031\u0001\u0002\\\u0006!A-\u0019;b!\u0011\tu+!8\u0011\u0007\u0005\u000by.C\u0002\u0002b\n\u0013AAQ=uK\"*\u0001#!\u0013\u0002fF:a$a\u0002\u0002h\u00065\u0018'C\u0012\u0002Z\u0005\u0005\u0014\u0011^A2c%\u0019\u00131PA?\u0003W\f9'M\u0003#\u0003\n\u000b\t)M\u0002'\u0003\u001f\nQAY;jY\u0012,\u0012\u0001O\u0001\u0018\u000bb\u0004xN\u001d;J]N$\u0018M\u001c;t!J|7-\u001a3ve\u0016\u0004\"AK\n\u0014\u0007M\tI\u0010E\u0002B\u0003wL1!!@C\u0005\u0019\te.\u001f*fMR\u0011\u0011Q_\u0001\u0005\u001d\u0006kU)A\u0003O\u00036+\u0005%A\u0004ck&dG-\u001a:\u0016\u0005\t%\u0001#\u0002B\u0006\u0005#iSB\u0001B\u0007\u0015\u0011\u0011y!!\b\u0002\u0011\u0019,hn\u0019;j_:LAAa\u0005\u0003\u000e\tA1+\u001e9qY&,'\u000f")
public class ExportInstantsProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private ProcedureParameter sortByFieldParameter;
    private final String defaultActions;
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return ExportInstantsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ExportInstantsProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ProcedureParameter sortByFieldParameter() {
        return this.sortByFieldParameter;
    }

    public void sortByFieldParameter_$eq(ProcedureParameter x$1) {
        this.sortByFieldParameter = x$1;
    }

    public String defaultActions() {
        return this.defaultActions;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        String table = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[0]).get();
        String localFolder = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[2]).get());
        String actions = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[3]).get();
        boolean desc = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[4]).get());
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        Path archivePath = new Path(new StringBuilder(27).append(basePath).append("/.hoodie/.commits_.archive*").toString());
        java.util.Set actionSet = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])actions.split(",")))).asJava();
        int numExports = limit == -1 ? Integer.MAX_VALUE : limit;
        int numCopied = 0;
        if (!new File(localFolder).isDirectory()) {
            throw new HoodieException(new StringBuilder(31).append(localFolder).append(" is not a valid local directory").toString());
        }
        java.util.List nonArchivedInstants = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metaClient.getActiveTimeline().filterCompletedInstants().getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)actionSet.contains(i.getAction()))).toList()).asJava();
        FileStatus[] statuses = HadoopFSUtils.getFs(basePath, this.jsc().hadoopConfiguration()).globStatus(archivePath);
        java.util.List archivedStatuses = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])statuses)).sortWith((Function2 & Serializable & scala.Serializable)(f1, f2) -> BoxesRunTime.boxToBoolean((boolean)ExportInstantsProcedure.$anonfun$call$2(f1, f2)))).asJava();
        if (desc) {
            Collections.reverse(nonArchivedInstants);
            numCopied = this.copyNonArchivedInstants(metaClient, nonArchivedInstants, numExports, localFolder);
            if (numCopied < numExports) {
                Collections.reverse(archivedStatuses);
                numCopied += this.copyArchivedInstants(basePath, archivedStatuses, actionSet, numExports - numCopied, localFolder);
            }
        } else {
            numCopied = this.copyArchivedInstants(basePath, archivedStatuses, actionSet, numExports, localFolder);
            if (numCopied < numExports) {
                numCopied += this.copyNonArchivedInstants(metaClient, nonArchivedInstants, numExports - numCopied, localFolder);
            }
        }
        return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(22).append("Exported ").append(numCopied).append(" Instants to ").append(localFolder).toString()})), (List)Nil$.MODULE$);
    }

    private int copyArchivedInstants(String basePath, java.util.List<FileStatus> statuses, java.util.Set<String> actionSet, int limit, String localFolder) throws Exception {
        IntRef copyCount = IntRef.create((int)0);
        HoodieStorage storage = HoodieStorageUtils.getStorage(basePath, HadoopFSUtils.getStorageConf(this.jsc().hadoopConfiguration()));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(statuses).asScala()).foreach((Function1 & Serializable & scala.Serializable)fs -> {
            ExportInstantsProcedure.$anonfun$copyArchivedInstants$1(this, storage, copyCount, limit, actionSet, localFolder, fs);
            return BoxedUnit.UNIT;
        });
        return copyCount.elem;
    }

    private int copyNonArchivedInstants(HoodieTableMetaClient metaClient, java.util.List<HoodieInstant> instants, int limit, String localFolder) throws Exception {
        IntRef copyCount;
        block0: {
            copyCount = IntRef.create((int)0);
            if (instants.isEmpty()) break block0;
            HoodieActiveTimeline timeline = metaClient.getActiveTimeline();
            HoodieStorage storage = HoodieStorageUtils.getStorage(metaClient.getBasePath(), HadoopFSUtils.getStorageConf(this.jsc().hadoopConfiguration()));
            InstantFileNameGenerator instantFileNameGenerator = metaClient.getTimelineLayout().getInstantFileNameGenerator();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(instants).asScala()).foreach((Function1 & Serializable & scala.Serializable)instant -> {
                ExportInstantsProcedure.$anonfun$copyNonArchivedInstants$1(this, localFolder, instantFileNameGenerator, timeline, storage, copyCount, instant);
                return BoxedUnit.UNIT;
            });
        }
        return copyCount.elem;
    }

    private void writeToFile(HoodieStorage storage, String path, byte[] data) throws Exception {
        OutputStream out = storage.create(new StoragePath(path));
        out.write(data);
        out.flush();
        out.close();
    }

    @Override
    public ExportInstantsProcedure build() {
        return new ExportInstantsProcedure();
    }

    public static final /* synthetic */ boolean $anonfun$call$2(FileStatus f1, FileStatus f2) {
        return (int)(f1.getModificationTime() - f2.getModificationTime()) > 0;
    }

    public static final /* synthetic */ void $anonfun$copyArchivedInstants$1(ExportInstantsProcedure $this, HoodieStorage storage$1, IntRef copyCount$1, int limit$1, java.util.Set actionSet$2, String localFolder$1, FileStatus fs) {
        HoodieLogFormat.Reader reader = HoodieLogFormat.newReader(storage$1, new HoodieLogFile(HadoopFSUtils.convertToStoragePath(fs.getPath())), HoodieArchivedMetaEntry.getClassSchema());
        while (reader.hasNext() && copyCount$1.elem < limit$1) {
            HoodieAvroDataBlock blk = (HoodieAvroDataBlock)reader.next();
            ClosableIterator recordItr = blk.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
            try {
                while (recordItr.hasNext()) {
                    SpecificRecordBase specificRecordBase;
                    HoodieRecord ir = (HoodieRecord)recordItr.next();
                    HoodieArchivedMetaEntry archiveEntryRecord = (HoodieArchivedMetaEntry)((Object)SpecificData.get().deepCopy(HoodieArchivedMetaEntry.SCHEMA$, (Object)ir));
                    String action = archiveEntryRecord.get("actionType").toString();
                    if (!actionSet$2.contains(action)) {
                        throw Breaks$.MODULE$.break();
                    }
                    String string = action;
                    if ("clean".equals(string)) {
                        specificRecordBase = archiveEntryRecord.getHoodieCleanMetadata();
                    } else if ("commit".equals(string)) {
                        specificRecordBase = archiveEntryRecord.getHoodieCommitMetadata();
                    } else if ("deltacommit".equals(string)) {
                        specificRecordBase = archiveEntryRecord.getHoodieCommitMetadata();
                    } else if ("rollback".equals(string)) {
                        specificRecordBase = archiveEntryRecord.getHoodieRollbackMetadata();
                    } else if ("savepoint".equals(string)) {
                        specificRecordBase = archiveEntryRecord.getHoodieSavePointMetadata();
                    } else if ("compaction".equals(string)) {
                        specificRecordBase = archiveEntryRecord.getHoodieCompactionMetadata();
                    } else {
                        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Unknown type of action ").append(action).toString());
                        specificRecordBase = null;
                    }
                    HoodieCleanMetadata metadata = specificRecordBase;
                    String instantTime = archiveEntryRecord.get("commitTime").toString();
                    String outPath = new StringBuilder(2).append(localFolder$1).append("/").append(instantTime).append(".").append(action).toString();
                    if (metadata != null) {
                        $this.writeToFile(storage$1, outPath, HoodieAvroUtils.avroToJson((GenericRecord)metadata, true));
                    }
                    ++copyCount$1.elem;
                    if (copyCount$1.elem != limit$1) continue;
                    throw Breaks$.MODULE$.break();
                }
            }
            finally {
                if (recordItr == null) continue;
                recordItr.close();
            }
        }
        reader.close();
    }

    public static final /* synthetic */ void $anonfun$copyNonArchivedInstants$1(ExportInstantsProcedure $this, String localFolder$2, InstantFileNameGenerator instantFileNameGenerator$1, HoodieActiveTimeline timeline$1, HoodieStorage storage$2, IntRef copyCount$2, HoodieInstant instant) {
        byte[] data;
        byte[] byArray;
        String localPath = new StringBuilder(1).append(localFolder$2).append("/").append(instantFileNameGenerator$1.getFileName(instant)).toString();
        String string = instant.getAction();
        if ("clean".equals(string)) {
            HoodieCleanMetadata metadata = timeline$1.readCleanMetadata(instant);
            byArray = HoodieAvroUtils.avroToJson((GenericRecord)metadata, true);
        } else if ("deltacommit".equals(string)) {
            byArray = timeline$1.getInstantDetails(instant).get();
        } else if ("commit".equals(string)) {
            byArray = timeline$1.getInstantDetails(instant).get();
        } else if ("compaction".equals(string)) {
            byArray = timeline$1.getInstantDetails(instant).get();
        } else if ("rollback".equals(string)) {
            HoodieRollbackMetadata metadata = timeline$1.readRollbackMetadata(instant);
            byArray = HoodieAvroUtils.avroToJson((GenericRecord)metadata, true);
        } else if ("savepoint".equals(string)) {
            HoodieSavepointMetadata metadata = timeline$1.readSavepointMetadata(instant);
            byArray = HoodieAvroUtils.avroToJson((GenericRecord)metadata, true);
        } else {
            byArray = data = null;
        }
        if (data != null) {
            $this.writeToFile(storage$2, localPath, data);
            ++copyCount$2.elem;
            return;
        }
    }

    public ExportInstantsProcedure() {
        Logging.$init$((Logging)this);
        this.defaultActions = "clean,commit,deltacommit,rollback,savepoint,restore";
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.required(1, "local_folder", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(2, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)-1)), ProcedureParameter$.MODULE$.optional(3, "actions", DataTypes.StringType, this.defaultActions()), ProcedureParameter$.MODULE$.optional(4, "desc", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("export_detail", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

