/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDatasetBulkInsertHelper;
import org.apache.hudi.HoodieSparkSqlWriter;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieInternalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertInternalPartitionerWithRowsFactory;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.execution.bulkinsert.NonSortPartitionerWithRows;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.sync.common.AbstractSyncTool;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class HoodieSparkSqlWriter$ {
    public static HoodieSparkSqlWriter$ MODULE$;
    private final Logger log;
    private boolean tableExists;
    private boolean asyncCompactionTriggerFnDefined;
    private boolean asyncClusteringTriggerFnDefined;

    static {
        new HoodieSparkSqlWriter$();
    }

    private Logger log() {
        return this.log;
    }

    private boolean tableExists() {
        return this.tableExists;
    }

    private void tableExists_$eq(boolean x$1) {
        this.tableExists = x$1;
    }

    private boolean asyncCompactionTriggerFnDefined() {
        return this.asyncCompactionTriggerFnDefined;
    }

    private void asyncCompactionTriggerFnDefined_$eq(boolean x$1) {
        this.asyncCompactionTriggerFnDefined = x$1;
    }

    private boolean asyncClusteringTriggerFnDefined() {
        return this.asyncClusteringTriggerFnDefined;
    }

    private void asyncClusteringTriggerFnDefined_$eq(boolean x$1) {
        this.asyncClusteringTriggerFnDefined = x$1;
    }

    public Tuple6<Object, Option<String>, Option<String>, Option<String>, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, HoodieTableConfig> write(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> optParams, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> hoodieWriteClient, scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> asyncCompactionTriggerFn, scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> asyncClusteringTriggerFn) {
        Tuple6 tuple6;
        block23: {
            SparkRDDWriteClient writeClient;
            HoodieWriteResult writeResult;
            String commitActionType;
            String instantTime;
            JavaSparkContext jsc;
            WriteOperationType operation;
            scala.collection.immutable.Map parameters;
            HoodieTableConfig tableConfig;
            Path basePath;
            block28: {
                Tuple2 tuple2;
                block27: {
                    Tuple2 tuple22;
                    Boolean dropPartitionColumns;
                    String partitionColumns;
                    KeyGenerator keyGenerator;
                    String tblName;
                    HoodieConfig hoodieConfig;
                    FileSystem fs;
                    SparkContext sparkContext;
                    String path;
                    block24: {
                        Option commitTime;
                        boolean success;
                        block26: {
                            Tuple2<Object, Option<String>> tuple23;
                            block25: {
                                HoodieTableType tableType;
                                block22: {
                                    Some some;
                                    String ser;
                                    Predef$.MODULE$.assert(optParams.get((Object)"path").exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$write$1(x$1))), (Function0 & Serializable & scala.Serializable)() -> "'path' must be set");
                                    path = (String)optParams.apply((Object)"path");
                                    basePath = new Path(path);
                                    sparkContext = sqlContext.sparkContext();
                                    fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
                                    this.tableExists_$eq(fs.exists(new Path(basePath, ".hoodie")));
                                    tableConfig = this.getHoodieTableConfig(sparkContext, path, hoodieTableConfigOpt);
                                    HoodieWriterUtils$.MODULE$.validateTableConfig(sqlContext.sparkSession(), optParams, (HoodieConfig)tableConfig);
                                    Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> tuple24 = this.mergeParamsAndGetHoodieConfig(optParams, tableConfig);
                                    if (tuple24 == null) {
                                        throw new MatchError(tuple24);
                                    }
                                    scala.collection.immutable.Map parameters2 = (scala.collection.immutable.Map)tuple24._1();
                                    HoodieConfig hoodieConfig2 = (HoodieConfig)tuple24._2();
                                    Tuple2 tuple25 = new Tuple2((Object)parameters2, (Object)hoodieConfig2);
                                    Tuple2 tuple26 = tuple25;
                                    parameters = (scala.collection.immutable.Map)tuple26._1();
                                    hoodieConfig = (HoodieConfig)tuple26._2();
                                    tblName = hoodieConfig.getStringOrThrow(HoodieWriteConfig.TBL_NAME, new StringBuilder(15).append("'").append(HoodieWriteConfig.TBL_NAME.key()).append("' must be set.").toString()).trim();
                                    Predef$.MODULE$.assert(!StringUtils.isNullOrEmpty((String)hoodieConfig.getString(HoodieWriteConfig.TBL_NAME)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("'").append(HoodieWriteConfig.TBL_NAME.key()).append("' must be set.").toString());
                                    this.asyncCompactionTriggerFnDefined_$eq(asyncCompactionTriggerFn.isDefined());
                                    this.asyncClusteringTriggerFnDefined_$eq(asyncClusteringTriggerFn.isDefined());
                                    scala.Option option = sparkContext.getConf().getOption("spark.serializer");
                                    if (!(option instanceof Some) || !(ser = (String)(some = (Some)option).value()).equals("org.apache.spark.serializer.KryoSerializer")) {
                                        throw new HoodieException("hoodie only support org.apache.spark.serializer.KryoSerializer as spark.serializer");
                                    }
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    tableType = HoodieTableType.valueOf((String)hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.TABLE_TYPE()));
                                    operation = WriteOperationType.fromValue((String)hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.OPERATION()));
                                    if (Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS()))) {
                                        WriteOperationType writeOperationType = operation;
                                        WriteOperationType writeOperationType2 = WriteOperationType.UPSERT;
                                        if (!(writeOperationType != null ? !writeOperationType.equals(writeOperationType2) : writeOperationType2 != null)) {
                                            this.log().warn((Object)new StringBuilder(66).append(DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).append(" is not applicable ").append("when ").append(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS()).append(" is set to be true, ").append("overriding the ").append(DataSourceWriteOptions$.MODULE$.OPERATION()).append(" to be ").append(DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).toString());
                                            operation = WriteOperationType.INSERT;
                                        }
                                    }
                                    jsc = new JavaSparkContext(sparkContext);
                                    instantTime = HoodieActiveTimeline.createNewInstantTime();
                                    keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)new TypedProperties((Properties)hoodieConfig.getProps()));
                                    SaveMode saveMode = mode;
                                    SaveMode saveMode2 = SaveMode.Ignore;
                                    if ((saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) || !this.tableExists()) break block22;
                                    this.log().warn((Object)new StringBuilder(73).append("hoodie table at ").append(basePath).append(" already exists. Ignoring & not performing actual writes.").toString());
                                    tuple6 = new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Option.empty(), (Object)Option.empty(), (Object)Option.empty(), hoodieWriteClient.orNull(Predef$.MODULE$.$conforms()), (Object)tableConfig);
                                    break block23;
                                }
                                this.handleSaveModes(sqlContext.sparkSession(), mode, basePath, tableConfig, tblName, operation, fs);
                                partitionColumns = HoodieSparkUtils$.MODULE$.getPartitionColumns(keyGenerator, this.toProperties((scala.collection.immutable.Map<String, String>)parameters));
                                if (!this.tableExists()) {
                                    String baseFileFormat = hoodieConfig.getStringOrDefault(HoodieTableConfig.BASE_FILE_FORMAT);
                                    String archiveLogFolder = hoodieConfig.getStringOrDefault(HoodieTableConfig.ARCHIVELOG_FOLDER);
                                    String recordKeyFields = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD());
                                    boolean populateMetaFields = hoodieConfig.getBooleanOrDefault(HoodieTableConfig.POPULATE_META_FIELDS);
                                    HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.withPropertyBuilder().setTableType(tableType).setTableName(tblName).setRecordKeyFields(recordKeyFields).setBaseFileFormat(baseFileFormat).setArchiveLogFolder(archiveLogFolder).setPayloadClassName(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME())).setPreCombineField(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD(), null)).setPartitionFields(partitionColumns).setPopulateMetaFields(populateMetaFields).setRecordKeyFields(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD())).setKeyGeneratorClassProp(HoodieWriterUtils$.MODULE$.getOriginKeyGenerator((scala.collection.immutable.Map<String, String>)parameters)).setHiveStylePartitioningEnable(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING())).setUrlEncodePartitioning(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING())).initTable(sparkContext.hadoopConfiguration(), path);
                                    tableConfig = tableMetaClient.getTableConfig();
                                }
                                commitActionType = CommitUtils.getCommitActionType((WriteOperationType)operation, (HoodieTableType)tableConfig.getTableType());
                                dropPartitionColumns = hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS());
                                if (!Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER()))) break block24;
                                WriteOperationType writeOperationType = operation;
                                WriteOperationType writeOperationType3 = WriteOperationType.BULK_INSERT;
                                if (writeOperationType != null ? !writeOperationType.equals(writeOperationType3) : writeOperationType3 != null) break block24;
                                tuple23 = this.bulkInsertAsRow(sqlContext, (scala.collection.immutable.Map<String, String>)parameters, df, tblName, basePath, path, instantTime, partitionColumns);
                                if (tuple23 == null) break block25;
                                success = tuple23._1$mcZ$sp();
                                commitTime = (Option)tuple23._2();
                                if (commitTime != null) break block26;
                            }
                            throw new MatchError(tuple23);
                        }
                        Option option = commitTime;
                        Tuple2 tuple27 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)success), (Object)option);
                        Tuple2 tuple28 = tuple27;
                        boolean success2 = tuple28._1$mcZ$sp();
                        Option commitTime2 = (Option)tuple28._2();
                        return new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)success2), (Object)commitTime2, (Object)Option.empty(), (Object)Option.empty(), hoodieWriteClient.orNull(Predef$.MODULE$.$conforms()), (Object)tableConfig);
                    }
                    boolean reconcileSchema = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key()))).toBoolean();
                    WriteOperationType writeOperationType = operation;
                    if (WriteOperationType.DELETE.equals(writeOperationType)) {
                        RDD<GenericRecord> genericRecords = this.registerKryoClassesAndGetGenericRecords(tblName, sparkContext, df, reconcileSchema);
                        JavaRDD hoodieKeysToDelete = genericRecords.map((Function1 & Serializable & scala.Serializable)gr -> keyGenerator.getKey(gr), ClassTag$.MODULE$.apply(HoodieKey.class)).toJavaRDD();
                        if (!this.tableExists()) {
                            throw new HoodieException(new StringBuilder(31).append("hoodie table at ").append(basePath).append(" does not exist").toString());
                        }
                        SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataSourceUtils.createHoodieClient((JavaSparkContext)jsc, null, (String)path, (String)tblName, (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap(parameters.$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key()))));
                        Object object = this.isAsyncCompactionEnabled((SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>)client, tableConfig, (scala.collection.immutable.Map<String, String>)parameters, jsc.hadoopConfiguration()) ? ((Function1)asyncCompactionTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                        Object object2 = this.isAsyncClusteringEnabled((SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>)client, (scala.collection.immutable.Map<String, String>)parameters) ? ((Function1)asyncClusteringTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                        client.startCommitWithTime(instantTime, commitActionType);
                        HoodieWriteResult writeStatuses = DataSourceUtils.doDeleteOperation((SparkRDDWriteClient)client, (JavaRDD)hoodieKeysToDelete, (String)instantTime);
                        tuple22 = new Tuple2((Object)writeStatuses, (Object)client);
                    } else if (WriteOperationType.DELETE_PARTITION.equals(writeOperationType)) {
                        List<Object> list;
                        RDD<GenericRecord> genericRecords = this.registerKryoClassesAndGetGenericRecords(tblName, sparkContext, df, reconcileSchema);
                        if (!this.tableExists()) {
                            throw new HoodieException(new StringBuilder(31).append("hoodie table at ").append(basePath).append(" does not exist").toString());
                        }
                        if (JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)parameters).containsKey(DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key())) {
                            String[] partitionColsToDelete = ((String)parameters.get((Object)DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key()).get()).split(",");
                            list = Arrays.asList((Object[])partitionColsToDelete);
                        } else {
                            list = genericRecords.map((Function1 & Serializable & scala.Serializable)gr -> keyGenerator.getKey(gr).getPartitionPath(), ClassTag$.MODULE$.apply(String.class)).toJavaRDD().distinct().collect();
                        }
                        List<Object> partitionsToDelete = list;
                        SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataSourceUtils.createHoodieClient((JavaSparkContext)jsc, null, (String)path, (String)tblName, (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap(parameters.$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key()))));
                        client.startCommitWithTime(instantTime, commitActionType);
                        HoodieWriteResult writeStatuses = DataSourceUtils.doDeletePartitionsOperation((SparkRDDWriteClient)client, partitionsToDelete, (String)instantTime);
                        tuple22 = new Tuple2((Object)writeStatuses, (Object)client);
                    } else {
                        Tuple2 tuple29 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tblName);
                        if (tuple29 == null) {
                            throw new MatchError((Object)tuple29);
                        }
                        String structName = (String)tuple29._1();
                        String nameSpace = (String)tuple29._2();
                        Tuple2 tuple210 = new Tuple2((Object)structName, (Object)nameSpace);
                        Tuple2 tuple211 = tuple210;
                        String structName2 = (String)tuple211._1();
                        String nameSpace2 = (String)tuple211._2();
                        sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
                        Schema schema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(df.schema(), structName2, nameSpace2);
                        if (reconcileSchema) {
                            schema = this.getLatestTableSchema(fs, basePath, sparkContext, schema);
                        }
                        sparkContext.getConf().registerAvroSchemas((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{schema}));
                        this.log().info((Object)new StringBuilder(25).append("Registered avro schema : ").append(schema.toString(true)).toString());
                        RDD genericRecords = HoodieSparkUtils$.MODULE$.createRdd(df, structName2, nameSpace2, reconcileSchema, Option.of((Object)schema));
                        boolean shouldCombine = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key()))).toBoolean() || operation.equals((Object)WriteOperationType.UPSERT) || new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HoodieWriteConfig.COMBINE_BEFORE_INSERT.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieWriteConfig.COMBINE_BEFORE_INSERT.defaultValue()))).toBoolean();
                        JavaRDD hoodieAllIncomingRecords = genericRecords.map((Function1 & Serializable & scala.Serializable)gr -> {
                            HoodieRecord hoodieRecord;
                            GenericRecord processedRecord = MODULE$.getProcessedRecord(partitionColumns, (GenericRecord)gr, Predef$.MODULE$.Boolean2boolean(dropPartitionColumns));
                            if (shouldCombine) {
                                Comparable orderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal((GenericRecord)gr, (String)hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD()), (boolean)false);
                                hoodieRecord = DataSourceUtils.createHoodieRecord((GenericRecord)processedRecord, (Comparable)orderingVal, (HoodieKey)keyGenerator.getKey(gr), (String)hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME()));
                            } else {
                                hoodieRecord = DataSourceUtils.createHoodieRecord((GenericRecord)processedRecord, (HoodieKey)keyGenerator.getKey(gr), (String)hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME()));
                            }
                            HoodieRecord hoodieRecord2 = hoodieRecord;
                            return hoodieRecord2;
                        }, ClassTag$.MODULE$.apply(HoodieRecord.class)).toJavaRDD();
                        Schema writeSchema = Predef$.MODULE$.Boolean2boolean(dropPartitionColumns) ? this.generateSchemaWithoutPartitionColumns(partitionColumns, schema) : schema;
                        SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataSourceUtils.createHoodieClient((JavaSparkContext)jsc, (String)writeSchema.toString(), (String)path, (String)tblName, (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap(parameters.$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key()))));
                        Object object = this.isAsyncCompactionEnabled((SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>)client, tableConfig, (scala.collection.immutable.Map<String, String>)parameters, jsc.hadoopConfiguration()) ? ((Function1)asyncCompactionTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                        Object object3 = this.isAsyncClusteringEnabled((SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>)client, (scala.collection.immutable.Map<String, String>)parameters) ? ((Function1)asyncClusteringTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                        JavaRDD hoodieRecords = Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS())) ? DataSourceUtils.dropDuplicates((JavaSparkContext)jsc, (JavaRDD)hoodieAllIncomingRecords, (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)parameters)) : hoodieAllIncomingRecords;
                        client.startCommitWithTime(instantTime, commitActionType);
                        HoodieWriteResult writeResult2 = DataSourceUtils.doWriteOperation((SparkRDDWriteClient)client, (JavaRDD)hoodieRecords, (String)instantTime, (WriteOperationType)operation);
                        tuple22 = new Tuple2((Object)writeResult2, (Object)client);
                    }
                    tuple2 = tuple22;
                    if (tuple2 == null) break block27;
                    writeResult = (HoodieWriteResult)tuple2._1();
                    writeClient = (SparkRDDWriteClient)tuple2._2();
                    if (writeClient != null) break block28;
                }
                throw new MatchError((Object)tuple2);
            }
            SparkRDDWriteClient sparkRDDWriteClient = writeClient;
            Tuple2 tuple2 = new Tuple2((Object)writeResult, (Object)sparkRDDWriteClient);
            Tuple2 tuple212 = tuple2;
            HoodieWriteResult writeResult3 = (HoodieWriteResult)tuple212._1();
            SparkRDDWriteClient writeClient2 = (SparkRDDWriteClient)tuple212._2();
            Tuple3<Object, Option<String>, Option<String>> tuple3 = this.commitAndPerformPostOperations(sqlContext.sparkSession(), df.schema(), writeResult3, (scala.collection.immutable.Map<String, String>)parameters, (SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>)writeClient2, tableConfig, jsc, new HoodieSparkSqlWriter.TableInstantInfo(basePath, instantTime, commitActionType, operation));
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            boolean writeSuccessful = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
            Option compactionInstant = (Option)tuple3._2();
            Option clusteringInstant = (Option)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful), (Object)compactionInstant, (Object)clusteringInstant);
            Tuple3 tuple33 = tuple32;
            boolean writeSuccessful2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
            Option compactionInstant2 = (Option)tuple33._2();
            Option clusteringInstant2 = (Option)tuple33._3();
            tuple6 = new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful2), (Object)Option.ofNullable((Object)instantTime), (Object)compactionInstant2, (Object)clusteringInstant2, (Object)writeClient2, (Object)tableConfig);
        }
        return tuple6;
    }

    public scala.Option<HoodieTableConfig> write$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> write$default$6() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> write$default$7() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> write$default$8() {
        return Option$.MODULE$.empty();
    }

    public Schema generateSchemaWithoutPartitionColumns(String partitionParam, Schema schema) {
        ArrayList fieldsToRemove = new ArrayList();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionParam.split(","))).map((Function1 & Serializable & scala.Serializable)partitionField -> partitionField.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$generateSchemaWithoutPartitionColumns$2(s))))).map((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)fieldsToRemove.add(field)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
        return HoodieAvroUtils.removeFields((Schema)schema, fieldsToRemove);
    }

    public GenericRecord getProcessedRecord(String partitionParam, GenericRecord record, boolean dropPartitionColumns) {
        GenericRecord processedRecord;
        block0: {
            processedRecord = record;
            if (!dropPartitionColumns) break block0;
            Schema writeSchema = this.generateSchemaWithoutPartitionColumns(partitionParam, record.getSchema());
            processedRecord = HoodieAvroUtils.rewriteRecord((GenericRecord)record, (Schema)writeSchema);
        }
        return processedRecord;
    }

    public Schema getLatestTableSchema(FileSystem fs, Path basePath, SparkContext sparkContext, Schema schema) {
        Schema latestSchema;
        block0: {
            latestSchema = schema;
            if (!FSUtils.isTableExists((String)basePath.toString(), (FileSystem)fs)) break block0;
            HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.builder().setConf(sparkContext.hadoopConfiguration()).setBasePath(basePath.toString()).build();
            TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(tableMetaClient);
            latestSchema = tableSchemaResolver.getLatestSchema(schema, false, null);
        }
        return latestSchema;
    }

    public RDD<GenericRecord> registerKryoClassesAndGetGenericRecords(String tblName, SparkContext sparkContext, Dataset<Row> df, boolean reconcileSchema) {
        String structName = new StringBuilder(7).append(tblName).append("_record").toString();
        String nameSpace = new StringBuilder(7).append("hoodie.").append(tblName).toString();
        sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
        return HoodieSparkUtils$.MODULE$.createRdd(df, structName, nameSpace, reconcileSchema, HoodieSparkUtils$.MODULE$.createRdd$default$5());
    }

    public boolean bootstrap(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> optParams, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> hoodieWriteClient) {
        BoxedUnit boxedUnit;
        Object object;
        Predef$.MODULE$.assert(optParams.get((Object)"path").exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$bootstrap$1(x$7))), (Function0 & Serializable & scala.Serializable)() -> "'path' must be set");
        String path = (String)optParams.apply((Object)"path");
        Path basePath = new Path(path);
        SparkContext sparkContext = sqlContext.sparkContext();
        FileSystem fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
        this.tableExists_$eq(fs.exists(new Path(basePath, ".hoodie")));
        HoodieTableConfig tableConfig = this.getHoodieTableConfig(sparkContext, path, hoodieTableConfigOpt);
        HoodieWriterUtils$.MODULE$.validateTableConfig(sqlContext.sparkSession(), optParams, (HoodieConfig)tableConfig);
        Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> tuple2 = this.mergeParamsAndGetHoodieConfig(optParams, tableConfig);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map parameters = (scala.collection.immutable.Map)tuple2._1();
        HoodieConfig hoodieConfig = (HoodieConfig)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)parameters, (Object)hoodieConfig);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Map parameters2 = (scala.collection.immutable.Map)tuple23._1();
        HoodieConfig hoodieConfig2 = (HoodieConfig)tuple23._2();
        String tableName = hoodieConfig2.getStringOrThrow(HoodieWriteConfig.TBL_NAME, new StringBuilder(15).append("'").append(HoodieWriteConfig.TBL_NAME.key()).append("' must be set.").toString());
        String tableType = hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.TABLE_TYPE());
        String bootstrapBasePath = hoodieConfig2.getStringOrThrow(HoodieBootstrapConfig.BASE_PATH, new StringBuilder(32).append("'").append(HoodieBootstrapConfig.BASE_PATH.key()).append("' is required for '").append(DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()).append("'").append(" operation'").toString());
        String bootstrapIndexClass = hoodieConfig2.getStringOrDefault(HoodieBootstrapConfig.INDEX_CLASS_NAME);
        ObjectRef schema = ObjectRef.create(null);
        if (df.schema().nonEmpty()) {
            Tuple2 tuple24 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tableName);
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            String structName = (String)tuple24._1();
            String namespace = (String)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)structName, (Object)namespace);
            Tuple2 tuple26 = tuple25;
            String structName2 = (String)tuple26._1();
            String namespace2 = (String)tuple26._2();
            schema.elem = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(df.schema(), structName2, namespace2).toString();
        } else {
            schema.elem = HoodieAvroUtils.getNullSchema().toString();
        }
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Ignore;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && this.tableExists()) {
            this.log().warn((Object)new StringBuilder(73).append("hoodie table at ").append(basePath).append(" already exists. Ignoring & not performing actual writes.").toString());
            object = BoxesRunTime.boxToBoolean((boolean)false);
        } else {
            this.handleSaveModes(sqlContext.sparkSession(), mode, basePath, tableConfig, tableName, WriteOperationType.BOOTSTRAP, fs);
            object = BoxedUnit.UNIT;
        }
        if (!this.tableExists()) {
            String archiveLogFolder = hoodieConfig2.getStringOrDefault(HoodieTableConfig.ARCHIVELOG_FOLDER);
            String partitionColumns = HoodieWriterUtils$.MODULE$.getPartitionColumns((scala.collection.immutable.Map<String, String>)parameters2);
            String recordKeyFields = hoodieConfig2.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD());
            String keyGenProp = hoodieConfig2.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME);
            boolean populateMetaFields = new StringOps(Predef$.MODULE$.augmentString((String)parameters2.getOrElse((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieTableConfig.POPULATE_META_FIELDS.defaultValue()))).toBoolean();
            String baseFileFormat = hoodieConfig2.getStringOrDefault(HoodieTableConfig.BASE_FILE_FORMAT);
            boxedUnit = HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.valueOf((String)tableType)).setTableName(tableName).setRecordKeyFields(recordKeyFields).setArchiveLogFolder(archiveLogFolder).setPayloadClassName(hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME())).setPreCombineField(hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD(), null)).setBootstrapIndexClass(bootstrapIndexClass).setBaseFileFormat(baseFileFormat).setBootstrapBasePath(bootstrapBasePath).setPartitionFields(partitionColumns).setPopulateMetaFields(populateMetaFields).setKeyGeneratorClassProp(keyGenProp).setHiveStylePartitioningEnable(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING())).setUrlEncodePartitioning(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING())).initTable(sparkContext.hadoopConfiguration(), path);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        JavaSparkContext jsc = new JavaSparkContext(sqlContext.sparkContext());
        try (SparkRDDWriteClient writeClient = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataSourceUtils.createHoodieClient((JavaSparkContext)jsc, (String)((String)schema$1.elem), (String)path, (String)tableName, (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)parameters2)));){
            writeClient.bootstrap(Option.empty());
        }
        boolean metaSyncSuccess = this.metaSync(sqlContext.sparkSession(), hoodieConfig2, basePath, df.schema());
        return metaSyncSuccess;
    }

    public scala.Option<HoodieTableConfig> bootstrap$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> bootstrap$default$6() {
        return Option$.MODULE$.empty();
    }

    public Tuple2<Object, Option<String>> bulkInsertAsRow(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> df, String tblName, Path basePath, String path, String instantTime, String partitionColumns) {
        Dataset<Row> hoodieDF;
        Option userDefinedBulkInsertPartitionerOpt;
        SparkContext sparkContext = sqlContext.sparkContext();
        boolean populateMetaFields = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieTableConfig.POPULATE_META_FIELDS.defaultValue()))).toBoolean();
        boolean dropPartitionColumns = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS().defaultValue()))).toBoolean();
        Tuple2 tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tblName);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String structName = (String)tuple2._1();
        String nameSpace = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
        Tuple2 tuple23 = tuple22;
        String structName2 = (String)tuple23._1();
        String nameSpace2 = (String)tuple23._2();
        sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
        Schema schema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(df.schema(), structName2, nameSpace2);
        if (dropPartitionColumns) {
            schema = this.generateSchemaWithoutPartitionColumns(partitionColumns, schema);
        }
        sparkContext.getConf().registerAvroSchemas((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{schema}));
        this.log().info((Object)new StringBuilder(25).append("Registered avro schema : ").append(schema.toString(true)).toString());
        if (new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key()))).toBoolean()) {
            throw new HoodieException("Dropping duplicates with bulk_insert in row writer path is not supported yet");
        }
        scala.collection.immutable.Map params = parameters.updated((Object)HoodieWriteConfig.AVRO_SCHEMA_STRING.key(), (Object)schema.toString());
        HoodieWriteConfig writeConfig = DataSourceUtils.createHoodieConfig((String)schema.toString(), (String)path, (String)tblName, (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)params));
        NonSortPartitionerWithRows bulkInsertPartitionerRows = populateMetaFields ? ((userDefinedBulkInsertPartitionerOpt = DataSourceUtils.createUserDefinedBulkInsertPartitionerWithRows((HoodieWriteConfig)writeConfig)).isPresent() ? (BulkInsertPartitioner)userDefinedBulkInsertPartitionerOpt.get() : BulkInsertInternalPartitionerWithRowsFactory.get((BulkInsertSortMode)writeConfig.getBulkInsertSortMode())) : new NonSortPartitionerWithRows();
        boolean arePartitionRecordsSorted = bulkInsertPartitionerRows.arePartitionRecordsSorted();
        parameters.updated((Object)"hoodie.bulkinsert.are.partitioner.records.sorted", (Object)((Object)BoxesRunTime.boxToBoolean((boolean)arePartitionRecordsSorted)).toString());
        boolean isGlobalIndex = populateMetaFields ? SparkHoodieIndexFactory.isGlobalIndex((HoodieWriteConfig)writeConfig) : false;
        Dataset<Row> dataset = hoodieDF = populateMetaFields ? HoodieDatasetBulkInsertHelper.prepareHoodieDatasetForBulkInsert(sqlContext, writeConfig, df, structName2, nameSpace2, (BulkInsertPartitioner<Dataset<Row>>)bulkInsertPartitionerRows, isGlobalIndex, dropPartitionColumns) : HoodieDatasetBulkInsertHelper.prepareHoodieDatasetForBulkInsertWithoutMetaFields(df);
        if (package$.MODULE$.SPARK_VERSION().startsWith("2.")) {
            hoodieDF.write().format("org.apache.hudi.internal").option("hoodie.instant.time", instantTime).options((Map)params).mode(SaveMode.Append).save();
        } else if (package$.MODULE$.SPARK_VERSION().startsWith("3.")) {
            hoodieDF.write().format("org.apache.hudi.spark3.internal").option("hoodie.instant.time", instantTime).option(HoodieInternalConfig.BULKINSERT_INPUT_DATA_SCHEMA_DDL.key(), hoodieDF.schema().toDDL()).options((Map)params).mode(SaveMode.Append).save();
        } else {
            throw new HoodieException("Bulk insert using row writer is not supported with current Spark version. To use row writer please switch to spark 2 or spark 3");
        }
        HoodieConfig hoodieConfig = HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)params);
        boolean hiveSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SYNC_ENABLED()))).toBoolean();
        boolean metaSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.META_SYNC_ENABLED()))).toBoolean();
        boolean syncHiveSuccess = hiveSyncEnabled || metaSyncEnabled ? this.metaSync(sqlContext.sparkSession(), hoodieConfig, basePath, df.schema()) : true;
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)syncHiveSuccess), (Object)Option.ofNullable((Object)instantTime));
    }

    /*
     * WARNING - void declaration
     */
    public TypedProperties toProperties(scala.collection.immutable.Map<String, String> params) {
        void var2_2;
        TypedProperties props = new TypedProperties();
        params.foreach((Function1 & Serializable & scala.Serializable)kv -> props.setProperty((String)kv._1(), (String)kv._2()));
        return var2_2;
    }

    private void handleSaveModes(SparkSession spark, SaveMode mode, Path tablePath, HoodieTableConfig tableConfig, String tableName, WriteOperationType operation, FileSystem fs) {
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Append;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && this.tableExists()) {
            String existingTableName = tableConfig.getTableName();
            Function2 resolver = spark.sessionState().conf().resolver();
            if (!BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)existingTableName, (Object)tableName))) {
                throw new HoodieException(new StringBuilder(96).append("hoodie table with name ").append(existingTableName).append(" already exists at ").append(tablePath).append(",").append(" can not append data to the table with another name ").append(tableName).append(".").toString());
            }
        }
        WriteOperationType writeOperationType = operation;
        WriteOperationType writeOperationType2 = WriteOperationType.DELETE;
        if (writeOperationType == null ? writeOperationType2 != null : !writeOperationType.equals(writeOperationType2)) {
            SaveMode saveMode3 = mode;
            SaveMode saveMode4 = SaveMode.ErrorIfExists;
            if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && this.tableExists()) {
                throw new HoodieException(new StringBuilder(32).append("hoodie table at ").append(tablePath).append(" already exists.").toString());
            }
            SaveMode saveMode5 = mode;
            SaveMode saveMode6 = SaveMode.Overwrite;
            if (!(saveMode5 != null ? !saveMode5.equals(saveMode6) : saveMode6 != null) && this.tableExists()) {
                WriteOperationType writeOperationType3 = operation;
                WriteOperationType writeOperationType4 = WriteOperationType.INSERT_OVERWRITE_TABLE;
                if (writeOperationType3 == null ? writeOperationType4 != null : !writeOperationType3.equals(writeOperationType4)) {
                    this.log().warn((Object)new StringBuilder(84).append("hoodie table at ").append(tablePath).append(" already exists. Deleting existing data & overwriting with new data.").toString());
                    fs.delete(tablePath, true);
                    this.tableExists_$eq(false);
                }
            }
        } else {
            SaveMode saveMode7 = mode;
            SaveMode saveMode8 = SaveMode.Append;
            if (saveMode7 == null ? saveMode8 != null : !saveMode7.equals(saveMode8)) {
                throw new HoodieException(new StringBuilder(54).append("Append is the only save mode applicable for ").append(operation.toString()).append(" operation").toString());
            }
        }
    }

    private boolean syncHive(Path basePath, FileSystem fs, HoodieConfig hoodieConfig, SQLConf sqlConf) {
        HiveSyncConfig hiveSyncConfig = this.buildSyncConfig(basePath, hoodieConfig, sqlConf);
        HiveConf hiveConf = new HiveConf();
        hiveConf.addResource(fs.getConf());
        new HiveSyncTool(hiveSyncConfig, hiveConf, fs).syncHoodieTable();
        return true;
    }

    private HiveSyncConfig buildSyncConfig(Path basePath, HoodieConfig hoodieConfig, SQLConf sqlConf) {
        HiveSyncConfig hiveSyncConfig = new HiveSyncConfig();
        hiveSyncConfig.basePath = basePath.toString();
        hiveSyncConfig.baseFileFormat = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_BASE_FILE_FORMAT());
        hiveSyncConfig.usePreApacheInputFormat = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_USE_PRE_APACHE_INPUT_FORMAT()))).toBoolean());
        hiveSyncConfig.databaseName = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_DATABASE());
        hiveSyncConfig.tableName = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_TABLE());
        hiveSyncConfig.hiveUser = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_USER());
        hiveSyncConfig.hivePass = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_PASS());
        hiveSyncConfig.jdbcUrl = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_URL());
        hiveSyncConfig.skipROSuffix = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE(), (String)DataSourceWriteOptions$.MODULE$.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE().defaultValue()))).toBoolean());
        hiveSyncConfig.partitionFields = JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)ListBuffer$.MODULE$.apply((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_PARTITION_FIELDS()).split(","))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$buildSyncConfig$2(x$12))))).toList()));
        hiveSyncConfig.partitionValueExtractorClass = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_PARTITION_EXTRACTOR_CLASS());
        hiveSyncConfig.useJdbc = hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_USE_JDBC());
        hiveSyncConfig.useFileListingFromMetadata = hoodieConfig.getBoolean(HoodieMetadataConfig.ENABLE);
        hiveSyncConfig.ignoreExceptions = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_IGNORE_EXCEPTIONS()))).toBoolean());
        hiveSyncConfig.supportTimestamp = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SUPPORT_TIMESTAMP_TYPE()))).toBoolean());
        hiveSyncConfig.autoCreateDatabase = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_AUTO_CREATE_DATABASE()))).toBoolean());
        hiveSyncConfig.decodePartition = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING()))).toBoolean());
        hiveSyncConfig.batchSyncNum = Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_BATCH_SYNC_PARTITION_NUM()))).toInt());
        hiveSyncConfig.syncAsSparkDataSourceTable = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SYNC_AS_DATA_SOURCE_TABLE()))).toBoolean());
        hiveSyncConfig.sparkSchemaLengthThreshold = BoxesRunTime.unboxToInt((Object)sqlConf.getConf(StaticSQLConf$.MODULE$.SCHEMA_STRING_LENGTH_THRESHOLD()));
        hiveSyncConfig.createManagedTable = hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_CREATE_MANAGED_TABLE());
        hiveSyncConfig.syncMode = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_SYNC_MODE());
        hiveSyncConfig.serdeProperties = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_TABLE_SERDE_PROPERTIES());
        hiveSyncConfig.tableProperties = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.HIVE_TABLE_PROPERTIES());
        return hiveSyncConfig;
    }

    private boolean metaSync(SparkSession spark, HoodieConfig hoodieConfig, Path basePath, StructType schema) {
        BooleanRef metaSyncSuccess;
        block2: {
            BoxedUnit boxedUnit;
            boolean hiveSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SYNC_ENABLED()))).toBoolean();
            boolean metaSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.META_SYNC_ENABLED()))).toBoolean();
            ObjectRef syncClientToolClassSet = ObjectRef.create((Object)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.META_SYNC_CLIENT_TOOL_CLASS_NAME()).split(","))).foreach((Function1 & Serializable & scala.Serializable)syncClass -> (Set)((Set)syncClientToolClassSet$1.elem).$plus$eq(syncClass));
            if (hiveSyncEnabled) {
                metaSyncEnabled = true;
                boxedUnit = ((Set)syncClientToolClassSet.elem).$plus$eq((Object)HiveSyncTool.class.getName());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            metaSyncSuccess = BooleanRef.create((boolean)true);
            if (!metaSyncEnabled) break block2;
            FileSystem fs = basePath.getFileSystem(spark.sessionState().newHadoopConf());
            ((Set)syncClientToolClassSet.elem).foreach((Function1 & Serializable & scala.Serializable)impl -> {
                HoodieSparkSqlWriter$.$anonfun$metaSync$2(hoodieConfig, basePath, fs, spark, metaSyncSuccess, impl);
                return BoxedUnit.UNIT;
            });
        }
        return metaSyncSuccess.elem;
    }

    private Tuple3<Object, Option<String>, Option<String>> commitAndPerformPostOperations(SparkSession spark, StructType schema, HoodieWriteResult writeResult, scala.collection.immutable.Map<String, String> parameters, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client, HoodieTableConfig tableConfig, JavaSparkContext jsc, HoodieSparkSqlWriter.TableInstantInfo tableInstantInfo) {
        Tuple3 tuple3;
        if (writeResult.getWriteStatuses().rdd().filter((Function1 & Serializable & scala.Serializable)ws -> BoxesRunTime.boxToBoolean((boolean)ws.hasErrors())).isEmpty()) {
            this.log().info((Object)"Proceeding to commit the write.");
            scala.collection.immutable.Map metaMap = (scala.collection.immutable.Map)parameters.filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$commitAndPerformPostOperations$2(parameters, kv)));
            boolean commitSuccess = client.commit(tableInstantInfo.instantTime(), writeResult.getWriteStatuses(), Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap))), tableInstantInfo.commitActionType(), writeResult.getPartitionToReplaceFileIds());
            if (commitSuccess) {
                this.log().info((Object)new StringBuilder(19).append("Commit ").append(tableInstantInfo.instantTime()).append(" successful!").toString());
            } else {
                this.log().info((Object)new StringBuilder(15).append("Commit ").append(tableInstantInfo.instantTime()).append(" failed!").toString());
            }
            boolean asyncCompactionEnabled = this.isAsyncCompactionEnabled(client, tableConfig, parameters, jsc.hadoopConfiguration());
            Option compactionInstant = asyncCompactionEnabled ? client.scheduleCompaction(Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap)))) : Option.empty();
            this.log().info((Object)new StringBuilder(24).append("Compaction Scheduled is ").append(compactionInstant).toString());
            boolean asyncClusteringEnabled = this.isAsyncClusteringEnabled(client, parameters);
            Option clusteringInstant = asyncClusteringEnabled ? client.scheduleClustering(Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap)))) : Option.empty();
            this.log().info((Object)new StringBuilder(24).append("Clustering Scheduled is ").append(clusteringInstant).toString());
            boolean metaSyncSuccess = this.metaSync(spark, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig(parameters), tableInstantInfo.basePath(), schema);
            this.log().info((Object)new StringBuilder(30).append("Is Async Compaction Enabled ? ").append(asyncCompactionEnabled).toString());
            if (!asyncCompactionEnabled && !asyncClusteringEnabled) {
                client.close();
            }
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((commitSuccess && metaSyncSuccess ? 1 : 0) != 0), (Object)compactionInstant, (Object)clusteringInstant);
        } else {
            this.log().error((Object)new StringBuilder(19).append(tableInstantInfo.operation()).append(" failed with errors").toString());
            if (this.log().isTraceEnabled()) {
                this.log().trace((Object)"Printing out the top 100 errors");
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])writeResult.getWriteStatuses().rdd().filter((Function1 & Serializable & scala.Serializable)ws -> BoxesRunTime.boxToBoolean((boolean)ws.hasErrors())).take(100))).foreach((Function1 & Serializable & scala.Serializable)ws -> {
                    HoodieSparkSqlWriter$.$anonfun$commitAndPerformPostOperations$4(ws);
                    return BoxedUnit.UNIT;
                });
            }
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Option.empty(), (Object)Option.empty());
        }
        return tuple3;
    }

    private boolean isAsyncCompactionEnabled(SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client, HoodieTableConfig tableConfig, scala.collection.immutable.Map<String, String> parameters, Configuration configuration) {
        boolean bl;
        this.log().info((Object)new StringBuilder(33).append("Config.inlineCompactionEnabled ? ").append(client.getConfig().inlineCompactionEnabled()).toString());
        if (this.asyncCompactionTriggerFnDefined() && !client.getConfig().inlineCompactionEnabled() && parameters.get((Object)DataSourceWriteOptions$.MODULE$.ASYNC_COMPACT_ENABLE().key()).exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$isAsyncCompactionEnabled$1(r)))) {
            HoodieTableType hoodieTableType = tableConfig.getTableType();
            HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
            bl = !(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isAsyncClusteringEnabled(SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client, scala.collection.immutable.Map<String, String> parameters) {
        this.log().info((Object)new StringBuilder(32).append("Config.asyncClusteringEnabled ? ").append(client.getConfig().isAsyncClusteringEnabled()).toString());
        return this.asyncClusteringTriggerFnDefined() && client.getConfig().isAsyncClusteringEnabled() && parameters.get((Object)DataSourceWriteOptions$.MODULE$.ASYNC_CLUSTERING_ENABLE().key()).exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$isAsyncClusteringEnabled$1(r)));
    }

    private HoodieTableConfig getHoodieTableConfig(SparkContext sparkContext, String tablePath, scala.Option<HoodieTableConfig> hoodieTableConfigOpt) {
        return this.tableExists() ? (HoodieTableConfig)hoodieTableConfigOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> HoodieTableMetaClient.builder().setConf(sparkContext.hadoopConfiguration()).setBasePath(tablePath).build().getTableConfig()) : null;
    }

    private Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> mergeParamsAndGetHoodieConfig(scala.collection.immutable.Map<String, String> optParams, HoodieTableConfig tableConfig) {
        scala.collection.immutable.Map translatedOptions = DataSourceWriteOptions$.MODULE$.translateSqlOptions(optParams);
        scala.collection.mutable.Map mergedParams = Map$.MODULE$.empty().$plus$plus(HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults((scala.collection.immutable.Map<String, String>)translatedOptions));
        if (!mergedParams.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key()) && mergedParams.contains((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key())) {
            mergedParams.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), mergedParams.apply((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()));
        }
        if (tableConfig != null) {
            JavaConversions$.MODULE$.deprecated$u0020propertiesAsScalaMap((Properties)tableConfig.getProps()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                HoodieSparkSqlWriter$.$anonfun$mergeParamsAndGetHoodieConfig$1(mergedParams, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        scala.collection.immutable.Map params = mergedParams.toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)params, (Object)HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)params));
    }

    public static final /* synthetic */ boolean $anonfun$write$1(String x$1) {
        return !StringUtils.isNullOrEmpty((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$generateSchemaWithoutPartitionColumns$2(String s) {
        return !s.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$bootstrap$1(String x$7) {
        return !StringUtils.isNullOrEmpty((String)x$7);
    }

    public static final /* synthetic */ boolean $anonfun$buildSyncConfig$2(String x$12) {
        return !x$12.isEmpty();
    }

    public static final /* synthetic */ void $anonfun$metaSync$2(HoodieConfig hoodieConfig$2, Path basePath$1, FileSystem fs$1, SparkSession spark$1, BooleanRef metaSyncSuccess$1, String impl) {
        boolean bl;
        String string = impl.trim();
        if ("org.apache.hudi.hive.HiveSyncTool".equals(string)) {
            MODULE$.log().info((Object)new StringBuilder(33).append("Syncing to Hive Metastore (URL: ").append(hoodieConfig$2.getString(DataSourceWriteOptions$.MODULE$.HIVE_URL())).append(")").toString());
            MODULE$.syncHive(basePath$1, fs$1, hoodieConfig$2, spark$1.sessionState().conf());
            bl = true;
        } else {
            Properties properties = new Properties();
            properties.putAll((java.util.Map<?, ?>)hoodieConfig$2.getProps());
            properties.put("basePath", basePath$1.toString());
            AbstractSyncTool syncHoodie = (AbstractSyncTool)ReflectionUtils.loadClass((String)impl.trim(), (Class[])((Class[])((Object[])new Class[]{Properties.class, FileSystem.class})), (Object[])new Object[]{properties, fs$1});
            syncHoodie.syncHoodieTable();
            bl = true;
        }
        boolean syncSuccess = bl;
        metaSyncSuccess$1.elem = metaSyncSuccess$1.elem && syncSuccess;
    }

    public static final /* synthetic */ boolean $anonfun$commitAndPerformPostOperations$2(scala.collection.immutable.Map parameters$3, Tuple2 kv) {
        return ((String)kv._1()).startsWith((String)parameters$3.apply((Object)DataSourceWriteOptions$.MODULE$.COMMIT_METADATA_KEYPREFIX().key()));
    }

    public static final /* synthetic */ void $anonfun$commitAndPerformPostOperations$5(Tuple2 kt) {
        MODULE$.log().trace((Object)new StringBuilder(15).append("Error for key: ").append(kt._1()).toString(), (Throwable)kt._2());
    }

    public static final /* synthetic */ void $anonfun$commitAndPerformPostOperations$4(WriteStatus ws) {
        block0: {
            MODULE$.log().trace((Object)"Global error :", ws.getGlobalError());
            if (ws.getErrors().size() <= 0) break block0;
            JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap((java.util.Map)ws.getErrors()).foreach((Function1 & Serializable & scala.Serializable)kt -> {
                HoodieSparkSqlWriter$.$anonfun$commitAndPerformPostOperations$5(kt);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$isAsyncCompactionEnabled$1(String r) {
        return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$isAsyncClusteringEnabled$1(String r) {
        return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
    }

    public static final /* synthetic */ void $anonfun$mergeParamsAndGetHoodieConfig$1(scala.collection.mutable.Map mergedParams$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        mergedParams$1.update((Object)key, (Object)value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private HoodieSparkSqlWriter$() {
        MODULE$ = this;
        this.log = LogManager.getLogger(this.getClass());
        this.tableExists = false;
        this.asyncCompactionTriggerFnDefined = false;
        this.asyncClusteringTriggerFnDefined = false;
    }
}

