/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.bootstrap;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.avro.model.HoodiePath;
import org.apache.hudi.client.bootstrap.FullRecordBootstrapDataProvider;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.bootstrap.FileStatusUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public abstract class SparkFullBootstrapDataProviderBase
extends FullRecordBootstrapDataProvider<JavaRDD<HoodieRecord>> {
    private final transient SparkSession sparkSession;

    public SparkFullBootstrapDataProviderBase(TypedProperties props, HoodieSparkEngineContext context) {
        super(props, (HoodieEngineContext)context);
        this.sparkSession = SparkSession.builder().config(context.getJavaSparkContext().getConf()).getOrCreate();
    }

    public JavaRDD<HoodieRecord> generateInputRecords(String tableName, String sourceBasePath, List<Pair<String, List<HoodieFileStatus>>> partitionPathsWithFiles) {
        String[] filePaths = (String[])partitionPathsWithFiles.stream().map(Pair::getValue).flatMap(f -> f.stream().map(fs -> FileStatusUtils.toPath((HoodiePath)fs.getPath()).toString())).toArray(String[]::new);
        Dataset inputDataset = this.sparkSession.read().format(this.getFormat()).load(filePaths);
        try {
            KeyGenerator keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)this.props);
            String structName = tableName + "_record";
            String namespace = "hoodie." + tableName;
            RDD genericRecords = HoodieSparkUtils.createRdd((Dataset)inputDataset, (String)structName, (String)namespace, (boolean)false, (Option)Option.empty());
            return genericRecords.toJavaRDD().map((Function & Serializable)gr -> {
                String orderingVal = HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)gr, (String)this.props.getString("hoodie.datasource.write.precombine.field"), (boolean)false);
                try {
                    return DataSourceUtils.createHoodieRecord((GenericRecord)gr, (Comparable)((Object)orderingVal), (HoodieKey)keyGenerator.getKey(gr), (String)this.props.getString("hoodie.datasource.write.payload.class"));
                }
                catch (IOException ioe) {
                    throw new HoodieIOException(ioe.getMessage(), ioe);
                }
            });
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    protected abstract String getFormat();
}

