/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.index.zorder.ZOrderingIndexHelper;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExtractValue;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.Or$;
import org.apache.spark.sql.catalyst.expressions.StartsWith;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.PartitionedFile$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.ParIterableLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DataSkippingUtils$
implements Logging {
    public static DataSkippingUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DataSkippingUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Expression createZIndexLookupFilter(Expression sourceFilterExpr, StructType indexSchema) {
        Literal literal;
        Option<Expression> option = this.tryComposeIndexFilterExpr(sourceFilterExpr, indexSchema);
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression e = (Expression)some.value();
            literal = e;
        } else if (None$.MODULE$.equals(option)) {
            literal = Literal$.MODULE$.TrueLiteral();
        } else {
            throw new MatchError(option);
        }
        return literal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Expression> tryComposeIndexFilterExpr(Expression sourceExpr, StructType indexSchema) {
        Expression expression;
        Expression expression2;
        Expression expression3;
        Expression expression4;
        IsNotNull isNotNull;
        Expression attribute;
        IsNull isNull;
        Expression attribute2;
        Expression expression5;
        boolean bl = false;
        EqualTo equalTo = null;
        boolean bl2 = false;
        Not not = null;
        boolean bl3 = false;
        LessThan lessThan = null;
        boolean bl4 = false;
        GreaterThan greaterThan = null;
        boolean bl5 = false;
        LessThanOrEqual lessThanOrEqual = null;
        boolean bl6 = false;
        GreaterThanOrEqual greaterThanOrEqual = null;
        Expression expression6 = sourceExpr;
        if (expression6 instanceof EqualTo) {
            bl = true;
            equalTo = (EqualTo)expression6;
            Expression attribute3 = equalTo.left();
            Expression value = equalTo.right();
            if (attribute3 instanceof AttributeReference) {
                AttributeReference attributeReference = (AttributeReference)attribute3;
                if (value instanceof Literal) {
                    Literal literal = (Literal)value;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> DataSkippingUtils$.colContainsValuesEqualToLiteral$1(colName, literal));
                }
            }
        }
        if (bl) {
            Expression value = equalTo.left();
            Expression attribute4 = equalTo.right();
            if (value instanceof Literal) {
                Literal literal = (Literal)value;
                if (attribute4 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)attribute4;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> DataSkippingUtils$.colContainsValuesEqualToLiteral$1(colName, literal));
                }
            }
        }
        if (expression6 instanceof Not) {
            bl2 = true;
            not = (Not)expression6;
            Expression expression7 = not.child();
            if (expression7 instanceof EqualTo) {
                EqualTo equalTo2 = (EqualTo)expression7;
                Expression attribute5 = equalTo2.left();
                Expression value = equalTo2.right();
                if (attribute5 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)attribute5;
                    if (value instanceof Literal) {
                        Literal literal = (Literal)value;
                        return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new Not((Expression)DataSkippingUtils$.colContainsOnlyValuesEqualToLiteral$1(colName, literal)));
                    }
                }
            }
        }
        if (bl2 && (expression5 = not.child()) instanceof EqualTo) {
            EqualTo equalTo3 = (EqualTo)expression5;
            Expression value = equalTo3.left();
            Expression attribute6 = equalTo3.right();
            if (value instanceof Literal) {
                Literal literal = (Literal)value;
                if (attribute6 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)attribute6;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new Not((Expression)DataSkippingUtils$.colContainsOnlyValuesEqualToLiteral$1(colName, literal)));
                }
            }
        }
        if (expression6 instanceof EqualNullSafe) {
            Literal literal;
            Object object;
            EqualNullSafe equalNullSafe = (EqualNullSafe)expression6;
            Expression expression8 = equalNullSafe.right();
            if (equalNullSafe.left() instanceof AttributeReference && expression8 instanceof Literal && (object = (literal = (Literal)expression8).value()) == null) {
                return this.getTargetIndexedColName(equalNullSafe.left(), indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new EqualTo(DataSkippingUtils$.numNulls$1(colName), equalNullSafe.right()));
            }
        }
        if (expression6 instanceof LessThan) {
            bl3 = true;
            lessThan = (LessThan)expression6;
            Expression attribute7 = lessThan.left();
            Expression value = lessThan.right();
            if (attribute7 instanceof AttributeReference) {
                AttributeReference attributeReference = (AttributeReference)attribute7;
                if (value instanceof Literal) {
                    Literal literal = (Literal)value;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new LessThan(DataSkippingUtils$.minValue$1(colName), (Expression)literal));
                }
            }
        }
        if (expression6 instanceof GreaterThan) {
            bl4 = true;
            greaterThan = (GreaterThan)expression6;
            Expression value = greaterThan.left();
            Expression attribute8 = greaterThan.right();
            if (value instanceof Literal) {
                Literal literal = (Literal)value;
                if (attribute8 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)attribute8;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new LessThan(DataSkippingUtils$.minValue$1(colName), (Expression)literal));
                }
            }
        }
        if (bl3) {
            Expression value = lessThan.left();
            Expression attribute9 = lessThan.right();
            if (value instanceof Literal) {
                Literal literal = (Literal)value;
                if (attribute9 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)attribute9;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new GreaterThan(DataSkippingUtils$.maxValue$1(colName), (Expression)literal));
                }
            }
        }
        if (bl4) {
            Expression attribute10 = greaterThan.left();
            Expression value = greaterThan.right();
            if (attribute10 instanceof AttributeReference) {
                AttributeReference attributeReference = (AttributeReference)attribute10;
                if (value instanceof Literal) {
                    Literal literal = (Literal)value;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new GreaterThan(DataSkippingUtils$.maxValue$1(colName), (Expression)literal));
                }
            }
        }
        if (expression6 instanceof LessThanOrEqual) {
            bl5 = true;
            lessThanOrEqual = (LessThanOrEqual)expression6;
            Expression attribute11 = lessThanOrEqual.left();
            Expression value = lessThanOrEqual.right();
            if (attribute11 instanceof AttributeReference) {
                AttributeReference attributeReference = (AttributeReference)attribute11;
                if (value instanceof Literal) {
                    Literal literal = (Literal)value;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new LessThanOrEqual(DataSkippingUtils$.minValue$1(colName), (Expression)literal));
                }
            }
        }
        if (expression6 instanceof GreaterThanOrEqual) {
            bl6 = true;
            greaterThanOrEqual = (GreaterThanOrEqual)expression6;
            Expression value = greaterThanOrEqual.left();
            Expression attribute12 = greaterThanOrEqual.right();
            if (value instanceof Literal) {
                Literal literal = (Literal)value;
                if (attribute12 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)attribute12;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new LessThanOrEqual(DataSkippingUtils$.minValue$1(colName), (Expression)literal));
                }
            }
        }
        if (bl5) {
            Expression value = lessThanOrEqual.left();
            Expression attribute13 = lessThanOrEqual.right();
            if (value instanceof Literal) {
                Literal literal = (Literal)value;
                if (attribute13 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)attribute13;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new GreaterThanOrEqual(DataSkippingUtils$.maxValue$1(colName), (Expression)literal));
                }
            }
        }
        if (bl6) {
            Expression attribute14 = greaterThanOrEqual.left();
            Expression right = greaterThanOrEqual.right();
            if (attribute14 instanceof AttributeReference) {
                AttributeReference attributeReference = (AttributeReference)attribute14;
                if (right instanceof Literal) {
                    Literal literal = (Literal)right;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new GreaterThanOrEqual(DataSkippingUtils$.maxValue$1(colName), (Expression)literal));
                }
            }
        }
        if (expression6 instanceof IsNull && (attribute2 = (isNull = (IsNull)expression6).child()) instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)attribute2;
            return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new GreaterThan(DataSkippingUtils$.numNulls$1(colName), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        }
        if (expression6 instanceof IsNotNull && (attribute = (isNotNull = (IsNotNull)expression6).child()) instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)attribute;
            return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new EqualTo(DataSkippingUtils$.numNulls$1(colName), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        }
        if (expression6 instanceof In) {
            In in = (In)expression6;
            Expression attribute15 = in.value();
            Seq list = in.list();
            if (attribute15 instanceof AttributeReference) {
                AttributeReference attributeReference = (AttributeReference)attribute15;
                if (list instanceof Seq) {
                    Seq seq = list;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> (Expression)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)lit -> DataSkippingUtils$.colContainsValuesEqualToLiteral$1(colName, lit), Seq$.MODULE$.canBuildFrom())).reduce((Function2)Or$.MODULE$));
                }
            }
        }
        if (bl2 && (expression4 = not.child()) instanceof In) {
            In in = (In)expression4;
            Expression attribute16 = in.value();
            Seq list = in.list();
            if (attribute16 instanceof AttributeReference) {
                AttributeReference attributeReference = (AttributeReference)attribute16;
                if (list instanceof Seq) {
                    Seq seq = list;
                    return this.getTargetIndexedColName((Expression)attributeReference, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new Not((Expression)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)lit -> DataSkippingUtils$.colContainsOnlyValuesEqualToLiteral$1(colName, lit), Seq$.MODULE$.canBuildFrom())).reduce((Function2)Or$.MODULE$)));
                }
            }
        }
        if (expression6 instanceof StartsWith) {
            Literal literal;
            StartsWith startsWith = (StartsWith)expression6;
            Expression attribute17 = startsWith.left();
            Expression v = startsWith.right();
            if (v instanceof Literal && (literal = (Literal)v).value() instanceof UTF8String) {
                return this.getTargetIndexedColName(attribute17, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> DataSkippingUtils$.colContainsValuesEqualToLiteral$1(colName, literal));
            }
        }
        if (bl2 && (expression3 = not.child()) instanceof StartsWith) {
            Literal literal;
            StartsWith startsWith = (StartsWith)expression3;
            Expression attribute18 = startsWith.left();
            Expression value = startsWith.right();
            if (value instanceof Literal && (literal = (Literal)value).value() instanceof UTF8String) {
                return this.getTargetIndexedColName(attribute18, indexSchema).map((Function1 & Serializable & scala.Serializable)colName -> new Not((Expression)new And((Expression)new StartsWith(DataSkippingUtils$.minValue$1(colName), (Expression)literal), (Expression)new StartsWith(DataSkippingUtils$.maxValue$1(colName), (Expression)literal))));
            }
        }
        if (expression6 instanceof Or) {
            Or or = (Or)expression6;
            Expression resLeft = this.createZIndexLookupFilter(or.left(), indexSchema);
            Expression resRight = this.createZIndexLookupFilter(or.right(), indexSchema);
            return Option$.MODULE$.apply((Object)new Or(resLeft, resRight));
        }
        if (expression6 instanceof And) {
            And and = (And)expression6;
            Expression resLeft = this.createZIndexLookupFilter(and.left(), indexSchema);
            Expression resRight = this.createZIndexLookupFilter(and.right(), indexSchema);
            return Option$.MODULE$.apply((Object)new And(resLeft, resRight));
        }
        if (bl2 && (expression2 = not.child()) instanceof And) {
            And and = (And)expression2;
            Expression left = and.left();
            Expression right = and.right();
            if (left != null) {
                Expression expression9 = left;
                if (right != null) {
                    Expression expression10 = right;
                    return Option$.MODULE$.apply((Object)this.createZIndexLookupFilter((Expression)new Or((Expression)new Not(expression9), (Expression)new Not(expression10)), indexSchema));
                }
            }
        }
        if (bl2 && (expression = not.child()) instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            if (left != null) {
                Expression expression11 = left;
                if (right != null) {
                    Expression expression12 = right;
                    return Option$.MODULE$.apply((Object)this.createZIndexLookupFilter((Expression)new And((Expression)new Not(expression11), (Expression)new Not(expression12)), indexSchema));
                }
            }
        }
        if (expression6 == null) throw new MatchError((Object)expression6);
        return None$.MODULE$;
    }

    private boolean checkColIsIndexed(String colName, StructType indexSchema) {
        return ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ZOrderingIndexHelper.getMinColumnNameFor((String)colName), ZOrderingIndexHelper.getMaxColumnNameFor((String)colName), ZOrderingIndexHelper.getNumNullsColumnNameFor((String)colName)}))).forall((Function1 & Serializable & scala.Serializable)stat -> BoxesRunTime.boxToBoolean((boolean)indexSchema.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataSkippingUtils$.$anonfun$checkColIsIndexed$2(stat, x$1)))));
    }

    private Option<String> getTargetIndexedColName(Expression resolvedExpr, StructType indexSchema) {
        String colName = new UnresolvedAttribute(this.getTargetColNameParts(resolvedExpr)).name();
        return this.checkColIsIndexed(colName, indexSchema) ? Option$.MODULE$.apply((Object)colName) : None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Seq<String> getTargetColNameParts(Expression resolvedTargetCol) {
        Expression expression;
        while (true) {
            Expression c;
            if ((expression = resolvedTargetCol) instanceof Attribute) {
                Attribute attribute = (Attribute)expression;
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{attribute.name()}));
            }
            if (!(expression instanceof Alias)) break;
            Alias alias = (Alias)expression;
            resolvedTargetCol = c = alias.child();
        }
        if (expression instanceof GetStructField) {
            GetStructField getStructField = (GetStructField)expression;
            Expression c = getStructField.child();
            Option option = getStructField.name();
            if (option instanceof Some) {
                Some some = (Some)option;
                String name = (String)some.value();
                return (Seq)this.getTargetColNameParts(c).$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom());
            }
        }
        if (!(expression instanceof ExtractValue)) throw new AnalysisException(new StringBuilder(64).append("convert reference to name failed,  Found unsupported expression ").append(expression).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        ExtractValue extractValue = (ExtractValue)expression;
        throw new AnalysisException(new StringBuilder(92).append("convert reference to name failed, Updating nested fields is only supported for StructType: ").append(extractValue).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Seq<FileStatus> getIndexFiles(Configuration conf, String indexPath) {
        Path basePath = new Path(indexPath);
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])basePath.getFileSystem(conf).listStatus(basePath))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DataSkippingUtils$.$anonfun$getIndexFiles$1(f))));
    }

    public Set<String> readParquetFile(SparkSession spark, Seq<FileStatus> indexFiles, Seq<Filter> filters, Option<StructType> schemaOpts) {
        Configuration hadoopConf = spark.sparkContext().hadoopConfiguration();
        Seq partitionedFiles = (Seq)indexFiles.map((Function1 & Serializable & scala.Serializable)f -> new PartitionedFile(InternalRow$.MODULE$.empty(), f.getPath().toString(), 0L, f.getLen(), PartitionedFile$.MODULE$.apply$default$5()), Seq$.MODULE$.canBuildFrom());
        StructType requiredSchema = new StructType().add("file", (DataType)StringType$.MODULE$, true);
        StructType schema = (StructType)schemaOpts.getOrElse((Function0 & Serializable & scala.Serializable)() -> requiredSchema);
        Function1 parquetReader = new ParquetFileFormat().buildReaderWithPartitionValues(spark, schema, StructType$.MODULE$.apply((Seq)Nil$.MODULE$), requiredSchema, filters, Predef$.MODULE$.Map().empty(), hadoopConf);
        Iterator[] results = new Iterator[partitionedFiles.size()];
        ((ParIterableLike)((Parallelizable)partitionedFiles.zipWithIndex(Seq$.MODULE$.canBuildFrom())).par()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DataSkippingUtils$.$anonfun$readParquetFile$3(parquetReader, results, x0$1);
            return BoxedUnit.UNIT;
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])results)).flatMap((Function1 & Serializable & scala.Serializable)f -> f, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
    }

    public Seq<Filter> readParquetFile$default$3() {
        return Nil$.MODULE$;
    }

    public Option<StructType> readParquetFile$default$4() {
        return None$.MODULE$;
    }

    private static final Expression minValue$1(String colName) {
        return functions$.MODULE$.col(ZOrderingIndexHelper.getMinColumnNameFor((String)colName)).expr();
    }

    private static final Expression maxValue$1(String colName) {
        return functions$.MODULE$.col(ZOrderingIndexHelper.getMaxColumnNameFor((String)colName)).expr();
    }

    private static final Expression numNulls$1(String colName) {
        return functions$.MODULE$.col(ZOrderingIndexHelper.getNumNullsColumnNameFor((String)colName)).expr();
    }

    private static final Expression colContainsValuesEqualToLiteral$1(String colName, Literal value) {
        return new And((Expression)new LessThanOrEqual(DataSkippingUtils$.minValue$1(colName), (Expression)value), (Expression)new GreaterThanOrEqual(DataSkippingUtils$.maxValue$1(colName), (Expression)value));
    }

    private static final And colContainsOnlyValuesEqualToLiteral$1(String colName, Literal value) {
        return new And((Expression)new EqualTo(DataSkippingUtils$.minValue$1(colName), (Expression)value), (Expression)new EqualTo(DataSkippingUtils$.maxValue$1(colName), (Expression)value));
    }

    public static final /* synthetic */ boolean $anonfun$checkColIsIndexed$2(String stat$1, StructField x$1) {
        String string = x$1.name();
        String string2 = stat$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getIndexFiles$1(FileStatus f) {
        return f.getPath().getName().endsWith(".parquet");
    }

    public static final /* synthetic */ void $anonfun$readParquetFile$3(Function1 parquetReader$1, Iterator[] results$1, Tuple2 x0$1) {
        Iterator rows;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionedFile pf = (PartitionedFile)tuple2._1();
        int index = tuple2._2$mcI$sp();
        Iterator fileIterator = (Iterator)parquetReader$1.apply((Object)pf);
        results$1[index] = rows = fileIterator.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Object object;
            Object object2 = x$2;
            if (object2 instanceof InternalRow) {
                InternalRow internalRow = (InternalRow)object2;
                object = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{internalRow}));
            } else if (object2 instanceof ColumnarBatch) {
                ColumnarBatch columnarBatch = (ColumnarBatch)object2;
                object = JavaConverters$.MODULE$.asScalaIteratorConverter(columnarBatch.rowIterator()).asScala();
            } else {
                throw new MatchError(object2);
            }
            return object;
        }).map((Function1 & Serializable & scala.Serializable)r -> r.getString(0));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private DataSkippingUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

