/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.analysis;

import org.apache.hudi.SparkAdapterSupport;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.CompactionPath;
import org.apache.spark.sql.catalyst.plans.logical.CompactionShowOnPath;
import org.apache.spark.sql.catalyst.plans.logical.CompactionShowOnTable;
import org.apache.spark.sql.catalyst.plans.logical.CompactionTable;
import org.apache.spark.sql.catalyst.plans.logical.DeleteFromTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.UpdateTable;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hudi.HoodieSqlUtils$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$;
import org.apache.spark.sql.hudi.command.CompactionHoodiePathCommand;
import org.apache.spark.sql.hudi.command.CompactionHoodieTableCommand;
import org.apache.spark.sql.hudi.command.CompactionShowHoodiePathCommand;
import org.apache.spark.sql.hudi.command.CompactionShowHoodieTableCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableAsSelectCommand;
import org.apache.spark.sql.hudi.command.DeleteHoodieTableCommand;
import org.apache.spark.sql.hudi.command.InsertIntoHoodieTableCommand;
import org.apache.spark.sql.hudi.command.MergeIntoHoodieTableCommand;
import org.apache.spark.sql.hudi.command.UpdateHoodieTableCommand;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005-t!B\f\u0019\u0011\u0003)c!B\u0014\u0019\u0011\u0003A\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004\"\u0002\u001b\u0002\t\u0003)\u0004\"B-\u0002\t\u0003)\u0004b\u0002.\u0002\u0003\u0003%\ti\u0017\u0005\n\u0003'\n\u0011\u0011!CA\u0003+B\u0011\"!\u0019\u0002\u0003\u0003%I!a\u0019\u0007\t\u001dB\u0002)\u0018\u0005\tM\"\u0011)\u001a!C\u0001O\"A\u0001\u000e\u0003B\tB\u0003%Q\tC\u00033\u0011\u0011\u0005\u0011\u000eC\u0003[\u0011\u0011\u00053\u000eC\u0004o\u0011\u0005\u0005I\u0011A8\t\u000fED\u0011\u0013!C\u0001e\"9Q\u0010CA\u0001\n\u0003r\b\"CA\b\u0011\u0005\u0005I\u0011AA\t\u0011%\tI\u0002CA\u0001\n\u0003\tY\u0002C\u0005\u0002(!\t\t\u0011\"\u0011\u0002*!I\u0011q\u0007\u0005\u0002\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003\u0007B\u0011\u0011!C!\u0003\u000bB\u0011\"a\u0012\t\u0003\u0003%\t%!\u0013\t\u0013\u0005-\u0003\"!A\u0005B\u00055\u0013A\u0004%p_\u0012LW-\u00118bYf\u001c\u0018n\u001d\u0006\u00033i\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u00037q\tA\u0001[;eS*\u0011QDH\u0001\u0004gFd'BA\u0010!\u0003\u0015\u0019\b/\u0019:l\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001A\u0011a%A\u0007\u00021\tq\u0001j\\8eS\u0016\fe.\u00197zg&\u001c8cA\u0001*_A\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\u0004\"A\u000b\u0019\n\u0005EZ#\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001&\u0003U\u0019Wo\u001d;p[J+7o\u001c7vi&|gNU;mKN$\u0012A\u000e\t\u0004o}\u0012eB\u0001\u001d>\u001d\tID(D\u0001;\u0015\tYD%\u0001\u0004=e>|GOP\u0005\u0002Y%\u0011ahK\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0015IA\u0002TKFT!AP\u0016\u0011\t)\u001aU)S\u0005\u0003\t.\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005\u0019;U\"\u0001\u000f\n\u0005!c\"\u0001D*qCJ\\7+Z:tS>t\u0007c\u0001&P#6\t1J\u0003\u0002M\u001b\u0006)!/\u001e7fg*\u0011a\nH\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0001k\u0013\u0002\u0005%VdW\r\u0005\u0002S/6\t1K\u0003\u0002U+\u00069An\\4jG\u0006d'B\u0001,N\u0003\u0015\u0001H.\u00198t\u0013\tA6KA\u0006M_\u001eL7-\u00197QY\u0006t\u0017\u0001H2vgR|W\u000eU8ti\"{7MU3t_2,H/[8o%VdWm]\u0001\u0006CB\u0004H.\u001f\u000b\u00049\u0006E\u0003C\u0001\u0014\t'\u0015A\u0011JX20!\ty\u0016-D\u0001a\u0015\tY\u0002%\u0003\u0002cA\n\u00192\u000b]1sW\u0006#\u0017\r\u001d;feN+\b\u000f]8siB\u0011!\u0006Z\u0005\u0003K.\u0012q\u0001\u0015:pIV\u001cG/\u0001\u0007ta\u0006\u00148nU3tg&|g.F\u0001F\u00035\u0019\b/\u0019:l'\u0016\u001c8/[8oAQ\u0011AL\u001b\u0005\u0006M.\u0001\r!\u0012\u000b\u0003#2DQ!\u001c\u0007A\u0002E\u000bA\u0001\u001d7b]\u0006!1m\u001c9z)\ta\u0006\u000fC\u0004g\u001bA\u0005\t\u0019A#\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t1O\u000b\u0002Fi.\nQ\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003u.\n!\"\u00198o_R\fG/[8o\u0013\taxOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005!A.\u00198h\u0015\t\tI!\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003\u0007\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\n!\rQ\u0013QC\u0005\u0004\u0003/Y#aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u000f\u0003G\u00012AKA\u0010\u0013\r\t\tc\u000b\u0002\u0004\u0003:L\b\"CA\u0013#\u0005\u0005\t\u0019AA\n\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0006\t\u0007\u0003[\t\u0019$!\b\u000e\u0005\u0005=\"bAA\u0019W\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0012q\u0006\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002<\u0005\u0005\u0003c\u0001\u0016\u0002>%\u0019\u0011qH\u0016\u0003\u000f\t{w\u000e\\3b]\"I\u0011QE\n\u0002\u0002\u0003\u0007\u0011QD\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111C\u0001\ti>\u001cFO]5oOR\tq0\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003w\ty\u0005C\u0005\u0002&Y\t\t\u00111\u0001\u0002\u001e!)a-\u0002a\u0001\u000b\u00069QO\\1qa2LH\u0003BA,\u0003;\u0002BAKA-\u000b&\u0019\u00111L\u0016\u0003\r=\u0003H/[8o\u0011!\tyFBA\u0001\u0002\u0004a\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\u0007\u0005\u0003\u0002\u0002\u0005\u001d\u0014\u0002BA5\u0003\u0007\u0011aa\u00142kK\u000e$\b")
public class HoodieAnalysis
extends Rule<LogicalPlan>
implements SparkAdapterSupport,
Product,
Serializable {
    private final SparkSession sparkSession;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public static Option<SparkSession> unapply(HoodieAnalysis hoodieAnalysis) {
        return HoodieAnalysis$.MODULE$.unapply(hoodieAnalysis);
    }

    public static Seq<Function1<SparkSession, Rule<LogicalPlan>>> customPostHocResolutionRules() {
        return HoodieAnalysis$.MODULE$.customPostHocResolutionRules();
    }

    public static Seq<Function1<SparkSession, Rule<LogicalPlan>>> customResolutionRules() {
        return HoodieAnalysis$.MODULE$.customResolutionRules();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieAnalysis hoodieAnalysis = this;
        synchronized (hoodieAnalysis) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        return !this.bitmap$0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public LogicalPlan apply(LogicalPlan plan) {
        void var2_15;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof MergeIntoTable) {
            MergeIntoTable mergeIntoTable = (MergeIntoTable)logicalPlan;
            LogicalPlan target = mergeIntoTable.targetTable();
            if (mergeIntoTable.resolved() && HoodieSqlUtils$.MODULE$.isHoodieTable(target, this.sparkSession())) {
                MergeIntoHoodieTableCommand mergeIntoHoodieTableCommand = new MergeIntoHoodieTableCommand(mergeIntoTable);
                return var2_15;
            }
        }
        if (logicalPlan instanceof UpdateTable) {
            UpdateTable updateTable = (UpdateTable)logicalPlan;
            LogicalPlan table = updateTable.table();
            if (updateTable.resolved() && HoodieSqlUtils$.MODULE$.isHoodieTable(table, this.sparkSession())) {
                UpdateHoodieTableCommand updateHoodieTableCommand = new UpdateHoodieTableCommand(updateTable);
                return var2_15;
            }
        }
        if (logicalPlan instanceof DeleteFromTable) {
            DeleteFromTable deleteFromTable = (DeleteFromTable)logicalPlan;
            LogicalPlan table = deleteFromTable.table();
            if (deleteFromTable.resolved() && HoodieSqlUtils$.MODULE$.isHoodieTable(table, this.sparkSession())) {
                DeleteHoodieTableCommand deleteHoodieTableCommand = new DeleteHoodieTableCommand(deleteFromTable);
                return var2_15;
            }
        }
        if (this.sparkAdapter().isInsertInto(logicalPlan)) {
            LogicalRelation logicalRelation;
            Tuple5 tuple5 = (Tuple5)this.sparkAdapter().getInsertIntoChildren(logicalPlan).get();
            if (tuple5 == null) throw new MatchError((Object)tuple5);
            LogicalPlan table = (LogicalPlan)tuple5._1();
            Map partition = (Map)tuple5._2();
            LogicalPlan query = (LogicalPlan)tuple5._3();
            boolean overwrite = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            Tuple4 tuple4 = new Tuple4((Object)table, (Object)partition, (Object)query, (Object)BoxesRunTime.boxToBoolean((boolean)overwrite));
            Tuple4 tuple42 = tuple4;
            LogicalPlan table2 = (LogicalPlan)tuple42._1();
            Map partition2 = (Map)tuple42._2();
            LogicalPlan query2 = (LogicalPlan)tuple42._3();
            boolean overwrite2 = BoxesRunTime.unboxToBoolean((Object)tuple42._4());
            LogicalPlan logicalPlan2 = table2;
            LogicalPlan logicalPlan3 = logicalPlan2 instanceof LogicalRelation && HoodieSqlUtils$.MODULE$.isHoodieTable((LogicalPlan)(logicalRelation = (LogicalRelation)logicalPlan2), this.sparkSession()) ? new InsertIntoHoodieTableCommand(logicalRelation, query2, (Map<String, Option<String>>)partition2, overwrite2) : logicalPlan;
            LogicalPlan logicalPlan4 = logicalPlan3;
            return var2_15;
        }
        if (logicalPlan instanceof CreateTable) {
            Some some;
            LogicalPlan query;
            CreateTable createTable = (CreateTable)logicalPlan;
            CatalogTable table = createTable.tableDesc();
            SaveMode mode = createTable.mode();
            Option option = createTable.query();
            if (option instanceof Some && (query = (LogicalPlan)(some = (Some)option).value()).resolved() && HoodieSqlUtils$.MODULE$.isHoodieTable(table)) {
                CreateHoodieTableAsSelectCommand createHoodieTableAsSelectCommand = new CreateHoodieTableAsSelectCommand(table, mode, query);
                return var2_15;
            }
        }
        if (logicalPlan instanceof CompactionTable) {
            CompactionTable compactionTable = (CompactionTable)logicalPlan;
            LogicalPlan table = compactionTable.table();
            Enumeration.Value operation = compactionTable.operation();
            Option<Object> options = compactionTable.instantTimestamp();
            if (table.resolved() && HoodieSqlUtils$.MODULE$.isHoodieTable(table, this.sparkSession())) {
                TableIdentifier tableId = HoodieSqlUtils$.MODULE$.getTableIdentify(table);
                CatalogTable catalogTable = this.sparkSession().sessionState().catalog().getTableMetadata(tableId);
                CompactionHoodieTableCommand compactionHoodieTableCommand = new CompactionHoodieTableCommand(catalogTable, operation, options);
                return var2_15;
            }
        }
        if (logicalPlan instanceof CompactionPath) {
            CompactionPath compactionPath = (CompactionPath)logicalPlan;
            String path = compactionPath.path();
            Enumeration.Value operation = compactionPath.operation();
            Option<Object> options = compactionPath.instantTimestamp();
            CompactionHoodiePathCommand compactionHoodiePathCommand = new CompactionHoodiePathCommand(path, operation, options);
            return var2_15;
        }
        if (logicalPlan instanceof CompactionShowOnTable) {
            CompactionShowOnTable compactionShowOnTable = (CompactionShowOnTable)logicalPlan;
            LogicalPlan table = compactionShowOnTable.table();
            int limit = compactionShowOnTable.limit();
            if (HoodieSqlUtils$.MODULE$.isHoodieTable(table, this.sparkSession())) {
                TableIdentifier tableId = HoodieSqlUtils$.MODULE$.getTableIdentify(table);
                CatalogTable catalogTable = this.sparkSession().sessionState().catalog().getTableMetadata(tableId);
                CompactionShowHoodieTableCommand compactionShowHoodieTableCommand = new CompactionShowHoodieTableCommand(catalogTable, limit);
                return var2_15;
            }
        }
        if (logicalPlan instanceof CompactionShowOnPath) {
            CompactionShowOnPath compactionShowOnPath = (CompactionShowOnPath)logicalPlan;
            String path = compactionShowOnPath.path();
            int limit = compactionShowOnPath.limit();
            CompactionShowHoodiePathCommand compactionShowHoodiePathCommand = new CompactionShowHoodiePathCommand(path, limit);
            return var2_15;
        }
        LogicalPlan logicalPlan5 = plan;
        return var2_15;
    }

    public HoodieAnalysis copy(SparkSession sparkSession) {
        return new HoodieAnalysis(sparkSession);
    }

    public SparkSession copy$default$1() {
        return this.sparkSession();
    }

    public String productPrefix() {
        return "HoodieAnalysis";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.sparkSession();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HoodieAnalysis;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HoodieAnalysis)) return false;
        boolean bl = true;
        if (!bl) return false;
        HoodieAnalysis hoodieAnalysis = (HoodieAnalysis)((Object)x$1);
        SparkSession sparkSession = this.sparkSession();
        SparkSession sparkSession2 = hoodieAnalysis.sparkSession();
        if (sparkSession == null) {
            if (sparkSession2 != null) {
                return false;
            }
        } else if (!sparkSession.equals(sparkSession2)) return false;
        if (!hoodieAnalysis.canEqual((Object)this)) return false;
        return true;
    }

    public HoodieAnalysis(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        Product.$init$((Product)this);
    }
}

