/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand$;
import org.apache.spark.sql.hudi.command.AlterHoodieTableChangeColumnCommand$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u000e\u001d\u0001&B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\r\"A1\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005Y\u0001\tE\t\u0015!\u0003N\u0011!I\u0006A!f\u0001\n\u0003Q\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011B.\t\u000b\t\u0004A\u0011A2\t\u000b%\u0004A\u0011\t6\t\u000bu\u0004A\u0011\u0002@\t\u0013\u0005-\u0002!!A\u0005\u0002\u00055\u0002\"CA\u001b\u0001E\u0005I\u0011AA\u001c\u0011%\ti\u0005AI\u0001\n\u0003\ty\u0005C\u0005\u0002T\u0001\t\n\u0011\"\u0001\u0002V!I\u0011\u0011\f\u0001\u0002\u0002\u0013\u0005\u00131\f\u0005\n\u0003W\u0002\u0011\u0011!C\u0001\u0003[B\u0011\"!\u001e\u0001\u0003\u0003%\t!a\u001e\t\u0013\u0005\r\u0005!!A\u0005B\u0005\u0015\u0005\"CAJ\u0001\u0005\u0005I\u0011AAK\u0011%\ty\nAA\u0001\n\u0003\n\tkB\u0005\u0002&r\t\t\u0011#\u0001\u0002(\u001aA1\u0004HA\u0001\u0012\u0003\tI\u000b\u0003\u0004c+\u0011\u0005\u0011q\u0017\u0005\n\u0003s+\u0012\u0011!C#\u0003wC\u0011\"!0\u0016\u0003\u0003%\t)a0\t\u0013\u0005\u001dW#!A\u0005\u0002\u0006%\u0007\"CAn+\u0005\u0005I\u0011BAo\u0005\r\nE\u000e^3s\u0011>|G-[3UC\ndWm\u00115b]\u001e,7i\u001c7v[:\u001cu.\\7b]\u0012T!!\b\u0010\u0002\u000f\r|W.\\1oI*\u0011q\u0004I\u0001\u0005QV$\u0017N\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001UQZ\u0014\t\u0005\u0002,e5\tAF\u0003\u0002.]\u00059An\\4jG\u0006d'BA\u00181\u0003\u0015\u0001H.\u00198t\u0015\t\t\u0004%\u0001\u0005dCR\fG._:u\u0013\t\u0019DFA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA\u001b:\u001b\u00051$BA\u000f8\u0015\tA\u0004%A\u0005fq\u0016\u001cW\u000f^5p]&\u0011!H\u000e\u0002\u0010%Vtg.\u00192mK\u000e{W.\\1oIB\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t9\u0001K]8ek\u000e$\bC\u0001\u001fC\u0013\t\u0019UH\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\buC\ndW-\u00133f]RLg-[3s+\u00051\u0005CA$I\u001b\u0005\u0001\u0014BA%1\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018\u0001\u0005;bE2,\u0017\nZ3oi&4\u0017.\u001a:!\u0003)\u0019w\u000e\\;n]:\u000bW.Z\u000b\u0002\u001bB\u0011a*\u0016\b\u0003\u001fN\u0003\"\u0001U\u001f\u000e\u0003ES!A\u0015\u0015\u0002\rq\u0012xn\u001c;?\u0013\t!V(\u0001\u0004Qe\u0016$WMZ\u0005\u0003-^\u0013aa\u0015;sS:<'B\u0001+>\u0003-\u0019w\u000e\\;n]:\u000bW.\u001a\u0011\u0002\u00139,woQ8mk6tW#A.\u0011\u0005q{V\"A/\u000b\u0005y\u0003\u0013!\u0002;za\u0016\u001c\u0018B\u00011^\u0005-\u0019FO];di\u001aKW\r\u001c3\u0002\u00159,woQ8mk6t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005I\u001a<\u0007\u000e\u0005\u0002f\u00015\tA\u0004C\u0003E\u000f\u0001\u0007a\tC\u0003L\u000f\u0001\u0007Q\nC\u0003Z\u000f\u0001\u00071,A\u0002sk:$\"a\u001b=\u0011\u00071\fHO\u0004\u0002n_:\u0011\u0001K\\\u0005\u0002}%\u0011\u0001/P\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00118OA\u0002TKFT!\u0001]\u001f\u0011\u0005U4X\"\u0001\u0011\n\u0005]\u0004#a\u0001*po\")\u0011\u0010\u0003a\u0001u\u0006a1\u000f]1sWN+7o]5p]B\u0011Qo_\u0005\u0003y\u0002\u0012Ab\u00159be.\u001cVm]:j_:\faB^1mS\u0012\fG/Z*dQ\u0016l\u0017\rF\u0003\u0000\u0003\u000b\t)\u0002E\u0002=\u0003\u0003I1!a\u0001>\u0005\u0011)f.\u001b;\t\u000f\u0005\u001d\u0011\u00021\u0001\u0002\n\u0005Ia.Z<TG\",W.\u0019\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002\u0013\u0002\t\u00054(o\\\u0005\u0005\u0003'\tiA\u0001\u0004TG\",W.\u0019\u0005\b\u0003/I\u0001\u0019AA\r\u0003)iW\r^1DY&,g\u000e\u001e\t\u0005\u00037\t9#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0015!\u0018M\u00197f\u0015\u0011\t\u0019#!\n\u0002\r\r|W.\\8o\u0015\tyB%\u0003\u0003\u0002*\u0005u!!\u0006%p_\u0012LW\rV1cY\u0016lU\r^1DY&,g\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0004e\u0003_\t\t$a\r\t\u000f\u0011S\u0001\u0013!a\u0001\r\"91J\u0003I\u0001\u0002\u0004i\u0005bB-\u000b!\u0003\u0005\raW\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIDK\u0002G\u0003wY#!!\u0010\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000fj\u0014AC1o]>$\u0018\r^5p]&!\u00111JA!\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tFK\u0002N\u0003w\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002X)\u001a1,a\u000f\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\u0006\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\t1\fgn\u001a\u0006\u0003\u0003O\nAA[1wC&\u0019a+!\u0019\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005=\u0004c\u0001\u001f\u0002r%\u0019\u00111O\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005e\u0014q\u0010\t\u0004y\u0005m\u0014bAA?{\t\u0019\u0011I\\=\t\u0013\u0005\u0005\u0005#!AA\u0002\u0005=\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\bB1\u0011\u0011RAH\u0003sj!!a#\u000b\u0007\u00055U(\u0001\u0006d_2dWm\u0019;j_:LA!!%\u0002\f\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9*!(\u0011\u0007q\nI*C\u0002\u0002\u001cv\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0002J\t\t\u00111\u0001\u0002z\u00051Q-];bYN$B!a&\u0002$\"I\u0011\u0011Q\n\u0002\u0002\u0003\u0007\u0011\u0011P\u0001$\u00032$XM\u001d%p_\u0012LW\rV1cY\u0016\u001c\u0005.\u00198hK\u000e{G.^7o\u0007>lW.\u00198e!\t)Wc\u0005\u0003\u0016\u0003W\u000b\u0005\u0003CAW\u0003g3Uj\u00173\u000e\u0005\u0005=&bAAY{\u00059!/\u001e8uS6,\u0017\u0002BA[\u0003_\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\t9+\u0001\u0005u_N#(/\u001b8h)\t\ti&A\u0003baBd\u0017\u0010F\u0004e\u0003\u0003\f\u0019-!2\t\u000b\u0011C\u0002\u0019\u0001$\t\u000b-C\u0002\u0019A'\t\u000beC\u0002\u0019A.\u0002\u000fUt\u0017\r\u001d9msR!\u00111ZAl!\u0015a\u0014QZAi\u0013\r\ty-\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rq\n\u0019NR'\\\u0013\r\t).\u0010\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005e\u0017$!AA\u0002\u0011\f1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005}\u0007\u0003BA0\u0003CLA!a9\u0002b\t1qJ\u00196fGR\u0004")
public class AlterHoodieTableChangeColumnCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableIdentifier;
    private final String columnName;
    private final StructField newColumn;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, String, StructField>> unapply(AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand) {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.unapply(alterHoodieTableChangeColumnCommand);
    }

    public static Function1<Tuple3<TableIdentifier, String, StructField>, AlterHoodieTableChangeColumnCommand> tupled() {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<StructField, AlterHoodieTableChangeColumnCommand>>> curried() {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = this;
        synchronized (alterHoodieTableChangeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    public String columnName() {
        return this.columnName;
    }

    public StructField newColumn() {
        return this.newColumn;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, this.tableIdentifier());
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        if (!BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)this.columnName(), (Object)this.newColumn().name()))) {
            throw new AnalysisException("Can not support change column name for hudi table currently.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        StructType newTableSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.tableSchema().fields())).map((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)field.name(), (Object)this.columnName())) ? this.newColumn() : field, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        StructType newDataSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.dataSchema().fields())).map((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)field.name(), (Object)this.columnName())) ? this.newColumn() : field, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        Tuple2 tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.tableIdentifier().table());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String structName = (String)tuple2._1();
        String nameSpace = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
        Tuple2 tuple23 = tuple22;
        String structName2 = (String)tuple23._1();
        String nameSpace2 = (String)tuple23._2();
        Schema newSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(newTableSchema, structName2, nameSpace2);
        this.validateSchema(newSchema, hoodieCatalogTable.metaClient());
        AlterHoodieTableAddColumnsCommand$.MODULE$.commitWithSchema(newSchema, hoodieCatalogTable, sparkSession);
        try {
            sparkSession.catalog().uncacheTable(this.tableIdentifier().quotedString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.log().warn(new StringBuilder(43).append("Exception when attempting to uncache table ").append(this.tableIdentifier().quotedString()).toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        sparkSession.catalog().refreshTable(this.tableIdentifier().unquotedString());
        sparkSession.sessionState().catalog().alterTableDataSchema(this.tableIdentifier(), newDataSchema);
        return (Seq)Seq$.MODULE$.empty();
    }

    private void validateSchema(Schema newSchema, HoodieTableMetaClient metaClient) {
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        Schema tableSchema = HoodieAvroUtils.createHoodieWriteSchema((Schema)schemaUtil.getTableAvroSchemaWithoutMetadataFields());
        if (!TableSchemaResolver.isSchemaCompatible((Schema)tableSchema, (Schema)newSchema)) {
            throw new HoodieException(new StringBuilder(85).append("Failed schema compatibility check for newSchema :").append(newSchema).append(", origin table schema :").append(tableSchema).append(", base path :").append(metaClient.getBasePath()).toString());
        }
    }

    public AlterHoodieTableChangeColumnCommand copy(TableIdentifier tableIdentifier, String columnName, StructField newColumn) {
        return new AlterHoodieTableChangeColumnCommand(tableIdentifier, columnName, newColumn);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdentifier();
    }

    public String copy$default$2() {
        return this.columnName();
    }

    public StructField copy$default$3() {
        return this.newColumn();
    }

    public String productPrefix() {
        return "AlterHoodieTableChangeColumnCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableIdentifier();
                break;
            }
            case 1: {
                object = this.columnName();
                break;
            }
            case 2: {
                object = this.newColumn();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterHoodieTableChangeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterHoodieTableChangeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = (AlterHoodieTableChangeColumnCommand)((Object)x$1);
        TableIdentifier tableIdentifier = this.tableIdentifier();
        TableIdentifier tableIdentifier2 = alterHoodieTableChangeColumnCommand.tableIdentifier();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.columnName();
        String string2 = alterHoodieTableChangeColumnCommand.columnName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        StructField structField = this.newColumn();
        StructField structField2 = alterHoodieTableChangeColumnCommand.newColumn();
        if (structField == null) {
            if (structField2 != null) {
                return false;
            }
        } else if (!structField.equals(structField2)) return false;
        if (!alterHoodieTableChangeColumnCommand.canEqual((Object)this)) return false;
        return true;
    }

    public AlterHoodieTableChangeColumnCommand(TableIdentifier tableIdentifier, String columnName, StructField newColumn) {
        this.tableIdentifier = tableIdentifier;
        this.columnName = columnName;
        this.newColumn = newColumn;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
    }
}

