/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hive.ddl.HiveSyncMode;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.DeleteFromTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.HoodieSqlUtils$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.DeleteHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\r\u001b\u0001\u001eB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\")Q\n\u0001C\u0001\u001d\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0006B\u0002+\u0001A\u0003%\u0001\u0006C\u0004V\u0001\t\u0007I\u0011\u0002,\t\rm\u0003\u0001\u0015!\u0003X\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015\u0019\b\u0001\"\u0003u\u0011%\t\u0019\u0001AA\u0001\n\u0003\t)\u0001C\u0005\u0002\n\u0001\t\n\u0011\"\u0001\u0002\f!I\u0011\u0011\u0005\u0001\u0002\u0002\u0013\u0005\u00131\u0005\u0005\n\u0003g\u0001\u0011\u0011!C\u0001\u0003kA\u0011\"!\u0010\u0001\u0003\u0003%\t!a\u0010\t\u0013\u0005-\u0003!!A\u0005B\u00055\u0003\"CA.\u0001\u0005\u0005I\u0011AA/\u0011%\t9\u0007AA\u0001\n\u0003\nIgB\u0005\u0002ni\t\t\u0011#\u0001\u0002p\u0019A\u0011DGA\u0001\u0012\u0003\t\t\b\u0003\u0004N'\u0011\u0005\u0011q\u0010\u0005\n\u0003\u0003\u001b\u0012\u0011!C#\u0003\u0007C\u0011\"!\"\u0014\u0003\u0003%\t)a\"\t\u0013\u0005-5#!A\u0005\u0002\u00065\u0005\"CAM'\u0005\u0005I\u0011BAN\u0005a!U\r\\3uK\"{w\u000eZ5f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\u0006\u00037q\tqaY8n[\u0006tGM\u0003\u0002\u001e=\u0005!\u0001.\u001e3j\u0015\ty\u0002%A\u0002tc2T!!\t\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\r\"\u0013AB1qC\u000eDWMC\u0001&\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001FM\u001d?\tB\u0011\u0011\u0006M\u0007\u0002U)\u00111\u0006L\u0001\bY><\u0017nY1m\u0015\tic&A\u0003qY\u0006t7O\u0003\u00020=\u0005A1-\u0019;bYf\u001cH/\u0003\u00022U\tYAj\\4jG\u0006d\u0007\u000b\\1o!\t\u0019t'D\u00015\u0015\tYRG\u0003\u00027=\u0005IQ\r_3dkRLwN\\\u0005\u0003qQ\u0012qBU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003uqj\u0011a\u000f\u0006\u0003;\tJ!!P\u001e\u0003'M\u0003\u0018M]6BI\u0006\u0004H/\u001a:TkB\u0004xN\u001d;\u0011\u0005}\u0012U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\u000fA\u0013x\u000eZ;diB\u0011q(R\u0005\u0003\r\u0002\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f1\u0002Z3mKR,G+\u00192mKV\t\u0011\n\u0005\u0002*\u0015&\u00111J\u000b\u0002\u0010\t\u0016dW\r^3Ge>lG+\u00192mK\u0006aA-\u001a7fi\u0016$\u0016M\u00197fA\u00051A(\u001b8jiz\"\"aT)\u0011\u0005A\u0003Q\"\u0001\u000e\t\u000b\u001d\u001b\u0001\u0019A%\u0002\u000bQ\f'\r\\3\u0016\u0003!\na\u0001^1cY\u0016\u0004\u0013a\u0002;bE2,\u0017\nZ\u000b\u0002/B\u0011\u0001,W\u0007\u0002]%\u0011!L\f\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\u0006AA/\u00192mK&#\u0007%A\u0002sk:$\"A\u00188\u0011\u0007};'N\u0004\u0002aK:\u0011\u0011\rZ\u0007\u0002E*\u00111MJ\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005K!A\u001a!\u0002\u000fA\f7m[1hK&\u0011\u0001.\u001b\u0002\u0004'\u0016\f(B\u00014A!\tYG.D\u0001\u001f\u0013\tigDA\u0002S_^DQa\u001c\u0005A\u0002A\fAb\u001d9be.\u001cVm]:j_:\u0004\"a[9\n\u0005It\"\u0001D*qCJ\\7+Z:tS>t\u0017!\u00052vS2$\u0007j\\8eS\u0016\u001cuN\u001c4jOR\u0019Q/!\u0001\u0011\tYTX0 \b\u0003ob\u0004\"!\u0019!\n\u0005e\u0004\u0015A\u0002)sK\u0012,g-\u0003\u0002|y\n\u0019Q*\u00199\u000b\u0005e\u0004\u0005C\u0001<\u007f\u0013\tyHP\u0001\u0004TiJLgn\u001a\u0005\u0006_&\u0001\r\u0001]\u0001\u0005G>\u0004\u0018\u0010F\u0002P\u0003\u000fAqa\u0012\u0006\u0011\u0002\u0003\u0007\u0011*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055!fA%\u0002\u0010-\u0012\u0011\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001c\u0001\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty\"!\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003K\u0001B!a\n\u000225\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0003mC:<'BAA\u0018\u0003\u0011Q\u0017M^1\n\u0007}\fI#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00028A\u0019q(!\u000f\n\u0007\u0005m\u0002IA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002B\u0005\u001d\u0003cA \u0002D%\u0019\u0011Q\t!\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002J9\t\t\u00111\u0001\u00028\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0014\u0011\r\u0005E\u0013qKA!\u001b\t\t\u0019FC\u0002\u0002V\u0001\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI&a\u0015\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003?\n)\u0007E\u0002@\u0003CJ1!a\u0019A\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0013\u0011\u0003\u0003\u0005\r!!\u0011\u0002\r\u0015\fX/\u00197t)\u0011\ty&a\u001b\t\u0013\u0005%\u0013#!AA\u0002\u0005\u0005\u0013\u0001\u0007#fY\u0016$X\rS8pI&,G+\u00192mK\u000e{W.\\1oIB\u0011\u0001kE\n\u0005'\u0005MD\t\u0005\u0004\u0002v\u0005m\u0014jT\u0007\u0003\u0003oR1!!\u001fA\u0003\u001d\u0011XO\u001c;j[\u0016LA!! \u0002x\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0005=\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0012!B1qa2LHcA(\u0002\n\")qI\u0006a\u0001\u0013\u00069QO\\1qa2LH\u0003BAH\u0003+\u0003BaPAI\u0013&\u0019\u00111\u0013!\u0003\r=\u0003H/[8o\u0011!\t9jFA\u0001\u0002\u0004y\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\n\u0005\u0003\u0002(\u0005}\u0015\u0002BAQ\u0003S\u0011aa\u00142kK\u000e$\b")
public class DeleteHoodieTableCommand
extends LogicalPlan
implements RunnableCommand,
SparkAdapterSupport,
scala.Serializable {
    private final DeleteFromTable deleteTable;
    private final LogicalPlan table;
    private final TableIdentifier tableId;
    private SparkAdapter sparkAdapter;
    private Map<String, SQLMetric> metrics;
    private volatile byte bitmap$0;

    public static Option<DeleteFromTable> unapply(DeleteHoodieTableCommand deleteHoodieTableCommand) {
        return DeleteHoodieTableCommand$.MODULE$.unapply(deleteHoodieTableCommand);
    }

    public static <A> Function1<DeleteFromTable, A> andThen(Function1<DeleteHoodieTableCommand, A> function1) {
        return DeleteHoodieTableCommand$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, DeleteHoodieTableCommand> compose(Function1<A, DeleteFromTable> function1) {
        return DeleteHoodieTableCommand$.MODULE$.compose(function1);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        DeleteHoodieTableCommand deleteHoodieTableCommand = this;
        synchronized (deleteHoodieTableCommand) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DeleteHoodieTableCommand deleteHoodieTableCommand = this;
        synchronized (deleteHoodieTableCommand) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.metrics$lzycompute() : this.metrics;
    }

    public DeleteFromTable deleteTable() {
        return this.deleteTable;
    }

    private LogicalPlan table() {
        return this.table;
    }

    private TableIdentifier tableId() {
        return this.tableId;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("start execute delete command for ").append(this.tableId()).toString());
        Dataset df = HoodieSqlUtils$.MODULE$.removeMetaFields((Dataset<Row>)Dataset$.MODULE$.ofRows(sparkSession, this.table()));
        if (this.deleteTable().condition().isDefined()) {
            df = df.filter(Column$.MODULE$.apply((Expression)this.deleteTable().condition().get()));
        }
        Map<String, String> config = this.buildHoodieConfig(sparkSession);
        df.write().format("hudi").mode(SaveMode.Append).options(config).save();
        sparkSession.catalog().refreshTable(this.tableId().unquotedString());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Finish execute delete command for ").append(this.tableId()).toString());
        return (Seq)Seq$.MODULE$.empty();
    }

    private Map<String, String> buildHoodieConfig(SparkSession sparkSession) {
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, this.tableId());
        String path = hoodieCatalogTable.tableLocation();
        HoodieTableConfig tableConfig = hoodieCatalogTable.tableConfig();
        StructType tableSchema = hoodieCatalogTable.tableSchema();
        String[] partitionColumns = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableConfig.getPartitionFieldProp().split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        StructType partitionSchema = StructType$.MODULE$.apply((Seq)tableSchema.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeleteHoodieTableCommand.$anonfun$buildHoodieConfig$2(partitionColumns, f))));
        String[] primaryColumns = (String[])tableConfig.getRecordKeyFields().get();
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])primaryColumns)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("There are no primary key defined in table ").append(this.tableId()).append(", cannot execute delete operator").toString());
        return HoodieSqlUtils$.MODULE$.withSparkConf(sparkSession, hoodieCatalogTable.catalogProperties(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)tableConfig.getTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)tableConfig.getHiveStylePartitioningEnable()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key()), (Object)tableConfig.getUrlEncodePartitioning()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)SqlKeyGenerator.class.getCanonicalName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SqlKeyGenerator$.MODULE$.ORIGIN_KEYGEN_CLASS_NAME()), (Object)tableConfig.getKeyGeneratorClassName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)tableConfig.getPartitionFieldProp()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_SYNC_MODE().key()), (Object)HiveSyncMode.HMS.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_SUPPORT_TIMESTAMP_TYPE().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.DELETE_PARALLELISM_VALUE.key()), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SqlKeyGenerator$.MODULE$.PARTITION_SCHEMA()), (Object)partitionSchema.toDDL())}))));
    }

    public DeleteHoodieTableCommand copy(DeleteFromTable deleteTable) {
        return new DeleteHoodieTableCommand(deleteTable);
    }

    public DeleteFromTable copy$default$1() {
        return this.deleteTable();
    }

    public String productPrefix() {
        return "DeleteHoodieTableCommand";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.deleteTable();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DeleteHoodieTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DeleteHoodieTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DeleteHoodieTableCommand deleteHoodieTableCommand = (DeleteHoodieTableCommand)((Object)x$1);
        DeleteFromTable deleteFromTable = this.deleteTable();
        DeleteFromTable deleteFromTable2 = deleteHoodieTableCommand.deleteTable();
        if (deleteFromTable == null) {
            if (deleteFromTable2 != null) {
                return false;
            }
        } else if (!deleteFromTable.equals(deleteFromTable2)) return false;
        if (!deleteHoodieTableCommand.canEqual((Object)this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$buildHoodieConfig$2(String[] partitionColumns$1, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionColumns$1)).contains((Object)f.name());
    }

    public DeleteHoodieTableCommand(DeleteFromTable deleteTable) {
        this.deleteTable = deleteTable;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        this.table = deleteTable.table();
        this.tableId = HoodieSqlUtils$.MODULE$.getTableIdentify(this.table());
    }
}

