/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\f\u0019\u0001\u0015B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006m\u0001!\ta\u000e\u0005\tw\u0001A)\u0019!C\u0005y!A\u0011\n\u0001EC\u0002\u0013%!\nC\u0003P\u0001\u0011\u0005\u0003\u000bC\u0003P\u0001\u0011\u0005c\rC\u0003n\u0001\u0011%a\u000eC\u0003w\u0001\u0011\u0005s\u000fC\u0003w\u0001\u0011\u0005\u0013pB\u0003|1!\u0005APB\u0003\u00181!\u0005Q\u0010\u0003\u00047\u0017\u0011\u0005\u0011\u0011\u0002\u0005\n\u0003\u0017Y!\u0019!C\u0001\u0003\u001bA\u0001\"!\b\fA\u0003%\u0011q\u0002\u0005\n\u0003?Y!\u0019!C\u0001\u0003\u001bA\u0001\"!\t\fA\u0003%\u0011q\u0002\u0005\n\u0003GY!\u0019!C\u0005\u0003KA\u0001\"a\u000f\fA\u0003%\u0011q\u0005\u0005\n\u0003{Y!\u0019!C\u0005\u0003KA\u0001\"a\u0010\fA\u0003%\u0011q\u0005\u0005\b\u0003\u0003ZA\u0011AA\"\u0011%\t9eCA\u0001\n\u0013\tIEA\bTc2\\U-_$f]\u0016\u0014\u0018\r^8s\u0015\tI\"$A\u0004d_6l\u0017M\u001c3\u000b\u0005ma\u0012\u0001\u00025vI&T!!\b\u0010\u0002\u0007M\fHN\u0003\u0002 A\u0005)1\u000f]1sW*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dZS\"\u0001\u0015\u000b\u0005%R\u0013AB6fs\u001e,gN\u0003\u0002\u001cA%\u0011A\u0006\u000b\u0002\u0014\u0007>l\u0007\u000f\\3y\u0017\u0016Lx)\u001a8fe\u0006$xN]\u0001\u0006aJ|\u0007o\u001d\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\naaY8oM&<'BA\u001a+\u0003\u0019\u0019w.\\7p]&\u0011Q\u0007\r\u0002\u0010)f\u0004X\r\u001a)s_B,'\u000f^5fg\u00061A(\u001b8jiz\"\"\u0001\u000f\u001e\u0011\u0005e\u0002Q\"\u0001\r\t\u000b5\u0012\u0001\u0019\u0001\u0018\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006,\u0012!\u0010\t\u0004}\u0005\u001bU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\r=\u0003H/[8o!\t!u)D\u0001F\u0015\t1E$A\u0003usB,7/\u0003\u0002I\u000b\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0019=\u0014\u0018nZ5o\u0017\u0016Lx)\u001a8\u0016\u0003-\u00032AP!M!\t9S*\u0003\u0002OQ\ta1*Z=HK:,'/\u0019;pe\u0006aq-\u001a;SK\u000e|'\u000fZ&fsR\u0011\u0011\u000b\u0018\t\u0003%fs!aU,\u0011\u0005Q{T\"A+\u000b\u0005Y#\u0013A\u0002\u001fs_>$h(\u0003\u0002Y\u007f\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAv\bC\u0003^\u000b\u0001\u0007a,\u0001\u0004sK\u000e|'\u000f\u001a\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\fqaZ3oKJL7M\u0003\u0002dA\u0005!\u0011M\u001e:p\u0013\t)\u0007MA\u0007HK:,'/[2SK\u000e|'\u000f\u001a\u000b\u0003#\u001eDQ\u0001\u001b\u0004A\u0002%\f1A]8x!\tQ7.D\u0001\u001d\u0013\taGDA\u0002S_^\fQdY8om\u0016\u0014H\u000fU1si&$\u0018n\u001c8QCRDGk\\*rYRK\b/\u001a\u000b\u0004#>\f\b\"\u00029\b\u0001\u0004\t\u0016!\u00049beRLG/[8o!\u0006$\b\u000eC\u0003s\u000f\u0001\u00071/A\u0004s_^$\u0016\u0010]3\u0011\u0005y\"\u0018BA;@\u0005\u001d\u0011un\u001c7fC:\f\u0001cZ3u!\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e5\u0015\u0005EC\b\"B/\t\u0001\u0004qFCA){\u0011\u0015A\u0017\u00021\u0001j\u0003=\u0019\u0016\u000f\\&fs\u001e+g.\u001a:bi>\u0014\bCA\u001d\f'\u0011Ya0a\u0001\u0011\u0005yz\u0018bAA\u0001\u007f\t1\u0011I\\=SK\u001a\u00042APA\u0003\u0013\r\t9a\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0002y\u0006\u0001\u0002+\u0011*U\u0013RKuJT0T\u0007\"+U*Q\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0003mC:<'BAA\r\u0003\u0011Q\u0017M^1\n\u0007i\u000b\u0019\"A\tQ\u0003J#\u0016\nV%P\u001d~\u001b6\tS#N\u0003\u0002\n\u0001d\u0014*J\u000f&sulS#Z\u000f\u0016sul\u0011'B'N{f*Q'F\u0003ey%+S$J\u001d~[U)W$F\u001d~\u001bE*Q*T?:\u000bU*\u0012\u0011\u0002'QLW.Z:uC6\u0004H+[7f\r>\u0014X.\u0019;\u0016\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003oi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0007M>\u0014X.\u0019;\u000b\t\u0005E\u00121G\u0001\u0005i&lWMC\u0002\u00026\t\nAA[8eC&!\u0011\u0011HA\u0016\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM]\u0001\u0015i&lWm\u001d;b[B$\u0016.\\3G_Jl\u0017\r\u001e\u0011\u0002%M\fH\u000eV5nKN$\u0018-\u001c9G_Jl\u0017\r^\u0001\u0014gFdG+[7fgR\fW\u000e\u001d$pe6\fG\u000fI\u0001\u0017O\u0016$(+Z1m\u0017\u0016Lx)\u001a8DY\u0006\u001c8OT1nKR\u0019\u0011+!\u0012\t\u000b5*\u0002\u0019\u0001\u0018\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0017\u0002B!!\u0005\u0002N%!\u0011qJA\n\u0005\u0019y%M[3di\u0002")
public class SqlKeyGenerator
extends ComplexKeyGenerator {
    private Option<StructType> partitionSchema;
    private Option<KeyGenerator> originKeyGen;
    private final TypedProperties props;
    private volatile byte bitmap$0;

    public static String getRealKeyGenClassName(TypedProperties typedProperties) {
        return SqlKeyGenerator$.MODULE$.getRealKeyGenClassName(typedProperties);
    }

    public static String ORIGIN_KEYGEN_CLASS_NAME() {
        return SqlKeyGenerator$.MODULE$.ORIGIN_KEYGEN_CLASS_NAME();
    }

    public static String PARTITION_SCHEMA() {
        return SqlKeyGenerator$.MODULE$.PARTITION_SCHEMA();
    }

    private Option<StructType> partitionSchema$lzycompute() {
        SqlKeyGenerator sqlKeyGenerator = this;
        synchronized (sqlKeyGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String partitionSchema = this.props.getString(SqlKeyGenerator$.MODULE$.PARTITION_SCHEMA(), "");
                this.partitionSchema = partitionSchema != null && new StringOps(Predef$.MODULE$.augmentString(partitionSchema)).nonEmpty() ? new Some((Object)StructType$.MODULE$.fromDDL(partitionSchema)) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.partitionSchema;
    }

    private Option<StructType> partitionSchema() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.partitionSchema$lzycompute() : this.partitionSchema;
    }

    private Option<KeyGenerator> originKeyGen$lzycompute() {
        SqlKeyGenerator sqlKeyGenerator = this;
        synchronized (sqlKeyGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                None$ none$;
                String beforeKeyGenClassName = this.props.getString(SqlKeyGenerator$.MODULE$.ORIGIN_KEYGEN_CLASS_NAME(), null);
                if (beforeKeyGenClassName != null) {
                    TypedProperties keyGenProps = new TypedProperties();
                    keyGenProps.putAll((Map)this.props);
                    keyGenProps.remove((Object)SqlKeyGenerator$.MODULE$.ORIGIN_KEYGEN_CLASS_NAME());
                    String convertedKeyGenClassName = SqlKeyGenerator$.MODULE$.getRealKeyGenClassName(this.props);
                    keyGenProps.put((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), (Object)convertedKeyGenClassName);
                    none$ = new Some((Object)KeyGenUtils.createKeyGeneratorByClassName((TypedProperties)keyGenProps));
                } else {
                    none$ = None$.MODULE$;
                }
                this.originKeyGen = none$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.originKeyGen;
    }

    private Option<KeyGenerator> originKeyGen() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.originKeyGen$lzycompute() : this.originKeyGen;
    }

    public String getRecordKey(GenericRecord record) {
        return this.originKeyGen().isDefined() ? ((KeyGenerator)this.originKeyGen().get()).getKey(record).getRecordKey() : super.getRecordKey(record);
    }

    public String getRecordKey(Row row) {
        return this.originKeyGen().isDefined() ? ((SparkKeyGeneratorInterface)this.originKeyGen().get()).getRecordKey(row) : super.getRecordKey(row);
    }

    private String convertPartitionPathToSqlType(String partitionPath, boolean rowType) {
        String[] partitionFragments;
        return this.partitionSchema().isDefined() ? (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(partitionFragments = partitionPath.split("/")))).size() != ((SeqLike)this.partitionSchema().get()).size() ? partitionPath : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionFragments)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])((StructType)this.partitionSchema().get()).fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField partitionField;
                String hiveStylePrefix;
                String partitionValue = (String)tuple2._1();
                boolean isHiveStyle = partitionValue.startsWith(hiveStylePrefix = new StringBuilder(1).append((partitionField = (StructField)tuple2._2()).name()).append("=").toString());
                String _partitionValue = isHiveStyle ? partitionValue.substring(hiveStylePrefix.length()) : partitionValue;
                DataType dataType = partitionField.dataType();
                if (TimestampType$.MODULE$.equals(dataType)) {
                    long timeMs = rowType ? SqlKeyGenerator$.MODULE$.org$apache$spark$sql$hudi$command$SqlKeyGenerator$$sqlTimestampFormat().parseMillis(_partitionValue) : TimeUnit.MILLISECONDS.convert(new StringOps(Predef$.MODULE$.augmentString(_partitionValue)).toLong(), TimeUnit.MICROSECONDS);
                    String timestampFormat = PartitionPathEncodeUtils.escapePathName((String)SqlKeyGenerator$.MODULE$.org$apache$spark$sql$hudi$command$SqlKeyGenerator$$timestampTimeFormat().print(timeMs));
                    string = isHiveStyle ? new StringBuilder(0).append(hiveStylePrefix).append(timestampFormat).toString() : timestampFormat;
                } else {
                    string = partitionValue;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            String string2 = string;
            return string2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("/")) : partitionPath;
    }

    public String getPartitionPath(GenericRecord record) {
        String partitionPath = super.getPartitionPath(record);
        return this.convertPartitionPathToSqlType(partitionPath, false);
    }

    public String getPartitionPath(Row row) {
        String partitionPath = super.getPartitionPath(row);
        return this.convertPartitionPathToSqlType(partitionPath, true);
    }

    public SqlKeyGenerator(TypedProperties props) {
        this.props = props;
        super(props);
    }
}

