/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.ScalaAssertionSupport;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.GlobalDeleteKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.hudi.testutils.KeyGeneratorTestUtilities;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001\u0002\u00192\u0001aBQ!\u0010\u0001\u0005\u0002yBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004I\u0001\u0001\u0006IA\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0011\u0019)\u0006\u0001)A\u0005\u0017\"Ia\u000b\u0001a\u0001\u0002\u0004%\ta\u0016\u0005\n=\u0002\u0001\r\u00111A\u0005\u0002}C\u0011\u0002\u001b\u0001A\u0002\u0003\u0005\u000b\u0015\u0002-\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0003Q\u0007\"C8\u0001\u0001\u0004\u0005\r\u0011\"\u0001q\u0011%\u0011\b\u00011A\u0001B\u0003&1\u000eC\u0005t\u0001\u0001\u0007\t\u0019!C\u0001i\"I1\u0010\u0001a\u0001\u0002\u0004%\t\u0001 \u0005\n}\u0002\u0001\r\u0011!Q!\nUD\u0001b \u0001C\u0002\u0013\u0005\u0011\u0011\u0001\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\u0004!I\u0011Q\u0003\u0001C\u0002\u0013\u0005\u0011\u0011\u0001\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\u0004!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u001a\u0001\u0011%\u0011Q\u0007\u0005\b\u0003O\u0002A\u0011AA\u000e\u0011\u001d\t\t\b\u0001C\u0001\u000371a!!\u001e\u0001\u0001\u0005]\u0004BCAF/\t\u0005\t\u0015!\u0003\u00028!1Qh\u0006C\u0001\u0003\u001bC\u0011\"!&\u0018\u0005\u0004%\t!a&\t\u0011\u0005eu\u0003)A\u0005\u0003\u0017B\u0011\"a'\u0018\u0005\u0004%\t!a&\t\u0011\u0005uu\u0003)A\u0005\u0003\u0017B\u0011\"a(\u0018\u0005\u0004%\t!a&\t\u0011\u0005\u0005v\u0003)A\u0005\u0003\u0017B\u0011\"a)\u0018\u0005\u0004%\t!a&\t\u0011\u0005\u0015v\u0003)A\u0005\u0003\u0017B1\"a*\u0018\u0001\u0004\u0005\r\u0011\"\u0001\u0002*\"Y\u0011\u0011W\fA\u0002\u0003\u0007I\u0011AAZ\u0011-\t9l\u0006a\u0001\u0002\u0003\u0006K!a+\t\u000f\u0005ev\u0003\"\u0011\u0002<\"9\u0011QZ\f\u0005B\u0005=\u0007bBAg/\u0011\u0005\u0013Q\u001b\u0005\b\u0003S<B\u0011IAv\u0011\u001d\tIo\u0006C!\u0003_Dq!!>\u0001\t\u0003\tY\u0002C\u0004\u0002z\u0002!\t!a\u0007\t\u000f\u0005u\b\u0001\"\u0001\u0002\u001c!9!\u0011\u0001\u0001\u0005\u0002\u0005m\u0001b\u0002B\u0003\u0001\u0011\u0005\u00111\u0004\u0005\b\u0005\u0013\u0001A\u0011AA\u000e\u0005Y!Vm\u001d;ECR\f7k\\;sG\u0016$UMZ1vYR\u001c(B\u0001\u001a4\u0003\u0011AW\u000fZ5\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\b\u0005\u0002;w5\t\u0011'\u0003\u0002=c\t)2kY1mC\u0006\u001b8/\u001a:uS>t7+\u001e9q_J$\u0018A\u0002\u001fj]&$h\bF\u0001@!\tQ\u0004!\u0001\u0004tG\",W.Y\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011QiM\u0001\u0005CZ\u0014x.\u0003\u0002H\t\n11k\u00195f[\u0006\fqa]2iK6\f\u0007%\u0001\u0006tiJ,8\r\u001e+za\u0016,\u0012a\u0013\t\u0003\u0019Nk\u0011!\u0014\u0006\u0003\u001d>\u000bQ\u0001^=qKNT!\u0001U)\u0002\u0007M\fHN\u0003\u0002Sg\u0005)1\u000f]1sW&\u0011A+\u0014\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017aC:ueV\u001cG\u000fV=qK\u0002\n!BY1tKJ+7m\u001c:e+\u0005A\u0006CA-]\u001b\u0005Q&BA.E\u0003\u001d9WM\\3sS\u000eL!!\u0018.\u0003\u001b\u001d+g.\u001a:jGJ+7m\u001c:e\u00039\u0011\u0017m]3SK\u000e|'\u000fZ0%KF$\"\u0001\u00194\u0011\u0005\u0005$W\"\u00012\u000b\u0003\r\fQa]2bY\u0006L!!\u001a2\u0003\tUs\u0017\u000e\u001e\u0005\bO\u001e\t\t\u00111\u0001Y\u0003\rAH%M\u0001\fE\u0006\u001cXMU3d_J$\u0007%A\u0004cCN,'k\\<\u0016\u0003-\u0004\"\u0001\\7\u000e\u0003=K!A\\(\u0003\u0007I{w/A\u0006cCN,'k\\<`I\u0015\fHC\u00011r\u0011\u001d9'\"!AA\u0002-\f\u0001BY1tKJ{w\u000fI\u0001\fS:$XM\u001d8bYJ{w/F\u0001v!\t1\u00180D\u0001x\u0015\tAx*\u0001\u0005dCR\fG._:u\u0013\tQxOA\u0006J]R,'O\\1m%><\u0018aD5oi\u0016\u0014h.\u00197S_^|F%Z9\u0015\u0005\u0001l\bbB4\u000e\u0003\u0003\u0005\r!^\u0001\rS:$XM\u001d8bYJ{w\u000fI\u0001\u000fi\u0016\u001cHo\u0015;sk\u000e$h*Y7f+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\tAA[1wC&!\u0011\u0011CA\u0004\u0005\u0019\u0019FO]5oO\u0006yA/Z:u'R\u0014Xo\u0019;OC6,\u0007%A\u0007uKN$h*Y7fgB\f7-Z\u0001\u000fi\u0016\u001cHOT1nKN\u0004\u0018mY3!\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0002A\"\u001a1#a\b\u0011\t\u0005\u0005\u0012qF\u0007\u0003\u0003GQA!!\n\u0002(\u0005\u0019\u0011\r]5\u000b\t\u0005%\u00121F\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\ti#N\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003c\t\u0019C\u0001\u0006CK\u001a|'/Z#bG\"\fAbZ3u\u0017\u0016L8i\u001c8gS\u001e$\u0002\"a\u000e\u0002H\u0005}\u00131\r\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003\u0019\u0019wN\u001c4jO*\u0019\u0011\u0011I\u0019\u0002\r\r|W.\\8o\u0013\u0011\t)%a\u000f\u0003\u001fQK\b/\u001a3Qe>\u0004XM\u001d;jKNDq!!\u0013\u0015\u0001\u0004\tY%\u0001\nsK\u000e|'\u000fZ&fs\u001aKW\r\u001c3OC6,\u0007\u0003BA'\u00037rA!a\u0014\u0002XA\u0019\u0011\u0011\u000b2\u000e\u0005\u0005M#bAA+o\u00051AH]8pizJ1!!\u0017c\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011CA/\u0015\r\tIF\u0019\u0005\b\u0003C\"\u0002\u0019AA&\u0003I\u0001\u0018M\u001d;ji&|g\u000eU1uQ\u001aKW\r\u001c3\t\u000f\u0005\u0015D\u00031\u0001\u0002L\u0005)\u0002.\u001b<f'RLH.\u001a)beRLG/[8oS:<\u0017A\u0006;fgR\u001c\u0016.\u001c9mK.+\u0017pR3oKJ\fGo\u001c:)\u0007U\tY\u0007\u0005\u0003\u0002\"\u00055\u0014\u0002BA8\u0003G\u0011A\u0001V3ti\u0006AC/Z:u+N,'\u000fR3gS:,GmS3z\u000f\u0016tWM]1u_J<vN]6t/&$\bNU8xg\"\u001aa#a\u001b\u0003/U\u001bXM\u001d#fM&tW\rZ&fs\u001e+g.\u001a:bi>\u00148#B\f\u0002z\u0005\u0015\u0005\u0003BA>\u0003\u0003k!!! \u000b\u0007\u0005}\u0014'\u0001\u0004lKf<WM\\\u0005\u0005\u0003\u0007\u000biH\u0001\u0007LKf<UM\\3sCR|'\u000f\u0005\u0003\u0002|\u0005\u001d\u0015\u0002BAE\u0003{\u0012!d\u00159be.\\U-_$f]\u0016\u0014\u0018\r^8s\u0013:$XM\u001d4bG\u0016\fQ\u0001\u001d:paN$B!a$\u0002\u0014B\u0019\u0011\u0011S\f\u000e\u0003\u0001Aq!a#\u001a\u0001\u0004\t9$A\u0007sK\u000e|'\u000fZ&fsB\u0013x\u000e]\u000b\u0003\u0003\u0017\naB]3d_J$7*Z=Qe>\u0004\b%A\tqCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b)s_B\f!\u0003]1si&$\u0018n\u001c8QCRD\u0007K]8qA\u0005Y1\u000b\u0016*V\u0007R{f*Q'F\u00031\u0019FKU+D)~s\u0015)T#!\u0003%q\u0015)T#T!\u0006\u001bU)\u0001\u0006O\u00036+5\u000bU!D\u000b\u0002\n1bY8om\u0016\u0014H/\u001a:G]V\u0011\u00111\u0016\t\u0006C\u000656\u000eW\u0005\u0004\u0003_\u0013'!\u0003$v]\u000e$\u0018n\u001c82\u0003=\u0019wN\u001c<feR,'O\u00128`I\u0015\fHc\u00011\u00026\"AqmIA\u0001\u0002\u0004\tY+\u0001\u0007d_:4XM\u001d;fe\u001as\u0007%\u0001\u0004hKR\\U-\u001f\u000b\u0005\u0003{\u000bI\r\u0005\u0003\u0002@\u0006\u0015WBAAa\u0015\u0011\t\u0019-a\u0010\u0002\u000b5|G-\u001a7\n\t\u0005\u001d\u0017\u0011\u0019\u0002\n\u0011>|G-[3LKfDa!a3&\u0001\u0004A\u0016A\u0002:fG>\u0014H-\u0001\u0007hKR\u0014VmY8sI.+\u0017\u0010\u0006\u0003\u0002L\u0005E\u0007BBAjM\u0001\u00071.A\u0002s_^$b!a6\u0002f\u0006\u001d\b\u0003BAm\u0003Cl!!a7\u000b\u00079\u000biNC\u0002\u0002`F\u000ba!\u001e8tC\u001a,\u0017\u0002BAr\u00037\u0014!\"\u0016+GqM#(/\u001b8h\u0011\u0019\t\u0019n\na\u0001k\")\u0001i\na\u0001\u0017\u0006\u0001r-\u001a;QCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b\u000b\u0005\u0003\u0017\ni\u000f\u0003\u0004\u0002T\"\u0002\ra\u001b\u000b\u0007\u0003/\f\t0a=\t\u000bML\u0003\u0019A;\t\u000b%K\u0003\u0019A&\u0002/Q,7\u000f^\"p[BdW\r_&fs\u001e+g.\u001a:bi>\u0014\bf\u0001\u0016\u0002l\u0005aB/Z:u\u000f2|'-\u00197EK2,G/Z&fs\u001e+g.\u001a:bi>\u0014\bfA\u0016\u0002l\u0005\u0011C/Z:u\u001fZ,'o\u001e:ji\u0016<\u0016\u000e\u001e5MCR,7\u000f^!we>\u0004\u0016-\u001f7pC\u0012D3\u0001LA6\u0003i\"Xm\u001d;Pm\u0016\u0014xO]5uK^KG\u000f\u001b'bi\u0016\u001cH/\u0011<s_B\u000b\u0017\u0010\\8bI\u000e{WNY5oK\u0006sGmR3u+B$\u0017\r^3WC2,X\rK\u0002.\u0003W\na\u0007^3ti\u0012+g-Y;mi\"{w\u000eZ5f%\u0016\u001cwN\u001d3QCfdw.\u00193D_6\u0014\u0017N\\3B]\u0012<U\r^+qI\u0006$XMV1mk\u0016D3ALA6\u0003q!Xm\u001d;F[B$\u0018\u0010S8pI&,'+Z2pe\u0012\u0004\u0016-\u001f7pC\u0012D3aLA6\u0001")
public class TestDataSourceDefaults
extends ScalaAssertionSupport {
    private final Schema schema = SchemaTestUtil.getComplexEvolvedSchema();
    private final StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(this.schema());
    private GenericRecord baseRecord;
    private Row baseRow;
    private InternalRow internalRow;
    private final String testStructName;
    private final String testNamespace;

    public Schema schema() {
        return this.schema;
    }

    public StructType structType() {
        return this.structType;
    }

    public GenericRecord baseRecord() {
        return this.baseRecord;
    }

    public void baseRecord_$eq(GenericRecord x$1) {
        this.baseRecord = x$1;
    }

    public Row baseRow() {
        return this.baseRow;
    }

    public void baseRow_$eq(Row x$1) {
        this.baseRow = x$1;
    }

    public InternalRow internalRow() {
        return this.internalRow;
    }

    public void internalRow_$eq(InternalRow x$1) {
        this.internalRow = x$1;
    }

    public String testStructName() {
        return this.testStructName;
    }

    public String testNamespace() {
        return this.testNamespace;
    }

    @BeforeEach
    public void initialize() {
        this.baseRecord_$eq(SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)1, (String)"001", (String)"f1"));
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
    }

    private TypedProperties getKeyConfig(String recordKeyFieldName, String partitionPathField, String hiveStylePartitioning) {
        TypedProperties props = new TypedProperties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), recordKeyFieldName);
        props.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), partitionPathField);
        props.setProperty(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), hiveStylePartitioning);
        return props;
    }

    @Test
    public void testSimpleKeyGenerator() {
        SimpleKeyGenerator keyGen = new SimpleKeyGenerator(this.getKeyConfig("field1", "name", "false"));
        HoodieKey expectedKey = new HoodieKey("field1", "name1");
        Assertions.assertEquals((Object)expectedKey, (Object)keyGen.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey.getRecordKey(), (Object)keyGen.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey.getPartitionPath(), (Object)keyGen.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getRecordKey()), (Object)keyGen.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getPartitionPath()), (Object)keyGen.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props = new TypedProperties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1");
        this.assertThrows(IllegalArgumentException.class, (Function0 & Serializable & scala.Serializable)() -> new SimpleKeyGenerator(props));
        TypedProperties props2 = new TypedProperties();
        props2.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionField");
        this.assertThrows(IllegalArgumentException.class, (Function0 & Serializable & scala.Serializable)() -> new SimpleKeyGenerator(props2));
        SimpleKeyGenerator keyGen2 = new SimpleKeyGenerator(this.getKeyConfig("testNestedRecord.userId", "testNestedRecord.isAdmin", "false"));
        Assertions.assertEquals((Object)new HoodieKey("UserId1@001", "false"), (Object)keyGen2.getKey(this.baseRecord()));
        SimpleKeyGenerator keyGen3 = new SimpleKeyGenerator(this.getKeyConfig("testNestedRecord.NotThere", "testNestedRecord.isAdmin", "false"));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen3.getKey(this.baseRecord()));
        SimpleKeyGenerator keyGen4 = new SimpleKeyGenerator(this.getKeyConfig("testNestedRecord.userId", "testNestedRecord.notThere", "false"));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen4.getPartitionPath(this.baseRow()));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen4.getPartitionPath(this.internalRow(), this.structType()));
        SimpleKeyGenerator keyGen5 = new SimpleKeyGenerator(this.getKeyConfig("field1", "name", "true"));
        Assertions.assertEquals((Object)"name=name1", (Object)keyGen5.getKey(this.baseRecord()).getPartitionPath());
        Assertions.assertEquals((Object)"name=name1", (Object)keyGen5.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)"name=name1"), (Object)keyGen5.getPartitionPath(this.internalRow(), this.structType()));
        SimpleKeyGenerator keyGen6 = new SimpleKeyGenerator(this.getKeyConfig("field1", "name", "false"));
        this.baseRecord().put("name", (Object)"");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        Assertions.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)keyGen6.getKey(this.baseRecord()).getPartitionPath());
        Assertions.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)keyGen6.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)"__HIVE_DEFAULT_PARTITION__"), (Object)keyGen6.getPartitionPath(this.internalRow(), this.structType()));
        this.baseRecord().put("name", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        Assertions.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)keyGen6.getKey(this.baseRecord()).getPartitionPath());
        Assertions.assertEquals((Object)"__HIVE_DEFAULT_PARTITION__", (Object)keyGen6.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)"__HIVE_DEFAULT_PARTITION__"), (Object)keyGen6.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props3 = new TypedProperties();
        props3.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1");
        props3.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "name");
        SimpleKeyGenerator keyGen7 = new SimpleKeyGenerator(props3);
        this.baseRecord().put("field1", (Object)"");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen7.getKey(this.baseRecord()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen7.getRecordKey(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen7.getRecordKey(this.internalRow(), this.structType()));
        this.baseRecord().put("field1", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen7.getKey(this.baseRecord()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen7.getRecordKey(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen7.getRecordKey(this.internalRow(), this.structType()));
    }

    @Test
    public void testUserDefinedKeyGeneratorWorksWithRows() {
        UserDefinedKeyGenerator keyGen = new UserDefinedKeyGenerator(this.getKeyConfig("field1", "name", "false"));
        Assertions.assertEquals((Object)"field1", (Object)keyGen.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)"name1", (Object)keyGen.getPartitionPath(this.baseRow()));
    }

    @Test
    public void testComplexKeyGenerator() {
        ComplexKeyGenerator keyGen = new ComplexKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        HoodieKey expectedKey = new HoodieKey("field1:field1,name:name1", "field1/name1");
        Assertions.assertEquals((Object)expectedKey, (Object)keyGen.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey.getRecordKey(), (Object)keyGen.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey.getPartitionPath(), (Object)keyGen.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getRecordKey()), (Object)keyGen.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getPartitionPath()), (Object)keyGen.getPartitionPath(this.internalRow(), this.structType()));
        this.assertThrows(IllegalArgumentException.class, (Function0 & Serializable & scala.Serializable)() -> {
            TypedProperties props = new TypedProperties();
            props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1");
            ComplexKeyGenerator keyGen = new ComplexKeyGenerator(props);
            keyGen.getKey(this.baseRecord());
            keyGen.getRecordKey(this.baseRow());
            return keyGen.getRecordKey(this.internalRow(), this.structType());
        });
        this.assertThrows(IllegalArgumentException.class, (Function0 & Serializable & scala.Serializable)() -> {
            TypedProperties props = new TypedProperties();
            props.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionField");
            ComplexKeyGenerator keyGen = new ComplexKeyGenerator(props);
            keyGen.getKey(this.baseRecord());
            keyGen.getPartitionPath(this.baseRow());
            return keyGen.getPartitionPath(this.internalRow(), this.structType());
        });
        ComplexKeyGenerator keyGen2 = new ComplexKeyGenerator(this.getKeyConfig("testNestedRecord.userId,testNestedRecord.isAdmin", "testNestedRecord.userId,testNestedRecord.isAdmin", "false"));
        HoodieKey expectedKey2 = new HoodieKey("testNestedRecord.userId:UserId1@001,testNestedRecord.isAdmin:false", "UserId1@001/false");
        Assertions.assertEquals((Object)expectedKey2, (Object)keyGen2.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey2.getRecordKey(), (Object)keyGen2.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey2.getPartitionPath(), (Object)keyGen2.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey2.getRecordKey()), (Object)keyGen2.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey2.getPartitionPath()), (Object)keyGen2.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen3 = new ComplexKeyGenerator(this.getKeyConfig("testNestedRecord.NotThere", "testNestedRecord.isAdmin", "false"));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen3.getKey(this.baseRecord()));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen3.getRecordKey(this.baseRow()));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen3.getRecordKey(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen4 = new ComplexKeyGenerator(this.getKeyConfig("testNestedRecord.userId", "testNestedRecord.notThere", "false"));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen4.getPartitionPath(this.baseRow()));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen4.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen5 = new ComplexKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "true"));
        HoodieKey expectedKey3 = new HoodieKey("field1:field1,name:name1", "field1=field1/name=name1");
        Assertions.assertEquals((Object)expectedKey3, (Object)keyGen5.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey3.getRecordKey(), (Object)keyGen5.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey3.getPartitionPath(), (Object)keyGen5.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey3.getRecordKey()), (Object)keyGen5.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey3.getPartitionPath()), (Object)keyGen5.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen6 = new ComplexKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        this.baseRecord().put("name", (Object)"");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        HoodieKey expectedKey4 = new HoodieKey("field1:field1,name:__empty__", "field1/__HIVE_DEFAULT_PARTITION__");
        Assertions.assertEquals((Object)expectedKey4, (Object)keyGen6.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey4.getRecordKey(), (Object)keyGen6.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey4.getPartitionPath(), (Object)keyGen6.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey4.getRecordKey()), (Object)keyGen6.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey4.getPartitionPath()), (Object)keyGen6.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen7 = new ComplexKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        this.baseRecord().put("name", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        HoodieKey expectedKey5 = new HoodieKey("field1:field1,name:__null__", "field1/__HIVE_DEFAULT_PARTITION__");
        Assertions.assertEquals((Object)expectedKey5, (Object)keyGen7.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey5.getRecordKey(), (Object)keyGen7.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey5.getPartitionPath(), (Object)keyGen7.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey5.getRecordKey()), (Object)keyGen7.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey5.getPartitionPath()), (Object)keyGen7.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props = new TypedProperties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1,name");
        props.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "field1,name");
        ComplexKeyGenerator keyGen8 = new ComplexKeyGenerator(props);
        this.baseRecord().put("name", (Object)"");
        this.baseRecord().put("field1", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen8.getKey(this.baseRecord()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen8.getRecordKey(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen8.getRecordKey(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen9 = new ComplexKeyGenerator(this.getKeyConfig("field1, name", "field1, name", "false"));
        this.baseRecord().put("name", (Object)"name1");
        this.baseRecord().put("field1", (Object)"field1");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        HoodieKey expectedKey6 = new HoodieKey("field1:field1,name:name1", "field1/name1");
        Assertions.assertEquals((Object)expectedKey6, (Object)keyGen9.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey6.getRecordKey(), (Object)keyGen9.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey6.getPartitionPath(), (Object)keyGen9.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey6.getRecordKey()), (Object)keyGen9.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey6.getPartitionPath()), (Object)keyGen9.getPartitionPath(this.internalRow(), this.structType()));
        ComplexKeyGenerator keyGen10 = new ComplexKeyGenerator(this.getKeyConfig("field1,", "field1,", "false"));
        HoodieKey expectedKey7 = new HoodieKey("field1:field1", "field1");
        Assertions.assertEquals((Object)expectedKey7, (Object)keyGen10.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey7.getRecordKey(), (Object)keyGen10.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey7.getPartitionPath(), (Object)keyGen10.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey7.getRecordKey()), (Object)keyGen10.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey7.getPartitionPath()), (Object)keyGen10.getPartitionPath(this.internalRow(), this.structType()));
    }

    @Test
    public void testGlobalDeleteKeyGenerator() {
        GlobalDeleteKeyGenerator keyGen = new GlobalDeleteKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        HoodieKey expectedKey = new HoodieKey("field1:field1,name:name1", "");
        Assertions.assertEquals((Object)expectedKey, (Object)keyGen.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey.getRecordKey(), (Object)keyGen.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey.getPartitionPath(), (Object)keyGen.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getRecordKey()), (Object)keyGen.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey.getPartitionPath()), (Object)keyGen.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props = new TypedProperties();
        props.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1,name");
        GlobalDeleteKeyGenerator keyGen2 = new GlobalDeleteKeyGenerator(props);
        HoodieKey expectedKey2 = new HoodieKey("field1:field1,name:name1", "");
        Assertions.assertEquals((Object)expectedKey2, (Object)keyGen2.getKey(this.baseRecord()));
        Assertions.assertEquals((Object)expectedKey2.getRecordKey(), (Object)keyGen2.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey2.getPartitionPath(), (Object)keyGen2.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey2.getRecordKey()), (Object)keyGen2.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey2.getPartitionPath()), (Object)keyGen2.getPartitionPath(this.internalRow(), this.structType()));
        this.baseRecord().put("name", (Object)"");
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        GlobalDeleteKeyGenerator keyGen3 = new GlobalDeleteKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        HoodieKey expectedKey3 = new HoodieKey("field1:field1,name:__empty__", "");
        Assertions.assertEquals((Object)expectedKey3.getRecordKey(), (Object)keyGen3.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey3.getPartitionPath(), (Object)keyGen3.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey3.getRecordKey()), (Object)keyGen3.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey3.getPartitionPath()), (Object)keyGen3.getPartitionPath(this.internalRow(), this.structType()));
        this.baseRecord().put("name", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        GlobalDeleteKeyGenerator keyGen4 = new GlobalDeleteKeyGenerator(this.getKeyConfig("field1,name", "field1,name", "false"));
        HoodieKey expectedKey4 = new HoodieKey("field1:field1,name:__null__", "");
        Assertions.assertEquals((Object)expectedKey4.getRecordKey(), (Object)keyGen4.getRecordKey(this.baseRow()));
        Assertions.assertEquals((Object)expectedKey4.getPartitionPath(), (Object)keyGen4.getPartitionPath(this.baseRow()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey4.getRecordKey()), (Object)keyGen4.getRecordKey(this.internalRow(), this.structType()));
        Assertions.assertEquals((Object)UTF8String.fromString((String)expectedKey4.getPartitionPath()), (Object)keyGen4.getPartitionPath(this.internalRow(), this.structType()));
        TypedProperties props2 = new TypedProperties();
        props2.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionField");
        this.assertThrows(IllegalArgumentException.class, (Function0 & Serializable & scala.Serializable)() -> new GlobalDeleteKeyGenerator(props2));
        GlobalDeleteKeyGenerator keyGen5 = new GlobalDeleteKeyGenerator(this.getKeyConfig("testNestedRecord.NotThere", "testNestedRecord.isAdmin", "false"));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen5.getKey(this.baseRecord()));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen5.getRecordKey(this.baseRow()));
        this.assertThrows(HoodieException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen5.getRecordKey(this.internalRow(), this.structType()));
        TypedProperties props3 = new TypedProperties();
        props3.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "field1,name");
        GlobalDeleteKeyGenerator keyGen6 = new GlobalDeleteKeyGenerator(props3);
        this.baseRecord().put("name", (Object)"");
        this.baseRecord().put("field1", null);
        this.baseRow_$eq(KeyGeneratorTestUtilities.getRow(this.baseRecord(), this.schema(), this.structType()));
        this.internalRow_$eq(KeyGeneratorTestUtilities.getInternalRow(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen6.getKey(this.baseRecord()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen6.getRecordKey(this.baseRow()));
        this.assertThrows(HoodieKeyException.class, (Function0 & Serializable & scala.Serializable)() -> keyGen6.getRecordKey(this.internalRow(), this.structType()));
    }

    @Test
    public void testOverwriteWithLatestAvroPayload() {
        OverwriteWithLatestAvroPayload overWritePayload1 = new OverwriteWithLatestAvroPayload(this.baseRecord(), (Comparable)Predef$.MODULE$.int2Integer(1));
        GenericRecord laterRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)2, (String)"001", (String)"f1");
        OverwriteWithLatestAvroPayload overWritePayload2 = new OverwriteWithLatestAvroPayload(laterRecord, (Comparable)Predef$.MODULE$.int2Integer(2));
        OverwriteWithLatestAvroPayload combinedPayload12 = overWritePayload1.preCombine(overWritePayload2);
        GenericRecord combinedGR12 = (GenericRecord)combinedPayload12.getInsertValue(this.schema()).get();
        Assertions.assertEquals((Object)"field2", (Object)combinedGR12.get("field1").toString());
        OverwriteWithLatestAvroPayload combinedPayload21 = overWritePayload2.preCombine(overWritePayload1);
        GenericRecord combinedGR21 = (GenericRecord)combinedPayload21.getInsertValue(this.schema()).get();
        Assertions.assertEquals((Object)"field2", (Object)combinedGR21.get("field1").toString());
    }

    @Test
    public void testOverwriteWithLatestAvroPayloadCombineAndGetUpdateValue() {
        Object baseOrderingVal = this.baseRecord().get("favoriteIntNumber");
        Schema fieldSchema = this.baseRecord().getSchema().getField("favoriteIntNumber").schema();
        TypedProperties props = new TypedProperties();
        props.put((Object)"hoodie.payload.ordering.field", (Object)"favoriteIntNumber");
        OverwriteWithLatestAvroPayload basePayload = new OverwriteWithLatestAvroPayload(this.baseRecord(), (Comparable)HoodieAvroUtils.convertValueForSpecificDataTypes((Schema)fieldSchema, (Object)baseOrderingVal, (boolean)false));
        GenericRecord laterRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)2, (String)"001", (String)"f1");
        Object laterOrderingVal = laterRecord.get("favoriteIntNumber");
        OverwriteWithLatestAvroPayload newerPayload = new OverwriteWithLatestAvroPayload(laterRecord, (Comparable)HoodieAvroUtils.convertValueForSpecificDataTypes((Schema)fieldSchema, (Object)laterOrderingVal, (boolean)false));
        OverwriteWithLatestAvroPayload preCombinedPayload = basePayload.preCombine(newerPayload);
        GenericRecord precombinedGR = (GenericRecord)preCombinedPayload.getInsertValue(this.schema()).get();
        Assertions.assertEquals((Object)"field2", (Object)precombinedGR.get("field1").toString());
    }

    @Test
    public void testDefaultHoodieRecordPayloadCombineAndGetUpdateValue() {
        Schema fieldSchema = this.baseRecord().getSchema().getField("favoriteIntNumber").schema();
        TypedProperties props = HoodiePayloadConfig.newBuilder().withPayloadOrderingField("favoriteIntNumber").build().getProps();
        GenericRecord laterRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)2, (String)"001", (String)"f1");
        Object laterOrderingVal = laterRecord.get("favoriteIntNumber");
        GenericRecord earlierRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)1, (String)"000", (String)"f1");
        Object earlierOrderingVal = earlierRecord.get("favoriteIntNumber");
        DefaultHoodieRecordPayload laterPayload = new DefaultHoodieRecordPayload(laterRecord, (Comparable)HoodieAvroUtils.convertValueForSpecificDataTypes((Schema)fieldSchema, (Object)laterOrderingVal, (boolean)false));
        DefaultHoodieRecordPayload earlierPayload = new DefaultHoodieRecordPayload(earlierRecord, (Comparable)HoodieAvroUtils.convertValueForSpecificDataTypes((Schema)fieldSchema, (Object)earlierOrderingVal, (boolean)false));
        OverwriteWithLatestAvroPayload preCombinedPayload = laterPayload.preCombine((OverwriteWithLatestAvroPayload)earlierPayload);
        GenericRecord precombinedGR = (GenericRecord)preCombinedPayload.getInsertValue(this.schema()).get();
        Assertions.assertEquals((Object)"field2", (Object)precombinedGR.get("field1").toString());
        Assertions.assertEquals((Object)laterOrderingVal, (Object)precombinedGR.get("favoriteIntNumber"));
        Option earlierWithLater = earlierPayload.combineAndGetUpdateValue((IndexedRecord)laterRecord, this.schema(), (Properties)props);
        GenericRecord earlierwithLaterGR = (GenericRecord)earlierWithLater.get();
        Assertions.assertEquals((Object)"field2", (Object)earlierwithLaterGR.get("field1").toString());
        Assertions.assertEquals((Object)laterOrderingVal, (Object)earlierwithLaterGR.get("favoriteIntNumber"));
        Option laterWithEarlier = laterPayload.combineAndGetUpdateValue((IndexedRecord)earlierRecord, this.schema(), (Properties)props);
        GenericRecord laterWithEarlierGR = (GenericRecord)laterWithEarlier.get();
        Assertions.assertEquals((Object)"field2", (Object)laterWithEarlierGR.get("field1").toString());
        Assertions.assertEquals((Object)laterOrderingVal, (Object)laterWithEarlierGR.get("favoriteIntNumber"));
    }

    @Test
    public void testEmptyHoodieRecordPayload() {
        EmptyHoodieRecordPayload emptyPayload1 = new EmptyHoodieRecordPayload(this.baseRecord(), (Comparable)Predef$.MODULE$.int2Integer(1));
        GenericRecord laterRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema(), (int)2, (String)"001", (String)"f1");
        EmptyHoodieRecordPayload emptyPayload2 = new EmptyHoodieRecordPayload(laterRecord, (Comparable)Predef$.MODULE$.int2Integer(2));
        EmptyHoodieRecordPayload combinedPayload12 = emptyPayload1.preCombine(emptyPayload2);
        Option combined12 = combinedPayload12.getInsertValue(this.schema());
        Assertions.assertEquals((Object)Option.empty(), (Object)combined12);
    }

    public TestDataSourceDefaults() {
        this.testStructName = "testStructName";
        this.testNamespace = "testNamespace";
    }

    public class UserDefinedKeyGenerator
    extends KeyGenerator
    implements SparkKeyGeneratorInterface {
        private final String recordKeyProp;
        private final String partitionPathProp;
        private final String STRUCT_NAME;
        private final String NAMESPACE;
        private Function1<Row, GenericRecord> converterFn;

        public String recordKeyProp() {
            return this.recordKeyProp;
        }

        public String partitionPathProp() {
            return this.partitionPathProp;
        }

        public String STRUCT_NAME() {
            return this.STRUCT_NAME;
        }

        public String NAMESPACE() {
            return this.NAMESPACE;
        }

        public Function1<Row, GenericRecord> converterFn() {
            return this.converterFn;
        }

        public void converterFn_$eq(Function1<Row, GenericRecord> x$1) {
            this.converterFn = x$1;
        }

        public HoodieKey getKey(GenericRecord record) {
            return new HoodieKey(HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)this.recordKeyProp(), (boolean)true, (boolean)false), HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)this.partitionPathProp(), (boolean)true, (boolean)false));
        }

        public String getRecordKey(Row row) {
            if (this.converterFn() == null) {
                this.converterFn_$eq((Function1<Row, GenericRecord>)AvroConversionUtils$.MODULE$.createConverterToAvro(row.schema(), this.STRUCT_NAME(), this.NAMESPACE()));
            }
            GenericRecord genericRecord = (GenericRecord)this.converterFn().apply((Object)row);
            return this.getKey(genericRecord).getRecordKey();
        }

        public UTF8String getRecordKey(InternalRow row, StructType schema) {
            return null;
        }

        public String getPartitionPath(Row row) {
            if (this.converterFn() == null) {
                this.converterFn_$eq((Function1<Row, GenericRecord>)AvroConversionUtils$.MODULE$.createConverterToAvro(row.schema(), this.STRUCT_NAME(), this.NAMESPACE()));
            }
            GenericRecord genericRecord = (GenericRecord)this.converterFn().apply((Object)row);
            return this.getKey(genericRecord).getPartitionPath();
        }

        public UTF8String getPartitionPath(InternalRow internalRow, StructType structType) {
            return null;
        }

        public /* synthetic */ TestDataSourceDefaults org$apache$hudi$TestDataSourceDefaults$UserDefinedKeyGenerator$$$outer() {
            return TestDataSourceDefaults.this;
        }

        public UserDefinedKeyGenerator(TypedProperties props) {
            if (TestDataSourceDefaults.this == null) {
                throw null;
            }
            super(props);
            this.recordKeyProp = props.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key());
            this.partitionPathProp = props.getString(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key());
            this.STRUCT_NAME = "hoodieRowTopLevelField";
            this.NAMESPACE = "hoodieRow";
        }
    }
}

