/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.commons.io.FileUtils;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.TestHoodieSparkSqlWriter$;
import org.apache.hudi.TestHoodieSparkSqlWriter$StringLongTest$;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.functional.TestBootstrap;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.HoodieSparkSessionExtension;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import org.scalatest.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011-a\u0001\u0002-Z\u0001\u0001DQa\u001a\u0001\u0005\u0002!D\u0011b\u001b\u0001A\u0002\u0003\u0007I\u0011\u00017\t\u0013Q\u0004\u0001\u0019!a\u0001\n\u0003)\b\"C>\u0001\u0001\u0004\u0005\t\u0015)\u0003n\u0011%a\b\u00011AA\u0002\u0013\u0005Q\u0010C\u0006\u0002\u0004\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0001BCA\u0005\u0001\u0001\u0007\t\u0011)Q\u0005}\"Y\u00111\u0002\u0001A\u0002\u0003\u0007I\u0011AA\u0007\u0011-\t9\u0002\u0001a\u0001\u0002\u0004%\t!!\u0007\t\u0017\u0005u\u0001\u00011A\u0001B\u0003&\u0011q\u0002\u0005\f\u0003?\u0001\u0001\u0019!a\u0001\n\u0003\t\t\u0003C\u0006\u00028\u0001\u0001\r\u00111A\u0005\u0002\u0005e\u0002bCA\u001f\u0001\u0001\u0007\t\u0011)Q\u0005\u0003GA1\"a\u0010\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\"!Y\u0011\u0011\t\u0001A\u0002\u0003\u0007I\u0011AA\"\u0011-\t9\u0005\u0001a\u0001\u0002\u0003\u0006K!a\t\t\u0013\u0005%\u0003\u00011A\u0005\u0002\u0005-\u0003\"CA-\u0001\u0001\u0007I\u0011AA.\u0011!\ty\u0006\u0001Q!\n\u00055\u0003bCA1\u0001\u0001\u0007\t\u0019!C\u0001\u0003GB1\"!\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002|!Y\u0011q\u0010\u0001A\u0002\u0003\u0005\u000b\u0015BA3\u0011%\t\t\t\u0001a\u0001\n\u0003\t\u0019\tC\u0005\u0002\f\u0002\u0001\r\u0011\"\u0001\u0002\u000e\"A\u0011\u0011\u0013\u0001!B\u0013\t)I\u0002\u0004\u0002\u0014\u0002\u0001\u0015Q\u0013\u0005\u000b\u0003GS\"Q3A\u0005\u0002\u0005\r\u0004BCAS5\tE\t\u0015!\u0003\u0002f!Q\u0011q\u0015\u000e\u0003\u0016\u0004%\t!!+\t\u0015\u0005E&D!E!\u0002\u0013\tY\u000b\u0003\u0004h5\u0011\u0005\u00111\u0017\u0005\n\u0003{S\u0012\u0011!C\u0001\u0003\u007fC\u0011\"!2\u001b#\u0003%\t!a2\t\u0013\u0005u'$%A\u0005\u0002\u0005}\u0007\"CAr5\u0005\u0005I\u0011IA&\u0011%\t)OGA\u0001\n\u0003\t9\u000fC\u0005\u0002pj\t\t\u0011\"\u0001\u0002r\"I\u00111 \u000e\u0002\u0002\u0013\u0005\u0013Q \u0005\n\u0005\u0017Q\u0012\u0011!C\u0001\u0005\u001bA\u0011Ba\u0006\u001b\u0003\u0003%\tE!\u0007\t\u0013\tm!$!A\u0005B\tu\u0001\"\u0003B\u00105\u0005\u0005I\u0011\tB\u0011\u000f%\u0011)\u0003AA\u0001\u0012\u0003\u00119CB\u0005\u0002\u0014\u0002\t\t\u0011#\u0001\u0003*!1q\r\fC\u0001\u0005oA\u0011Ba\u0007-\u0003\u0003%)E!\b\t\u0013\teB&!A\u0005\u0002\nm\u0002\"\u0003B!Y\u0005\u0005I\u0011\u0011B\"\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005/BqAa\u001c\u0001\t\u0003\u00119\u0006C\u0004\u0003z\u0001!\tAa\u0016\t\u000f\tm\u0004\u0001\"\u0001\u0003X!9!Q\u0010\u0001\u0005\u0002\t}\u0004b\u0002BI\u0001\u0011\u0005!1\u0013\u0005\b\u0005?\u0003A\u0011\u0001BQ\u0011\u001d\u0011)\r\u0001C\u0001\u0005\u000fD\u0011B!:\u0001#\u0003%\tAa:\t\u0013\t-\b!%A\u0005\u0002\t\u001d\bb\u0002Bw\u0001\u0011\u0005!q\u000b\u0005\b\u0005o\u0004A\u0011\u0001B,\u0011\u001d\u0011Y\u0010\u0001C\u0001\u0005/BqAa@\u0001\t\u0003\u00119\u0006C\u0004\u0004\u0004\u0001!\ta!\u0002\t\u000f\r%\u0002\u0001\"\u0001\u0003X!91Q\u0006\u0001\u0005\u0002\r=\u0002bBB#\u0001\u0011\u0005!q\u000b\u0005\b\u0007\u0013\u0002A\u0011\u0001B,\u0011\u001d\u0019i\u0005\u0001C\u0001\u0005/Bqa!\u0015\u0001\t\u0003\u00119\u0006C\u0004\u0004V\u0001!\tAa\u0016\t\u000f\re\u0003\u0001\"\u0001\u0004\\!91Q\u000f\u0001\u0005\u0002\r]\u0004bBBF\u0001\u0011\u00051Q\u0012\u0005\b\u0007;\u0003A\u0011ABP\u0011\u001d\u0019I\u000b\u0001C\u0001\u0005/Bqa!,\u0001\t\u0003\u0019y\u000bC\u0004\u0004<\u0002!\ta!0\t\u000f\r]\u0007\u0001\"\u0001\u0003X!911\u001c\u0001\u0005\u0002\t]\u0003bBBp\u0001\u0011\u0005!q\u000b\u0005\b\u0007G\u0004A\u0011\u0001B,\u0011\u001d\u00199\u000f\u0001C\u0001\u0005/Bqaa;\u0001\t\u0003\u00119fB\u0004\u0004pfC\ta!=\u0007\raK\u0006\u0012ABz\u0011\u00199W\u000b\"\u0001\u0004v\"91\u0011O+\u0005\u0002\r](\u0001\u0007+fgRDun\u001c3jKN\u0003\u0018M]6Tc2<&/\u001b;fe*\u0011!lW\u0001\u0005QV$\u0017N\u0003\u0002];\u00061\u0011\r]1dQ\u0016T\u0011AX\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0005\u0004\"AY3\u000e\u0003\rT\u0011\u0001Z\u0001\u0006g\u000e\fG.Y\u0005\u0003M\u000e\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001j!\tQ\u0007!D\u0001Z\u0003\u0015\u0019\b/\u0019:l+\u0005i\u0007C\u00018s\u001b\u0005y'B\u00019r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003WnK!a]8\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0013M\u0004\u0018M]6`I\u0015\fHC\u0001<z!\t\u0011w/\u0003\u0002yG\n!QK\\5u\u0011\u001dQ8!!AA\u00025\f1\u0001\u001f\u00132\u0003\u0019\u0019\b/\u0019:lA\u0005Q1/\u001d7D_:$X\r\u001f;\u0016\u0003y\u0004\"A\\@\n\u0007\u0005\u0005qN\u0001\u0006T#2\u001buN\u001c;fqR\fab]9m\u0007>tG/\u001a=u?\u0012*\u0017\u000fF\u0002w\u0003\u000fAqA\u001f\u0004\u0002\u0002\u0003\u0007a0A\u0006tc2\u001cuN\u001c;fqR\u0004\u0013AA:d+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005MQ\"A9\n\u0007\u0005U\u0011O\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004tG~#S-\u001d\u000b\u0004m\u0006m\u0001\u0002\u0003>\n\u0003\u0003\u0005\r!a\u0004\u0002\u0007M\u001c\u0007%\u0001\u0005uK6\u0004\b+\u0019;i+\t\t\u0019\u0003\u0005\u0003\u0002&\u0005MRBAA\u0014\u0015\u0011\tI#a\u000b\u0002\t\u0019LG.\u001a\u0006\u0005\u0003[\ty#A\u0002oS>T!!!\r\u0002\t)\fg/Y\u0005\u0005\u0003k\t9C\u0001\u0003QCRD\u0017\u0001\u0004;f[B\u0004\u0016\r\u001e5`I\u0015\fHc\u0001<\u0002<!A!\u0010DA\u0001\u0002\u0004\t\u0019#A\u0005uK6\u0004\b+\u0019;iA\u0005\tB/Z7q\u0005>|Go\u0015;sCB\u0004\u0016\r\u001e5\u0002+Q,W\u000e\u001d\"p_R\u001cFO]1q!\u0006$\bn\u0018\u0013fcR\u0019a/!\u0012\t\u0011i|\u0011\u0011!a\u0001\u0003G\t!\u0003^3na\n{w\u000e^*ue\u0006\u0004\b+\u0019;iA\u0005\u0011\u0002n\\8eS\u00164un\u001c+bE2,g*Y7f+\t\ti\u0005\u0005\u0003\u0002P\u0005USBAA)\u0015\u0011\t\u0019&a\f\u0002\t1\fgnZ\u0005\u0005\u0003/\n\tF\u0001\u0004TiJLgnZ\u0001\u0017Q>|G-[3G_>$\u0016M\u00197f\u001d\u0006lWm\u0018\u0013fcR\u0019a/!\u0018\t\u0011i\u0014\u0012\u0011!a\u0001\u0003\u001b\n1\u0003[8pI&,gi\\8UC\ndWMT1nK\u0002\nA\u0002^3na\n\u000b7/\u001a)bi\",\"!!\u001a\u0011\t\u0005\u001d\u0014Q\u000f\b\u0005\u0003S\n\t\bE\u0002\u0002l\rl!!!\u001c\u000b\u0007\u0005=t,\u0001\u0004=e>|GOP\u0005\u0004\u0003g\u001a\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002X\u0005]$bAA:G\u0006\u0001B/Z7q\u0005\u0006\u001cX\rU1uQ~#S-\u001d\u000b\u0004m\u0006u\u0004\u0002\u0003>\u0016\u0003\u0003\u0005\r!!\u001a\u0002\u001bQ,W\u000e\u001d\"bg\u0016\u0004\u0016\r\u001e5!\u0003M\u0019w.\\7p]R\u000b'\r\\3N_\u0012Lg-[3s+\t\t)\t\u0005\u0005\u0002h\u0005\u001d\u0015QMA3\u0013\u0011\tI)a\u001e\u0003\u00075\u000b\u0007/A\fd_6lwN\u001c+bE2,Wj\u001c3jM&,'o\u0018\u0013fcR\u0019a/a$\t\u0011iD\u0012\u0011!a\u0001\u0003\u000b\u000bAcY8n[>tG+\u00192mK6{G-\u001b4jKJ\u0004#AD*ue&tw\rT8oOR+7\u000f^\n\u00075\u0005\f9*!(\u0011\u0007\t\fI*C\u0002\u0002\u001c\u000e\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002c\u0003?K1!!)d\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011)X/\u001b3\u0002\u000bU,\u0018\u000e\u001a\u0011\u0002\u0005Q\u001cXCAAV!\r\u0011\u0017QV\u0005\u0004\u0003_\u001b'\u0001\u0002'p]\u001e\f1\u0001^:!)\u0019\t),!/\u0002<B\u0019\u0011q\u0017\u000e\u000e\u0003\u0001Aq!a) \u0001\u0004\t)\u0007C\u0004\u0002(~\u0001\r!a+\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003k\u000b\t-a1\t\u0013\u0005\r\u0006\u0005%AA\u0002\u0005\u0015\u0004\"CATAA\u0005\t\u0019AAV\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!3+\t\u0005\u0015\u00141Z\u0016\u0003\u0003\u001b\u0004B!a4\u0002Z6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f).A\u0005v]\u000eDWmY6fI*\u0019\u0011q[2\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\\\u0006E'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAqU\u0011\tY+a3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u000fE\u0002c\u0003WL1!!<d\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u00190!?\u0011\u0007\t\f)0C\u0002\u0002x\u000e\u00141!\u00118z\u0011!QX%!AA\u0002\u0005%\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\bC\u0002B\u0001\u0005\u000f\t\u00190\u0004\u0002\u0003\u0004)\u0019!QA2\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\n\t\r!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u0004\u0003\u0016A\u0019!M!\u0005\n\u0007\tM1MA\u0004C_>dW-\u00198\t\u0011i<\u0013\u0011!a\u0001\u0003g\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003S\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001b\na!Z9vC2\u001cH\u0003\u0002B\b\u0005GA\u0001B\u001f\u0016\u0002\u0002\u0003\u0007\u00111_\u0001\u000f'R\u0014\u0018N\\4M_:<G+Z:u!\r\t9\fL\n\u0006Y\t-\u0012Q\u0014\t\u000b\u0005[\u0011\u0019$!\u001a\u0002,\u0006UVB\u0001B\u0018\u0015\r\u0011\tdY\u0001\beVtG/[7f\u0013\u0011\u0011)Da\f\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003(\u0005)\u0011\r\u001d9msR1\u0011Q\u0017B\u001f\u0005\u007fAq!a)0\u0001\u0004\t)\u0007C\u0004\u0002(>\u0002\r!a+\u0002\u000fUt\u0017\r\u001d9msR!!Q\tB)!\u0015\u0011'q\tB&\u0013\r\u0011Ie\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f\t\u0014i%!\u001a\u0002,&\u0019!qJ2\u0003\rQ+\b\u000f\\33\u0011%\u0011\u0019\u0006MA\u0001\u0002\u0004\t),A\u0002yIA\nQa]3u+B$\u0012A\u001e\u0015\u0004c\tm\u0003\u0003\u0002B/\u0005Wj!Aa\u0018\u000b\t\t\u0005$1M\u0001\u0004CBL'\u0002\u0002B3\u0005O\nqA[;qSR,'OC\u0002\u0003ju\u000bQA[;oSRLAA!\u001c\u0003`\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3A\rB:!\u0011\u0011iF!\u001e\n\t\t]$q\f\u0002\n\u0003\u001a$XM]#bG\"\f\u0001#\u001b8jiN\u0003\u0018M]6D_:$X\r\u001f;\u0002)\rdW-\u00198vaN\u0003\u0018M]6D_:$X\r\u001f;t\u00039!'o\u001c9NKR\fg)[3mIN$BA!!\u0003\u000eB)aNa!\u0003\b&\u0019!QQ8\u0003\u000f\u0011\u000bG/Y:fiB\u0019aN!#\n\u0007\t-uNA\u0002S_^DqAa$6\u0001\u0004\u0011\t)\u0001\u0002eM\u0006yq-\u001a;D_6lwN\u001c)be\u0006l7\u000f\u0006\u0005\u0002\u0006\nU%\u0011\u0014BN\u0011\u001d\u00119J\u000ea\u0001\u0003G\tA\u0001]1uQ\"9\u0011\u0011\n\u001cA\u0002\u0005\u0015\u0004b\u0002BOm\u0001\u0007\u0011QM\u0001\ni\u0006\u0014G.\u001a+za\u0016\f1cY8om\u0016\u0014HOU8x\u0019&\u001cH\u000fV8TKF$BAa)\u00036B1!Q\u0015BX\u0005\u000fsAAa*\u0003,:!\u00111\u000eBU\u0013\u0005!\u0017b\u0001BWG\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002BY\u0005g\u00131aU3r\u0015\r\u0011ik\u0019\u0005\b\u0005o;\u0004\u0019\u0001B]\u0003%Ig\u000e];u\u0019&\u001cH\u000f\u0005\u0004\u0003<\n\u0005'qQ\u0007\u0003\u0005{SAAa0\u00020\u0005!Q\u000f^5m\u0013\u0011\u0011\u0019M!0\u0003\t1K7\u000f^\u0001\u001bi\u0016\u001cHOQ;mW&s7/\u001a:u/&$\bnU8si6{G-\u001a\u000b\bm\n%'Q\u001cBq\u0011\u001d\u0011Y\r\u000fa\u0001\u0005\u001b\f\u0001b]8si6{G-\u001a\t\u0005\u0005\u001f\u0014I.\u0004\u0002\u0003R*!!1\u001bBk\u0003)\u0011W\u000f\\6j]N,'\u000f\u001e\u0006\u0004\u0005/L\u0016!C3yK\u000e,H/[8o\u0013\u0011\u0011YN!5\u0003%\t+Hn[%og\u0016\u0014HoU8si6{G-\u001a\u0005\n\u0005?D\u0004\u0013!a\u0001\u0005\u001f\t!\u0003]8qk2\fG/Z'fi\u00064\u0015.\u001a7eg\"I!1\u001d\u001d\u0011\u0002\u0003\u0007!qB\u0001\u0011K:\f'\r\\3P\u0007\u000e\u001buN\u001c4jON\fA\u0005^3ti\n+Hn[%og\u0016\u0014HoV5uQN{'\u000f^'pI\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0005STCAa\u0004\u0002L\u0006!C/Z:u\u0005Vd7.\u00138tKJ$x+\u001b;i'>\u0014H/T8eK\u0012\"WMZ1vYR$3'A\u0010uKN$\b+\u0019:b[\u0016$XM]:XSRDwK]5uK\u0012+g-Y;miND3a\u000fBy!\u0011\u0011iFa=\n\t\tU(q\f\u0002\u0005)\u0016\u001cH/A\u0012uKN$H\u000b\u001b:po\u0016C8-\u001a9uS>t\u0017J\u001c<bY&$7+\u001a:jC2L'0\u001a:)\u0007q\u0012\t0A\u0019uKN$H\u000b\u001b:po\u0016C8-\u001a9uS>t\u0017\t\u001c:fC\u0012LX\t_5tiN<\u0016\u000e\u001e5BaB,g\u000eZ*bm\u0016lu\u000eZ3)\u0007u\u0012\t0\u0001\u0017uKN$h+\u00197jI\u0006$X\rV1cY\u0016\u001cuN\u001c4jO^KG\u000f[(wKJ<(/\u001b;f'\u00064X-T8eK\"\u001aaH!=\u00023Q,7\u000f\u001e\"vY.Len]3si\u001a{'oU8si6{G-\u001a\u000b\u0004m\u000e\u001d\u0001b\u0002Bf\u007f\u0001\u0007!Q\u001a\u0015\b\u007f\r-11DB\u000f!\u0011\u0019iaa\u0006\u000e\u0005\r=!\u0002BB\t\u0007'\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0007+\u0011\u0019'\u0001\u0004qCJ\fWn]\u0005\u0005\u00073\u0019yA\u0001\u0006F]Vl7k\\;sG\u0016\fQA^1mk\u0016\u001c#A!4)\u0007}\u001a\t\u0003\u0005\u0003\u0004$\r\u0015RBAB\n\u0013\u0011\u00199ca\u0005\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0011uKN$()\u001e7l\u0013:\u001cXM\u001d;G_J\u001cvN\u001d;N_\u0012,w+\u001b;i\u001f\u000e\u001b\u0005f\u0001!\u0003r\u0006\u0019C/Z:u\u0005Vd7.\u00138tKJ$hi\u001c:Q_B,H.\u0019;f\u001b\u0016$\u0018MR5fY\u0012\u001cHc\u0001<\u00042!9!q\\!A\u0002\t=\u0001fB!\u00046\rm2Q\b\t\u0005\u0007\u001b\u00199$\u0003\u0003\u0004:\r=!a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0007\u007f\u0019\t%G\u0001\u00023\u0005\u0001\u0001fA!\u0004\"\u0005qB/Z:u\t&\u001c\u0018M\u00197f\u0003:$WI\\1cY\u0016lU\r^1GS\u0016dGm\u001d\u0015\u0004\u0005\nE\u0018A\t;fgR$%o\u001c9EkBd\u0017nY1uKN\u0014vn\u001e$pe\n+Hn[%og\u0016\u0014H\u000fK\u0002D\u0005c\fq\u0005^3ti&s7/\u001a:u\t\u0006$\u0018m]3u/&$\bn\\;u!J,7m\\7cS:,g)[3mI\"\u001aAI!=\u0002MQ,7\u000f^%og\u0016\u0014H\u000fR1uCN,GoV5uQ>,H\u000fU1si&$\u0018n\u001c8GS\u0016dG\rK\u0002F\u0005c\fQ\u0007^3ti\n+Hn[%og\u0016\u0014H\u000fR1uCN,GoV5uQ\u0012\u000bG/Y:pkJ\u001cW-S7qY6+H\u000e^5qY\u0016\u0014v.\u001e8eg\"\u001aaI!=\u0002eQ,7\u000f\u001e#bi\u0006\u001cx.\u001e:dK&s7/\u001a:u\r>\u0014H+\u00192mKRK\b/\u001a\"bg\u00164\u0015\u000e\\3NKR\fg)[3mIN$rA^B/\u0007?\u001a\t\u0007C\u0004\u0003\u001e\u001e\u0003\r!!\u001a\t\u000f\t}w\t1\u0001\u0003\u0010!911M$A\u0002\u0005\u0015\u0014A\u00042bg\u00164\u0015\u000e\\3G_Jl\u0017\r\u001e\u0015\b\u000f\u000e\u001d41DB7!\u0011\u0019ia!\u001b\n\t\r-4q\u0002\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-\u001a\u0017\u0003\u0007_\n#a!\u001d\u0002)Q,7\u000f\u001e#bi\u0006\u001cx.\u001e:dK&s7/\u001a:uQ\r95\u0011E\u0001(i\u0016\u001cHoV5uQ\u0012\u000bG/Y:pkJ\u001cWMQ8piN$(/\u00199G_J$\u0016M\u00197f)f\u0004X\rF\u0002w\u0007sBqA!(I\u0001\u0004\t)\u0007K\u0004I\u0007k\u0019iha \u0002\u000fM$(/\u001b8hg2\"1\u0011QBCC\t\u0019\u0019)A\u0007D\u001fBKvl\u0014(`/JKE+R\u0011\u0003\u0007\u000f\u000bQ\"T#S\u000f\u0016{vJT0S\u000b\u0006#\u0005f\u0001%\u0004\"\u0005\u0001\u0013N\\5uS\u0006d\u0017N_3NKR\f7\t\\5f]R4uN\u001d\"p_R\u001cHO]1q)%18qRBJ\u0007+\u001bI\nC\u0004\u0004\u0012&\u0003\r!!\"\u0002\u001d\u0019|w\u000eV1cY\u0016\u0004\u0016M]1ng\"9!QT%A\u0002\u0005\u0015\u0004bBBL\u0013\u0002\u0007!qB\u0001\u0011C\u0012$'i\\8ugR\u0014\u0018\r\u001d)bi\"Dqaa'J\u0001\u0004\u0011y!\u0001\u0007j]&$()Y:f!\u0006$\b.A\u0010uKN$8k\u00195f[\u0006,eo\u001c7vi&|gNR8s)\u0006\u0014G.\u001a+za\u0016$2A^BQ\u0011\u001d\u0011iJ\u0013a\u0001\u0003KBsASB\u001b\u0007{\u001a)\u000b\f\u0003\u0004\u0002\u000e\u0015\u0005f\u0001&\u0004\"\u0005\u0011C/Z:u\u0013:\u001c'/Z7f]R\fGNV5fo^KG\u000f\u001b*fa2\f7-Z7f]RD3a\u0013By\u0003Y!Xm\u001d;EK2,G/\u001a)beRLG/[8ogZ\u0013Dc\u0001<\u00042\"911\u0017'A\u0002\t=\u0011aG;tKB\u000b'\u000f^5uS>t7\u000fV8EK2,G/Z\"p]\u001aLw\rK\u0004M\u0007k\u0019Yda.-\t\r}2\u0011\t\u0015\u0004\u0019\u000e\u0005\u0012!\u000b;fgRtuN\u001c)beRLG/[8o)\u0006\u0014G.Z,ji\"lU\r^1uC\ndWmU;qa>\u0014H\u000fF\u0002w\u0007\u007fCqA!(N\u0001\u0004\u0019\t\r\u0005\u0003\u0004D\u000e5WBABc\u0015\u0011\u00199m!3\u0002\u000b5|G-\u001a7\u000b\u0007\r-\u0017,\u0001\u0004d_6lwN\\\u0005\u0005\u0007\u001f\u001c)MA\bI_>$\u0017.\u001a+bE2,G+\u001f9fQ\u001di51BB\u000e\u0007'\u001c#a!1)\u00075\u001b\t#A\u001cuKN$Hk\\,sSR,w+\u001b;i_V$\b+\u0019:b[\u0016$XM]:J]\u000edW\u000fZ3e\u0013:Dun\u001c3jKR\u000b'\r\\3D_:4\u0017n\u001a\u0015\u0004\u001d\nE\u0018\u0001\t;fgRtuN\u001c9beRLGo\u001c8fIR{G)\u001a4bk2$8*Z=HK:D3a\u0014By\u0003\u0001\"Xm\u001d;EK\u001a\fW\u000f\u001c;LKf<UM\u001c+p\u001d>t\u0007/\u0019:uSR|g.\u001a3)\u0007A\u0013\t0\u0001\u000euKN$hj\\&fs\u001e+g\u000eV8TS6\u0004H.Z&fs\u001e+g\u000eK\u0002R\u0005c\f!\u0004^3tiNKW\u000e\u001d7f\u0017\u0016Lx)\u001a8U_:{7*Z=HK:D3A\u0015By\u0003e!Xm\u001d;HKR|%/[4j].+\u0017pR3oKJ\fGo\u001c:)\u0007M\u0013\t0\u0001\rUKN$\bj\\8eS\u0016\u001c\u0006/\u0019:l'FdwK]5uKJ\u0004\"A[+\u0014\u0005U\u000bGCABy+\t\u0019I\u0010\u0005\u0004\u0004|\u0012\u0005AQA\u0007\u0003\u0007{TAaa@\u0003>\u000611\u000f\u001e:fC6LA\u0001b\u0001\u0004~\n11\u000b\u001e:fC6\u0004Ba!\u0004\u0005\b%!A\u0011BB\b\u0005%\t%oZ;nK:$8\u000f")
public class TestHoodieSparkSqlWriter {
    private volatile TestHoodieSparkSqlWriter$StringLongTest$ StringLongTest$module;
    private SparkSession spark;
    private SQLContext sqlContext;
    private SparkContext sc;
    private Path tempPath;
    private Path tempBootStrapPath;
    private String hoodieFooTableName = "hoodie_foo_tbl";
    private String tempBasePath;
    private scala.collection.immutable.Map<String, String> commonTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);

    public static Stream<Arguments> testDatasourceInsert() {
        return TestHoodieSparkSqlWriter$.MODULE$.testDatasourceInsert();
    }

    public TestHoodieSparkSqlWriter$StringLongTest$ StringLongTest() {
        if (this.StringLongTest$module == null) {
            this.StringLongTest$lzycompute$1();
        }
        return this.StringLongTest$module;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public Path tempPath() {
        return this.tempPath;
    }

    public void tempPath_$eq(Path x$1) {
        this.tempPath = x$1;
    }

    public Path tempBootStrapPath() {
        return this.tempBootStrapPath;
    }

    public void tempBootStrapPath_$eq(Path x$1) {
        this.tempBootStrapPath = x$1;
    }

    public String hoodieFooTableName() {
        return this.hoodieFooTableName;
    }

    public void hoodieFooTableName_$eq(String x$1) {
        this.hoodieFooTableName = x$1;
    }

    public String tempBasePath() {
        return this.tempBasePath;
    }

    public void tempBasePath_$eq(String x$1) {
        this.tempBasePath = x$1;
    }

    public scala.collection.immutable.Map<String, String> commonTableModifier() {
        return this.commonTableModifier;
    }

    public void commonTableModifier_$eq(scala.collection.immutable.Map<String, String> x$1) {
        this.commonTableModifier = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.initSparkContext();
        this.tempPath_$eq(Files.createTempDirectory("hoodie_test_path", new FileAttribute[0]));
        this.tempBootStrapPath_$eq(Files.createTempDirectory("hoodie_test_bootstrap", new FileAttribute[0]));
        this.tempBasePath_$eq(((Object)this.tempPath().toAbsolutePath()).toString());
        this.commonTableModifier_$eq(this.getCommonParams(this.tempPath(), this.hoodieFooTableName(), HoodieTableType.COPY_ON_WRITE.name()));
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        FileUtils.deleteDirectory((File)this.tempPath().toFile());
        FileUtils.deleteDirectory((File)this.tempBootStrapPath().toFile());
    }

    public void initSparkContext() {
        SparkConf sparkConf = new SparkConf();
        Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_2() ? sparkConf.set("spark.sql.catalog.spark_catalog", "org.apache.spark.sql.hudi.catalog.HoodieCatalog") : BoxedUnit.UNIT;
        this.spark_$eq(SparkSession$.MODULE$.builder().appName(this.hoodieFooTableName()).master("local[2]").withExtensions((Function1)new HoodieSparkSessionExtension()).config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config(sparkConf).getOrCreate());
        this.sc_$eq(this.spark().sparkContext());
        this.sc().setLogLevel("ERROR");
        this.sqlContext_$eq(this.spark().sqlContext());
    }

    public void cleanupSparkContexts() {
        block2: {
            if (this.sqlContext() != null) {
                this.sqlContext().clearCache();
                this.sqlContext_$eq(null);
            }
            if (this.sc() != null) {
                this.sc().stop();
                this.sc_$eq(null);
            }
            if (this.spark() == null) break block2;
            this.spark().close();
        }
    }

    public Dataset<Row> dropMetaFields(Dataset<Row> df) {
        return df.drop((String)HoodieRecord.HOODIE_META_COLUMNS.get(0)).drop((String)HoodieRecord.HOODIE_META_COLUMNS.get(1)).drop((String)HoodieRecord.HOODIE_META_COLUMNS.get(2)).drop((String)HoodieRecord.HOODIE_META_COLUMNS.get(3)).drop((String)HoodieRecord.HOODIE_META_COLUMNS.get(4));
    }

    public scala.collection.immutable.Map<String, String> getCommonParams(Path path, String hoodieFooTableName, String tableType) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)((Object)path.toAbsolutePath()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)hoodieFooTableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.SimpleKeyGenerator")}));
    }

    public Seq<Row> convertRowListToSeq(java.util.List<Row> inputList) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(inputList.iterator()).asScala()).toSeq();
    }

    public void testBulkInsertWithSortMode(BulkInsertSortMode sortMode, boolean populateMetaFields, boolean enableOCCConfigs) {
        Dataset<Row> trimmedDf;
        scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)"hoodie.bulkinsert.shuffle.parallelism", (Object)"4").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), (Object)"true").updated((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Object)String.valueOf(populateMetaFields)).updated((Object)HoodieWriteConfig.BULK_INSERT_SORT_MODE.key(), (Object)sortMode.name());
        if (enableOCCConfigs) {
            fooTableModifier = fooTableModifier.updated((Object)"hoodie.write.concurrency.mode", (Object)"optimistic_concurrency_control").updated((Object)"hoodie.cleaner.policy.failed.writes", (Object)"LAZY").updated((Object)"hoodie.write.lock.provider", (Object)"org.apache.hudi.client.transaction.lock.InProcessLockProvider");
        }
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> inserts = DataSourceTestUtils.generateRandomRows(1000);
        Dataset toUpdateDataset = this.sqlContext().createDataFrame(DataSourceTestUtils.getUniqueRows(inserts, 40), structType);
        java.util.List<Row> updates = DataSourceTestUtils.updateRowsWithHigherTs((Dataset<Row>)toUpdateDataset);
        Buffer records = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(inserts).union((GenSeq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(updates), Buffer$.MODULE$.canBuildFrom());
        Seq<Row> recordsSeq = this.convertRowListToSeq(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(records));
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2016/03/15", "2015/03/16", "2015/03/17"}));
        String[] fullPartitionPaths = new String[3];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fullPartitionPaths)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            fullPartitionPaths$1[i] = String.format("%s/%s/*", this.tempBasePath(), partitions.apply(i));
        });
        Dataset actualDf = this.sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
        if (!populateMetaFields) {
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((long)0L, (long)actualDf.select((String)HoodieRecord.HOODIE_META_COLUMNS.get(i), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)TestHoodieSparkSqlWriter.$anonfun$testBulkInsertWithSortMode$3(entry))).count()));
        }
        Predef$.MODULE$.assert(df.except(trimmedDf = this.dropMetaFields((Dataset<Row>)actualDf)).count() == 0L);
    }

    public boolean testBulkInsertWithSortMode$default$2() {
        return true;
    }

    public boolean testBulkInsertWithSortMode$default$3() {
        return false;
    }

    @Test
    public void testParametersWithWriteDefaults() {
        scala.collection.immutable.Map originals = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(Predef$.MODULE$.Map().empty());
        String rhsKey = "hoodie.right.hand.side.key";
        String rhsVal = "hoodie.right.hand.side.val";
        scala.collection.immutable.Map modifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rhsKey), (Object)rhsVal)}));
        scala.collection.immutable.Map modified = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(modifier);
        Function2 & Serializable & scala.Serializable matcher = (Function2 & Serializable & scala.Serializable)(k, v) -> package$.MODULE$.Matchers().convertToAnyShouldWrapper(modified.apply(k), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229), Prettifier$.MODULE$.default()).should(package$.MODULE$.Matchers().be().apply(v));
        originals.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            String string2;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && "hoodie.datasource.write.operation".equals(string2 = (String)tuple2._1())) {
                return (Assertion)matcher.apply((Object)"hoodie.datasource.write.operation", (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL());
            }
            if (tuple2 != null && "hoodie.datasource.write.table.type".equals(string = (String)tuple2._1())) {
                return (Assertion)matcher.apply((Object)"hoodie.datasource.write.table.type", (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL());
            }
            if (tuple2 != null) {
                String string3 = (String)tuple2._1();
                String string4 = rhsKey;
                String string5 = string3;
                if (string4 == null) {
                    if (string5 == null) return (Assertion)matcher.apply((Object)rhsKey, (Object)rhsVal);
                } else if (string4.equals(string5)) {
                    return (Assertion)matcher.apply((Object)rhsKey, (Object)rhsVal);
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return (Assertion)matcher.apply((Object)k, (Object)v);
        });
    }

    @Test
    public void testThrowExceptionInvalidSerializer() {
        this.spark().stop();
        SparkSession session = SparkSession$.MODULE$.builder().appName("hoodie_test").master("local").getOrCreate();
        try {
            SQLContext sqlContext = session.sqlContext();
            scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"hoodie/test/path"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test_tbl")}));
            HoodieException e = (HoodieException)package$.MODULE$.Matchers().intercept((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write(sqlContext, SaveMode.ErrorIfExists, options, session.emptyDataFrame(), HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            Predef$.MODULE$.assert(e.getMessage().contains("spark.serializer"));
        }
        finally {
            session.stop();
            this.initSparkContext();
        }
    }

    @Test
    public void testThrowExceptionAlreadyExistsWithAppendSaveMode() {
        scala.collection.immutable.Map fooTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4")}));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame = this.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringLongTest[]{new StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime())})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$1(null)));
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, dataFrame, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        scala.collection.immutable.Map barTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_bar_tbl"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4")}));
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame2 = this.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringLongTest[]{new StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime())})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$1(null)));
        HoodieException tableAlreadyExistException = (HoodieException)package$.MODULE$.Matchers().intercept((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, barTableModifier, dataFrame2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        Predef$.MODULE$.assert(tableAlreadyExistException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(tableAlreadyExistException.getMessage().contains(new StringBuilder(31).append(HoodieWriteConfig.TBL_NAME.key()).append(":\thoodie_bar_tbl\thoodie_foo_tbl").toString()));
        scala.collection.immutable.Map deleteTableModifier = barTableModifier.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)"delete")})));
        HoodieException deleteCmdException = (HoodieException)package$.MODULE$.Matchers().intercept((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, deleteTableModifier, dataFrame2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        Predef$.MODULE$.assert(tableAlreadyExistException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(tableAlreadyExistException.getMessage().contains(new StringBuilder(31).append(HoodieWriteConfig.TBL_NAME.key()).append(":\thoodie_bar_tbl\thoodie_foo_tbl").toString()));
    }

    @Test
    public void testValidateTableConfigWithOverwriteSaveMode() {
        scala.collection.immutable.Map tableModifier1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.recordkey.field"), (Object)"uuid")}));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$2(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame = this.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringLongTest[]{new StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime())})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$2(null)));
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, tableModifier1, dataFrame, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        scala.collection.immutable.Map tableModifier2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.recordkey.field"), (Object)"ts")}));
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$2(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame2 = this.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringLongTest[]{new StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime())})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$2(null)));
        HoodieException hoodieException = (HoodieException)package$.MODULE$.Matchers().intercept((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, tableModifier2, dataFrame2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        Predef$.MODULE$.assert(hoodieException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(hoodieException.getMessage().contains("RecordKey:\tts\tuuid"));
        Predef$.MODULE$.assert(BoxesRunTime.unboxToBoolean((Object)HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, tableModifier2, dataFrame2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8())._1()));
    }

    @ParameterizedTest
    @EnumSource(value=BulkInsertSortMode.class)
    public void testBulkInsertForSortMode(BulkInsertSortMode sortMode) {
        this.testBulkInsertWithSortMode(sortMode, true, this.testBulkInsertWithSortMode$default$3());
    }

    @Test
    public void testBulkInsertForSortModeWithOCC() {
        this.testBulkInsertWithSortMode(BulkInsertSortMode.GLOBAL_SORT, true, true);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBulkInsertForPopulateMetaFields(boolean populateMetaFields) {
        this.testBulkInsertWithSortMode(BulkInsertSortMode.NONE, populateMetaFields, this.testBulkInsertWithSortMode$default$3());
    }

    @Test
    public void testDisableAndEnableMetaFields() {
        this.testBulkInsertWithSortMode(BulkInsertSortMode.NONE, false, this.testBulkInsertWithSortMode$default$3());
        scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)"hoodie.bulkinsert.shuffle.parallelism", (Object)"4").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), (Object)"true").updated((Object)HoodieWriteConfig.BULK_INSERT_SORT_MODE.key(), (Object)BulkInsertSortMode.NONE.name()).updated((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Object)"true");
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> inserts = DataSourceTestUtils.generateRandomRows(1000);
        SparkContext qual$1 = this.sc();
        Buffer x$1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(inserts);
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        try {
            HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (HoodieException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Config conflict"));
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
    }

    @Test
    public void testDropDuplicatesRowForBulkInsert() {
        try {
            scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)"hoodie.bulkinsert.shuffle.parallelism", (Object)"4").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), (Object)"true").updated((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key(), (Object)"true");
            Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
            StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
            java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(100);
            Seq<Row> recordsSeq = this.convertRowListToSeq(records);
            SparkContext qual$1 = this.spark().sparkContext();
            Seq<Row> x$1 = recordsSeq;
            int x$2 = qual$1.parallelize$default$2();
            Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
            HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
            Assertions.fail((String)"Drop duplicates with bulk insert in row writing should have thrown exception");
        }
        catch (HoodieException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Dropping duplicates with bulk_insert in row writer path is not supported yet"));
        }
    }

    @Test
    public void testInsertDatasetWithoutPrecombineField() {
        scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key(), (Object)"false");
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(100);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, (scala.collection.immutable.Map)fooTableModifier.$minus((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2016/03/15", "2015/03/16", "2015/03/17"}));
        String[] fullPartitionPaths = new String[3];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fullPartitionPaths)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            fullPartitionPaths$2[i] = String.format("%s/%s/*", this.tempBasePath(), partitions.apply(i));
        });
        Dataset actualDf = this.spark().sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
        Dataset<Row> trimmedDf = this.dropMetaFields((Dataset<Row>)actualDf);
        Predef$.MODULE$.assert(df.except(trimmedDf).count() == 0L);
    }

    @Test
    public void testInsertDatasetWithoutPartitionField() {
        scala.collection.immutable.Map tableOpts = this.commonTableModifier().updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL());
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(1);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, (scala.collection.immutable.Map)tableOpts.$minus((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8()), ClassTag$.MODULE$.apply(IOException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
    }

    @Test
    public void testBulkInsertDatasetWithDatasourceImplMultipleRounds() {
        scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)"hoodie.bulkinsert.shuffle.parallelism", (Object)"4").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), (Object)"true");
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2016/03/15", "2015/03/16", "2015/03/17"}));
        String[] fullPartitionPaths = new String[3];
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            fullPartitionPaths$3[i] = String.format("%s/%s/*", this.tempBasePath(), partitions.apply(i));
        });
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        ObjectRef totalExpectedDf = ObjectRef.create((Object)this.spark().createDataFrame(this.sc().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(200);
            Seq<Row> recordsSeq = this.convertRowListToSeq(records);
            SparkContext qual$1 = this.sc();
            Seq<Row> x$1 = recordsSeq;
            int x$2 = qual$1.parallelize$default$2();
            Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
            HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
            Dataset actualDf = this.sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
            Dataset<Row> trimmedDf = this.dropMetaFields((Dataset<Row>)actualDf);
            totalExpectedDf$1.elem = ((Dataset)totalExpectedDf$1.elem).union(df);
            Predef$.MODULE$.assert(((Dataset)totalExpectedDf$1.elem).except(trimmedDf).count() == 0L);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"testDatasourceInsert"})
    public void testDatasourceInsertForTableTypeBaseFileMetaFields(String tableType, boolean populateMetaFields, String baseFileFormat) {
        String hoodieFooTableName = "hoodie_foo_tbl";
        scala.collection.immutable.Map fooTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)hoodieFooTableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.BASE_FILE_FORMAT.key()), (Object)baseFileFormat), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)String.valueOf(populateMetaFields)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)SimpleKeyGenerator.class.getCanonicalName())}));
        scala.collection.immutable.Map fooTableParams = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(fooTableModifier);
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        Schema modifiedSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType, "trip", "example.schema");
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(100);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        this.initializeMetaClientForBootstrap((scala.collection.immutable.Map<String, String>)fooTableParams, tableType, false, true);
        SparkRDDWriteClient client = (SparkRDDWriteClient)Mockito.spy((Object)DataSourceUtils.createHoodieClient((JavaSparkContext)new JavaSparkContext(this.sc()), (String)modifiedSchema.toString(), (String)this.tempBasePath(), (String)hoodieFooTableName, (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)fooTableParams)));
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, Option$.MODULE$.empty(), Option$.MODULE$.apply((Object)client), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        ((BaseHoodieWriteClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)0))).scheduleCompaction((Option)ArgumentMatchers.any());
        ((BaseHoodieWriteClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).close();
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2016/03/15", "2015/03/16", "2015/03/17"}));
        String[] fullPartitionPaths = new String[3];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fullPartitionPaths)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            fullPartitionPaths$4[i] = String.format("%s/%s/*", this.tempBasePath(), partitions.apply(i));
        });
        Dataset actualDf = null;
        if (baseFileFormat.equalsIgnoreCase(HoodieFileFormat.PARQUET.name())) {
            actualDf = this.sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
        } else if (baseFileFormat.equalsIgnoreCase(HoodieFileFormat.ORC.name())) {
            actualDf = this.sqlContext().read().orc((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
        }
        Dataset<Row> trimmedDf = this.dropMetaFields(actualDf);
        Predef$.MODULE$.assert(df.except(trimmedDf).count() == 0L);
    }

    @ParameterizedTest
    @ValueSource(strings={"COPY_ON_WRITE", "MERGE_ON_READ"})
    public void testWithDatasourceBootstrapForTableType(String tableType) {
        Path srcPath = Files.createTempDirectory("hoodie_bootstrap_source_path", new FileAttribute[0]);
        try {
            Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(Instant.now().toEpochMilli(), 0, 100, Collections.emptyList(), JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.spark().sqlContext());
            sourceDF.write().format("parquet").mode(SaveMode.Overwrite).save(((Object)srcPath.toAbsolutePath()).toString());
            scala.collection.immutable.Map fooTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.BASE_PATH.key()), (Object)((Object)srcPath.toAbsolutePath()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.KEYGEN_CLASS_NAME.key()), (Object)NonpartitionedKeyGenerator.class.getCanonicalName())}));
            scala.collection.immutable.Map fooTableParams = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(fooTableModifier);
            this.initializeMetaClientForBootstrap((scala.collection.immutable.Map<String, String>)fooTableParams, tableType, true, false);
            SparkRDDWriteClient client = (SparkRDDWriteClient)Mockito.spy((Object)DataSourceUtils.createHoodieClient((JavaSparkContext)new JavaSparkContext(this.sc()), null, (String)this.tempBasePath(), (String)this.hoodieFooTableName(), (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)fooTableParams)));
            HoodieSparkSqlWriter$.MODULE$.bootstrap(this.sqlContext(), SaveMode.Append, fooTableModifier, this.spark().emptyDataFrame(), Option$.MODULE$.empty(), Option$.MODULE$.apply((Object)client));
            ((BaseHoodieWriteClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).close();
            boolean ignoreResult = HoodieSparkSqlWriter$.MODULE$.bootstrap(this.sqlContext(), SaveMode.Ignore, fooTableModifier, this.spark().emptyDataFrame(), Option$.MODULE$.empty(), Option$.MODULE$.apply((Object)client));
            Assertions.assertFalse((boolean)ignoreResult);
            ((BaseHoodieWriteClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)2))).close();
            Dataset actualDf = this.sqlContext().read().parquet(this.tempBasePath());
            Predef$.MODULE$.assert(actualDf.count() == 100L);
        }
        finally {
            FileUtils.deleteDirectory((File)srcPath.toFile());
        }
    }

    public void initializeMetaClientForBootstrap(scala.collection.immutable.Map<String, String> fooTableParams, String tableType, boolean addBootstrapPath, boolean initBasePath) {
        block0: {
            HoodieTableMetaClient.PropertyBuilder tableMetaClientBuilder = HoodieTableMetaClient.withPropertyBuilder().setTableType(tableType).setTableName(this.hoodieFooTableName()).setRecordKeyFields((String)fooTableParams.apply((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key())).setBaseFileFormat((String)fooTableParams.getOrElse((Object)HoodieWriteConfig.BASE_FILE_FORMAT.key(), (Function0 & Serializable & scala.Serializable)() -> ((Enum)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).name())).setArchiveLogFolder((String)HoodieTableConfig.ARCHIVELOG_FOLDER.defaultValue()).setPayloadClassName((String)fooTableParams.apply((Object)DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME().key())).setPreCombineField((String)fooTableParams.apply((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key())).setPartitionFields((String)fooTableParams.apply((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key())).setKeyGeneratorClassProp((String)fooTableParams.apply((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()));
            Object object = addBootstrapPath ? tableMetaClientBuilder.setBootstrapBasePath((String)fooTableParams.apply((Object)HoodieBootstrapConfig.BASE_PATH.key())) : BoxedUnit.UNIT;
            if (!initBasePath) break block0;
            tableMetaClientBuilder.initTable(this.sc().hadoopConfiguration(), this.tempBasePath());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"COPY_ON_WRITE", "MERGE_ON_READ"})
    public void testSchemaEvolutionForTableType(String tableType) {
        scala.collection.immutable.Map fooTableModifier = this.getCommonParams(this.tempPath(), this.hoodieFooTableName(), tableType).updated((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key(), (Object)"true");
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(10);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df1 = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, fooTableModifier, df1, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF1 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.tempBasePath()).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)10L, (long)snapshotDF1.count());
        Dataset<Row> trimmedDf1 = this.dropMetaFields((Dataset<Row>)snapshotDF1);
        Predef$.MODULE$.assert(df1.except(trimmedDf1).count() == 0L);
        Seq<Row> updatesSeq = this.convertRowListToSeq(DataSourceTestUtils.generateUpdates(records, 5));
        SparkContext qual$2 = this.sc();
        Seq<Row> x$3 = updatesSeq;
        int x$4 = qual$2.parallelize$default$2();
        Dataset updatesDf = this.spark().createDataFrame(qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, updatesDf, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF2 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.tempBasePath()).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)10L, (long)snapshotDF2.count());
        Dataset<Row> trimmedDf2 = this.dropMetaFields((Dataset<Row>)snapshotDF2);
        Predef$.MODULE$.assert(updatesDf.intersect(trimmedDf2).except(updatesDf).count() == 0L);
        Schema evolSchema = DataSourceTestUtils.getStructTypeExampleEvolvedSchema();
        StructType evolStructType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(evolSchema);
        records = DataSourceTestUtils.generateRandomRowsEvolvedSchema(5);
        recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$3 = this.sc();
        Seq<Row> x$5 = recordsSeq;
        int x$6 = qual$3.parallelize$default$2();
        Dataset df3 = this.spark().createDataFrame(qual$3.parallelize(x$5, x$6, ClassTag$.MODULE$.apply(Row.class)), evolStructType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df3, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF3 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.tempBasePath()).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)15L, (long)snapshotDF3.count());
        Dataset<Row> trimmedDf3 = this.dropMetaFields((Dataset<Row>)snapshotDF3);
        Predef$.MODULE$.assert(df3.intersect(trimmedDf3).except(df3).count() == 0L);
        records = DataSourceTestUtils.generateRandomRows(10);
        recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$4 = this.sc();
        Seq<Row> x$7 = recordsSeq;
        int x$8 = qual$4.parallelize$default$2();
        Dataset df4 = this.spark().createDataFrame(qual$4.parallelize(x$7, x$8, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df4, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF4 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.tempBasePath()).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)25L, (long)snapshotDF4.count());
        HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.tempBasePath()).build();
        Schema actualSchema = new TableSchemaResolver(tableMetaClient).getTableAvroSchemaWithoutMetadataFields();
        Assertions.assertTrue((actualSchema != null ? 1 : 0) != 0);
        Tuple2 tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.hoodieFooTableName());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String structName = (String)tuple2._1();
        String nameSpace = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
        Tuple2 tuple23 = tuple22;
        String structName2 = (String)tuple23._1();
        String nameSpace2 = (String)tuple23._2();
        Schema expectedSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)evolStructType, structName2, nameSpace2);
        Assertions.assertEquals((Object)expectedSchema, (Object)actualSchema);
    }

    @Test
    public void testIncrementalViewWithReplacement() {
        new .colon.colon((Object)DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL(), (List)new .colon.colon((Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestHoodieSparkSqlWriter.$anonfun$testIncrementalViewWithReplacement$1(this, tableType);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDeletePartitionsV2(boolean usePartitionsToDeleteConfig) {
        scala.collection.immutable.Map<String, String> fooTableModifier = this.getCommonParams(this.tempPath(), this.hoodieFooTableName(), HoodieTableType.COPY_ON_WRITE.name());
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(10);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df1 = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, fooTableModifier, df1, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF1 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.tempBasePath()).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)10L, (long)snapshotDF1.count());
        Dataset<Row> trimmedDf1 = this.dropMetaFields((Dataset<Row>)snapshotDF1);
        Predef$.MODULE$.assert(df1.except(trimmedDf1).count() == 0L);
        Seq<Row> updatesSeq = this.convertRowListToSeq(DataSourceTestUtils.generateUpdates(records, 5));
        SparkContext qual$2 = this.sc();
        Seq<Row> x$3 = updatesSeq;
        int x$4 = qual$2.parallelize$default$2();
        Dataset updatesDf = this.spark().createDataFrame(qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, updatesDf, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF2 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.tempBasePath()).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)10L, (long)snapshotDF2.count());
        Dataset<Row> trimmedDf2 = this.dropMetaFields((Dataset<Row>)snapshotDF2);
        Predef$.MODULE$.assert(updatesDf.intersect(trimmedDf2).except(updatesDf).count() == 0L);
        Object object = usePartitionsToDeleteConfig ? fooTableModifier.updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key(), (Object)"2016/03/15") : BoxedUnit.UNIT;
        Dataset recordsToDelete = df1.filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)TestHoodieSparkSqlWriter.$anonfun$testDeletePartitionsV2$1(entry)));
        scala.collection.immutable.Map updatedParams = fooTableModifier.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)WriteOperationType.DELETE_PARTITION.name());
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, updatedParams, recordsToDelete, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
        Dataset snapshotDF3 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.tempBasePath()).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)0L, (long)snapshotDF3.filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)TestHoodieSparkSqlWriter.$anonfun$testDeletePartitionsV2$2(entry))).count());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testNonPartitionTableWithMetatableSupport(HoodieTableType tableType) {
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"col3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"keyid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.NonpartitionedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.enable"), (Object)"true")}));
        Dataset df = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid"})).withColumn("col3", functions$.MODULE$.expr("keyid")).withColumn("age", functions$.MODULE$.expr("keyid + 1000"));
        df.write().format("hudi").options((Map)options.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)"insert")).mode(SaveMode.Overwrite).save(this.tempBasePath());
        Dataset df_update = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid"})).withColumn("col3", functions$.MODULE$.expr("keyid")).withColumn("age", functions$.MODULE$.expr("keyid + 2000"));
        df_update.write().format("hudi").options((Map)options.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)"upsert")).mode(SaveMode.Append).save(this.tempBasePath());
        Predef$.MODULE$.assert(this.spark().read().format("hudi").load(this.tempBasePath()).count() == 10L);
        Predef$.MODULE$.assert(this.spark().read().format("hudi").load(this.tempBasePath()).where("age >= 2000").count() == 10L);
    }

    @Test
    public void testToWriteWithoutParametersIncludedInHoodieTableConfig() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_1").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        Tuple2 tuple23 = tuple22;
        String tableName12 = (String)tuple23._1();
        String tablePath12 = (String)tuple23._2();
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(296).append("\n         | create table ").append(tableName12).append(" (\n         |   id int,\n         |   name string,\n         |   price double,\n         |   ts long,\n         |   dt string\n         | ) using hudi\n         | partitioned by (dt)\n         | options (\n         |  primaryKey = 'id'\n         | )\n         | location '").append(tablePath12).append("'\n       ").toString())).stripMargin());
        HoodieTableConfig tableConfig1 = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(tablePath12).build().getTableConfig();
        String string = tableConfig1.getHiveStylePartitioningEnable();
        String string2 = "true";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        String string3 = tableConfig1.getUrlEncodePartitioning();
        String string4 = "false";
        Predef$.MODULE$.assert(!(string3 != null ? !string3.equals(string4) : string4 != null));
        String string5 = tableConfig1.getKeyGeneratorClassName();
        String string6 = SimpleKeyGenerator.class.getName();
        Predef$.MODULE$.assert(!(string5 != null ? !string5.equals(string6) : string6 != null));
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Append).save(tablePath12);
        Predef$.MODULE$.assert(this.spark().read().format("hudi").load(new StringBuilder(2).append(tablePath12).append("/*").toString()).count() == 1L);
        Tuple2 tuple24 = new Tuple2((Object)"hoodie_test_params_2", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_2").toString());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        String tableName2 = (String)tuple24._1();
        String tablePath2 = (String)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)tableName2, (Object)tablePath2);
        Tuple2 tuple26 = tuple25;
        String tableName22 = (String)tuple26._1();
        String tablePath22 = (String)tuple26._2();
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName22).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), "true").option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()).mode(SaveMode.Overwrite).save(tablePath22);
        HoodieTableConfig tableConfig2 = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(tablePath22).build().getTableConfig();
        String string7 = tableConfig2.getHiveStylePartitioningEnable();
        String string8 = "false";
        Predef$.MODULE$.assert(!(string7 != null ? !string7.equals(string8) : string8 != null));
        String string9 = tableConfig2.getUrlEncodePartitioning();
        String string10 = "true";
        Predef$.MODULE$.assert(!(string9 != null ? !string9.equals(string10) : string10 != null));
        String string11 = tableConfig2.getKeyGeneratorClassName();
        String string12 = SimpleKeyGenerator.class.getName();
        Predef$.MODULE$.assert(!(string11 != null ? !string11.equals(string12) : string12 != null));
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        HoodieException configConflictException = (HoodieException)((Object)package$.MODULE$.Matchers().intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName22).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), ComplexKeyGenerator.class.getName()).mode(SaveMode.Append).save(tablePath22), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 902)));
        Predef$.MODULE$.assert(configConflictException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(configConflictException.getMessage().contains(new StringBuilder(15).append("KeyGenerator:\t").append(ComplexKeyGenerator.class.getName()).append("\t").append(SimpleKeyGenerator.class.getName()).toString()));
        df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName22).mode(SaveMode.Append).save(tablePath22);
        Dataset data = this.spark().read().format("hudi").load(new StringBuilder(2).append(tablePath22).append("/*").toString());
        Predef$.MODULE$.assert(data.count() == 2L);
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.select("_hoodie_partition_path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getString(0), _spark.implicits().newStringEncoder()).distinct().collect())).head();
        String string13 = "2021-10-16";
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string13) : string13 != null));
    }

    @Test
    public void testNonpartitonedToDefaultKeyGen() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$2(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_1").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        Tuple2 tuple23 = tuple22;
        String tableName12 = (String)tuple23._1();
        String tablePath12 = (String)tuple23._2();
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), NonpartitionedKeyGenerator.class.getName()).mode(SaveMode.Overwrite).save(tablePath12);
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$2(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        HoodieException configConflictException = (HoodieException)((Object)package$.MODULE$.Matchers().intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Append).save(tablePath12), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 945)));
        Predef$.MODULE$.assert(configConflictException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(configConflictException.getMessage().contains(new StringBuilder(15).append("KeyGenerator:\t").append(SimpleKeyGenerator.class.getName()).append("\t").append(NonpartitionedKeyGenerator.class.getName()).toString()));
    }

    @Test
    public void testDefaultKeyGenToNonpartitoned() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$3(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$3(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_1").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        Tuple2 tuple23 = tuple22;
        String tableName12 = (String)tuple23._1();
        String tablePath12 = (String)tuple23._2();
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Overwrite).save(tablePath12);
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$3(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$3(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        HoodieException configConflictException = (HoodieException)((Object)package$.MODULE$.Matchers().intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), NonpartitionedKeyGenerator.class.getName()).mode(SaveMode.Append).save(tablePath12), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 977)));
        Predef$.MODULE$.assert(configConflictException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(configConflictException.getMessage().contains(new StringBuilder(15).append("KeyGenerator:\t").append(NonpartitionedKeyGenerator.class.getName()).append("\t").append(SimpleKeyGenerator.class.getName()).toString()));
    }

    @Test
    public void testNoKeyGenToSimpleKeyGen() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$4(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$4(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_1").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        Tuple2 tuple23 = tuple22;
        String tableName12 = (String)tuple23._1();
        String tablePath12 = (String)tuple23._2();
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Overwrite).save(tablePath12);
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$4(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$4(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        try {
            df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()).mode(SaveMode.Append).save(tablePath12);
        }
        catch (Throwable throwable) {
            Assertions.fail((String)"Switching from no keygen to explicit SimpleKeyGenerator should not fail");
        }
    }

    @Test
    public void testSimpleKeyGenToNoKeyGen() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$5
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$5(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator5$5(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_1").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        Tuple2 tuple23 = tuple22;
        String tableName12 = (String)tuple23._1();
        String tablePath12 = (String)tuple23._2();
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()).mode(SaveMode.Overwrite).save(tablePath12);
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$5
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$5(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16")})), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator13$5(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        try {
            df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Append).save(tablePath12);
        }
        catch (Throwable throwable) {
            Assertions.fail((String)"Switching from  explicit SimpleKeyGenerator to default keygen should not fail");
        }
    }

    @Test
    public void testGetOriginKeyGenerator() {
        String kg2;
        String kg1;
        scala.collection.immutable.Map m1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key()), (Object)ComplexKeyGenerator.class.getName())}));
        String string = kg1 = HoodieWriterUtils$.MODULE$.getOriginKeyGenerator(m1);
        String string2 = ComplexKeyGenerator.class.getName();
        Assertions.assertTrue((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
        scala.collection.immutable.Map m2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key()), (Object)SqlKeyGenerator.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SqlKeyGenerator$.MODULE$.ORIGINAL_KEYGEN_CLASS_NAME()), (Object)SimpleKeyGenerator.class.getName())}));
        String string3 = kg2 = HoodieWriterUtils$.MODULE$.getOriginKeyGenerator(m2);
        String string4 = SimpleKeyGenerator.class.getName();
        Assertions.assertTrue((!(string3 != null ? !string3.equals(string4) : string4 != null) ? 1 : 0) != 0);
    }

    private final void StringLongTest$lzycompute$1() {
        TestHoodieSparkSqlWriter testHoodieSparkSqlWriter = this;
        synchronized (testHoodieSparkSqlWriter) {
            if (this.StringLongTest$module == null) {
                this.StringLongTest$module = new TestHoodieSparkSqlWriter$StringLongTest$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$testBulkInsertWithSortMode$3(Row entry) {
        return !entry.mkString(",").equals("");
    }

    public static final /* synthetic */ void $anonfun$testIncrementalViewWithReplacement$1(TestHoodieSparkSqlWriter $this, String tableType) {
        String baseBootStrapPath = ((Object)$this.tempBootStrapPath().toAbsolutePath()).toString();
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"col3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"keyid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.NonpartitionedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
        Dataset df = $this.spark().range(0L, 1000L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid"})).withColumn("col3", functions$.MODULE$.expr("keyid")).withColumn("age", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))).withColumn("p", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)));
        df.write().format("hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert").option("hoodie.insert.shuffle.parallelism", "4").mode(SaveMode.Overwrite).save($this.tempBasePath());
        df.write().format("hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert_overwrite_table").option("hoodie.insert.shuffle.parallelism", "4").mode(SaveMode.Append).save($this.tempBasePath());
        String[] currentCommits = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().read().format("hudi").load($this.tempBasePath()).select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(1))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long incrementalKeyIdNum = $this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "0000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), currentCommits[0]).load($this.tempBasePath()).select("keyid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).orderBy("keyid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
        Predef$.MODULE$.assert(incrementalKeyIdNum == 1000L);
        df.write().mode(SaveMode.Overwrite).save(baseBootStrapPath);
        $this.spark().emptyDataFrame().write().format("hudi").options((Map)options).option(HoodieBootstrapConfig.BASE_PATH.key(), baseBootStrapPath).option(HoodieBootstrapConfig.KEYGEN_CLASS_NAME.key(), NonpartitionedKeyGenerator.class.getCanonicalName()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()).option(HoodieBootstrapConfig.PARALLELISM_VALUE.key(), "4").mode(SaveMode.Overwrite).save($this.tempBasePath());
        df.write().format("hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert_overwrite_table").option("hoodie.insert.shuffle.parallelism", "4").mode(SaveMode.Append).save($this.tempBasePath());
        String[] currentCommitsBootstrap = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().read().format("hudi").load($this.tempBasePath()).select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(1))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long incrementalKeyIdNumBootstrap = $this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), "0000").option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), currentCommitsBootstrap[0]).load($this.tempBasePath()).select("keyid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).orderBy("keyid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
        Predef$.MODULE$.assert(incrementalKeyIdNumBootstrap == 1000L);
    }

    public static final /* synthetic */ boolean $anonfun$testDeletePartitionsV2$1(Row entry) {
        String partitionPath = entry.getString(1);
        return partitionPath.equals("2016/03/15") || partitionPath.equals("2015/03/16");
    }

    public static final /* synthetic */ boolean $anonfun$testDeletePartitionsV2$2(Row entry) {
        String partitionPath = entry.getString(3);
        return !partitionPath.equals("2015/03/17");
    }

    public class StringLongTest
    implements Product,
    scala.Serializable {
        private final String uuid;
        private final long ts;
        public final /* synthetic */ TestHoodieSparkSqlWriter $outer;

        public String uuid() {
            return this.uuid;
        }

        public long ts() {
            return this.ts;
        }

        public StringLongTest copy(String uuid, long ts) {
            return new StringLongTest(this.org$apache$hudi$TestHoodieSparkSqlWriter$StringLongTest$$$outer(), uuid, ts);
        }

        public String copy$default$1() {
            return this.uuid();
        }

        public long copy$default$2() {
            return this.ts();
        }

        public String productPrefix() {
            return "StringLongTest";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.uuid();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.ts());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StringLongTest;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.uuid()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.ts()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StringLongTest)) return false;
            if (((StringLongTest)object).org$apache$hudi$TestHoodieSparkSqlWriter$StringLongTest$$$outer() != this.org$apache$hudi$TestHoodieSparkSqlWriter$StringLongTest$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            StringLongTest stringLongTest = (StringLongTest)x$1;
            String string = this.uuid();
            String string2 = stringLongTest.uuid();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.ts() != stringLongTest.ts()) return false;
            if (!stringLongTest.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ TestHoodieSparkSqlWriter org$apache$hudi$TestHoodieSparkSqlWriter$StringLongTest$$$outer() {
            return this.$outer;
        }

        public StringLongTest(TestHoodieSparkSqlWriter $outer, String uuid, long ts) {
            this.uuid = uuid;
            this.ts = ts;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

