/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.SparkVersionsSupport;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4AAB\u0004\u0001\u001d!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)q\t\u0001C\u0001\u0011\")\u0001\u000b\u0001C\u0001\u0011\")!\u000b\u0001C\u0001'\n!B+Z:u\u0011>|G-[3Ta\u0006\u00148.\u0016;jYNT!\u0001C\u0005\u0002\t!,H-\u001b\u0006\u0003\u0015-\ta!\u00199bG\",'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0001C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u000f\u0005AB/Z:u'B\f'o\u001b,feNLwN\\\"iK\u000e\\WM]:\u0015\u0005mq\u0002C\u0001\t\u001d\u0013\ti\u0012C\u0001\u0003V]&$\b\"B\u0010\u0003\u0001\u0004\u0001\u0013\u0001D:qCJ\\g+\u001a:tS>t\u0007CA\u0011)\u001d\t\u0011c\u0005\u0005\u0002$#5\tAE\u0003\u0002&\u001b\u00051AH]8pizJ!aJ\t\u0002\rA\u0013X\rZ3g\u0013\tI#F\u0001\u0004TiJLgn\u001a\u0006\u0003OEACA\u0001\u00179sA\u0011QFN\u0007\u0002])\u0011q\u0006M\u0001\taJ|g/\u001b3fe*\u0011\u0011GM\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005M\"\u0014a\u00026va&$XM\u001d\u0006\u0003k-\tQA[;oSRL!a\u000e\u0018\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011QDH\u0010!\"\u0003m\nQA\r\u00185]Q\n\u0013!P\u0001\u0006g9\nd\u0006M\u0011\u0002\u007f\u0005)1G\f\u001a/a\u0005\n\u0011)A\u00034]Mr\u0003\u0007\u000b\u0002\u0003\u0007B\u0011A)R\u0007\u0002a%\u0011a\t\r\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018a\u0006;fgR\u001c%/Z1uKJ#GmU2iK6\fWI^8m)\u0005Y\u0002FA\u0002K!\tYe*D\u0001M\u0015\ti%'A\u0002ba&L!a\u0014'\u0003\tQ+7\u000f^\u0001\u001fi\u0016\u001cHo\u0011:fCR,'\u000b\u001a3XSRDg*Z:uK\u0012\u001c6\r[3nCND#\u0001\u0002&\u0002'\r|gN^3siJ{w\u000fT5tiR{7+Z9\u0015\u0005Q+\u0007cA+[;:\u0011a\u000b\u0017\b\u0003G]K\u0011AE\u0005\u00033F\tq\u0001]1dW\u0006<W-\u0003\u0002\\9\n\u00191+Z9\u000b\u0005e\u000b\u0002C\u00010d\u001b\u0005y&B\u00011b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003E&\tQa\u001d9be.L!\u0001Z0\u0003\u0007I{w\u000fC\u0003g\u000b\u0001\u0007q-A\u0005j]B,H\u000fT5tiB\u0019\u0001.\\/\u000e\u0003%T!A[6\u0002\tU$\u0018\u000e\u001c\u0006\u0002Y\u0006!!.\u0019<b\u0013\tq\u0017N\u0001\u0003MSN$\b")
public class TestHoodieSparkUtils {
    @ParameterizedTest
    @ValueSource(strings={"2.4.4", "3.1.0", "3.2.0", "3.3.0"})
    public void testSparkVersionCheckers(String sparkVersion) {
        SparkVersionsSupport vsMock = new SparkVersionsSupport(null, sparkVersion){
            private final String sparkVersion$1;

            public boolean isSpark2() {
                return SparkVersionsSupport.isSpark2$((SparkVersionsSupport)this);
            }

            public boolean isSpark3() {
                return SparkVersionsSupport.isSpark3$((SparkVersionsSupport)this);
            }

            public boolean isSpark3_0() {
                return SparkVersionsSupport.isSpark3_0$((SparkVersionsSupport)this);
            }

            public boolean isSpark3_1() {
                return SparkVersionsSupport.isSpark3_1$((SparkVersionsSupport)this);
            }

            public boolean isSpark3_2() {
                return SparkVersionsSupport.isSpark3_2$((SparkVersionsSupport)this);
            }

            public boolean isSpark3_3() {
                return SparkVersionsSupport.isSpark3_3$((SparkVersionsSupport)this);
            }

            public boolean gteqSpark3_0() {
                return SparkVersionsSupport.gteqSpark3_0$((SparkVersionsSupport)this);
            }

            public boolean gteqSpark3_1() {
                return SparkVersionsSupport.gteqSpark3_1$((SparkVersionsSupport)this);
            }

            public boolean gteqSpark3_1_3() {
                return SparkVersionsSupport.gteqSpark3_1_3$((SparkVersionsSupport)this);
            }

            public boolean gteqSpark3_2() {
                return SparkVersionsSupport.gteqSpark3_2$((SparkVersionsSupport)this);
            }

            public boolean gteqSpark3_2_1() {
                return SparkVersionsSupport.gteqSpark3_2_1$((SparkVersionsSupport)this);
            }

            public boolean gteqSpark3_2_2() {
                return SparkVersionsSupport.gteqSpark3_2_2$((SparkVersionsSupport)this);
            }

            public boolean gteqSpark3_3() {
                return SparkVersionsSupport.gteqSpark3_3$((SparkVersionsSupport)this);
            }

            public String getSparkVersion() {
                return this.sparkVersion$1;
            }
            {
                this.sparkVersion$1 = sparkVersion$1;
                SparkVersionsSupport.$init$((SparkVersionsSupport)this);
            }
        };
        String string = sparkVersion;
        if ("2.4.4".equals(string)) {
            Assertions.assertTrue((boolean)vsMock.isSpark2());
            Assertions.assertFalse((boolean)vsMock.isSpark3());
            Assertions.assertFalse((boolean)vsMock.isSpark3_1());
            Assertions.assertFalse((boolean)vsMock.isSpark3_0());
            Assertions.assertFalse((boolean)vsMock.isSpark3_2());
            Assertions.assertFalse((boolean)vsMock.gteqSpark3_1());
            Assertions.assertFalse((boolean)vsMock.gteqSpark3_1_3());
            Assertions.assertFalse((boolean)vsMock.gteqSpark3_2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("3.1.0".equals(string)) {
            Assertions.assertTrue((boolean)vsMock.isSpark3());
            Assertions.assertTrue((boolean)vsMock.isSpark3_1());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_1());
            Assertions.assertFalse((boolean)vsMock.isSpark2());
            Assertions.assertFalse((boolean)vsMock.isSpark3_0());
            Assertions.assertFalse((boolean)vsMock.isSpark3_2());
            Assertions.assertFalse((boolean)vsMock.gteqSpark3_1_3());
            Assertions.assertFalse((boolean)vsMock.gteqSpark3_2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("3.2.0".equals(string)) {
            Assertions.assertTrue((boolean)vsMock.isSpark3());
            Assertions.assertTrue((boolean)vsMock.isSpark3_2());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_1());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_1_3());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_2());
            Assertions.assertFalse((boolean)vsMock.isSpark2());
            Assertions.assertFalse((boolean)vsMock.isSpark3_0());
            Assertions.assertFalse((boolean)vsMock.isSpark3_1());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("3.3.0".equals(string)) {
            Assertions.assertTrue((boolean)vsMock.isSpark3());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_1());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_1_3());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_2());
            Assertions.assertFalse((boolean)vsMock.isSpark3_2());
            Assertions.assertFalse((boolean)vsMock.isSpark2());
            Assertions.assertFalse((boolean)vsMock.isSpark3_0());
            Assertions.assertFalse((boolean)vsMock.isSpark3_1());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)string);
        }
    }

    @Test
    public void testCreateRddSchemaEvol() {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Hoodie Datasource test").master("local[2]").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").getOrCreate();
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        List<Row> records = DataSourceTestUtils.generateRandomRows(5);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        Dataset df1 = spark.createDataFrame(spark.sparkContext().parallelize(recordsSeq, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), structType);
        RDD genRecRDD = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema));
        genRecRDD.collect();
        Schema evolSchema = DataSourceTestUtils.getStructTypeExampleEvolvedSchema();
        records = DataSourceTestUtils.generateRandomRowsEvolvedSchema(5);
        recordsSeq = this.convertRowListToSeq(records);
        genRecRDD = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)evolSchema));
        genRecRDD.collect();
        genRecRDD = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)evolSchema));
        GenericRecord[] genRecs = (GenericRecord[])genRecRDD.collect();
        Assertions.assertEquals((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])genRecs)).size(), (int)5);
        spark.stop();
    }

    @Test
    public void testCreateRddWithNestedSchemas() {
        Object object;
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Hoodie Datasource test").master("local[2]").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").getOrCreate();
        StructType innerStruct1 = new StructType().add("innerKey", "string", false).add("innerValue", "long", true);
        StructType structType1 = new StructType().add("key", "string", false).add("nonNullableInnerStruct", (DataType)innerStruct1, false).add("nullableInnerStruct", (DataType)innerStruct1, true);
        Schema schema1 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType1, "test_struct_name", "test_namespace");
        Seq records1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key1", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey1_1", BoxesRunTime.boxToLong((long)1L)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey1_2", BoxesRunTime.boxToLong((long)2L)}))}))}));
        Dataset df1 = spark.createDataFrame(spark.sparkContext().parallelize(records1, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), structType1);
        RDD genRecRDD1 = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema1));
        Predef$.MODULE$.assert(schema1.equals((Object)((GenericRecord[])genRecRDD1.collect())[0].getSchema()));
        StructType structType2 = new StructType().add("key", "string", false).add("nonNullableInnerStruct", (DataType)innerStruct1, false).add("nullableInnerStruct", (DataType)innerStruct1, true).add("nullableInnerStruct2", (DataType)innerStruct1, true);
        Schema schema2 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType2, "test_struct_name", "test_namespace");
        Seq records2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key2", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_1", BoxesRunTime.boxToLong((long)2L)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_2", BoxesRunTime.boxToLong((long)2L)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_3", BoxesRunTime.boxToLong((long)2L)}))}))}));
        Dataset df2 = spark.createDataFrame(spark.sparkContext().parallelize(records2, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), structType2);
        RDD genRecRDD2 = HoodieSparkUtils$.MODULE$.createRdd(df2, "test_struct_name", "test_namespace", true, Option.of((Object)schema2));
        Predef$.MODULE$.assert(schema2.equals((Object)((GenericRecord[])genRecRDD2.collect())[0].getSchema()));
        RDD genRecRDD3 = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema2));
        Predef$.MODULE$.assert(((GenericRecord[])genRecRDD3.collect())[0].getSchema().equals((Object)schema2));
        genRecRDD3.foreach((Function1 & Serializable & scala.Serializable)entry -> {
            TestHoodieSparkUtils.$anonfun$testCreateRddWithNestedSchemas$1(entry);
            return BoxedUnit.UNIT;
        });
        StructType innerStruct3 = new StructType().add("innerKey", "string", false).add("innerValue", "long", true).add("new_nested_col", "string", true);
        StructType structType4 = new StructType().add("key", "string", false).add("nonNullableInnerStruct", (DataType)innerStruct1, false).add("nullableInnerStruct", (DataType)innerStruct3, true);
        Schema schema4 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType4, "test_struct_name", "test_namespace");
        Seq records4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key2", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_1", BoxesRunTime.boxToLong((long)2L)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_2", BoxesRunTime.boxToLong((long)2L), "new_nested_col_val1"}))}))}));
        Dataset df4 = spark.createDataFrame(spark.sparkContext().parallelize(records4, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), structType4);
        RDD genRecRDD4 = HoodieSparkUtils$.MODULE$.createRdd(df4, "test_struct_name", "test_namespace", true, Option.of((Object)schema4));
        Predef$.MODULE$.assert(schema4.equals((Object)((GenericRecord[])genRecRDD4.collect())[0].getSchema()));
        RDD genRecRDD5 = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema4));
        Predef$.MODULE$.assert(schema4.equals((Object)((GenericRecord[])genRecRDD4.collect())[0].getSchema()));
        GenericRecord genRec = ((GenericRecord[])genRecRDD5.collect())[0];
        GenericRecord nestedRec = (GenericRecord)genRec.get("nullableInnerStruct");
        Assertions.assertNull((Object)nestedRec.get("new_nested_col"));
        Assertions.assertNotNull((Object)nestedRec.get("innerKey"));
        Assertions.assertNotNull((Object)nestedRec.get("innerValue"));
        StructType innerStruct4 = new StructType().add("innerKey", "string", false).add("innerValue", "long", true).add("new_nested_col", "string", false);
        StructType structType6 = new StructType().add("key", "string", false).add("nonNullableInnerStruct", (DataType)innerStruct1, false).add("nullableInnerStruct", (DataType)innerStruct4, true);
        Schema schema6 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType6, "test_struct_name", "test_namespace");
        try {
            RDD genRecRDD6 = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema6));
            genRecRDD6.collect();
            object = Assertions.fail((String)"createRdd should fail, because records don't have a column which is not nullable in the passed in schema");
        }
        catch (Exception e) {
            if (HoodieSparkUtils$.MODULE$.gteqSpark3_3()) {
                Assertions.assertTrue((boolean)e.getMessage().contains("null value for (non-nullable) string at test_struct_name.nullableInnerStruct[nullableInnerStruct].new_nested_col"));
            } else {
                Assertions.assertTrue((boolean)e.getMessage().contains("null of string in field new_nested_col of test_namespace.test_struct_name.nullableInnerStruct of union"));
            }
            object = BoxedUnit.UNIT;
        }
        spark.stop();
    }

    public Seq<Row> convertRowListToSeq(List<Row> inputList) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(inputList.iterator()).asScala()).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testCreateRddWithNestedSchemas$1(GenericRecord entry) {
        Assertions.assertNull((Object)entry.get("nullableInnerStruct2"));
    }
}

