/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.function.Consumer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.QuickstartUtils;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.functional.TestCOWDataSource$;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.GlobalDeleteKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.HoodieSparkSessionExtension;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015g\u0001B\u001d;\u0001\rCQA\u0013\u0001\u0005\u0002-CqA\u0014\u0001A\u0002\u0013\u0005q\nC\u0004X\u0001\u0001\u0007I\u0011\u0001-\t\r\u0005\u0004\u0001\u0015)\u0003Q\u0011\u001d\u0011\u0007A1A\u0005\u0002\rDa\u0001\u001e\u0001!\u0002\u0013!\u0007bB;\u0001\u0005\u0004%\tA\u001e\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003x\u0011!\t)\u0001\u0001b\u0001\n\u00031\bbBA\u0004\u0001\u0001\u0006Ia\u001e\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u001d\t\t\u0004\u0001C!\u0003gAq!a\u0013\u0001\t\u0003\n\u0019\u0004C\u0004\u0002V\u0001!\t!a\r\t\u000f\u0005}\u0003\u0001\"\u0001\u00024!9\u00111\r\u0001\u0005\u0002\u0005M\u0002bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u00033\u0003A\u0011AA\u001a\u0011\u001d\ti\n\u0001C\u0001\u0003gAq!!)\u0001\t\u0003\t\u0019\u0004C\u0004\u0002&\u0002!\t!a\r\t\u000f\u0005%\u0006\u0001\"\u0001\u00024!9\u0011Q\u0016\u0001\u0005\u0002\u0005M\u0002bBAY\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003k\u0003A\u0011AA\u001a\u0011\u001d\tI\f\u0001C\u0001\u0003gAq!!0\u0001\t\u0003\t\u0019\u0004C\u0004\u0002B\u0002!I!a1\t\u000f\u0005U\u0007\u0001\"\u0001\u00024!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005M\u0002bBAo\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003C\u0004A\u0011AA\u001a\u0011\u001d\t)\u000f\u0001C\u0001\u0003gAq!!;\u0001\t\u0003\t\u0019\u0004C\u0004\u0002n\u0002!I!a<\t\u000f\u0005m\b\u0001\"\u0001\u0002~\"9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002b\u0002B\u0017\u0001\u0011\u0005\u00111\u0007\u0005\b\u0005c\u0001A\u0011AA\u001a\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005oAqAa\u0011\u0001\t\u0003\t\u0019\u0004C\u0004\u0003H\u0001!\t!a\r\t\u000f\t-\u0003\u0001\"\u0001\u0003N!9!1\f\u0001\u0005\u0002\u0005M\u0002b\u0002B0\u0001\u0011\u0005\u00111\u0007\u0005\b\u0005G\u0002A\u0011\u0001B3\u0011\u001d\u00119\b\u0001C\u0001\u0003g1aAa\u001f\u0001\u0001\tu\u0004\"\u0003BFa\t\u0005\t\u0015!\u0003x\u0011\u0019Q\u0005\u0007\"\u0001\u0003\u000e\"I!Q\u0013\u0019A\u0002\u0013\u0005!q\u0013\u0005\n\u00053\u0003\u0004\u0019!C\u0001\u00057C\u0001Ba(1A\u0003&!\u0011\u000f\u0005\b\u0005C\u0003D\u0011\tBR\u00111\u0011y\u000b\u0001I\u0001\u0002\u0003\u0005I\u0011\u0001BY\u00111\u0011)\f\u0001I\u0001\u0002\u0003\u0005I\u0011\u0001B\\\u0005E!Vm\u001d;D\u001f^#\u0015\r^1T_V\u00148-\u001a\u0006\u0003wq\n!BZ;oGRLwN\\1m\u0015\tid(\u0001\u0003ik\u0012L'BA A\u0003\u0019\t\u0007/Y2iK*\t\u0011)A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\tB\u0011Q\tS\u0007\u0002\r*\u0011q\tP\u0001\ni\u0016\u001cH/\u001e;jYNL!!\u0013$\u0003)!{w\u000eZ5f\u00072LWM\u001c;UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tA\n\u0005\u0002N\u00015\t!(A\u0003ta\u0006\u00148.F\u0001Q!\t\tV+D\u0001S\u0015\t\u0019F+A\u0002tc2T!A\u0014 \n\u0005Y\u0013&\u0001D*qCJ\\7+Z:tS>t\u0017!C:qCJ\\w\fJ3r)\tIv\f\u0005\u0002[;6\t1LC\u0001]\u0003\u0015\u00198-\u00197b\u0013\tq6L\u0001\u0003V]&$\bb\u00021\u0004\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\n\u0014AB:qCJ\\\u0007%\u0001\u0006d_6lwN\\(qiN,\u0012\u0001\u001a\t\u0005K*dG.D\u0001g\u0015\t9\u0007.A\u0005j[6,H/\u00192mK*\u0011\u0011nW\u0001\u000bG>dG.Z2uS>t\u0017BA6g\u0005\ri\u0015\r\u001d\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\fA\u0001\\1oO*\t\u0011/\u0001\u0003kCZ\f\u0017BA:o\u0005\u0019\u0019FO]5oO\u0006Y1m\\7n_:|\u0005\u000f^:!\u0003=1XM]5gS\u000e\fG/[8o\u0007>dW#A<\u0011\u0005a|hBA=~!\tQ8,D\u0001|\u0015\ta()\u0001\u0004=e>|GOP\u0005\u0003}n\u000ba\u0001\u0015:fI\u00164\u0017bA:\u0002\u0002)\u0011apW\u0001\u0011m\u0016\u0014\u0018NZ5dCRLwN\\\"pY\u0002\na#\u001e9eCR,GMV3sS\u001aL7-\u0019;j_:4\u0016\r\\\u0001\u0018kB$\u0017\r^3e-\u0016\u0014\u0018NZ5dCRLwN\u001c,bY\u0002\n\u0011eZ3u'B\f'o[*fgNLwN\\#yi\u0016t7/[8og&s'.Z2u_J$\"!!\u0004\u0011\r\u0005=\u0011\u0011DA\u000f\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011\u0001B;uS2T1!a\u0006=\u0003\u0019\u0019w.\\7p]&!\u00111DA\t\u0005\u0019y\u0005\u000f^5p]B1\u0011qDA\u0014\u0003Wi!!!\t\u000b\t\u0005\r\u0012QE\u0001\tMVt7\r^5p]*\u0019\u00111\u00039\n\t\u0005%\u0012\u0011\u0005\u0002\t\u0007>t7/^7feB\u0019\u0011+!\f\n\u0007\u0005=\"K\u0001\fTa\u0006\u00148nU3tg&|g.\u0012=uK:\u001c\u0018n\u001c8t\u0003\u0015\u0019X\r^+q)\u0005I\u0006f\u0001\u0007\u00028A!\u0011\u0011HA$\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012aA1qS*!\u0011\u0011IA\"\u0003\u001dQW\u000f]5uKJT1!!\u0012A\u0003\u0015QWO\\5u\u0013\u0011\tI%a\u000f\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\ri\u0011q\n\t\u0005\u0003s\t\t&\u0003\u0003\u0002T\u0005m\"!C!gi\u0016\u0014X)Y2i\u0003Q!Xm\u001d;TQ>\u0014HOT1nKN#xN]1hK\"\u001aa\"!\u0017\u0011\t\u0005e\u00121L\u0005\u0005\u0003;\nYD\u0001\u0003UKN$\u0018\u0001\u0005;fgRtu\u000e\u0015:fG>l'-\u001b8fQ\ry\u0011\u0011L\u0001#i\u0016\u001cH\u000fS8pI&,\u0017j\u001d#fY\u0016$X\r\u001a(p]\n{w\u000e\\3b]\u001aKW\r\u001c3)\u0007A\tI&A\u0018uKN$\bK];oKB\u000b'\u000f^5uS>tgi\u001c:US6,7\u000f^1na\n\u000b7/\u001a3LKf<UM\\3sCR|'\u000fF\u0002Z\u0003WBq!!\u001c\u0012\u0001\u0004\ty'A\bf]\u0006\u0014G.\u001a$jY\u0016Le\u000eZ3y!\rQ\u0016\u0011O\u0005\u0004\u0003gZ&a\u0002\"p_2,\u0017M\u001c\u0015\b#\u0005]\u0014qQAE!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003\u0003\u000by$\u0001\u0004qCJ\fWn]\u0005\u0005\u0003\u000b\u000bYHA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\t\u0005-\u0015QR\r\u0002\u0003e\t\u0001\u0001K\u0002\u0012\u0003#\u0003B!a%\u0002\u00166\u0011\u0011qP\u0005\u0005\u0003/\u000byHA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f!\u0004^3ti\u0006\u00138\r[5wC2<\u0016\u000e\u001e5Ck2\\\u0017J\\:feRD3AEA-\u0003Y!Xm\u001d;D_BLxJ\\,sSR,G)\u001a7fi\u0016\u001c\bfA\n\u0002Z\u0005\tC/Z:u\u001fZ,'o\u0016:ji\u0016lu\u000eZ3Vg\u0016\u0014V\r\u001d7bG\u0016\f5\r^5p]\"\u001aA#!\u0017\u0002?Q,7\u000f\u001e*fC\u0012\u0004\u0016\r\u001e5t\u001f:\u001cu\u000e]=P]^\u0013\u0018\u000e^3UC\ndW\rK\u0002\u0016\u00033\na\u0005^3ti>3XM],sSR,G+\u00192mK6{G-Z+tKJ+\u0007\u000f\\1dK\u0006\u001bG/[8oQ\r1\u0012\u0011L\u00016i\u0016\u001cHo\u0014<fe^\u0013\u0018\u000e^3N_\u0012,Wk]3SKBd\u0017mY3BGRLwN\\(o\t&\u001c(j\\5oiB\u000b'\u000f^5uS>t7\u000fK\u0002\u0018\u00033\n!\b^3ti>3XM],sSR,G+\u00192mK6{G-Z+tKJ+\u0007\u000f\\1dK\u0006\u001bG/[8o\u001f:$\u0015n\u001d&pS:$\b+\u0019:uSRLwN\\:)\u0007a\tI&A\tuKN$HI]8q\u0013:\u001cXM\u001d;EkBD3!GA-\u0003)\"Xm\u001d;D_6\u0004H.\u001a=ECR\fG+\u001f9f/JLG/Z!oIJ+\u0017\rZ\"p]NL7\u000f^3oGfD3AGA-\u0003Q!Xm\u001d;XSRD\u0017)\u001e;p\u0007>lW.\u001b;P]\"\u001a1$!\u0017\u0002%\u001d,G\u000fR1uC\u001a\u0013\u0018-\\3Xe&$XM\u001d\u000b\u0005\u0003\u000b\f\t\u000eE\u0003R\u0003\u000f\fY-C\u0002\u0002JJ\u0013q\u0002R1uC\u001a\u0013\u0018-\\3Xe&$XM\u001d\t\u0004#\u00065\u0017bAAh%\n\u0019!k\\<\t\r\u0005MG\u00041\u0001x\u00031YW-_$f]\u0016\u0014\u0018\r^8s\u0003)\"Xm\u001d;Ta\u0006\u00148\u000eU1si&$\u0018n\u001c8Cs^KG\u000f[\"vgR|WnS3z\u000f\u0016tWM]1u_JD3!HA-\u0003)\"Xm\u001d;Ta\u0006\u00148\u000eU1si&$\u0018n\u001c8Cs^KG\u000f[*j[BdWmS3z\u000f\u0016tWM]1u_JD3AHA-\u0003-\"Xm\u001d;Ta\u0006\u00148\u000eU1si&$\u0018n\u001c8Cs^KG\u000f[\"p[BdW\r_&fs\u001e+g.\u001a:bi>\u0014\bfA\u0010\u0002Z\u0005\u0011D/Z:u'B\f'o\u001b)beRLG/[8o\u0005f<\u0016\u000e\u001e5US6,7\u000f^1na\n\u000b7/\u001a3LKf<UM\\3sCR|'\u000fK\u0002!\u00033\n\u0001\u0007^3tiN\u0003\u0018M]6QCJ$\u0018\u000e^5p]\nKx+\u001b;i\u000f2|'-\u00197EK2,G/Z&fs\u001e+g.\u001a:bi>\u0014\bfA\u0011\u0002Z\u0005\u0011D/Z:u'B\f'o\u001b)beRLG/[8o\u0005f<\u0016\u000e\u001e5O_:\u0004\u0018M\u001d;ji&|g.\u001a3LKf<UM\\3sCR|'\u000fK\u0002#\u00033\nA\u0003^3tiB\u000b'\u000f^5uS>t\u0007K];oS:<GcB-\u0002r\u0006M\u0018q\u001f\u0005\b\u0003[\u001a\u0003\u0019AA8\u0011\u001d\t)p\ta\u0001\u0003_\nq\u0002]1si&$\u0018n\u001c8F]\u000e|G-\u001a\u0005\b\u0003s\u001c\u0003\u0019AA8\u0003EI7/T3uC\u0012\fG/Y#oC\ndW\rZ\u0001%i\u0016\u001cH/U;fef\u001cujV,ji\"\u0014\u0015m]3QCRD\u0017I\u001c3GS2,\u0017J\u001c3fqR)\u0011,a@\u0003\u0002!9\u0011Q\u001f\u0013A\u0002\u0005=\u0004bBA}I\u0001\u0007\u0011q\u000e\u0015\bI\t\u0015!1\u0002B\u0007!\u0011\tIHa\u0002\n\t\t%\u00111\u0010\u0002\n\u0007N48k\\;sG\u0016\fQA^1mk\u0016d\u0003Ba\u0004\u0003\u0014\t]!1D\u0011\u0003\u0005#\t!\u0002\u001e:vK22\u0017\r\\:fC\t\u0011)\"A\u0005ueV,G\u0006\u001e:vK\u0006\u0012!\u0011D\u0001\u000bM\u0006d7/\u001a\u0017ueV,\u0017E\u0001B\u000f\u0003-1\u0017\r\\:fY\u0019\fGn]3)\u0007\u0011\n\t*\u0001\u0013uKN$\b+\u0019:uSRLwN\u001c)sk:LgnZ,ji\"|W\u000f\u001e$jY\u0016Le\u000eZ3y)\rI&Q\u0005\u0005\b\u0003k,\u0003\u0019AA8Q\u001d)\u0013qOAD\u0005SaC!a#\u0002\u000e\"\u001aQ%!%\u0002'Q,7\u000f^*dQ\u0016l\u0017-\u0012<pYV$\u0018n\u001c8)\u0007\u0019\nI&\u0001\fuKN$8k\u00195f[\u0006tu\u000e^#rk\u0006dG)\u0019;bQ\r9\u0013\u0011L\u0001+i\u0016\u001cHoQ8qs>swK]5uK^KG\u000f\u001b#s_B\u0004X\r\u001a)beRLG/[8o\u0007>dW/\u001c8t)\rI&\u0011\b\u0005\b\u0005wA\u0003\u0019AA8\u0003i)g.\u00192mK\u0012\u0013x\u000e\u001d)beRLG/[8o\u0007>dW/\u001c8tQ\u001dA\u0013qOAD\u0005\u007faC!a#\u0002\u000e\"\u001a\u0001&!%\u0002-Q,7\u000f\u001e%p_\u0012LW-S:EK2,G/\u001a3D\u001f^C3!KA-\u0003\r\"Xm\u001d;Xe&$XmU7bY2\u0004&/Z2jg&|g\u000eR3dS6\fG\u000eV1cY\u0016D3AKA-\u0003\t\"Xm\u001d;QCJ$\u0018\u000e^5p]\u000e{G.^7ogB\u0013x\u000e]3s\u0011\u0006tG\r\\5oOR)\u0011La\u0014\u0003R!9\u0011QN\u0016A\u0002\u0005=\u0004b\u0002B*W\u0001\u0007\u0011qN\u0001\fkN,w\t\\8cE&tw\rK\u0004,\u0005\u000b\u0011YAa\u0016-\u0011\t=!1\u0003B\f\u00057A3aKAI\u0003}!Xm\u001d;TCZ,\u0017i\u001d+bE2,\u0017J\u001c#jM\u001a,'/\u001a8u\u001b>$Wm\u001d\u0015\u0004Y\u0005e\u0013\u0001\t;fgRlU\r\u001e:jGN\u0014V\r]8si\u0016\u0014h+[1ECR\f7k\\;sG\u0016D3!LA-\u0003A9W\r\u001e)bi\"4uN\u001d*fC\u0012,'\u000fF\u0004x\u0005O\u0012YG!\u001c\t\r\t%d\u00061\u0001x\u0003!\u0011\u0017m]3QCRD\u0007b\u0002B*]\u0001\u0007\u0011q\u000e\u0005\b\u0005_r\u0003\u0019\u0001B9\u0003I\u0001\u0018M\u001d;ji&|g\u000eU1uQ2+g/\u001a7\u0011\u0007i\u0013\u0019(C\u0002\u0003vm\u00131!\u00138u\u0003\u0011\"Xm\u001d;WC2LG-\u0019;f\u00072,8\u000f^3sS:<gi\u001c:SKB,\u0017\r^3e\t\u0006<\u0007fA\u0018\u0002Z\t\t2\u000b^1hK\u00163XM\u001c;NC:\fw-\u001a:\u0014\u0007A\u0012y\b\u0005\u0003\u0003\u0002\n\u001dUB\u0001BB\u0015\r\u0011)\tV\u0001\ng\u000eDW\rZ;mKJLAA!#\u0003\u0004\ni1\u000b]1sW2K7\u000f^3oKJ\fA\"\u001a<f]R$v\u000e\u0016:bG.$BAa$\u0003\u0014B\u0019!\u0011\u0013\u0019\u000e\u0003\u0001AaAa#3\u0001\u00049\u0018\u0001\u0004;sS\u001e<WM]\"pk:$XC\u0001B9\u0003A!(/[4hKJ\u001cu.\u001e8u?\u0012*\u0017\u000fF\u0002Z\u0005;C\u0001\u0002\u0019\u001b\u0002\u0002\u0003\u0007!\u0011O\u0001\u000eiJLwmZ3s\u0007>,h\u000e\u001e\u0011\u0002!=t7\u000b^1hK\u000e{W\u000e\u001d7fi\u0016$GcA-\u0003&\"9!q\u0015\u001cA\u0002\t%\u0016AD:uC\u001e,7i\\7qY\u0016$X\r\u001a\t\u0005\u0005\u0003\u0013Y+\u0003\u0003\u0003.\n\r%aG*qCJ\\G*[:uK:,'o\u0015;bO\u0016\u001cu.\u001c9mKR,G-\u0001\nqe>$Xm\u0019;fI\u0012\u0012\u0017m]3QCRDGc\u00017\u00034\"9\u0001mNA\u0001\u0002\u0004a\u0015!\u00059s_R,7\r^3eI\u0011\fG/Y$f]R!!\u0011\u0018Bb!\u0011\u0011YLa0\u000e\u0005\tu&bA$\u0002\u0016%!!\u0011\u0019B_\u0005]Aun\u001c3jKR+7\u000f\u001e#bi\u0006<UM\\3sCR|'\u000fC\u0004aq\u0005\u0005\t\u0019\u0001'")
public class TestCOWDataSource
extends HoodieClientTestBase {
    private SparkSession spark = null;
    private final scala.collection.immutable.Map<String, String> commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"1")}));
    private final String verificationCol;
    private final String updatedVerificationVal;

    public /* synthetic */ String protected$basePath(TestCOWDataSource x$1) {
        return x$1.basePath;
    }

    public /* synthetic */ HoodieTestDataGenerator protected$dataGen(TestCOWDataSource x$1) {
        return x$1.dataGen;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    public Option<Consumer<SparkSessionExtensions>> getSparkSessionExtensionsInjector() {
        return HoodieConversionUtils$.MODULE$.toJavaOption((scala.Option)new Some((Object)JFunction$.MODULE$.toJava((Function1 & Serializable & scala.Serializable)receiver -> {
            TestCOWDataSource.$anonfun$getSparkSessionExtensionsInjector$1(receiver);
            return BoxedUnit.UNIT;
        })));
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initFileSystem();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
        FileSystem.closeAll();
        System.gc();
    }

    @Test
    public void testShortNameStorage() {
        List records = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
    }

    @Test
    public void testNoPrecombine() {
        List records = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        scala.collection.immutable.Map commonOptsNoPreCombine = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
        inputDF.write().format("hudi").options((Map)commonOptsNoPreCombine).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        this.spark().read().format("org.apache.hudi").load(this.basePath).count();
    }

    @Test
    public void testHoodieIsDeletedNonBooleanField() {
        List records = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        Dataset df = inputDF.withColumn("_hoodie_is_deleted", functions$.MODULE$.lit((Object)"abc"));
        Assertions.assertThrows(HoodieException.class, (Executable)new Executable(this, df){
            private final /* synthetic */ TestCOWDataSource $outer;
            private final Dataset df$1;

            public void execute() {
                this.df$1.write().format("hudi").options(this.$outer.commonOpts()).mode(SaveMode.Overwrite).save(this.$outer.protected$basePath(this.$outer));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.df$1 = df$1;
            }
        }, (String)"Should have failed since _hoodie_is_deleted is not a BOOLEAN data type");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPrunePartitionForTimestampBasedKeyGenerator(boolean enableFileIndex) {
        scala.collection.immutable.Map options = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.TimestampBasedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.timestamp.type"), (Object)"DATE_STRING"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.output.dateformat"), (Object)"yyyy/MM/dd"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.timezone"), (Object)"GMT+8:00"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.deltastreamer.keygen.timebased.input.dateformat"), (Object)"yyyy-MM-dd")})));
        scala.collection.immutable.Map readOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_HOODIE_FILE_INDEX().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)enableFileIndex)).toString())}));
        HoodieTestDataGenerator dataGen1 = new HoodieTestDataGenerator((String[])((Object[])new String[]{"2022-01-01"}));
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen1.generateInserts("001", Predef$.MODULE$.int2Integer(20)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(this.spark().sessionState().newHadoopConf()).build();
        String commit1Time = ((HoodieInstant)this.metaClient.getActiveTimeline().lastInstant().get()).getTimestamp();
        HoodieTestDataGenerator dataGen2 = new HoodieTestDataGenerator((String[])((Object[])new String[]{"2022-01-02"}));
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)dataGen2.generateInserts("002", Predef$.MODULE$.int2Integer(30)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath);
        String commit2Time = ((HoodieInstant)this.metaClient.reloadActiveTimeline().lastInstant().get()).getTimestamp();
        String pathForReader = this.getPathForReader(this.basePath, !enableFileIndex, 3);
        Dataset snapshotQueryRes = this.spark().read().format("hudi").options((Map)readOpts).load(pathForReader);
        if (enableFileIndex) {
            Assertions.assertEquals((long)snapshotQueryRes.where("partition = '2022/01/01'").count(), (long)20L);
            Assertions.assertEquals((long)snapshotQueryRes.where("partition = '2022/01/02'").count(), (long)30L);
        } else {
            Assertions.assertEquals((long)snapshotQueryRes.where("partition = '2022-01-01'").count(), (long)20L);
            Assertions.assertEquals((long)snapshotQueryRes.where("partition = '2022-01-02'").count(), (long)30L);
        }
        Dataset incrementalQueryRes = this.spark().read().format("hudi").options((Map)readOpts).option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commit1Time).option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), commit2Time).load(this.basePath);
        Assertions.assertEquals((long)incrementalQueryRes.where("partition = '2022-01-01'").count(), (long)0L);
        Assertions.assertEquals((long)incrementalQueryRes.where("partition = '2022-01-02'").count(), (long)30L);
    }

    @Test
    public void testArchivalWithBulkInsert() {
        ObjectRef structType = ObjectRef.create(null);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            List records = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.protected$dataGen(this).generateInserts(new StringOps(Predef$.MODULE$.augmentString("%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), Predef$.MODULE$.int2Integer(100)))).toList();
            Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
            structType$1.elem = inputDF.schema();
            inputDF.write().format("hudi").options(this.commonOpts()).option("hoodie.keep.min.commits", "1").option("hoodie.keep.max.commits", "2").option("hoodie.cleaner.commits.retained", "0").option("hoodie.datasource.write.row.writer.enable", "true").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).mode(i == 0 ? SaveMode.Overwrite : SaveMode.Append).save(this.protected$basePath(this));
        });
        HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).build();
        Schema actualSchema = new TableSchemaResolver(tableMetaClient).getTableAvroSchemaWithoutMetadataFields();
        Tuple2 tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace((String)this.commonOpts().apply((Object)HoodieWriteConfig.TBL_NAME.key()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String structName = (String)tuple2._1();
        String nameSpace = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
        Tuple2 tuple23 = tuple22;
        String structName2 = (String)tuple23._1();
        String nameSpace2 = (String)tuple23._2();
        this.spark().sparkContext().getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
        Schema schema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)((StructType)structType.elem), structName2, nameSpace2);
        Assertions.assertTrue((actualSchema != null ? 1 : 0) != 0);
        Assertions.assertEquals((Object)schema, (Object)actualSchema);
    }

    @Test
    public void testCopyOnWriteDeletes() {
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        Dataset snapshotDF1 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)100L, (long)snapshotDF1.count());
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.deleteRecordsToStrings((java.util.List)this.dataGen.generateUniqueDeletes(Predef$.MODULE$.int2Integer(20)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset snapshotDF2 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)snapshotDF2.count(), (long)80L);
    }

    @Test
    public void testOverWriteModeUseReplaceAction() {
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(5)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("002", Predef$.MODULE$.int2Integer(5)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        String[] commits = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metaClient.getActiveTimeline().filterCompletedInstants().getInstants().toArray())).map((Function1 & Serializable & scala.Serializable)instant -> ((HoodieInstant)instant).getAction(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals((int)2, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commits)).size());
        Assertions.assertEquals((Object)"commit", (Object)commits[0]);
        Assertions.assertEquals((Object)"replacecommit", (Object)commits[1]);
    }

    @Test
    public void testReadPathsOnCopyOnWriteTable() {
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("001", Predef$.MODULE$.int2Integer(20));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)records1)), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        String instantTime = ((HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().getInstants().findFirst().get()).getTimestamp();
        String record1FilePaths = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fs.listStatus(new Path(this.basePath, (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dataGen.getPartitionPaths())).head())))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestCOWDataSource.$anonfun$testReadPathsOnCopyOnWriteTable$1(x$2))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TestCOWDataSource.$anonfun$testReadPathsOnCopyOnWriteTable$2(x$3))))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
        java.util.List records2 = this.dataGen.generateInsertsContainsAllPartitions("002", Predef$.MODULE$.int2Integer(20));
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)records2)), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)records2)), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset hudiReadPathDF = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), instantTime).option(DataSourceReadOptions$.MODULE$.READ_PATHS().key(), record1FilePaths).load();
        int expectedCount = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(records1).asScala()).count((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TestCOWDataSource.$anonfun$testReadPathsOnCopyOnWriteTable$4(this, record)));
        Assertions.assertEquals((long)expectedCount, (long)hudiReadPathDF.count());
    }

    @Test
    public void testOverWriteTableModeUseReplaceAction() {
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(5)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("002", Predef$.MODULE$.int2Integer(5)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_TABLE_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        String[] commits = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metaClient.getActiveTimeline().filterCompletedInstants().getInstants().toArray())).map((Function1 & Serializable & scala.Serializable)instant -> ((HoodieInstant)instant).getAction(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals((int)2, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commits)).size());
        Assertions.assertEquals((Object)"commit", (Object)commits[0]);
        Assertions.assertEquals((Object)"replacecommit", (Object)commits[1]);
    }

    @Test
    public void testOverWriteModeUseReplaceActionOnDisJointPartitions() {
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsForPartition("001", Predef$.MODULE$.int2Integer(5), "2016/03/15"))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsForPartition("002", Predef$.MODULE$.int2Integer(7), "2015/03/16"))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        List records3 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsForPartition("001", Predef$.MODULE$.int2Integer(6), "2016/03/15"))).toList();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset allRecords = this.spark().read().format("org.apache.hudi").load(new StringBuilder(6).append(this.basePath).append("/*/*/*").toString());
        allRecords.registerTempTable("tmpTable");
        this.spark().sql(String.format("select count(*) from tmpTable", new Object[0])).show();
        Row[] recordCountForPartition1 = (Row[])this.spark().sql(String.format("select count(*) from tmpTable where partition = '%s'", "2016/03/15")).collect();
        Assertions.assertEquals((Object)"6", (Object)recordCountForPartition1[0].get(0).toString());
        Row[] recordCountForPartition2 = (Row[])this.spark().sql(String.format("select count(*) from tmpTable where partition = '%s'", "2015/03/16")).collect();
        Assertions.assertEquals((Object)"7", (Object)recordCountForPartition2[0].get(0).toString());
        Row[] recordsForPartitionColumn = (Row[])this.spark().sql(String.format("select partition from tmpTable", new Object[0])).collect();
        int filterSecondPartitionCount = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])recordsForPartitionColumn)).filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)TestCOWDataSource.$anonfun$testOverWriteModeUseReplaceActionOnDisJointPartitions$1(row))))).size();
        Assertions.assertEquals((int)7, (int)filterSecondPartitionCount);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        String[] commits = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metaClient.getActiveTimeline().filterCompletedInstants().getInstants().toArray())).map((Function1 & Serializable & scala.Serializable)instant -> ((HoodieInstant)instant).getAction(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals((int)3, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commits)).size());
        Assertions.assertEquals((Object)"commit", (Object)commits[0]);
        Assertions.assertEquals((Object)"commit", (Object)commits[1]);
        Assertions.assertEquals((Object)"replacecommit", (Object)commits[2]);
    }

    @Test
    public void testOverWriteTableModeUseReplaceActionOnDisJointPartitions() {
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsForPartition("001", Predef$.MODULE$.int2Integer(5), "2016/03/15"))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsForPartition("002", Predef$.MODULE$.int2Integer(7), "2015/03/16"))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_TABLE_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset allRecords = this.spark().read().format("org.apache.hudi").load(new StringBuilder(6).append(this.basePath).append("/*/*/*").toString());
        allRecords.registerTempTable("tmpTable");
        this.spark().sql(String.format("select count(*) from tmpTable", new Object[0])).show();
        Row[] recordCountForPartition1 = (Row[])this.spark().sql(String.format("select count(*) from tmpTable where partition = '%s'", "2016/03/15")).collect();
        Assertions.assertEquals((Object)"0", (Object)recordCountForPartition1[0].get(0).toString());
        Row[] recordCountForPartition2 = (Row[])this.spark().sql(String.format("select count(*) from tmpTable where partition = '%s'", "2015/03/16")).collect();
        Assertions.assertEquals((Object)"7", (Object)recordCountForPartition2[0].get(0).toString());
        Row[] recordCount = (Row[])this.spark().sql(String.format("select count(*) from tmpTable", new Object[0])).collect();
        Assertions.assertEquals((Object)"7", (Object)recordCount[0].get(0).toString());
        Row[] recordsForPartitionColumn = (Row[])this.spark().sql(String.format("select partition from tmpTable", new Object[0])).collect();
        int filterSecondPartitionCount = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])recordsForPartitionColumn)).filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)TestCOWDataSource.$anonfun$testOverWriteTableModeUseReplaceActionOnDisJointPartitions$1(row))))).size();
        Assertions.assertEquals((int)7, (int)filterSecondPartitionCount);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
        String[] commits = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metaClient.getActiveTimeline().filterCompletedInstants().getInstants().toArray())).map((Function1 & Serializable & scala.Serializable)instant -> ((HoodieInstant)instant).getAction(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals((int)2, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commits)).size());
        Assertions.assertEquals((Object)"commit", (Object)commits[0]);
        Assertions.assertEquals((Object)"replacecommit", (Object)commits[1]);
    }

    @Test
    public void testDropInsertDup() {
        int insert1Cnt = 10;
        int insert2DupKeyCnt = 9;
        int insert2NewKeyCnt = 2;
        int totalUniqueKeyToGenerate = insert1Cnt + insert2NewKeyCnt;
        java.util.List allRecords = this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(totalUniqueKeyToGenerate));
        java.util.List inserts1 = allRecords.subList(0, insert1Cnt);
        java.util.List inserts2New = this.dataGen.generateSameKeyInserts("002", allRecords.subList(insert1Cnt, insert1Cnt + insert2NewKeyCnt));
        java.util.List inserts2Dup = this.dataGen.generateSameKeyInserts("002", inserts1.subList(0, insert2DupKeyCnt));
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings(inserts1)).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset hoodieROViewDF1 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)insert1Cnt, (long)hoodieROViewDF1.count());
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(inserts2Dup).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(inserts2New))))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key(), "true").mode(SaveMode.Append).save(this.basePath);
        Dataset hoodieROViewDF2 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)hoodieROViewDF2.count(), (long)totalUniqueKeyToGenerate);
        Dataset hoodieIncViewDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commitInstantTime1).load(this.basePath);
        Assertions.assertEquals((long)hoodieIncViewDF2.count(), (long)insert2NewKeyCnt);
    }

    @Test
    public void testComplexDataTypeWriteAndReadConsistency() {
        StructField structField = new StructField("_row_key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("timeStampValue", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("dateValue", (DataType)DateType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("decimalValue", (DataType)DataTypes.createDecimalType((int)15, (int)10), true, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("timestamp", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField7 = new StructField("partition", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7).$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        Seq records = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"11", "Andy", Timestamp.valueOf("1970-01-01 13:31:24"), Date.valueOf("1991-11-07"), scala.package$.MODULE$.BigDecimal().valueOf(1.0), BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"22", "lisi", Timestamp.valueOf("1970-01-02 13:31:24"), Date.valueOf("1991-11-08"), scala.package$.MODULE$.BigDecimal().valueOf(2.0), BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"33", "zhangsan", Timestamp.valueOf("1970-01-03 13:31:24"), Date.valueOf("1991-11-09"), scala.package$.MODULE$.BigDecimal().valueOf(3.0), BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)1)}))}));
        JavaRDD rdd = this.jsc.parallelize(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(records));
        Dataset recordsDF = this.spark().createDataFrame(rdd, schema);
        recordsDF.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder(4).append(this.basePath).append("/*/*").toString());
        recordsReadDF.printSchema();
        recordsReadDF.schema().foreach((Function1 & Serializable & scala.Serializable)f -> {
            TestCOWDataSource.$anonfun$testComplexDataTypeWriteAndReadConsistency$1(f);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testWithAutoCommitOn() {
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(HoodieWriteConfig.AUTO_COMMIT_ENABLE.key(), "true").mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
    }

    private DataFrameWriter<Row> getDataFrameWriter(String keyGenerator) {
        List records = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        return inputDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), keyGenerator).mode(SaveMode.Overwrite);
    }

    @Test
    public void testSparkPartitionByWithCustomKeyGenerator() {
        DataFrameWriter writer = this.getDataFrameWriter(CustomKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_ts"})).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder(4).append(this.basePath).append("/*/*").toString());
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.col("current_ts").cast("string"))).count() == 0L ? 1 : 0) != 0);
        writer = this.getDataFrameWriter(CustomKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_ts:TIMESTAMP"})).option("hoodie.deltastreamer.keygen.timebased.timestamp.type", "EPOCHMILLISECONDS").option("hoodie.deltastreamer.keygen.timebased.output.dateformat", "yyyyMMdd").mode(SaveMode.Overwrite).save(this.basePath);
        recordsReadDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder(4).append(this.basePath).append("/*/*").toString());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCOWDataSource.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestCOWDataSource$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.String").asType().toTypeConstructor();
            }

            public Org_apache_hudi_functional_TestCOWDataSource$$typecreator1$1(TestCOWDataSource $outer) {
            }
        }
        UserDefinedFunction udf_date_format = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)data -> TestCOWDataSource.$anonfun$testSparkPartitionByWithCustomKeyGenerator$1(BoxesRunTime.unboxToLong((Object)data)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestCOWDataSource$$typecreator1$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)udf_date_format.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("current_ts")})))).count() == 0L ? 1 : 0) != 0);
        writer = this.getDataFrameWriter(CustomKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "rider:SIMPLE", "current_ts:TIMESTAMP"})).option("hoodie.deltastreamer.keygen.timebased.timestamp.type", "EPOCHMILLISECONDS").option("hoodie.deltastreamer.keygen.timebased.output.dateformat", "yyyyMMdd").mode(SaveMode.Overwrite).save(this.basePath);
        recordsReadDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder(6).append(this.basePath).append("/*/*/*").toString());
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("driver"), functions$.MODULE$.lit((Object)"/"), functions$.MODULE$.col("rider"), functions$.MODULE$.lit((Object)"/"), udf_date_format.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("current_ts")}))})))).count() == 0L ? 1 : 0) != 0);
        writer = this.getDataFrameWriter(CustomKeyGenerator.class.getName());
        writer = writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_ts:DUMMY"})).option("hoodie.deltastreamer.keygen.timebased.timestamp.type", "EPOCHMILLISECONDS").option("hoodie.deltastreamer.keygen.timebased.output.dateformat", "yyyyMMdd");
        try {
            writer.save(this.basePath);
            Assertions.fail((String)"should fail when invalid PartitionKeyType is provided!");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getCause().getMessage().contains("No enum constant org.apache.hudi.keygen.CustomAvroKeyGenerator.PartitionKeyType.DUMMY"));
        }
    }

    @Test
    public void testSparkPartitionByWithSimpleKeyGenerator() {
        DataFrameWriter<Row> writer = this.getDataFrameWriter(SimpleKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver"})).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.col("driver"))).count() == 0L ? 1 : 0) != 0);
        writer = this.getDataFrameWriter(SimpleKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "rider"})).save(this.basePath);
        recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.lit((Object)"__HIVE_DEFAULT_PARTITION__"))).count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSparkPartitionByWithComplexKeyGenerator() {
        DataFrameWriter<Row> writer = this.getDataFrameWriter(ComplexKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver"})).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.col("driver"))).count() == 0L ? 1 : 0) != 0);
        writer = this.getDataFrameWriter(ComplexKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "rider"})).save(this.basePath);
        recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("driver"), functions$.MODULE$.lit((Object)"/"), functions$.MODULE$.col("rider")})))).count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSparkPartitionByWithTimestampBasedKeyGenerator() {
        DataFrameWriter<Row> writer = this.getDataFrameWriter(TimestampBasedKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_ts"})).option("hoodie.deltastreamer.keygen.timebased.timestamp.type", "EPOCHMILLISECONDS").option("hoodie.deltastreamer.keygen.timebased.output.dateformat", "yyyyMMdd").mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder(4).append(this.basePath).append("/*/*").toString());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCOWDataSource.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestCOWDataSource$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.String").asType().toTypeConstructor();
            }

            public Org_apache_hudi_functional_TestCOWDataSource$$typecreator1$2(TestCOWDataSource $outer) {
            }
        }
        UserDefinedFunction udf_date_format = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)data -> TestCOWDataSource.$anonfun$testSparkPartitionByWithTimestampBasedKeyGenerator$1(BoxesRunTime.unboxToLong((Object)data)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestCOWDataSource$$typecreator1$2(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)udf_date_format.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("current_ts")})))).count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSparkPartitionByWithGlobalDeleteKeyGenerator() {
        DataFrameWriter<Row> writer = this.getDataFrameWriter(GlobalDeleteKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver"})).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.lit((Object)""))).count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSparkPartitionByWithNonpartitionedKeyGenerator() {
        DataFrameWriter<Row> writer = this.getDataFrameWriter(NonpartitionedKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.lit((Object)""))).count() == 0L ? 1 : 0) != 0);
        writer = this.getDataFrameWriter(NonpartitionedKeyGenerator.class.getName());
        writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc"})).mode(SaveMode.Overwrite).save(this.basePath);
        recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertTrue((recordsReadDF.filter(functions$.MODULE$.col("_hoodie_partition_path").$eq$bang$eq((Object)functions$.MODULE$.lit((Object)""))).count() == 0L ? 1 : 0) != 0);
    }

    private void testPartitionPruning(boolean enableFileIndex, boolean partitionEncode, boolean isMetadataEnabled) {
        int N = 20;
        java.util.List records1 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(N));
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)records1)), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), partitionEncode).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).mode(SaveMode.Overwrite).save(this.basePath);
        String commitInstantTime1 = HoodieDataSourceHelpers.latestCommit((FileSystem)this.fs, (String)this.basePath);
        int countIn20160315 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(records1).asScala()).count((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)TestCOWDataSource.$anonfun$testPartitionPruning$1(record)));
        String pathForReader = this.getPathForReader(this.basePath, !enableFileIndex, partitionEncode ? 1 : 3);
        scala.collection.immutable.Map readOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_HOODIE_FILE_INDEX().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)enableFileIndex)).toString())}));
        long count1 = this.spark().read().format("hudi").options((Map)readOpts).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(pathForReader).filter("partition = '2016/03/15'").count();
        Assertions.assertEquals((long)countIn20160315, (long)count1);
        String partitionPath = partitionEncode ? "2016%2F03%2F15" : "2016/03/15";
        long count2 = this.spark().read().format("hudi").options((Map)readOpts).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(new StringBuilder(1).append(this.basePath).append("/").append(partitionPath).toString()).count();
        Assertions.assertEquals((long)countIn20160315, (long)count2);
        java.util.List records2 = this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(N + 1));
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)records2)), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), partitionEncode).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).mode(SaveMode.Append).save(this.basePath);
        Dataset hoodieIncViewDF1 = this.spark().read().format("org.apache.hudi").options((Map)readOpts).option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), commitInstantTime1).load(this.basePath);
        Assertions.assertEquals((long)(N + 1), (long)hoodieIncViewDF1.count());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)Metrics.isInitialized()));
    }

    @ParameterizedTest
    @CsvSource(value={"true,false", "true,true", "false,true", "false,false"})
    public void testQueryCOWWithBasePathAndFileIndex(boolean partitionEncode, boolean isMetadataEnabled) {
        this.testPartitionPruning(true, partitionEncode, isMetadataEnabled);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPartitionPruningWithoutFileIndex(boolean partitionEncode) {
        this.testPartitionPruning(false, partitionEncode, Predef$.MODULE$.Boolean2boolean((Boolean)HoodieMetadataConfig.ENABLE.defaultValue()));
    }

    @Test
    public void testSchemaEvolution() {
        scala.collection.immutable.Map opts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"true")}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key()), (Object)"true")})));
        StructField structField = new StructField("_row_key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("name", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("timestamp", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("partition", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema1 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        Seq records1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "Andy", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "lisi", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3", "zhangsan", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}))}));
        JavaRDD rdd = this.jsc.parallelize(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(records1));
        Dataset recordsDF = this.spark().createDataFrame(rdd, schema1);
        recordsDF.write().format("org.apache.hudi").options((Map)opts).mode(SaveMode.Overwrite).save(this.basePath);
        StructField structField5 = new StructField("_row_key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("name", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField7 = new StructField("age", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("timestamp", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField9 = new StructField("partition", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema2 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField9).$colon$colon((Object)structField8).$colon$colon((Object)structField7).$colon$colon((Object)structField6).$colon$colon((Object)structField5));
        Seq records2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"11", "Andy", "10", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"22", "lisi", "11", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"33", "zhangsan", "12", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}))}));
        JavaRDD rdd2 = this.jsc.parallelize(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(records2));
        Dataset recordsDF2 = this.spark().createDataFrame(rdd2, schema2);
        recordsDF2.write().format("org.apache.hudi").options((Map)opts).mode(SaveMode.Append).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(new StringBuilder(4).append(this.basePath).append("/*/*").toString());
        HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.builder().setConf(this.spark().sparkContext().hadoopConfiguration()).setBasePath(this.basePath).build();
        Schema actualSchema = new TableSchemaResolver(tableMetaClient).getTableAvroSchemaWithoutMetadataFields();
        Assertions.assertTrue((actualSchema != null ? 1 : 0) != 0);
        StructType actualStructType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(actualSchema);
        Assertions.assertEquals((Object)actualStructType, (Object)schema2);
        try {
            StructField structField10 = new StructField("_row_key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField11 = new StructField("age", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField12 = new StructField("timestamp", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField13 = new StructField("partition", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructType schema4 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField13).$colon$colon((Object)structField12).$colon$colon((Object)structField11).$colon$colon((Object)structField10));
            Seq records4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"11", "10", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"22", "11", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"33", "12", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}))}));
            JavaRDD rdd4 = this.jsc.parallelize(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(records4));
            Dataset recordsDF4 = this.spark().createDataFrame(rdd4, schema4);
            recordsDF4.write().format("org.apache.hudi").options((Map)opts).mode(SaveMode.Append).save(this.basePath);
            Assertions.fail((String)"Delete column should fail");
        }
        catch (HoodieUpsertException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().equals("Failed upsert schema compatibility check."));
        }
    }

    @Test
    public void testSchemaNotEqualData() {
        scala.collection.immutable.Map opts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"true")})));
        StructField structField = new StructField("_row_key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("timestamp", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("age", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("partition", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema1 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        String[] records = (String[])((Object[])new String[]{"{\"_row_key\":\"1\",\"name\":\"lisi\",\"timestamp\":1,\"partition\":1}", "{\"_row_key\":\"1\",\"name\":\"lisi\",\"timestamp\":1,\"partition\":1}"});
        Dataset inputDF = this.spark().read().schema(schema1.toDDL()).json(this.spark().sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])records), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().format("org.apache.hudi").options((Map)opts).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset recordsReadDF = this.spark().read().format("org.apache.hudi").load(this.basePath);
        StructType resultSchema = new StructType((StructField[])((TraversableOnce)recordsReadDF.schema().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestCOWDataSource.$anonfun$testSchemaNotEqualData$1(p)))).toArray(ClassTag$.MODULE$.apply(StructField.class)));
        Assertions.assertEquals((Object)resultSchema, (Object)schema1);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCopyOnWriteWithDroppedPartitionColumns(boolean enableDropPartitionColumns) {
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInsertsContainsAllPartitions("000", Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS().key(), enableDropPartitionColumns).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset snapshotDF1 = this.spark().read().format("org.apache.hudi").load(this.basePath);
        Assertions.assertEquals((long)snapshotDF1.count(), (long)100L);
        Assertions.assertEquals((long)3L, (long)snapshotDF1.select("partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count());
    }

    @Test
    public void testHoodieIsDeletedCOW() {
        int numRecords = 100;
        int numRecordsToDelete = 2;
        List records0 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(numRecords)))).toList();
        Dataset df0 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records0, 2, ClassTag$.MODULE$.apply(String.class)));
        df0.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset snapshotDF0 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)numRecords, (long)snapshotDF0.count());
        Dataset df1 = snapshotDF0.limit(numRecordsToDelete);
        Dataset dropDf = df1.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df1.columns())).filter((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.startsWith("_hoodie_")))));
        Dataset df2 = dropDf.withColumn("_hoodie_is_deleted", functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)).cast((DataType)BooleanType$.MODULE$));
        df2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        Dataset snapshotDF2 = this.spark().read().format("org.apache.hudi").load(new StringBuilder(8).append(this.basePath).append("/*/*/*/*").toString());
        Assertions.assertEquals((long)(numRecords - numRecordsToDelete), (long)snapshotDF2.count());
    }

    @Test
    public void testWriteSmallPrecisionDecimalTable() {
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(5)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class))).withColumn("shortDecimal", functions$.MODULE$.lit((Object)new BigDecimal("2090.0000")));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset inputDF2 = inputDF1.withColumn("shortDecimal", functions$.MODULE$.lit((Object)new BigDecimal("3090.0000")));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset readResult = this.spark().read().format("hudi").load(this.basePath);
        Predef$.MODULE$.assert(readResult.count() == 5L);
        Assertions.assertEquals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputDF2.sort("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).select("shortDecimal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.getDecimal(0).toPlainString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(","), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readResult.sort("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).select("shortDecimal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.getDecimal(0).toPlainString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(","));
    }

    @ParameterizedTest
    @CsvSource(value={"true,false", "true,true", "false,true", "false,false"})
    public void testPartitionColumnsProperHandling(boolean enableFileIndex, boolean useGlobbing) {
        block0: {
            SparkSession _spark = this.spark();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestCOWDataSource.class.getClassLoader());
            public final class Org_apache_hudi_functional_TestCOWDataSource$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_hudi_functional_TestCOWDataSource$$typecreator5$1(TestCOWDataSource $outer) {
                }
            }
            Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"z3", (Object)BoxesRunTime.boxToInteger((int)30), (Object)"v1", (Object)"2018-09-23"), new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"z3", (Object)BoxesRunTime.boxToInteger((int)35), (Object)"v1", (Object)"2018-09-24")})), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestCOWDataSource$$typecreator5$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "age", "ts", "data_date"}));
            df.write().format("hudi").options(this.commonOpts()).option("hoodie.insert.shuffle.parallelism", "4").option("hoodie.upsert.shuffle.parallelism", "4").option("hoodie.bulkinsert.shuffle.parallelism", "2").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "data_date").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), "org.apache.hudi.keygen.TimestampBasedKeyGenerator").option("hoodie.deltastreamer.keygen.timebased.timestamp.type", "DATE_STRING").option("hoodie.deltastreamer.keygen.timebased.input.dateformat", "yyyy-MM-dd").option("hoodie.deltastreamer.keygen.timebased.output.dateformat", "yyyy/MM/dd").option("hoodie.deltastreamer.keygen.timebased.timezone", "GMT+8:00").mode(SaveMode.Append).save(this.basePath);
            String pathForReader = this.getPathForReader(this.basePath, useGlobbing || !enableFileIndex, 3);
            scala.collection.immutable.Map readOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_HOODIE_FILE_INDEX().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)enableFileIndex)).toString())}));
            Dataset firstDF = this.spark().read().format("hudi").options((Map)readOpts).load(pathForReader);
            Predef$.MODULE$.assert(firstDF.count() == 2L);
            Seq expectedValues = useGlobbing || !enableFileIndex ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018-09-23", "2018-09-24"})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018/09/23", "2018/09/24"}));
            Assertions.assertEquals((Object)expectedValues, (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])firstDF.select("data_date", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.get(0).toString(), _spark.implicits().newStringEncoder()).collect())).sorted((Ordering)Ordering.String$.MODULE$))).toSeq());
            Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018/09/23", "2018/09/24"})), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])firstDF.select("_hoodie_partition_path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.get(0).toString(), _spark.implicits().newStringEncoder()).collect())).sorted((Ordering)Ordering.String$.MODULE$))).toSeq());
            if (useGlobbing || !enableFileIndex) break block0;
            Dataset secondDF = this.spark().read().format("hudi").options((Map)readOpts).option(DataSourceReadOptions$.MODULE$.EXTRACT_PARTITION_VALUES_FROM_PARTITION_PATH().key(), "true").load(pathForReader);
            Predef$.MODULE$.assert(secondDF.count() == 2L);
            Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018/09/23", "2018/09/24"})), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])secondDF.select("data_date", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)x$35 -> x$35.get(0).toString(), _spark.implicits().newStringEncoder()).collect())).sorted((Ordering)Ordering.String$.MODULE$))).toSeq());
            Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018/09/23", "2018/09/24"})), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])secondDF.select("_hoodie_partition_path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)x$36 -> x$36.get(0).toString(), _spark.implicits().newStringEncoder()).collect())).sorted((Ordering)Ordering.String$.MODULE$))).toSeq());
        }
    }

    @Test
    public void testSaveAsTableInDifferentModes() {
        scala.collection.mutable.Map options = Map$.MODULE$.empty().$plus$plus(this.commonOpts()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.basePath)})));
        List records1 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(5)))).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition"})).options((Map)options).mode(SaveMode.Append).saveAsTable("hoodie_test");
        this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(this.spark().sessionState().newHadoopConf()).build();
        Assertions.assertEquals((long)this.spark().read().format("hudi").load(this.basePath).count(), (long)5L);
        List records2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("002", Predef$.MODULE$.int2Integer(6)))).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition"})).options((Map)options).mode(SaveMode.Append).saveAsTable("hoodie_test");
        Assertions.assertEquals((long)this.spark().read().format("hudi").load(this.basePath).count(), (long)11L);
        List records3 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("003", Predef$.MODULE$.int2Integer(7)))).toList();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition"})).options((Map)options).mode(SaveMode.Ignore).saveAsTable("hoodie_test");
        Assertions.assertEquals((long)this.spark().read().format("hudi").load(this.basePath).count(), (long)11L);
        List records4 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("004", Predef$.MODULE$.int2Integer(8)))).toList();
        Dataset inputDF4 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records4, 2, ClassTag$.MODULE$.apply(String.class)));
        try {
            inputDF4.write().format("org.apache.hudi").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition"})).options((Map)options).mode(SaveMode.ErrorIfExists).saveAsTable("hoodie_test");
        }
        catch (Throwable e) {
            // empty catch block
        }
        List records5 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("005", Predef$.MODULE$.int2Integer(9)))).toList();
        Dataset inputDF5 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records5, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF5.write().format("org.apache.hudi").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition"})).options((Map)options).mode(SaveMode.Overwrite).saveAsTable("hoodie_test");
        Assertions.assertEquals((long)this.spark().read().format("hudi").load(this.basePath).count(), (long)9L);
    }

    @Test
    public void testMetricsReporterViaDataSource() {
        QuickstartUtils.DataGenerator dataGenerator = new QuickstartUtils.DataGenerator();
        java.util.List records = QuickstartUtils.convertToStringList((java.util.List)dataGenerator.generateInserts(Predef$.MODULE$.int2Integer(10)));
        RDD recordsRDD = this.spark().sparkContext().parallelize((Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(records), 2, ClassTag$.MODULE$.apply(String.class));
        Dataset inputDF = this.spark().read().json(this.sparkSession.createDataset(recordsRDD, Encoders$.MODULE$.STRING()));
        inputDF.write().format("hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionpath").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(HoodieWriteConfig.TBL_NAME.key(), "hoodie_test").option(HoodieMetricsConfig.TURN_METRICS_ON.key(), "true").option(HoodieMetricsConfig.METRICS_REPORTER_TYPE_VALUE.key(), "CONSOLE").mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)this.fs, (String)this.basePath, (String)"000"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)Metrics.isInitialized()), (String)"Metrics should be shutdown");
    }

    public String getPathForReader(String basePath, boolean useGlobbing, int partitionPathLevel) {
        return useGlobbing ? new StringBuilder(0).append(basePath).append(new StringOps(Predef$.MODULE$.augmentString("/*")).$times(partitionPathLevel + 1)).toString() : basePath;
    }

    @Test
    public void testValidateClusteringForRepeatedDag() {
        StageEventManager sm = new StageEventManager(this, "org.apache.hudi.table.action.commit.BaseCommitActionExecutor.executeClustering");
        this.spark().sparkContext().addSparkListener((SparkListenerInterface)sm);
        ObjectRef structType = ObjectRef.create(null);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            List records = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.protected$dataGen(this).generateInserts(new StringOps(Predef$.MODULE$.augmentString("%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), Predef$.MODULE$.int2Integer(100)))).toList();
            Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
            structType$2.elem = inputDF.schema();
            inputDF.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).option("hoodie.metadata.enable", "false").mode(i == 0 ? SaveMode.Overwrite : SaveMode.Append).save(this.protected$basePath(this));
        });
        List records = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts(new StringOps(Predef$.MODULE$.augmentString("%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)})), Predef$.MODULE$.int2Integer(100)))).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        structType.elem = inputDF.schema();
        inputDF.write().format("hudi").options(this.commonOpts()).option("hoodie.cleaner.commits.retained", "0").option("hoodie.parquet.small.file.limit", "0").option("hoodie.clustering.inline", "true").option("hoodie.clustering.inline.max.commits", "2").option("hoodie.metadata.enable", "false").mode(SaveMode.Append).save(this.basePath);
        Assertions.assertEquals((int)sm.triggerCount(), (int)1);
    }

    public static final /* synthetic */ void $anonfun$getSparkSessionExtensionsInjector$1(SparkSessionExtensions receiver) {
        new HoodieSparkSessionExtension().apply(receiver);
    }

    public static final /* synthetic */ boolean $anonfun$testReadPathsOnCopyOnWriteTable$1(FileStatus x$2) {
        return !x$2.getPath().getName().contains("hoodie_partition_metadata");
    }

    public static final /* synthetic */ boolean $anonfun$testReadPathsOnCopyOnWriteTable$2(FileStatus x$3) {
        return x$3.getPath().getName().endsWith("parquet");
    }

    public static final /* synthetic */ boolean $anonfun$testReadPathsOnCopyOnWriteTable$4(TestCOWDataSource $this, HoodieRecord record) {
        String string = record.getPartitionPath();
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.protected$dataGen($this).getPartitionPaths())).head();
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$testOverWriteModeUseReplaceActionOnDisJointPartitions$1(Row row) {
        return row.get(0).equals("2015/03/16");
    }

    public static final /* synthetic */ boolean $anonfun$testOverWriteTableModeUseReplaceActionOnDisJointPartitions$1(Row row) {
        return row.get(0).equals("2015/03/16");
    }

    public static final /* synthetic */ void $anonfun$testComplexDataTypeWriteAndReadConsistency$1(StructField f) {
        String string = f.name();
        if ("timeStampValue".equals(string)) {
            Assertions.assertEquals((Object)f.dataType(), (Object)TimestampType$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("dateValue".equals(string)) {
            Assertions.assertEquals((Object)f.dataType(), (Object)DateType$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("decimalValue".equals(string)) {
            Assertions.assertEquals((Object)f.dataType(), (Object)new DecimalType(15, 10));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ String $anonfun$testSparkPartitionByWithCustomKeyGenerator$1(long data) {
        return new DateTime(data).toString(DateTimeFormat.forPattern((String)"yyyyMMdd"));
    }

    public static final /* synthetic */ String $anonfun$testSparkPartitionByWithTimestampBasedKeyGenerator$1(long data) {
        return new DateTime(data).toString(DateTimeFormat.forPattern((String)"yyyyMMdd"));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionPruning$1(HoodieRecord record) {
        String string = record.getPartitionPath();
        String string2 = "2016/03/15";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSchemaNotEqualData$1(StructField p) {
        return !p.name().startsWith("_hoodie");
    }

    public TestCOWDataSource() {
        this.verificationCol = "driver";
        this.updatedVerificationVal = "driver_update";
    }

    public class StageEventManager
    extends SparkListener {
        private final String eventToTrack;
        private int triggerCount;
        public final /* synthetic */ TestCOWDataSource $outer;

        public int triggerCount() {
            return this.triggerCount;
        }

        public void triggerCount_$eq(int x$1) {
            this.triggerCount = x$1;
        }

        public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
            block0: {
                if (!stageCompleted.stageInfo().details().contains(this.eventToTrack)) break block0;
                this.triggerCount_$eq(this.triggerCount() + 1);
            }
        }

        public /* synthetic */ TestCOWDataSource org$apache$hudi$functional$TestCOWDataSource$StageEventManager$$$outer() {
            return this.$outer;
        }

        public StageEventManager(TestCOWDataSource $outer, String eventToTrack) {
            this.eventToTrack = eventToTrack;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.triggerCount = 0;
        }
    }
}

