/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.ColumnStatsIndexSupport;
import org.apache.hudi.ColumnStatsIndexSupport$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.config.HoodieStorageConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.TestColumnStatsIndex$;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random$;

@Tag(value="functional")
@DisabledIf(value="org.apache.hudi.HoodieSparkUtils#gteqSpark3_3", disabledReason="Jackson version conflicts (HUDI-5352)")
@ScalaSignature(bytes="\u0006\u0001\r5c\u0001B\u001b7\u0001}BQA\u0012\u0001\u0005\u0002\u001dC\u0011B\u0013\u0001A\u0002\u0003\u0007I\u0011A&\t\u0013M\u0003\u0001\u0019!a\u0001\n\u0003!\u0006\"C/\u0001\u0001\u0004\u0005\t\u0015)\u0003M\u0011\u001dq\u0006A1A\u0005\u0002}CaA\u001a\u0001!\u0002\u0013\u0001\u0007\"B4\u0001\t\u0003B\u0007\"\u0002;\u0001\t\u0003B\u0007\"B=\u0001\t\u0003Q\bb\u0002B+\u0001\u0011\u0005!q\u000b\u0005\b\u0005O\u0002A\u0011\u0001B5\u0011\u0019\u0011y\b\u0001C\u0001Q\"9!\u0011\u0012\u0001\u0005\n\t-\u0005b\u0002Ba\u0001\u0011%!1\u0019\u0005\b\u0005w\u0004A\u0011\u0002B\u007f\u0011\u001d\u0019I\u0001\u0001C\u0005\u0007\u0017Aqaa\u0004\u0001\t\u0013\u0019\t\u0002C\u0004\u0004\u0018\u0001!Ia!\u0007\t\u000f\r]\u0001\u0001\"\u0003\u0004\u001e!a1Q\u0005\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u0004(\u001d9\u0011Q\u0003\u001c\t\u0002\u0005]aAB\u001b7\u0011\u0003\tI\u0002\u0003\u0004G-\u0011\u0005\u0011q\u0005\u0004\u0007\u0003S1\u0002)a\u000b\t\u0015\u0005M\u0002D!f\u0001\n\u0003\t)\u0004\u0003\u0006\u0002Ha\u0011\t\u0012)A\u0005\u0003oA!\"!\u0013\u0019\u0005+\u0007I\u0011AA&\u0011)\t\u0019\u0006\u0007B\tB\u0003%\u0011Q\n\u0005\u000b\u0003+B\"Q3A\u0005\u0002\u0005-\u0003BCA,1\tE\t\u0015!\u0003\u0002N!1a\t\u0007C\u0001\u00033B\u0011\"!\u001a\u0019\u0003\u0003%\t!a\u001a\t\u0013\u0005=\u0004$%A\u0005\u0002\u0005E\u0004\"CAD1E\u0005I\u0011AAE\u0011%\ti\tGI\u0001\n\u0003\tI\tC\u0005\u0002\u0010b\t\t\u0011\"\u0011\u0002\u0012\"I\u00111\u0015\r\u0002\u0002\u0013\u0005\u0011Q\u0015\u0005\n\u0003[C\u0012\u0011!C\u0001\u0003_C\u0011\"!/\u0019\u0003\u0003%\t%a/\t\u0013\u0005%\u0007$!A\u0005\u0002\u0005-\u0007\"CAh1\u0005\u0005I\u0011IAi\u0011%\t\u0019\u000eGA\u0001\n\u0003\n)\u000eC\u0005\u0002Xb\t\t\u0011\"\u0011\u0002Z\u001eI\u0011Q\u001c\f\u0002\u0002#\u0005\u0011q\u001c\u0004\n\u0003S1\u0012\u0011!E\u0001\u0003CDaAR\u0017\u0005\u0002\u0005=\b\"CAj[\u0005\u0005IQIAk\u0011%\t\t0LA\u0001\n\u0003\u000b\u0019\u0010C\u0005\u0002|6\n\t\u0011\"!\u0002~\"I!qB\u0017\u0002\u0002\u0013%!\u0011\u0003\u0005\b\u000531B\u0011\u0001B\u000e\u0011%\u0011yAFA\u0001\n\u0013\u0011\tB\u0001\u000bUKN$8i\u001c7v[:\u001cF/\u0019;t\u0013:$W\r\u001f\u0006\u0003oa\n!BZ;oGRLwN\\1m\u0015\tI$(\u0001\u0003ik\u0012L'BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tO\u0001\ni\u0016\u001cH/\u001e;jYNL!!\u0012\"\u0003)!{w\u000eZ5f\u00072LWM\u001c;UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0001\n\u0005\u0002J\u00015\ta'A\u0003ta\u0006\u00148.F\u0001M!\ti\u0015+D\u0001O\u0015\ty\u0005+A\u0002tc2T!A\u0013\u001e\n\u0005Is%\u0001D*qCJ\\7+Z:tS>t\u0017!C:qCJ\\w\fJ3r)\t)6\f\u0005\u0002W36\tqKC\u0001Y\u0003\u0015\u00198-\u00197b\u0013\tQvK\u0001\u0003V]&$\bb\u0002/\u0004\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\n\u0014AB:qCJ\\\u0007%A\tt_V\u00148-\u001a+bE2,7k\u00195f[\u0006,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G:\u000bQ\u0001^=qKNL!!\u001a2\u0003\u0015M#(/^2u)f\u0004X-\u0001\nt_V\u00148-\u001a+bE2,7k\u00195f[\u0006\u0004\u0013!B:fiV\u0003H#A+)\u0005\u001dQ\u0007CA6s\u001b\u0005a'BA7o\u0003\r\t\u0007/\u001b\u0006\u0003_B\fqA[;qSR,'O\u0003\u0002ry\u0005)!.\u001e8ji&\u00111\u000f\u001c\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0005!1\bCA6x\u0013\tAHNA\u0005BMR,'/R1dQ\u0006aB/Z:u\u001b\u0016$\u0018\rZ1uC\u000e{G.^7o'R\fGo]%oI\u0016DHCA+|\u0011\u0015a\u0018\u00021\u0001~\u0003!!Xm\u001d;DCN,\u0007C\u0001@\u0019\u001d\tyXC\u0004\u0003\u0002\u0002\u0005Ma\u0002BA\u0002\u0003#qA!!\u0002\u0002\u00109!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\fy\na\u0001\u0010:p_Rt\u0014\"A\u001f\n\u0005mb\u0014BA\u001d;\u0013\t9\u0004(\u0001\u000bUKN$8i\u001c7v[:\u001cF/\u0019;t\u0013:$W\r\u001f\t\u0003\u0013Z\u0019RAFA\u000e\u0003C\u00012AVA\u000f\u0013\r\tyb\u0016\u0002\u0007\u0003:L(+\u001a4\u0011\u0007Y\u000b\u0019#C\u0002\u0002&]\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!a\u0006\u0003'\r{G.^7o'R\fGo\u001d+fgR\u001c\u0015m]3\u0014\u000fa\tY\"!\f\u0002\"A\u0019a+a\f\n\u0007\u0005ErKA\u0004Qe>$Wo\u0019;\u0002\u0013Q\f'\r\\3UsB,WCAA\u001c!\u0011\tI$a\u0011\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\tQ!\\8eK2T1!!\u00119\u0003\u0019\u0019w.\\7p]&!\u0011QIA\u001e\u0005=Aun\u001c3jKR\u000b'\r\\3UsB,\u0017A\u0003;bE2,G+\u001f9fA\u0005\u0001bm\u001c:dK\u001a+H\u000e\u001c'pON\u001b\u0017M\\\u000b\u0003\u0003\u001b\u00022AVA(\u0013\r\t\tf\u0016\u0002\b\u0005>|G.Z1o\u0003E1wN]2f\rVdG\u000eT8h'\u000e\fg\u000eI\u0001\u0013g\"|W\u000f\u001c3SK\u0006$\u0017J\\'f[>\u0014\u00180A\ntQ>,H\u000e\u001a*fC\u0012Le.T3n_JL\b\u0005\u0006\u0005\u0002\\\u0005}\u0013\u0011MA2!\r\ti\u0006G\u0007\u0002-!9\u00111G\u0010A\u0002\u0005]\u0002bBA%?\u0001\u0007\u0011Q\n\u0005\b\u0003+z\u0002\u0019AA'\u0003\u0011\u0019w\u000e]=\u0015\u0011\u0005m\u0013\u0011NA6\u0003[B\u0011\"a\r!!\u0003\u0005\r!a\u000e\t\u0013\u0005%\u0003\u0005%AA\u0002\u00055\u0003\"CA+AA\u0005\t\u0019AA'\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001d+\t\u0005]\u0012QO\u0016\u0003\u0003o\u0002B!!\u001f\u0002\u00046\u0011\u00111\u0010\u0006\u0005\u0003{\ny(A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011Q,\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0006\u0006m$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAFU\u0011\ti%!\u001e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a%\u0011\t\u0005U\u0015qT\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006!A.\u00198h\u0015\t\ti*\u0001\u0003kCZ\f\u0017\u0002BAQ\u0003/\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAT!\r1\u0016\u0011V\u0005\u0004\u0003W;&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAY\u0003o\u00032AVAZ\u0013\r\t)l\u0016\u0002\u0004\u0003:L\b\u0002\u0003/'\u0003\u0003\u0005\r!a*\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!0\u0011\r\u0005}\u0016QYAY\u001b\t\t\tMC\u0002\u0002D^\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9-!1\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u001b\ni\r\u0003\u0005]Q\u0005\u0005\t\u0019AAY\u0003!A\u0017m\u001d5D_\u0012,GCAAT\u0003!!xn\u0015;sS:<GCAAJ\u0003\u0019)\u0017/^1mgR!\u0011QJAn\u0011!a6&!AA\u0002\u0005E\u0016aE\"pYVlgn\u0015;biN$Vm\u001d;DCN,\u0007cAA/[M)Q&a9\u0002\"Aa\u0011Q]Av\u0003o\ti%!\u0014\u0002\\5\u0011\u0011q\u001d\u0006\u0004\u0003S<\u0016a\u0002:v]RLW.Z\u0005\u0005\u0003[\f9OA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!a8\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005m\u0013Q_A|\u0003sDq!a\r1\u0001\u0004\t9\u0004C\u0004\u0002JA\u0002\r!!\u0014\t\u000f\u0005U\u0003\u00071\u0001\u0002N\u00059QO\\1qa2LH\u0003BA\u0000\u0005\u0017\u0001RA\u0016B\u0001\u0005\u000bI1Aa\u0001X\u0005\u0019y\u0005\u000f^5p]BIaKa\u0002\u00028\u00055\u0013QJ\u0005\u0004\u0005\u00139&A\u0002+va2,7\u0007C\u0005\u0003\u000eE\n\t\u00111\u0001\u0002\\\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005'\u0001B!!&\u0003\u0016%!!qCAL\u0005\u0019y%M[3di\u0006\u0011C/Z:u\u001b\u0016$\u0018\rZ1uC\u000e{G.^7o'R\fGo]%oI\u0016D\b+\u0019:b[N,\"A!\b\u0011\r\t}!\u0011\u0006B\u0017\u001b\t\u0011\tC\u0003\u0003\u0003$\t\u0015\u0012AB:ue\u0016\fWN\u0003\u0003\u0003(\u0005m\u0015\u0001B;uS2LAAa\u000b\u0003\"\t11\u000b\u001e:fC6\u0004BAa\f\u0003:5\u0011!\u0011\u0007\u0006\u0005\u0005g\u0011)$\u0001\u0005qe>4\u0018\u000eZ3s\u0015\r\u00119D\\\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\tm\"\u0011\u0007\u0002\n\u0003J<W/\\3oiNDs!\u0003B \u0005\u000b\u00129\u0005\u0005\u0003\u00030\t\u0005\u0013\u0002\u0002B\"\u0005c\u0011A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d#A!\u0013\"\u0005\te\u0001fA\u0005\u0003NA!!q\nB)\u001b\t\u0011)$\u0003\u0003\u0003T\tU\"!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u00061C/Z:u\u001b\u0016$\u0018\rZ1uC\u000e{G.^7o'R\fGo]%oI\u0016Dh+\u00197vK\u000e{WO\u001c;\u0015\u0007U\u0013I\u0006C\u0004\u00024)\u0001\r!a\u000e)\u000f)\u0011iF!\u0012\u0003dA!!q\u0006B0\u0013\u0011\u0011\tG!\r\u0003\u0015\u0015sW/\\*pkJ\u001cWm\t\u0002\u00028!\u001a!B!\u0014\u0002[Q,7\u000f^'fi\u0006$\u0017\r^1D_2,XN\\*uCR\u001c\u0018J\u001c3fqB\u000b'\u000f^5bYB\u0013xN[3di&|g\u000eF\u0002V\u0005WBq!!\u0016\f\u0001\u0004\ti\u0005K\u0004\f\u0005_\u0012)Ha\u001e\u0011\t\t=\"\u0011O\u0005\u0005\u0005g\u0012\tDA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\t\te$1P\r\u0002\u0003e\t\u0001\u0001K\u0002\f\u0005\u001b\n!\u0005^3tiB\u000b'/];fi6+G/\u00193bi\u0006\u0014\u0016M\\4f\u000bb$(/Y2uS>t\u0007f\u0001\u0007\u0003\u0004B\u00191N!\"\n\u0007\t\u001dEN\u0001\u0003UKN$\u0018!\b3p/JLG/Z!oIZ\u000bG.\u001b3bi\u0016\u001cu\u000e\\;n]N#\u0018\r^:\u0015\u001fU\u0013iIa$\u0003(\n-&q\u0016BZ\u0005oCQ\u0001`\u0007A\u0002uDqA!%\u000e\u0001\u0004\u0011\u0019*\u0001\u0007nKR\fG-\u0019;b\u001fB$8\u000f\u0005\u0005\u0003\u0016\nu%1\u0015BR\u001d\u0011\u00119J!'\u0011\u0007\u0005\u001dq+C\u0002\u0003\u001c^\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002BP\u0005C\u00131!T1q\u0015\r\u0011Yj\u0016\t\u0005\u0005+\u0013)+\u0003\u0003\u0002\"\n\u0005\u0006b\u0002BU\u001b\u0001\u0007!1S\u0001\tQV$\u0017n\u00149ug\"9!QV\u0007A\u0002\t\r\u0016A\u00043bi\u0006\u001cv.\u001e:dKB\u000bG\u000f\u001b\u0005\b\u0005ck\u0001\u0019\u0001BR\u0003i)\u0007\u0010]3di\u0016$7i\u001c7Ti\u0006$8oU8ve\u000e,\u0007+\u0019;i\u0011\u001d\u0011),\u0004a\u0001\u0005G\u000b\u0011b\u001c9fe\u0006$\u0018n\u001c8\t\u000f\teV\u00021\u0001\u0003<\u0006A1/\u0019<f\u001b>$W\rE\u0002N\u0005{K1Aa0O\u0005!\u0019\u0016M^3N_\u0012,\u0017!\b2vS2$7i\u001c7v[:\u001cF/\u0019;t)\u0006\u0014G.Z'b]V\fG\u000e\\=\u0015\u0015\t\u0015'1\u001cBp\u0005g\u00149\u0010\u0005\u0003\u0003H\nUg\u0002\u0002Be\u0005#tAAa3\u0003P:!\u00111\u0001Bg\u0013\tQ%(\u0003\u0002P!&\u0019!1\u001b(\u0002\u000fA\f7m[1hK&!!q\u001bBm\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0003T:CqA!8\u000f\u0001\u0004\u0011\u0019+A\u0005uC\ndW\rU1uQ\"9!\u0011\u001d\bA\u0002\t\r\u0018\u0001D5oG2,H-\u001a3D_2\u001c\bC\u0002Bs\u0005[\u0014\u0019K\u0004\u0003\u0003h\n-h\u0002BA\u0004\u0005SL\u0011\u0001W\u0005\u0004\u0005'<\u0016\u0002\u0002Bx\u0005c\u00141aU3r\u0015\r\u0011\u0019n\u0016\u0005\b\u0005kt\u0001\u0019\u0001Br\u0003-Ig\u000eZ3yK\u0012\u001cu\u000e\\:\t\r\teh\u00021\u0001a\u0003-Ig\u000eZ3y'\u000eDW-\\1\u00021Y\fG.\u001b3bi\u0016\u001cu\u000e\\;n]N#\u0018\r^:J]\u0012,\u0007\u0010F\u0005V\u0005\u007f\u001c\taa\u0001\u0004\u0006!)Ap\u0004a\u0001{\"9!\u0011S\bA\u0002\tM\u0005b\u0002BY\u001f\u0001\u0007!1\u0015\u0005\b\u0007\u000fy\u0001\u0019AA'\u0003m1\u0018\r\\5eCR,7i\u001c7v[:\u001cF/\u0019;t\u001b\u0006tW/\u00197ms\u00069r-\u001a8fe\u0006$XMU1oI>lG)\u0019;b\rJ\fW.\u001a\u000b\u0005\u0005\u000b\u001ci\u0001C\u0003K!\u0001\u0007A*\u0001\u0004bg*\u001bxN\u001c\u000b\u0005\u0005G\u001b\u0019\u0002C\u0004\u0004\u0016E\u0001\rA!2\u0002\u0005\u00114\u0017\u0001B:peR$BA!2\u0004\u001c!91Q\u0003\nA\u0002\t\u0015GC\u0002Bc\u0007?\u0019\t\u0003C\u0004\u0004\u0016M\u0001\rA!2\t\u000f\r\r2\u00031\u0001\u0003d\u0006Y1o\u001c:u\u0007>dW/\u001c8t\u0003I\u0001(o\u001c;fGR,G\r\n2bg\u0016\u0004\u0016\r\u001e5\u0015\t\u0005M5\u0011\u0006\u0005\b9R\t\t\u00111\u0001IQ-\u00011Q\u0006B#\u0007s\u0019ida\u0010\u0011\t\r=2QG\u0007\u0003\u0007cQ1aa\rm\u0003%\u0019wN\u001c3ji&|g.\u0003\u0003\u00048\rE\"A\u0003#jg\u0006\u0014G.\u001a3JM\u0006\u001211H\u0001._J<g&\u00199bG\",g\u0006[;eS:Bun\u001c3jKN\u0003\u0018M]6Vi&d7oI4uKF\u001c\u0006/\u0019:lg}\u001b\u0014A\u00043jg\u0006\u0014G.\u001a3SK\u0006\u001cxN\\\u0011\u0003\u0007\u0003\nQES1dWN|g\u000e\t<feNLwN\u001c\u0011d_:4G.[2ug\u0002B\u0003*\u0016#J[U\u001aTGM\u0015)\u000f\u0001\u0019)E!\u0012\u0004LA\u00191na\u0012\n\u0007\r%CNA\u0002UC\u001e\f\u0013a\u000e")
public class TestColumnStatsIndex
extends HoodieClientTestBase {
    private SparkSession spark;
    private final StructType sourceTableSchema = new StructType().add("c1", (DataType)IntegerType$.MODULE$).add("c2", (DataType)StringType$.MODULE$).add("c3", (DataType)new DecimalType(9, 3)).add("c4", (DataType)TimestampType$.MODULE$).add("c5", (DataType)ShortType$.MODULE$).add("c6", (DataType)DateType$.MODULE$).add("c7", (DataType)BinaryType$.MODULE$).add("c8", (DataType)ByteType$.MODULE$);

    public static Stream<Arguments> testMetadataColumnStatsIndexParams() {
        return TestColumnStatsIndex$.MODULE$.testMetadataColumnStatsIndexParams();
    }

    public /* synthetic */ String protected$basePath(TestColumnStatsIndex x$1) {
        return x$1.basePath;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public StructType sourceTableSchema() {
        return this.sourceTableSchema;
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.initFileSystem();
        this.setTableName("hoodie_test");
        this.initMetaClient();
        this.spark_$eq(this.sqlContext.sparkSession());
    }

    @AfterEach
    public void tearDown() {
        this.cleanupFileSystem();
        this.cleanupSparkContexts();
    }

    @ParameterizedTest
    @MethodSource(value={"testMetadataColumnStatsIndexParams"})
    public void testMetadataColumnStatsIndex(ColumnStatsTestCase testCase) {
        scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true")}));
        scala.collection.immutable.Map commonOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)testCase.tableType().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_FULL_SCAN_LOG_FILES.key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)testCase.forceFullLogScan())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true")}))).$plus$plus((GenTraversableOnce)metadataOpts);
        this.doWriteAndValidateColumnStats(testCase, (scala.collection.immutable.Map<String, String>)metadataOpts, (scala.collection.immutable.Map<String, String>)commonOpts, "index/colstats/input-table-json", "index/colstats/column-stats-index-table.json", DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite);
        this.doWriteAndValidateColumnStats(testCase, (scala.collection.immutable.Map<String, String>)metadataOpts, (scala.collection.immutable.Map<String, String>)commonOpts, "index/colstats/another-input-table-json", "index/colstats/updated-column-stats-index-table.json", DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Append);
        HoodieTableType hoodieTableType = testCase.tableType();
        HoodieTableType hoodieTableType2 = HoodieTableType.COPY_ON_WRITE;
        String expectedColStatsSourcePath = !(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null) ? "index/colstats/cow-updated2-column-stats-index-table.json" : "index/colstats/mor-updated2-column-stats-index-table.json";
        this.doWriteAndValidateColumnStats(testCase, (scala.collection.immutable.Map<String, String>)metadataOpts, (scala.collection.immutable.Map<String, String>)commonOpts, "index/colstats/update-input-table-json", expectedColStatsSourcePath, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataColumnStatsIndexValueCount(HoodieTableType tableType) {
        scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true")}));
        scala.collection.immutable.Map commonOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true")}))).$plus$plus((GenTraversableOnce)metadataOpts);
        StructField structField = new StructField("c1", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("c2", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "v1"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "v2"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "v4"}))}));
        int x$2 = qual$1.parallelize$default$2();
        Dataset inputDF = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), schema);
        inputDF.sort("c1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c2"})).write().format("hudi").options((Map)commonOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)HoodieConversionUtils$.MODULE$.toProperties(metadataOpts)).build();
        ColumnStatsIndexSupport columnStatsIndex = new ColumnStatsIndexSupport(this.spark(), schema, metadataConfig, this.metaClient, ColumnStatsIndexSupport$.MODULE$.$lessinit$greater$default$5());
        columnStatsIndex.loadTransposed((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c2"})), false, (Function1 & Serializable & scala.Serializable)transposedDF -> {
            TestColumnStatsIndex.$anonfun$testMetadataColumnStatsIndexValueCount$1(transposedDF);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMetadataColumnStatsIndexPartialProjection(boolean shouldReadInMemory) {
        Seq targetColumnsToIndex = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
        scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COLUMN_STATS_INDEX_FOR_COLUMNS.key()), (Object)targetColumnsToIndex.mkString(","))}));
        scala.collection.immutable.Map opts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true")}))).$plus$plus((GenTraversableOnce)metadataOpts);
        String sourceJSONTablePath = this.getClass().getClassLoader().getResource("index/colstats/input-table-json").toString();
        Dataset inputDF = this.spark().read().schema(this.sourceTableSchema()).json(sourceJSONTablePath);
        inputDF.sort("c1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).repartition(4, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{new Column("c1")})).write().format("hudi").options((Map)opts).option(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), 10240L).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)HoodieConversionUtils$.MODULE$.toProperties(metadataOpts)).build();
        Seq requestedColumns = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c4"}));
        ColumnStatsIndexSupport columnStatsIndex = new ColumnStatsIndexSupport(this.spark(), this.sourceTableSchema(), metadataConfig, this.metaClient, ColumnStatsIndexSupport$.MODULE$.$lessinit$greater$default$5());
        columnStatsIndex.loadTransposed(requestedColumns, shouldReadInMemory, (Function1 & Serializable & scala.Serializable)emptyTransposedColStatsDF -> {
            TestColumnStatsIndex.$anonfun$testMetadataColumnStatsIndexPartialProjection$1(emptyTransposedColStatsDF);
            return BoxedUnit.UNIT;
        });
        Seq requestedColumns2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c4", "c1"}));
        StructType expectedColStatsSchema = ColumnStatsIndexSupport$.MODULE$.composeIndexSchema((Seq)requestedColumns2.sorted((Ordering)Ordering.String$.MODULE$), this.sourceTableSchema());
        Dataset expectedColStatsIndexTableDf = this.spark().read().schema(expectedColStatsSchema).json(this.getClass().getClassLoader().getResource("index/colstats/partial-column-stats-index-table.json").toString());
        Dataset<Row> manualColStatsTableDF = this.buildColumnStatsTableManually(this.basePath, (Seq<String>)requestedColumns2, (Seq<String>)targetColumnsToIndex, expectedColStatsSchema);
        ColumnStatsIndexSupport columnStatsIndex2 = new ColumnStatsIndexSupport(this.spark(), this.sourceTableSchema(), metadataConfig, this.metaClient, ColumnStatsIndexSupport$.MODULE$.$lessinit$greater$default$5());
        columnStatsIndex2.loadTransposed(requestedColumns2, shouldReadInMemory, (Function1 & Serializable & scala.Serializable)partialTransposedColStatsDF -> {
            TestColumnStatsIndex.$anonfun$testMetadataColumnStatsIndexPartialProjection$2(this, expectedColStatsIndexTableDf, manualColStatsTableDF, partialTransposedColStatsDF);
            return BoxedUnit.UNIT;
        });
        Seq missingCols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c3"}));
        StructType partialSourceTableSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sourceTableSchema().fields())).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)missingCols.contains((Object)f.name()))));
        String updateJSONTablePath = this.getClass().getClassLoader().getResource("index/colstats/partial-another-input-table-json").toString();
        Dataset updateDF = this.spark().read().schema(partialSourceTableSchema).json(updateJSONTablePath);
        updateDF.repartition(4).write().format("hudi").options((Map)opts).option(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), 10240L).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        String[] requestedColumns3 = this.sourceTableSchema().fieldNames();
        StructType expectedColStatsSchema2 = ColumnStatsIndexSupport$.MODULE$.composeIndexSchema((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requestedColumns3)).sorted((Ordering)Ordering.String$.MODULE$)), this.sourceTableSchema());
        Dataset expectedColStatsIndexUpdatedDF = this.spark().read().schema(expectedColStatsSchema2).json(this.getClass().getClassLoader().getResource("index/colstats/updated-partial-column-stats-index-table.json").toString());
        Dataset<Row> manualUpdatedColStatsTableDF = this.buildColumnStatsTableManually(this.basePath, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])requestedColumns3), (Seq<String>)targetColumnsToIndex, expectedColStatsSchema2);
        ColumnStatsIndexSupport columnStatsIndex3 = new ColumnStatsIndexSupport(this.spark(), this.sourceTableSchema(), metadataConfig, this.metaClient, ColumnStatsIndexSupport$.MODULE$.$lessinit$greater$default$5());
        columnStatsIndex3.loadTransposed((Seq)Predef$.MODULE$.wrapRefArray((Object[])requestedColumns3), shouldReadInMemory, (Function1 & Serializable & scala.Serializable)transposedUpdatedColStatsDF -> {
            TestColumnStatsIndex.$anonfun$testMetadataColumnStatsIndexPartialProjection$4(this, expectedColStatsIndexUpdatedDF, manualUpdatedColStatsTableDF, transposedUpdatedColStatsDF);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testParquetMetadataRangeExtraction() {
        Object object = new Object();
        try {
            Dataset<Row> df = this.generateRandomDataFrame(this.spark());
            String pathStr = ((Object)this.tempDir.resolve("min-max").toAbsolutePath()).toString();
            df.write().format("parquet").mode(SaveMode.Overwrite).save(pathStr);
            ParquetUtils utils = new ParquetUtils();
            Configuration conf = new Configuration();
            Path path = new Path(pathStr);
            FileSystem fs2 = path.getFileSystem(conf);
            Path parquetFilePath = ((FileStatus)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs2.listStatus(path))).filter((Function1 & Serializable & scala.Serializable)fs -> BoxesRunTime.boxToBoolean((boolean)TestColumnStatsIndex.$anonfun$testParquetMetadataRangeExtraction$1(fs))))).toSeq().head()).getPath();
            List ranges = utils.readRangeFromParquetMetadata(conf, parquetFilePath, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3a", "c3b", "c3c", "c4", "c5", "c6", "c7", "c8"}))).asJava());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ranges).asScala()).foreach((Function1 & Serializable & scala.Serializable)r -> {
                TestColumnStatsIndex.$anonfun$testParquetMetadataRangeExtraction$2(object, r);
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void doWriteAndValidateColumnStats(ColumnStatsTestCase testCase, scala.collection.immutable.Map<String, String> metadataOpts, scala.collection.immutable.Map<String, String> hudiOpts, String dataSourcePath, String expectedColStatsSourcePath, String operation, SaveMode saveMode) {
        String sourceJSONTablePath = this.getClass().getClassLoader().getResource(dataSourcePath).toString();
        Dataset inputDF = this.spark().read().schema(this.sourceTableSchema()).json(sourceJSONTablePath);
        inputDF.sort("c1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).repartition(4, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{new Column("c1")})).write().format("hudi").options(hudiOpts).option(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), 10240L).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), operation).mode(saveMode).save(this.basePath);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieTableType hoodieTableType = testCase.tableType();
        HoodieTableType hoodieTableType2 = HoodieTableType.COPY_ON_WRITE;
        boolean shouldValidateColumnStatsManually = !(hoodieTableType == null ? hoodieTableType2 != null : !hoodieTableType.equals(hoodieTableType2)) || operation.equals(DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL());
        this.validateColumnStatsIndex(testCase, metadataOpts, expectedColStatsSourcePath, shouldValidateColumnStatsManually);
    }

    private Dataset<Row> buildColumnStatsTableManually(String tablePath, Seq<String> includedCols, Seq<String> indexedCols, StructType indexSchema) {
        RemoteIterator it = this.fs.listFiles(new Path(tablePath), true);
        Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (it.hasNext()) {
            seq = (Seq)seq.$colon$plus(it.next(), Seq$.MODULE$.canBuildFrom());
        }
        Seq files = (Seq)seq.filter((Function1 & Serializable & scala.Serializable)fs -> BoxesRunTime.boxToBoolean((boolean)TestColumnStatsIndex.$anonfun$buildColumnStatsTableManually$1(fs)));
        return this.spark().createDataFrame((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)files.flatMap((Function1 & Serializable & scala.Serializable)file -> new ArrayOps.ofRef(TestColumnStatsIndex.$anonfun$buildColumnStatsTableManually$2(this, includedCols, indexedCols, file)), Seq$.MODULE$.canBuildFrom())).asJava(), indexSchema);
    }

    private void validateColumnStatsIndex(ColumnStatsTestCase testCase, scala.collection.immutable.Map<String, String> metadataOpts, String expectedColStatsSourcePath, boolean validateColumnStatsManually) {
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)HoodieConversionUtils$.MODULE$.toProperties(metadataOpts)).build();
        ColumnStatsIndexSupport columnStatsIndex = new ColumnStatsIndexSupport(this.spark(), this.sourceTableSchema(), metadataConfig, this.metaClient, ColumnStatsIndexSupport$.MODULE$.$lessinit$greater$default$5());
        StructType expectedColStatsSchema = ColumnStatsIndexSupport$.MODULE$.composeIndexSchema((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.sourceTableSchema().fieldNames()), this.sourceTableSchema());
        Seq validationSortColumns = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1_maxValue", "c1_minValue", "c2_maxValue", "c2_minValue"}));
        columnStatsIndex.loadTransposed((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.sourceTableSchema().fieldNames()), testCase.shouldReadInMemory(), (Function1 & Serializable & scala.Serializable)transposedColStatsDF -> {
            TestColumnStatsIndex.$anonfun$validateColumnStatsIndex$1(this, expectedColStatsSchema, expectedColStatsSourcePath, validationSortColumns, validateColumnStatsManually, transposedColStatsDF);
            return BoxedUnit.UNIT;
        });
    }

    private Dataset<Row> generateRandomDataFrame(SparkSession spark) {
        StructType sourceTableSchema = new StructType().add("c1", (DataType)IntegerType$.MODULE$).add("c2", (DataType)StringType$.MODULE$).add("c3a", (DataType)new DecimalType(9, 3)).add("c3b", (DataType)new DecimalType(10, 3)).add("c3c", (DataType)new DecimalType(20, 3)).add("c4", (DataType)TimestampType$.MODULE$).add("c5", (DataType)ShortType$.MODULE$).add("c6", (DataType)DateType$.MODULE$).add("c7", (DataType)BinaryType$.MODULE$).add("c8", (DataType)ByteType$.MODULE$);
        RDD rdd = spark.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000), 1, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)item -> TestColumnStatsIndex.$anonfun$generateRandomDataFrame$1(BoxesRunTime.unboxToInt((Object)item)), ClassTag$.MODULE$.apply(Row.class));
        return spark.createDataFrame(rdd, sourceTableSchema);
    }

    private String asJson(Dataset<Row> df) {
        return ((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.toJSON().select("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getString(0), Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private Dataset<Row> sort(Dataset<Row> df) {
        return this.sort(df, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1_maxValue", "c1_minValue"}))));
    }

    private Dataset<Row> sort(Dataset<Row> df, Seq<String> sortColumns) {
        String[] sortedCols = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).sorted((Ordering)Ordering.String$.MODULE$);
        return df.select((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortedCols)).head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortedCols)).tail())).sort((String)sortColumns.head(), (Seq)sortColumns.tail());
    }

    public static final /* synthetic */ void $anonfun$testMetadataColumnStatsIndexValueCount$1(Dataset transposedDF) {
        Row result = (Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])transposedDF.select("valueCount", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c2_nullCount"})).collect())).head();
        Assertions.assertTrue((result.getLong(0) == 4L ? 1 : 0) != 0);
        Assertions.assertTrue((result.getLong(1) == 1L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testMetadataColumnStatsIndexPartialProjection$1(Dataset emptyTransposedColStatsDF) {
        Assertions.assertEquals((int)0, (int)((Row[])emptyTransposedColStatsDF.collect()).length);
    }

    public static final /* synthetic */ void $anonfun$testMetadataColumnStatsIndexPartialProjection$2(TestColumnStatsIndex $this, Dataset expectedColStatsIndexTableDf$1, Dataset manualColStatsTableDF$1, Dataset partialTransposedColStatsDF) {
        Assertions.assertEquals((Object)expectedColStatsIndexTableDf$1.schema(), (Object)partialTransposedColStatsDF.schema());
        Assertions.assertEquals((Object)$this.asJson($this.sort((Dataset<Row>)expectedColStatsIndexTableDf$1)), (Object)$this.asJson($this.sort((Dataset<Row>)partialTransposedColStatsDF.drop("fileName"))));
        Assertions.assertEquals((Object)$this.asJson($this.sort((Dataset<Row>)manualColStatsTableDF$1)), (Object)$this.asJson($this.sort((Dataset<Row>)partialTransposedColStatsDF)));
    }

    public static final /* synthetic */ void $anonfun$testMetadataColumnStatsIndexPartialProjection$4(TestColumnStatsIndex $this, Dataset expectedColStatsIndexUpdatedDF$1, Dataset manualUpdatedColStatsTableDF$1, Dataset transposedUpdatedColStatsDF) {
        Assertions.assertEquals((Object)expectedColStatsIndexUpdatedDF$1.schema(), (Object)transposedUpdatedColStatsDF.schema());
        Assertions.assertEquals((Object)$this.asJson($this.sort((Dataset<Row>)expectedColStatsIndexUpdatedDF$1)), (Object)$this.asJson($this.sort((Dataset<Row>)transposedUpdatedColStatsDF.drop("fileName"))));
        Assertions.assertEquals((Object)$this.asJson($this.sort((Dataset<Row>)manualUpdatedColStatsTableDF$1)), (Object)$this.asJson($this.sort((Dataset<Row>)transposedUpdatedColStatsDF)));
    }

    public static final /* synthetic */ boolean $anonfun$testParquetMetadataRangeExtraction$1(FileStatus fs) {
        return fs.getPath().getName().endsWith(".parquet");
    }

    public static final /* synthetic */ void $anonfun$testParquetMetadataRangeExtraction$2(Object nonLocalReturnKey1$1, HoodieColumnRangeMetadata r) {
        if (r.getColumnName().equals("c4")) {
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        Comparable min = r.getMinValue();
        Comparable max = r.getMaxValue();
        Assertions.assertNotNull((Object)min);
        Assertions.assertNotNull((Object)max);
        Assertions.assertTrue((r.getMinValue().compareTo(r.getMaxValue()) <= 0 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$buildColumnStatsTableManually$1(LocatedFileStatus fs) {
        return fs.getPath().getName().endsWith(".parquet");
    }

    public static final /* synthetic */ Object[] $anonfun$buildColumnStatsTableManually$2(TestColumnStatsIndex $this, Seq includedCols$1, Seq indexedCols$1, LocatedFileStatus file) {
        Dataset df = $this.spark().read().schema($this.sourceTableSchema()).parquet(file.getPath().toString());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestColumnStatsIndex.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestColumnStatsIndex$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.String").asType().toTypeConstructor();
            }

            public Org_apache_hudi_functional_TestColumnStatsIndex$$typecreator1$1(TestColumnStatsIndex $outer) {
            }
        }
        String string = new StringBuilder(10).append("'").append(functions$.MODULE$.typedLit((Object)file.getPath().getName(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestColumnStatsIndex$$typecreator1$1(null)))).append("' AS file").toString();
        String string2 = "sum(1) AS valueCount";
        Seq exprs = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).filter((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)includedCols$1.contains((Object)col))))).flatMap((Function1 & Serializable & scala.Serializable)col -> {
            String minColName = new StringBuilder(9).append((String)col).append("_minValue").toString();
            String maxColName = new StringBuilder(9).append((String)col).append("_maxValue").toString();
            return indexedCols$1.contains(col) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(9).append("min(").append((String)col).append(") AS ").append(minColName).toString(), new StringBuilder(9).append("max(").append((String)col).append(") AS ").append(maxColName).toString(), new StringBuilder(41).append("sum(cast(isnull(").append((String)col).append(") AS long)) AS ").append((String)col).append("_nullCount").toString()})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("null AS ").append(minColName).toString(), new StringBuilder(8).append("null AS ").append(maxColName).toString(), new StringBuilder(18).append("null AS ").append((String)col).append("_nullCount").toString()}));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$colon((Object)string2, ClassTag$.MODULE$.apply(String.class)))).$plus$colon((Object)string, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        return Predef$.MODULE$.refArrayOps((Object[])df.selectExpr(exprs).collect());
    }

    public static final /* synthetic */ void $anonfun$validateColumnStatsIndex$1(TestColumnStatsIndex $this, StructType expectedColStatsSchema$1, String expectedColStatsSourcePath$1, Seq validationSortColumns$1, boolean validateColumnStatsManually$1, Dataset transposedColStatsDF) {
        block0: {
            Dataset expectedColStatsIndexTableDf = $this.spark().read().schema(expectedColStatsSchema$1).json($this.getClass().getClassLoader().getResource(expectedColStatsSourcePath$1).toString());
            Assertions.assertEquals((Object)expectedColStatsIndexTableDf.schema(), (Object)transposedColStatsDF.schema());
            Assertions.assertEquals((Object)$this.asJson($this.sort((Dataset<Row>)expectedColStatsIndexTableDf, (Seq<String>)validationSortColumns$1)), (Object)$this.asJson($this.sort((Dataset<Row>)transposedColStatsDF.drop("fileName"), (Seq<String>)validationSortColumns$1)));
            if (!validateColumnStatsManually$1) break block0;
            Dataset<Row> manualColStatsTableDF = $this.buildColumnStatsTableManually($this.protected$basePath($this), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])$this.sourceTableSchema().fieldNames()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])$this.sourceTableSchema().fieldNames()), expectedColStatsSchema$1);
            Assertions.assertEquals((Object)$this.asJson($this.sort(manualColStatsTableDF, (Seq<String>)validationSortColumns$1)), (Object)$this.asJson($this.sort((Dataset<Row>)transposedColStatsDF, (Seq<String>)validationSortColumns$1)));
        }
    }

    public static final /* synthetic */ byte $anonfun$generateRandomDataFrame$2(int x$5) {
        return (byte)x$5;
    }

    public static final /* synthetic */ Row $anonfun$generateRandomDataFrame$1(int item) {
        Integer c1 = item;
        String c2 = Random$.MODULE$.nextString(10);
        BigDecimal c3a = BigDecimal.valueOf(Random$.MODULE$.nextInt() % 0x1000000, 3);
        BigDecimal c3b = BigDecimal.valueOf(Random$.MODULE$.nextLong() % 0x100000000L, 3);
        BigDecimal c3c = new BigDecimal(new BigInteger(64, new Random()), 3);
        Timestamp c4 = new Timestamp(System.currentTimeMillis());
        Short c5 = Short.valueOf(String.valueOf(BoxesRunTime.boxToInteger((int)((item + 16) / 10))));
        Date c6 = Date.valueOf(new StringBuilder(2).append(2020).append("-").append(item % 11 + 1).append("-").append(item % 28 + 1).toString());
        byte[] c7 = (byte[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{item})).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToByte((byte)TestColumnStatsIndex.$anonfun$generateRandomDataFrame$2(BoxesRunTime.unboxToInt((Object)x$5))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        Byte c8 = Byte.valueOf("9");
        return RowFactory.create((Object[])new Object[]{c1, c2, c3a, c3b, c3c, c4, c5, c6, c7, c8});
    }

    public static class ColumnStatsTestCase
    implements Product,
    scala.Serializable {
        private final HoodieTableType tableType;
        private final boolean forceFullLogScan;
        private final boolean shouldReadInMemory;

        public HoodieTableType tableType() {
            return this.tableType;
        }

        public boolean forceFullLogScan() {
            return this.forceFullLogScan;
        }

        public boolean shouldReadInMemory() {
            return this.shouldReadInMemory;
        }

        public ColumnStatsTestCase copy(HoodieTableType tableType, boolean forceFullLogScan, boolean shouldReadInMemory) {
            return new ColumnStatsTestCase(tableType, forceFullLogScan, shouldReadInMemory);
        }

        public HoodieTableType copy$default$1() {
            return this.tableType();
        }

        public boolean copy$default$2() {
            return this.forceFullLogScan();
        }

        public boolean copy$default$3() {
            return this.shouldReadInMemory();
        }

        public String productPrefix() {
            return "ColumnStatsTestCase";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.tableType();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.forceFullLogScan());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.shouldReadInMemory());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ColumnStatsTestCase;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tableType()));
            n = Statics.mix((int)n, (int)(this.forceFullLogScan() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.shouldReadInMemory() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ColumnStatsTestCase)) return false;
            boolean bl = true;
            if (!bl) return false;
            ColumnStatsTestCase columnStatsTestCase = (ColumnStatsTestCase)x$1;
            HoodieTableType hoodieTableType = this.tableType();
            HoodieTableType hoodieTableType2 = columnStatsTestCase.tableType();
            if (hoodieTableType == null) {
                if (hoodieTableType2 != null) {
                    return false;
                }
            } else if (!hoodieTableType.equals(hoodieTableType2)) return false;
            if (this.forceFullLogScan() != columnStatsTestCase.forceFullLogScan()) return false;
            if (this.shouldReadInMemory() != columnStatsTestCase.shouldReadInMemory()) return false;
            if (!columnStatsTestCase.canEqual(this)) return false;
            return true;
        }

        public ColumnStatsTestCase(HoodieTableType tableType, boolean forceFullLogScan, boolean shouldReadInMemory) {
            this.tableType = tableType;
            this.forceFullLogScan = forceFullLogScan;
            this.shouldReadInMemory = shouldReadInMemory;
            Product.$init$((Product)this);
        }
    }
}

